
package org.llvm.adt.aliases;

import org.clank.java.*;
import org.clank.support.*;
import org.clank.support.aliases.*;
import static org.clank.support.Casts.*;
import static org.clank.java.io.*;
import static org.clank.java.std.*;
import static org.llvm.adt.ADTAliases.*;
import static org.llvm.support.llvm.*;
import static org.clank.support.NativePointer.*;
import static org.clank.support.NativeType.*;
import static org.clank.support.Native.*;
import org.llvm.support.*;
import org.llvm.adt.*;
import org.llvm.adt.aliases.*;

/*template <typename DerivedT, typename ${KEY_TYPE}, typename ${VALUE_TYPE}, typename KeyInfoT> TEMPLATE*/
//<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase">
@Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 39,
 cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase")
//</editor-fold>
public abstract class ${FILE_NAME}${CLASS_SUFFIX} implements NativeType.SizeofCapable {
  
  protected final ${VALUE_TYPE} defaultValue;
  
  protected final ${DENSE_MAP_INFO} keyInfoT;

  protected final ${KEY_TYPE} emptyKey;
  protected final ${KEY_TYPE} tombstoneKey;

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::DenseMapBase<DerivedT, ${KEY_TYPE}, ${VALUE_TYPE}, KeyInfoT>">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 248,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::DenseMapBase<DerivedT, ${KEY_TYPE}, ${VALUE_TYPE}, KeyInfoT>")
  //</editor-fold>  
  protected ${FILE_NAME}(${DENSE_MAP_INFO} keyInfo, ${VALUE_TYPE} defaultValue) {
    this.keyInfoT = keyInfo;
    this.defaultValue = defaultValue;
    this.emptyKey = keyInfoT.getEmptyKey();
    this.tombstoneKey = keyInfo.getTombstoneKey();
    assert ${ASSERT_INVALID_KEY_VALUE} : "empty/tombstoneKey key marker must be non null " + keyInfoT;
    assert keyInfoT.getEmptyKey() == this.emptyKey : "empty key must be persistent between calls" + keyInfoT;
    assert keyInfoT.getTombstoneKey() == this.tombstoneKey : "tombstone key must be persistent between calls" + keyInfoT;
    assert (emptyKey != tombstoneKey) : "EmptyKey must be different from TombstoneKey:" + keyInfo;
    assert ${ASSERT_DEFAULT_VALUE} : "non cloneable class for defaultValue " + defaultValue;
    if (ADTAliases.CHECK_DENSE_MAP_INFO) {
      assert (keyInfo.getHashValue(keyInfo.getEmptyKey()) != keyInfo.getHashValue(keyInfo.getTombstoneKey())) : "EmptyKey must have different hashCode to TombstoneKey:" + keyInfo;
    }
  }
  
/*protected:*/
  /*typedef std::pair<${KEY_TYPE}, ${VALUE_TYPE}> BucketT*/
//  public final class BucketT extends ${PAIR_TYPE}{ };
/*public:*/
  /*typedef ${KEY_TYPE} key_type*/
//  public final class key_type extends ${KEY_TYPE}{ };
  /*typedef ${VALUE_TYPE} mapped_type*/
//  public final class mapped_type extends ${VALUE_TYPE}{ };
  /*typedef BucketT value_type*/
//  public final class value_type extends BucketT{ };
  /*typedef ${DENSE_MAP_ITERATOR} iterator*/
//  public final class iterator extends ${DENSE_MAP_ITERATOR}{ };
  /*typedef ${DENSE_MAP_ITERATOR}<${KEY_TYPE}, ${VALUE_TYPE}, KeyInfoT, true> const_iterator*/
//  public final class const_iterator extends ${DENSE_MAP_ITERATOR}<${KEY_TYPE}, ${VALUE_TYPE}, KeyInfoT, true>{ };
  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::begin">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 53,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::begin")
  //</editor-fold>
  public /*inline*/ ${DENSE_MAP_ITERATOR} begin() {
    // When the map is empty, avoid the overhead of AdvancePastEmptyBuckets().
    return empty() ? end() : new ${DENSE_MAP_ITERATOR}(keyInfoT, $Buckets(), 0, getNumBuckets());
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::end">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 57,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::end")
  //</editor-fold>
  public /*inline*/ ${DENSE_MAP_ITERATOR} end() {
    return new ${DENSE_MAP_ITERATOR}(keyInfoT, $Buckets(), getNumBuckets(), getNumBuckets(), true);
  }

//  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::begin">
//  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 60,
//   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::begin")
//  //</editor-fold>
//  public /*inline*/ iterator begin() /*const*/ {
//    return empty() ? end() : iterator(getBuckets(), getBucketsEnd());
//  }
//
//  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::end">
//  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 63,
//   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::end")
//  //</editor-fold>
//  public /*inline*/ iterator end() /*const*/ {
//    return iterator(getBucketsEnd(), getBucketsEnd(), true);
//  }

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::empty">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 67,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::empty")
  //</editor-fold>
  public boolean empty() /*const*//* __attribute__((warn_unused_result))*/ {
    return getNumEntries() == 0;
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::size">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 70,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::size")
  //</editor-fold>
  public /*uint*/int size() /*const*/ {
    return getNumEntries();
  }

  
  /// Grow the densemap so that it has at least Size buckets. Does not shrink
  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::resize">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 73,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::resize")
  //</editor-fold>
  public void resize(/*size_t*/int Size) {
    if (Size >= getNumBuckets()) {
      grow(Size);
    }
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::clear">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 78,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::clear")
  //</editor-fold>
  public void clear() {
    if (getNumEntries() == 0 && getNumTombstones() == 0) {
      return;
    }
    
    // If the capacity of the array is huge, and the # elements used is small,
    // shrink the array.
    if ((getNumEntries() * 4 < getNumBuckets()) && (getNumBuckets() > 64)) {
      shrink_and_clear();
      return;
    }
    
    /*const*/${KEY_TYPE} EmptyKey = getEmptyKey(), TombstoneKey = getTombstoneKey();
    ${PAIR_TYPE}[] Buckets = $Buckets();
    for (int /*P*/ P = 0, /*P*/ E = getNumBuckets(); $noteq(P, E); ++P) {
      if (Buckets[P].first != EmptyKey) {
        if (Buckets[P].first != TombstoneKey) {
          if (!isDataPointerLike()) {
            Native.destroy(Buckets[P].second);
          }
          decrementNumEntries();
        }
        Buckets[P].first = EmptyKey;
      }
    }
    //(($eq(getNumEntries(), 0) && "Node count imbalance!") ? (/*static_cast*/void)(0) : __assert_fail("getNumEntries() == 0 && \"Node count imbalance!\"", ${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", 98, __PRETTY_FUNCTION__));
    setNumTombstones(0);
  }

  
  /// count - Returns non-zero if the specified key is in the map, 0 otherwise
  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::count">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 103,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::count")
  //</editor-fold>
  public int count(/*const*/${KEY_TYPE} /*&*/ Val) /*const*/ {
    return LookupBucketFor(Val, true) == INVALID_INDEX ? 0 : 1;
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::find">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 108,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::find")
  //</editor-fold>
  public ${DENSE_MAP_ITERATOR} find(/*const*/${KEY_TYPE} /*&*/ Val) {
    int TheBucket = LookupBucketFor(Val, true);
    if (TheBucket != INVALID_INDEX) {
      return new ${DENSE_MAP_ITERATOR}(keyInfoT, $Buckets(), TheBucket, getNumBuckets(), true);
    }
    return end();
  }

//  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::find">
//  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 114,
//   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::find")
//  //</editor-fold>
//  public ${DENSE_MAP_ITERATOR} find(/*const*/${KEY_TYPE} /*&*/ Val) /*const*/ {
//    type$ref<type$ptr<${PAIR_TYPE}>> TheBucketRef = NativePointer.create_type$ref((type$ptr<${PAIR_TYPE}>)null);
//    if (LookupBucketFor(Val, TheBucketRef)) {
//      return new ${DENSE_MAP_ITERATOR}(TheBucketRef.$deref(), getBucketsEnd(), true);
//    }
//    return end();
//  }

  
  /// Alternate version of find() which allows a different, and possibly
  /// less expensive, key type.
  /// The DenseMapInfo is responsible for supplying methods
  /// getHashValue(Lookup${KEY_TYPE}) and isEqual(Lookup${KEY_TYPE}, ${KEY_TYPE}) for each key
  /// type used.
  /*template <class Lookup${KEY_TYPE}> TEMPLATE*/
  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::find_as">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 127,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::find_as")
  //</editor-fold>
  public </*class*/ Lookup${KEY_TYPE}> ${DENSE_MAP_ITERATOR} find_as(/*const*/Lookup${KEY_TYPE} /*&*/ Val) {
    int TheBucket = LookupBucketForAltKey(Val, true);
    if (TheBucket != INVALID_INDEX) {
      return new ${DENSE_MAP_ITERATOR}(keyInfoT, $Buckets(), TheBucket, getNumBuckets(), true);
    }
    return end();
  }

//  /*template <class Lookup${KEY_TYPE}> TEMPLATE*/
//  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::find_as">
//  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 134,
//   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::find_as")
//  //</editor-fold>
//  public </*class*/ Lookup${KEY_TYPE}> iterator find_as(/*const*/Lookup${KEY_TYPE} /*&*/ Val) /*const*/ {
//    /*const*/BucketT /*P*/ TheBucket;
//    if (LookupBucketFor(Val, TheBucket)) {
//      return iterator(TheBucket, getBucketsEnd(), true);
//    }
//    return end();
//  }

  
  /// lookup - Return the entry for the specified key, or a default
  /// constructed value if no such entry exists.
  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::lookup">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 143,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::lookup")
  //</editor-fold>
  public ${VALUE_TYPE} lookup(/*const*/${KEY_TYPE} /*&*/ Val) /*const*/ {
    int TheBucket = LookupBucketFor(Val, true);
    if (TheBucket != INVALID_INDEX) {
      return $Buckets()[TheBucket].second;
    }
    return $tryClone(defaultValue);
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::insert">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 153,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::insert")
  //</editor-fold>
  public std.pairTypeBool<${DENSE_MAP_ITERATOR}> insert(/*const*/${PAIR_TYPE} /*&*/ KV) {
    int TheBucket = LookupBucketFor(KV.first, false);
    assert TheBucket != INVALID_INDEX;
    if (TheBucket < 0) {
      // Otherwise, insert the new element.
      TheBucket = InsertIntoBucket(KV.first, KV.second, TheBucket & CANDIDATE_INDEX_MASK);
      return std.make_pair_T_bool(new ${DENSE_MAP_ITERATOR}(keyInfoT, $Buckets(), TheBucket, getNumBuckets(), true), true);
    }
    return std.make_pair_T_bool(new ${DENSE_MAP_ITERATOR}(keyInfoT, $Buckets(), TheBucket, getNumBuckets(), true), false); // Already in map.
  }

  
  /// insert - Range insertion of pairs.
  /*template <typename InputIt> TEMPLATE*/
  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::insert">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 184,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::insert")
  //</editor-fold>
  public void insert(type$iterator<?, ${PAIR_TYPE}> I, type$iterator<?, ${PAIR_TYPE}> E) {
    for (; $noteq_iter(I, E); I.$preInc())  {
      insert(/*Deref*/I.$star());
    }
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::erase">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 190,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::erase")
  //</editor-fold>
  public boolean erase(/*const*/${KEY_TYPE} /*&*/ Val) {
    int TheBucketIdx = LookupBucketFor(Val, true);
    if (TheBucketIdx == INVALID_INDEX) {
      return false; // not in map.
    }
    ${PAIR_TYPE} TheBucket = $Buckets()[TheBucketIdx];
    if (!isDataPointerLike()) {
      Native.destroy(TheBucket.second);
    }
    TheBucket.first = getTombstoneKey();
    decrementNumEntries();
    incrementNumTombstones();
    return true;
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::erase">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 201,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::erase")
  //</editor-fold>
  public void erase(${DENSE_MAP_ITERATOR} I) {
    ${PAIR_TYPE} /*P*/ TheBucket = /*AddrOf*//*Deref*/I.$arrow();
    if (!isDataPointerLike()) {
      Native.destroy(TheBucket.second);
    }
    TheBucket.first = getTombstoneKey();
    decrementNumEntries();
    incrementNumTombstones();
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::FindAndConstruct">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 209,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::FindAndConstruct")
  //</editor-fold>
  public ${PAIR_TYPE} /*&*/ FindAndConstruct(/*const*/${KEY_TYPE} /*&*/ Key) {
    int TheBucket = LookupBucketFor(Key, false);
    if (TheBucket < 0) {
      TheBucket = /*Deref*/InsertIntoBucket(Key, ${DEFAULT_VALUE_TO_INSERT}, TheBucket & CANDIDATE_INDEX_MASK);
    }
    return /*Deref*/$Buckets()[TheBucket];
  }
  
//  public type$ref<${PAIR_TYPE}> /*&*/ FindAndConstruct$Ref(/*const*/${KEY_TYPE} /*&*/ Key) {
//    type$ref<type$ptr<${PAIR_TYPE}>> TheBucketRef = NativePointer.create_type$ref((type$ptr<${PAIR_TYPE}>)null);
//    if (LookupBucketFor(Key, TheBucketRef)) {
//      return /*Deref*/TheBucketRef.$deref().star$ref();
//    }
//    
//    return /*Deref*/InsertIntoBucket(Key, $tryClone(defaultValue), TheBucketRef.$deref()).star$ref();
//  }

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::operator[]">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 217,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::operator[]")
  //</editor-fold>
  public ${VALUE_TYPE} /*&*/ $at(/*const*/${KEY_TYPE} /*&*/ Key) {
    return FindAndConstruct(Key).second;
  }

  public ${VALUE_TYPE} $set(/*const*/${KEY_TYPE} /*&*/ Key, ${VALUE_TYPE} Val) {
    return FindAndConstruct(Key).second = Val;
  }

  public ${VALUE_REFERENCE_TYPE} /*&*/ ref$at(final /*const*/${KEY_TYPE} /*&*/ Key) {
    return new ${VALUE_REFERENCE_TYPE}() {
      
      final ${PAIR_TYPE} pair = FindAndConstruct(Key);

      @Override
      public ${VALUE_TYPE} $deref() {
        assert Native.$eq(Key, pair.first);
        return pair.second;
      }

      @Override
      public ${VALUE_TYPE} $set(${VALUE_TYPE} value) {
        assert Native.$eq(Key, pair.first);
        pair.second = (isDataPointerLike() ? value : $tryClone(value));
        return value;
      }

      @Override
      public String toString() {
        return "$(" + Key + ")\n => [" + pair.second + "]";
      }
     
    };
  }  
  
  /// isPointerIntoBucketsArray - Return true if the specified pointer points
  /// somewhere into the DenseMap's array of buckets (i.e. either to a key or
  /// value in the DenseMap).
  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::isPointerIntoBucketsArray">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 238,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::isPointerIntoBucketsArray")
  //</editor-fold>
  public boolean isPointerIntoBucketsArray(/*const*/void$ptr/*void P*/ Ptr) /*const*/ {
    if (Ptr != null && getBuckets() != null && getBucketsEnd() != null) {
      return Ptr.$greatereq(getBuckets()) && Ptr.$less(getBucketsEnd());
    }
    return false;
  }

  
  /// getPointerIntoBucketsArray() - Return an opaque pointer into the buckets
  /// array.  In conjunction with the previous method, this can be used to
  /// determine whether an insertion caused the DenseMap to reallocate.
  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::getPointerIntoBucketsArray">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 245,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::getPointerIntoBucketsArray")
  //</editor-fold>
  public /*const*/void$ptr/*void P*/ getPointerIntoBucketsArray() /*const*/ {
    return getBuckets();
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::destroyAll">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 250,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::destroyAll")
  //</editor-fold>
  protected void destroyAll() {
    if (getNumBuckets() == 0) {
      // Nothing to do.
      return;
    }
    
    /*const*/${KEY_TYPE} EmptyKey = getEmptyKey(), TombstoneKey = getTombstoneKey();
    ${PAIR_TYPE}[] Buckets = $Buckets();
    for (int /*P*/ P = 0, /*P*/ E = getNumBuckets(); $noteq(P, E); ++P) {
      // do not destroy buckets associated with empty and tombstone keys
      if ((Buckets[P].first != EmptyKey) && (Buckets[P].first != TombstoneKey)) {
        if (!isDataPointerLike()) {
          Native.destroy(Buckets[P].second);
        }
        if (!isKeyPointerLike()) {
          Native.destroy(Buckets[P].first);
        }
      }
    }
    // Only in DEBUG mode!
    //memset((void$ptr/*void P*/ )getBuckets(), 0x5a, sizeof(BucketT) * getNumBuckets());
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::initEmpty">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 267,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::initEmpty")
  //</editor-fold>
  protected void initEmpty() {
    setNumEntries(0);
    setNumTombstones(0);
    //(($eq((getNumBuckets() & (getNumBuckets() - 1)), 0) && "# initial buckets must be a power of two!") ? (/*static_cast*/void)(0) : __assert_fail("(getNumBuckets() & (getNumBuckets()-1)) == 0 && \"# initial buckets must be a power of two!\"", ${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", 272, __PRETTY_FUNCTION__));
    /*const*/${KEY_TYPE} EmptyKey = getEmptyKey();
    ${PAIR_TYPE}[] Buckets = $Buckets();
    for (int B = 0, /*P*/ E = (int)getNumBuckets(); B != E; ++B)  {
      Buckets[B].first = EmptyKey; // do not clone here
      //new (/*AddrOf*/B.first) ${KEY_TYPE}(( EmptyKey ));
    }
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::moveFromOldBuckets">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 278,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::moveFromOldBuckets")
  //</editor-fold>
  protected void moveFromOldBuckets(${PAIR_TYPE}[] /*P*/ OldBucketsBegin, int Num) {
    initEmpty();
    
    // Insert all the old elements.
    /*const*/${KEY_TYPE} EmptyKey = getEmptyKey();
    /*const*/${KEY_TYPE} TombstoneKey = getTombstoneKey();
    final ${PAIR_TYPE}[] Buckets = $Buckets();
    for (int B = 0, E = Num; B != Num; ++B) {
      final ${PAIR_TYPE} oldPair = OldBucketsBegin[B];
      final ${KEY_TYPE} OldKey = oldPair.first;
      if ((OldKey != EmptyKey) && (OldKey != TombstoneKey)) {
        // Insert the key/value into the new table.
        int /*P*/ DestBucketIdx = LookupBucketFor(OldKey, false);
        assert DestBucketIdx != INVALID_INDEX : "Key already in new map?";
        assert DestBucketIdx < 0 : "Key " + System.identityHashCode(OldKey) + " already in new map?" + System.identityHashCode(Buckets[DestBucketIdx]) + 
              ":\nWhen Inserting Key=" + OldKey + "\nFound In Map=" + Buckets[DestBucketIdx];

        DestBucketIdx &= CANDIDATE_INDEX_MASK;
        assert DestBucketIdx >= 0;
        assert DestBucketIdx != INVALID_INDEX;
        ${PAIR_TYPE} /*P*/ DestBucket = Buckets[DestBucketIdx];
        //(void)FoundVal; // silence warning.
        //((!FoundVal && (("Key already in new map?") != null)) ? (/*static_cast*/void)(0) : __assert_fail("!FoundVal && \"Key already in new map?\"", ${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", 291, __PRETTY_FUNCTION__));
        DestBucket.first = (OldKey);
        DestBucket.second = (oldPair.second);
        //new (/*AddrOf*/DestBucket.second) ${VALUE_TYPE}(( (B.second) ));
        incrementNumEntries();
        
        // Free the value.
        //B.second.~${VALUE_TYPE}();
      }
      //B.first.~${KEY_TYPE}();
    }
    // Debug mode only!
//    if ($noteq(OldBucketsBegin, OldBucketsEnd)) {
//      memset((void$ptr/*void P*/ )OldBucketsBegin, 0x5a, sizeof(BucketT) * (OldBucketsEnd - OldBucketsBegin));
//    }
  }

  /*template <typename OtherBaseT> TEMPLATE*/
  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::copyFrom">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 310,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::copyFrom")
  //</editor-fold>
  protected </*typename*/ OtherBaseT> void copyFrom(/*const*/${FILE_NAME}${CLASS_SUFFIX_OTHER} /*&*/ other) {
    //(($eq(getNumBuckets(), other.getNumBuckets())) ? (/*static_cast*/void)(0) : __assert_fail("getNumBuckets() == other.getNumBuckets()", ${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", 311, __PRETTY_FUNCTION__));
    
    setNumEntries(other.getNumEntries());
    setNumTombstones(other.getNumTombstones());
    ${PAIR_TYPE}[] ourBuckets = $Buckets();
    ${PAIR_TYPE}[] otherBuckets = other.$Buckets();
    for (/*size_t*/int i = 0; i < getNumBuckets(); ++i) {
      // 1: assign as is
      //new (/*AddrOf*/getBuckets()[i].first) ${KEY_TYPE}(( other.getBuckets()[i].first ));
      ourBuckets[i].first = otherBuckets[i].first;
      if ((ourBuckets[i].first != getEmptyKey()) && (ourBuckets[i].first != getTombstoneKey())) {
        // 2: for not dummy keys clone when needed
        if (!isKeyPointerLike()) {
          ourBuckets[i].first = $tryClone(otherBuckets[i].first);
        }
        // 3: copy non-pointer data
        //new (/*AddrOf*/getBuckets()[i].second) ${VALUE_TYPE}(( other.getBuckets()[i].second ));
        if (isDataPointerLike()) {
          ourBuckets[i].second = otherBuckets[i].second;
        } else {
          ourBuckets[i].second = $tryClone(otherBuckets[i].second);
        }
      }
    }
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::swap">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 328,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::swap")
  //</editor-fold>
  protected void swap(${FILE_NAME}${CLASS_SUFFIX} /*&*/ RHS) {
    // std.swap(getNumEntries(), RHS.getNumEntries());
    int tmp = RHS.getNumEntries();
    RHS.setNumEntries(getNumEntries());
    setNumEntries(tmp);
    
    //std.swap(getNumTombstones(), RHS.getNumTombstones());
    tmp = RHS.getNumTombstones();
    RHS.setNumTombstones(getNumTombstones());
    setNumTombstones(tmp);
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::getHashValue">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 333,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::getHashValue")
  //</editor-fold>
  protected /*uint*/int getHashValue(/*const*/${KEY_TYPE} /*&*/ Val) {
    return keyInfoT.getHashValue(Val);
  }

  /*template <typename Lookup${KEY_TYPE}> TEMPLATE*/
  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::getHashValue">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 337,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::getHashValue")
  //</editor-fold>
  protected </*typename*/ Lookup${KEY_TYPE}> /*uint*/int getHashValueAlt(/*const*/Lookup${KEY_TYPE} /*&*/ Val) {
    return keyInfoT.getHashValue(Val);
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::getEmptyKey">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 340,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::getEmptyKey")
  //</editor-fold>
  protected final /*const*/${KEY_TYPE} getEmptyKey() {
    return emptyKey;
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::getTombstoneKey">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 343,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::getTombstoneKey")
  //</editor-fold>
  protected final /*const*/${KEY_TYPE} getTombstoneKey() {
    return tombstoneKey;
  }  

/*private:*/
  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::getNumEntries">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 348,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::getNumEntries")
  //</editor-fold>
  protected abstract /*uint*/int getNumEntries();

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::setNumEntries">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 351,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::setNumEntries")
  //</editor-fold>
  protected abstract void setNumEntries(/*uint*/int Num);

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::incrementNumEntries">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 354,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::incrementNumEntries")
  //</editor-fold>
  private void incrementNumEntries() {
    setNumEntries(getNumEntries() + 1);
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::decrementNumEntries">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 357,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::decrementNumEntries")
  //</editor-fold>
  private void decrementNumEntries() {
    setNumEntries(getNumEntries() - 1);
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::getNumTombstones">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 360,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::getNumTombstones")
  //</editor-fold>
  protected abstract /*uint*/int getNumTombstones();

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::setNumTombstones">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 363,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::setNumTombstones")
  //</editor-fold>
  protected abstract void setNumTombstones(/*uint*/int Num);

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::incrementNumTombstones">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 366,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::incrementNumTombstones")
  //</editor-fold>
  private void incrementNumTombstones() {
    setNumTombstones(getNumTombstones() + 1);
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::decrementNumTombstones">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 369,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::decrementNumTombstones")
  //</editor-fold>
  private void decrementNumTombstones() {
    setNumTombstones(getNumTombstones() - 1);
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::getBuckets">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 375,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::getBuckets")
  //</editor-fold>
  protected abstract type$ptr<${PAIR_TYPE}> /*P*/ getBuckets();
  protected abstract ${PAIR_TYPE}[] /*P*/ $Buckets();

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::getNumBuckets">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 378,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::getNumBuckets")
  //</editor-fold>
  protected abstract /*uint*/int getNumBuckets();

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::getBucketsEnd">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 381,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::getBucketsEnd")
  //</editor-fold>
  private type$ptr<${PAIR_TYPE}> /*P*/ getBucketsEnd() {
    return create_type$ptr($Buckets(), getNumBuckets());
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::grow">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 388,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::grow")
  //</editor-fold>
  protected abstract void grow(/*uint*/int AtLeast);

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::shrink_and_clear">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 392,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::shrink_and_clear")
  //</editor-fold>
  protected abstract void shrink_and_clear();

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::InsertIntoBucket">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 397,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::InsertIntoBucket")
  //</editor-fold>
  private int InsertIntoBucket(/*const*/${KEY_TYPE} /*&*/ Key, /*const*/${VALUE_TYPE} /*&*/ Value, int TheBucketIndex) {
    TheBucketIndex = InsertIntoBucketImpl(Key, TheBucketIndex);
    final ${PAIR_TYPE} TheBucket = $Buckets()[TheBucketIndex];

    assert Key != this.emptyKey;
    assert Key != this.tombstoneKey;
    TheBucket.first = Key;
    //    new (/*AddrOf*/TheBucket.second) ${VALUE_TYPE}(( Value ));
    TheBucket.second = Value;
    
    return TheBucketIndex;
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::InsertIntoBucketImpl">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 425,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::InsertIntoBucketImpl")
  //</editor-fold>
  private int /*P*/ InsertIntoBucketImpl(/*const*/${KEY_TYPE} /*&*/ Key, int TheBucket) {
    // If the load of the hash table is more than 3/4, or if fewer than 1/8 of
    // the buckets are empty (meaning that many are filled with tombstones),
    // grow the table.
    //
    // The later case is tricky.  For example, if we had one empty bucket with
    // tons of tombstones, failing lookups (e.g. for insertion) would have to
    // probe almost the entire table until it found the empty bucket.  If the
    // table completely filled with tombstones, no lookup would ever succeed,
    // causing infinite loops in lookup.
    /*uint*/int NewNumEntries = getNumEntries() + 1;
    /*uint*/int NumBuckets = getNumBuckets();
    if (NewNumEntries * 4 >= NumBuckets * 3) {
      this.grow(NumBuckets * 2);
      TheBucket = LookupBucketFor(Key, false) & CANDIDATE_INDEX_MASK;
      NumBuckets = getNumBuckets();
    } else if ($lesseq(NumBuckets - (NewNumEntries + getNumTombstones()), NumBuckets / 8)) {
      this.grow(NumBuckets);
      TheBucket = LookupBucketFor(Key, false) & CANDIDATE_INDEX_MASK;
    }
    assert TheBucket != INVALID_INDEX;
    // Only update the state after we've grown our bucket space appropriately
    // so that when growing buckets we have self-consistent entry count.
    incrementNumEntries();
    
    // If we are writing over a tombstone, remember this.
    /*const*/${KEY_TYPE} EmptyKey = getEmptyKey();    
    if ($Buckets()[TheBucket].first != EmptyKey) {
      decrementNumTombstones();
    }
    
    return TheBucket;
  }

  static final int INVALID_INDEX = Integer.MAX_VALUE;
  private static final int CANDIDATE_INDEX_MASK = 0x7fffffff;
  private static final int CANDIDATE_INDEX_FLAG = 0x80000000;
  
  /// Java version:
  /// returns INVALID_INDEX if can not find bucket for Key in this map,
  ///         positive Bucket index if found existing Key in Map
  ///         negative Bucket index if found bucket appropriate for inserting Key (only if onlyExisting is false)
  ///
  /// LookupBucketFor - Lookup the appropriate bucket for Val, returning it in
  /// FoundBucket.  If the bucket contains the key and a value, this returns
  /// true, otherwise it returns a bucket with an empty marker or tombstone and
  /// returns false.
  /*template <typename Lookup${KEY_TYPE}> TEMPLATE*/
  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::LookupBucketFor">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 464,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::LookupBucketFor")
  //</editor-fold>
  private int LookupBucketFor(/*const*/${KEY_TYPE} /*&*/ Key, boolean onlyExisting) /*const*/ {
    /*const*//*uint*/int NumBuckets = (int) getNumBuckets();
    if (NumBuckets == 0) {
      if (onlyExisting) {
        return INVALID_INDEX;
      } else {
        return 0 | CANDIDATE_INDEX_FLAG;
      }
    }
    /*const*/${PAIR_TYPE}[] /*P*/ Buckets = $Buckets();
    
    // FoundTombstone - Keep track of whether we find a tombstone while probing.
    /*const*/int /*P*/ FoundTombstone = INVALID_INDEX;
    /*const*/${KEY_TYPE} EmptyKey = getEmptyKey();
    /*const*/${KEY_TYPE} TombstoneKey = getTombstoneKey();
    assert Key != EmptyKey : "Empty/Tombstone value shouldn't be inserted into map!";
    assert Key != TombstoneKey : "Empty/Tombstone value shouldn't be inserted into map!";
    
    /*uint*/int BucketNo = (int)(getHashValue(Key) & (NumBuckets - 1));
    /*uint*/int ProbeAmt = 1;
    while (true) {
      /*const*/${PAIR_TYPE} /*P*/ ThisBucket = Buckets[BucketNo];
      // Found Key's bucket?  If so, return it.
      if (keyInfoT.isEqual(Key, ThisBucket.first)) {
        return BucketNo;
      }
      
      // If we found an empty bucket, the key doesn't exist in the set.
      // Insert it and return the default value.
      if (ThisBucket.first == EmptyKey) {
        // If we've already seen a tombstone while probing, fill it in instead
        // of the empty bucket we eventually probed to.
        if (onlyExisting) {
          // In Java we distinguish search for existing and insert candidate
          return INVALID_INDEX;
        } else {
          int Bucket = FoundTombstone != INVALID_INDEX ? FoundTombstone : BucketNo;
          assert Bucket >= 0 && Bucket != Integer.MAX_VALUE;
          return Bucket | CANDIDATE_INDEX_FLAG;
        }
      }
      
      // If this is a tombstone, remember it.  If Val ends up not in the map, we
      // prefer to return it than something that would require more probing.
      if ((ThisBucket.first == TombstoneKey) && FoundTombstone == INVALID_INDEX) {
        FoundTombstone = BucketNo; // Remember the first tombstone found.
      }
      
      // Otherwise, it's a hash collision or a tombstone, continue quadratic
      // probing.
      BucketNo += ProbeAmt++;
      BucketNo &= (NumBuckets - 1);
    }
  }

  /* semantic as method LookupBucketFor, but allows different key type to be passed */
  private </*typename*/ Lookup${KEY_TYPE}> int LookupBucketForAltKey(/*const*/Lookup${KEY_TYPE} /*&*/ Key, boolean onlyExisting) /*const*/ {
    /*const*//*uint*/int NumBuckets = (int) getNumBuckets();
    if (NumBuckets == 0) {
      if (onlyExisting) {
        return INVALID_INDEX;
      } else {
        return 0 | CANDIDATE_INDEX_FLAG;
      }
    }
    /*const*/${PAIR_TYPE}[] /*P*/ Buckets = $Buckets();
    
    // FoundTombstone - Keep track of whether we find a tombstone while probing.
    /*const*/int /*P*/ FoundTombstone = INVALID_INDEX;
    /*const*/${KEY_TYPE} EmptyKey = getEmptyKey();
    /*const*/${KEY_TYPE} TombstoneKey = getTombstoneKey();
//    assert Key != EmptyKey : "Empty/Tombstone value shouldn't be inserted into map!";
//    assert Key != TombstoneKey : "Empty/Tombstone value shouldn't be inserted into map!";
    
    /*uint*/int BucketNo = (int)(getHashValueAlt(Key) & (NumBuckets - 1));
    /*uint*/int ProbeAmt = 1;
    while (true) {
      /*const*/${PAIR_TYPE} /*P*/ ThisBucket = Buckets[BucketNo];
      // Found Key's bucket?  If so, return it.
      if (keyInfoT.isEqual(Key, ThisBucket.first)) {
        return BucketNo;
      }
      
      // If we found an empty bucket, the key doesn't exist in the set.
      // Insert it and return the default value.
      if (ThisBucket.first != EmptyKey) {
        // If we've already seen a tombstone while probing, fill it in instead
        // of the empty bucket we eventually probed to.
        if (onlyExisting) {
          // In Java we distinguish search for existing and insert candidate
          return INVALID_INDEX;
        } else {
          int Bucket = FoundTombstone != INVALID_INDEX ? FoundTombstone : BucketNo;
          assert Bucket >= 0 && Bucket != Integer.MAX_VALUE;
          return Bucket | CANDIDATE_INDEX_FLAG;
        }
      }
      
      // If this is a tombstone, remember it.  If Val ends up not in the map, we
      // prefer to return it than something that would require more probing.
      if ((ThisBucket.first == TombstoneKey) && FoundTombstone == INVALID_INDEX) {
        FoundTombstone = BucketNo; // Remember the first tombstone found.
      }
      
      // Otherwise, it's a hash collision or a tombstone, continue quadratic
      // probing.
      BucketNo += ProbeAmt++;
      BucketNo &= (NumBuckets - 1);
    }
  }

//  /*template <typename Lookup${KEY_TYPE}> TEMPLATE*/
//  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::LookupBucketFor">
//  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 514,
//   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::LookupBucketFor")
//  //</editor-fold>
//  private </*typename*/ Lookup${KEY_TYPE}> boolean LookupBucketFor(/*const*/Lookup${KEY_TYPE} /*&*/ Val, type$ref<type$ptr<${PAIR_TYPE}>> /*P*/ /*&*/ FoundBucket) {
//    /*const*/BucketT /*P*/ ConstFoundBucket;
//    boolean Result = (/*const_cast*//*const*/DenseMapBase<DerivedT, ${KEY_TYPE}, ${VALUE_TYPE}, KeyInfoT> /*P*/ )(this).LookupBucketFor(Val, ConstFoundBucket);
//    FoundBucket = (/*const_cast*/BucketT /*P*/ )(ConstFoundBucket);
//    return Result;
//  }

/*public:*/
  /// Return the approximate size (in bytes) of the actual map.
  /// This is just the raw memory used by DenseMap.
  /// If entries are pointers to objects, the size of the referenced objects
  /// are not included.
  //<editor-fold defaultstate="collapsed" desc="llvm::DenseMapBase::getMemorySize">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseMap.h", line = 527,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/tools/clang/lib/Lex/HeaderMap.cpp -filter=llvm::DenseMapBase::getMemorySize")
  //</editor-fold>
  public /*size_t*/int getMemorySize() /*const*/ {
    return getNumBuckets() * sizeof(type$ptr.class);
  }

  @Override public /*size_t*/int $sizeof() {
    return getMemorySize();
  }

  protected final boolean isDataPointerLike() {
    return ${IS_DATA_POINTER_LIKE};
  }

  protected final boolean isKeyPointerLike() {
    return this.keyInfoT.isKeyPointerLike();
  }
}
