/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.analysis;

import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.util.Version;
import org.opensolaris.opengrok.analysis.plain.PlainFullTokenizer;
import org.opensolaris.opengrok.search.SearchEngine;

public final class HistoryAnalyzer
extends Analyzer {
    private CharArraySet stopWords;
    private static final String[] ENGLISH_STOP_WORDS = new String[]{"a", "an", "and", "are", "as", "at", "be", "but", "by", "for", "if", "in", "into", "is", "it", "no", "not", "of", "on", "or", "s", "such", "t", "that", "the", "their", "then", "there", "these", "they", "this", "to", "was", "will", "with", "/", "\\", ":", ".", "0.0", "1.0"};

    public HistoryAnalyzer() {
    }

    public HistoryAnalyzer(String[] stopWords) {
        super(Analyzer.PER_FIELD_REUSE_STRATEGY);
        this.stopWords = StopFilter.makeStopSet((Version)SearchEngine.LUCENE_VERSION, (String[])stopWords);
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        this.stopWords = StopFilter.makeStopSet((Version)SearchEngine.LUCENE_VERSION, (String[])ENGLISH_STOP_WORDS);
        PlainFullTokenizer plainfull = new PlainFullTokenizer(reader);
        return new Analyzer.TokenStreamComponents((Tokenizer)plainfull, (TokenStream)new StopFilter(SearchEngine.LUCENE_VERSION, (TokenStream)plainfull, this.stopWords));
    }
}

