/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.history;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.configuration.Configuration;
import org.opensolaris.opengrok.configuration.RuntimeEnvironment;
import org.opensolaris.opengrok.history.Annotation;
import org.opensolaris.opengrok.history.FileHistoryCache;
import org.opensolaris.opengrok.history.History;
import org.opensolaris.opengrok.history.HistoryCache;
import org.opensolaris.opengrok.history.HistoryEntry;
import org.opensolaris.opengrok.history.HistoryException;
import org.opensolaris.opengrok.history.HistoryReader;
import org.opensolaris.opengrok.history.JDBCHistoryCache;
import org.opensolaris.opengrok.history.Repository;
import org.opensolaris.opengrok.history.RepositoryFactory;
import org.opensolaris.opengrok.history.RepositoryInfo;
import org.opensolaris.opengrok.index.IgnoredNames;
import org.opensolaris.opengrok.util.Statistics;

public final class HistoryGuru {
    private static final Logger log = OpenGrokLogger.getLogger();
    private static HistoryGuru instance = new HistoryGuru();
    private final HistoryCache historyCache;
    private Map<String, Repository> repositories = new HashMap<String, Repository>();
    private final int scanningDepth;

    private HistoryGuru() {
        HistoryCache cache = null;
        RuntimeEnvironment env = RuntimeEnvironment.getInstance();
        this.scanningDepth = env.getScanningDepth();
        if (env.useHistoryCache()) {
            cache = env.storeHistoryCacheInDB() ? new JDBCHistoryCache() : new FileHistoryCache();
            try {
                cache.initialize();
            }
            catch (HistoryException he) {
                log.log(Level.WARNING, "Failed to initialize the history cache", he);
                cache = null;
            }
        }
        this.historyCache = cache;
    }

    public static HistoryGuru getInstance() {
        return instance;
    }

    private boolean useCache() {
        return this.historyCache != null;
    }

    public String getCacheInfo() throws HistoryException {
        return this.historyCache == null ? "No cache" : this.historyCache.getInfo();
    }

    public Annotation annotate(File file, String rev) throws IOException {
        Annotation ret = null;
        Repository repo = this.getRepository(file);
        if (repo != null) {
            ret = repo.annotate(file, rev);
            History hist = null;
            try {
                hist = repo.getHistory(file);
            }
            catch (HistoryException ex) {
                Logger.getLogger(HistoryGuru.class.getName()).log(Level.FINEST, "Cannot get messages for tooltip: ", ex);
            }
            if (hist != null && ret != null) {
                Set<String> revs = ret.getRevisions();
                for (HistoryEntry he : hist.getHistoryEntries()) {
                    String hist_rev = he.getRevision();
                    String short_rev = repo.getRevisionForAnnotate(hist_rev);
                    if (!revs.contains(short_rev)) continue;
                    ret.addDesc(short_rev, "changeset: " + he.getRevision() + "\nsummary: " + he.getMessage() + "\nuser: " + he.getAuthor() + "\ndate: " + he.getDate());
                }
            }
        }
        return ret;
    }

    public HistoryReader getHistoryReader(File file) throws HistoryException {
        History history = this.getHistory(file, false);
        return history == null ? null : new HistoryReader(history);
    }

    public History getHistory(File file) throws HistoryException {
        return this.getHistory(file, true, false);
    }

    public History getHistory(File file, boolean withFiles) throws HistoryException {
        return this.getHistory(file, true, false);
    }

    public History getHistoryUI(File file) throws HistoryException {
        return this.getHistory(file, true, true);
    }

    public History getHistory(File file, boolean withFiles, boolean ui) throws HistoryException {
        boolean doRemote;
        File dir = file.isDirectory() ? file : file.getParentFile();
        Repository repo = this.getRepository(dir);
        History history = null;
        Configuration.RemoteSCM rscm = RuntimeEnvironment.getInstance().getRemoteScmSupported();
        boolean bl = doRemote = ui && rscm == Configuration.RemoteSCM.UIONLY || rscm == Configuration.RemoteSCM.ON || ui || rscm == Configuration.RemoteSCM.DIRBASED && repo != null && repo.hasHistoryForDirectories();
        if (repo != null && repo.isWorking() && repo.fileHasHistory(file) && (!repo.isRemote() || doRemote)) {
            history = this.useCache() && this.historyCache.supportsRepository(repo) ? this.historyCache.get(file, repo, withFiles) : repo.getHistory(file);
        }
        return history;
    }

    public InputStream getRevision(String parent, String basename, String rev) {
        InputStream ret = null;
        Repository rep = this.getRepository(new File(parent));
        if (rep != null) {
            ret = rep.getHistoryGet(parent, basename, rev);
        }
        return ret;
    }

    public boolean hasHistory(File file) {
        Repository repo = this.getRepository(file);
        if (repo == null) {
            return false;
        }
        return repo.isWorking() && repo.fileHasHistory(file) && (RuntimeEnvironment.getInstance().getRemoteScmSupported() == Configuration.RemoteSCM.ON || RuntimeEnvironment.getInstance().getRemoteScmSupported() == Configuration.RemoteSCM.UIONLY || RuntimeEnvironment.getInstance().getRemoteScmSupported() == Configuration.RemoteSCM.DIRBASED || !repo.isRemote());
    }

    public boolean hasAnnotation(File file) {
        Repository repos;
        if (!file.isDirectory() && (repos = this.getRepository(file)) != null && repos.isWorking()) {
            return repos.fileHasAnnotation(file);
        }
        return false;
    }

    public Map<String, Date> getLastModifiedTimes(File directory) throws HistoryException {
        Repository repository = this.getRepository(directory);
        if (repository != null && this.useCache()) {
            return this.historyCache.getLastModifiedTimes(directory, repository);
        }
        return Collections.emptyMap();
    }

    private void addRepositories(File[] files, Collection<RepositoryInfo> repos, IgnoredNames ignoredNames, int depth) {
        this.addRepositories(files, repos, ignoredNames, true, depth);
    }

    private void addRepositories(File[] files, Collection<RepositoryInfo> repos, IgnoredNames ignoredNames, boolean recursiveSearch, int depth) {
        Repository repository;
        for (File file : files) {
            repository = null;
            if (!file.getName().equals(".opengrok_skip_history")) continue;
            log.log(Level.INFO, "Skipping history cache creation for " + file.getParentFile().getAbsolutePath() + " and it's subdirectories");
            return;
        }
        for (File file : files) {
            repository = null;
            try {
                repository = RepositoryFactory.getRepository(file);
            }
            catch (InstantiationException ie) {
                log.log(Level.WARNING, "Could not create repoitory for '" + file + "', could not instantiate the repository.", ie);
            }
            catch (IllegalAccessException iae) {
                log.log(Level.WARNING, "Could not create repoitory for '" + file + "', missing access rights.", iae);
            }
            if (repository == null) {
                if (!file.isDirectory() || ignoredNames.ignore(file)) continue;
                File[] subFiles = file.listFiles();
                if (subFiles == null) {
                    log.log(Level.WARNING, "Failed to get sub directories for '" + file.getAbsolutePath() + "', check access permissions.");
                    continue;
                }
                if (depth > this.scanningDepth) continue;
                this.addRepositories(subFiles, repos, ignoredNames, depth + 1);
                continue;
            }
            try {
                String path = file.getCanonicalPath();
                repository.setDirectoryName(path);
                if (RuntimeEnvironment.getInstance().isVerbose()) {
                    log.log(Level.CONFIG, "Adding <{0}> repository: <{1}>", new Object[]{repository.getClass().getName(), path});
                }
                repos.add(new RepositoryInfo(repository));
                if (!recursiveSearch || !repository.supportsSubRepositories()) continue;
                File[] subFiles = file.listFiles();
                if (subFiles == null) {
                    log.log(Level.WARNING, "Failed to get sub directories for '" + file.getAbsolutePath() + "', check access permissions.");
                    continue;
                }
                if (depth > this.scanningDepth) continue;
                this.addRepositories(subFiles, repos, ignoredNames, false, depth + 1);
            }
            catch (IOException exp) {
                log.log(Level.WARNING, "Failed to get canonical path for " + file.getAbsolutePath() + ": " + exp.getMessage());
                log.log(Level.WARNING, "Repository will be ignored...", exp);
            }
        }
    }

    public void addRepositories(String dir) {
        ArrayList<RepositoryInfo> repos = new ArrayList<RepositoryInfo>();
        this.addRepositories(new File[]{new File(dir)}, repos, RuntimeEnvironment.getInstance().getIgnoredNames(), 0);
        RuntimeEnvironment.getInstance().setRepositories(repos);
        this.invalidateRepositories(repos);
    }

    public void updateRepositories() {
        boolean verbose = RuntimeEnvironment.getInstance().isVerbose();
        for (Map.Entry<String, Repository> entry : this.repositories.entrySet()) {
            Repository repository = entry.getValue();
            String path = entry.getKey();
            String type = repository.getClass().getSimpleName();
            if (repository.isWorking()) {
                if (verbose) {
                    log.info(String.format("Update %s repository in %s", type, path));
                }
                try {
                    repository.update();
                }
                catch (UnsupportedOperationException e) {
                    log.warning(String.format("Skipping update of %s repository in %s: Not implemented", type, path));
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "An error occured while updating " + path + " (" + type + ")", e);
                }
                continue;
            }
            log.warning(String.format("Skipping update of %s repository in %s: Missing SCM dependencies?", type, path));
        }
    }

    public void updateRepositories(Collection<String> paths) {
        boolean verbose = RuntimeEnvironment.getInstance().isVerbose();
        List<Repository> repos = this.getReposFromString(paths);
        for (Repository repository : repos) {
            String type = repository.getClass().getSimpleName();
            if (repository.isWorking()) {
                if (verbose) {
                    log.info(String.format("Update %s repository in %s", type, repository.getDirectoryName()));
                }
                try {
                    repository.update();
                }
                catch (UnsupportedOperationException e) {
                    log.warning(String.format("Skipping update of %s repository in %s: Not implemented", type, repository.getDirectoryName()));
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "An error occured while updating " + repository.getDirectoryName() + " (" + type + ")", e);
                }
                continue;
            }
            log.warning(String.format("Skipping update of %s repository in %s: Missing SCM dependencies?", type, repository.getDirectoryName()));
        }
    }

    private void createCache(Repository repository, String sinceRevision) {
        String path = repository.getDirectoryName();
        String type = repository.getClass().getSimpleName();
        if (repository.isWorking()) {
            boolean verbose = RuntimeEnvironment.getInstance().isVerbose();
            Statistics elapsed = new Statistics();
            if (verbose) {
                log.log(Level.INFO, "Creating historycache for {0} ({1})", new Object[]{path, type});
            }
            try {
                repository.createCache(this.historyCache, sinceRevision);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "An error occured while creating cache for " + path + " (" + type + ")", e);
            }
            if (verbose) {
                elapsed.report(log, "Done historycache for " + path);
            }
        } else {
            log.log(Level.WARNING, "Skipping creation of historycache of " + type + " repository in " + path + ": Missing SCM dependencies?");
        }
    }

    private void createCacheReal(Collection<Repository> repositories) {
        Statistics elapsed = new Statistics();
        ExecutorService executor = RuntimeEnvironment.getHistoryExecutor();
        HashMap<Repository, String> repos2process = new HashMap<Repository, String>();
        for (Repository repository : repositories) {
            try {
                String string = this.historyCache.getLatestCachedRevision(repository);
                repos2process.put(repository, string);
            }
            catch (HistoryException he) {
                log.log(Level.WARNING, String.format("Failed to retrieve latest cached revision for %s", repository.getDirectoryName()), he);
            }
        }
        log.log(Level.INFO, "Creating historycache for {0} repositories", repos2process.size());
        final CountDownLatch latch = new CountDownLatch(repos2process.size());
        for (final Map.Entry entry : repos2process.entrySet()) {
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        HistoryGuru.this.createCache((Repository)entry.getKey(), (String)entry.getValue());
                    }
                    catch (Exception ex) {
                        log.log(Level.WARNING, "createCacheReal() got exception" + ex);
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {
            OpenGrokLogger.getLogger().log(Level.SEVERE, "latch exception" + interruptedException);
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
            try {
                executor.awaitTermination(999L, TimeUnit.DAYS);
            }
            catch (InterruptedException interruptedException) {
                OpenGrokLogger.getLogger().log(Level.WARNING, "Received interrupt while waiting for executor to finish", interruptedException);
            }
        }
        RuntimeEnvironment.freeHistoryExecutor();
        try {
            RuntimeEnvironment.destroyRenamedHistoryExecutor();
        }
        catch (InterruptedException interruptedException) {
            OpenGrokLogger.getLogger().log(Level.SEVERE, "destroying of renamed thread pool failed", interruptedException);
        }
        try {
            this.historyCache.optimize();
        }
        catch (HistoryException historyException) {
            OpenGrokLogger.getLogger().log(Level.WARNING, "Failed optimizing the history cache database", historyException);
        }
        elapsed.report(log, "Done historycache for all repositories");
        this.historyCache.setHistoryIndexDone();
    }

    public void createCache(Collection<String> repositories) {
        if (!this.useCache()) {
            return;
        }
        this.createCacheReal(this.getReposFromString(repositories));
    }

    public void removeCache(Collection<String> repositories) throws HistoryException {
        List<Repository> repos = this.getReposFromString(repositories);
        HistoryCache cache = this.historyCache;
        if (cache == null) {
            if (RuntimeEnvironment.getInstance().storeHistoryCacheInDB()) {
                cache = new JDBCHistoryCache();
                cache.initialize();
            } else {
                cache = new FileHistoryCache();
            }
        }
        for (Repository r : repos) {
            try {
                cache.clear(r);
                log.info("History cache for " + r.getDirectoryName() + " cleared.");
            }
            catch (HistoryException e) {
                log.warning("Clearing history cache for repository " + r.getDirectoryName() + " failed: " + e.getLocalizedMessage());
            }
        }
        this.invalidateRepositories(repos);
    }

    public void createCache() {
        if (!this.useCache()) {
            return;
        }
        this.createCacheReal(this.repositories.values());
    }

    private List<Repository> getReposFromString(Collection<String> repositories) {
        ArrayList<Repository> repos = new ArrayList<Repository>();
        File root = RuntimeEnvironment.getInstance().getSourceRootFile();
        for (String file : repositories) {
            File f = new File(root, file);
            Repository r = this.getRepository(f);
            if (r == null) {
                log.log(Level.WARNING, "Could not locate a repository for {0}", f.getAbsolutePath());
                continue;
            }
            if (repos.contains(r)) continue;
            repos.add(r);
        }
        return repos;
    }

    public void ensureHistoryCacheExists(File file) throws HistoryException {
        if (!this.useCache()) {
            return;
        }
        Repository repository = this.getRepository(file);
        if (repository == null) {
            return;
        }
        String sinceRevision = null;
        if (this.historyCache.hasCacheForDirectory(file, repository) && (sinceRevision = this.historyCache.getLatestCachedRevision(repository)) == null) {
            return;
        }
        this.createCache(this.getRepository(file), sinceRevision);
    }

    protected Repository getRepository(File path) {
        Map<String, Repository> repos = this.repositories;
        File file = path;
        try {
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Failed to get canonical path for " + path, e);
            return null;
        }
        for (file = path.getCanonicalFile(); file != null; file = file.getParentFile()) {
            Repository r = repos.get(file.getAbsolutePath());
            if (r == null) continue;
            return r;
        }
        return null;
    }

    public void invalidateRepositories(Collection<? extends RepositoryInfo> repos, List<String> dirs) {
        if (repos != null && !repos.isEmpty() && dirs != null && !dirs.isEmpty()) {
            ArrayList<? extends RepositoryInfo> newrepos = new ArrayList<RepositoryInfo>();
            for (RepositoryInfo repositoryInfo : repos) {
                for (String dir : dirs) {
                    Path dirPath = new File(dir).toPath();
                    Path iPath = new File(repositoryInfo.getDirectoryName()).toPath();
                    if (!iPath.startsWith(dirPath)) continue;
                    newrepos.add(repositoryInfo);
                }
            }
            repos = newrepos;
        }
        this.invalidateRepositories(repos);
    }

    public void invalidateRepositories(Collection<? extends RepositoryInfo> repos) {
        if (repos == null || repos.isEmpty()) {
            this.repositories.clear();
        } else {
            HashMap<String, Repository> newrepos = new HashMap<String, Repository>(repos.size());
            Statistics elapsed = new Statistics();
            boolean verbose = RuntimeEnvironment.getInstance().isVerbose();
            if (verbose) {
                log.log(Level.FINE, "invalidating repositories");
            }
            for (RepositoryInfo repositoryInfo : repos) {
                try {
                    Repository r = RepositoryFactory.getRepository(repositoryInfo);
                    if (r == null) {
                        log.log(Level.WARNING, "Failed to instanciate internal repository data for " + repositoryInfo.getType() + " in " + repositoryInfo.getDirectoryName());
                        continue;
                    }
                    newrepos.put(r.getDirectoryName(), r);
                }
                catch (InstantiationException ex) {
                    log.log(Level.WARNING, "Could not create " + repositoryInfo.getType() + " for '" + repositoryInfo.getDirectoryName() + "', could not instantiate the repository.", ex);
                }
                catch (IllegalAccessException iae) {
                    log.log(Level.WARNING, "Could not create " + repositoryInfo.getType() + " for '" + repositoryInfo.getDirectoryName() + "', missing access rights.", iae);
                }
            }
            this.repositories = newrepos;
            if (verbose) {
                elapsed.report(log, "done invalidating repositories");
            }
        }
    }
}

