/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.web;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.configuration.RuntimeEnvironment;
import org.opensolaris.opengrok.web.PageConfig;

public final class WebappListener
implements ServletContextListener,
ServletRequestListener {
    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext context = servletContextEvent.getServletContext();
        RuntimeEnvironment env = RuntimeEnvironment.getInstance();
        String config = context.getInitParameter("CONFIGURATION");
        if (config == null) {
            OpenGrokLogger.getLogger().severe("CONFIGURATION section missing in web.xml");
        } else {
            try {
                env.readConfiguration(new File(config));
            }
            catch (IOException ex) {
                OpenGrokLogger.getLogger().log(Level.WARNING, "OpenGrok Configuration error. Failed to read config file: ", ex);
            }
        }
        String address = context.getInitParameter("ConfigAddress");
        if (address != null && address.length() > 0) {
            OpenGrokLogger.getLogger().log(Level.CONFIG, "Will listen for configuration on [{0}]", address);
            String[] cfg = address.split(":");
            if (cfg.length == 2) {
                try {
                    InetSocketAddress addr = new InetSocketAddress(InetAddress.getByName(cfg[0]), Integer.parseInt(cfg[1]));
                    if (!RuntimeEnvironment.getInstance().startConfigurationListenerThread(addr)) {
                        OpenGrokLogger.getLogger().log(Level.SEVERE, "OpenGrok: Failed to start configuration listener thread");
                    }
                }
                catch (NumberFormatException ex) {
                    OpenGrokLogger.getLogger().log(Level.SEVERE, "OpenGrok: Failed to start configuration listener thread:", ex);
                }
                catch (UnknownHostException ex) {
                    OpenGrokLogger.getLogger().log(Level.SEVERE, "OpenGrok: Failed to start configuration listener thread:", ex);
                }
            } else {
                OpenGrokLogger.getLogger().log(Level.SEVERE, "Incorrect format for the configuration address: ");
                for (int i = 0; i < cfg.length; ++i) {
                    OpenGrokLogger.getLogger().log(Level.SEVERE, "[{0}]", cfg[i]);
                }
            }
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        RuntimeEnvironment.getInstance().stopConfigurationListenerThread();
    }

    public void requestDestroyed(ServletRequestEvent e) {
        PageConfig.cleanup(e.getServletRequest());
    }

    public void requestInitialized(ServletRequestEvent e) {
    }
}

