/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Images;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java2d.AnimatingSurface;

public class WarpImage
extends AnimatingSurface {
    private static int iw;
    private static int ih;
    private static int iw2;
    private static int ih2;
    private static Image img;
    private static final int FORWARD = 0;
    private static final int BACK = 1;
    private Point2D[] pts;
    private int direction = 0;
    private int pNum;
    private int x;
    private int y;

    public WarpImage() {
        this.setBackground(Color.white);
        img = this.getImage("surfing.png");
        iw = img.getWidth(this);
        ih = img.getHeight(this);
        iw2 = iw / 2;
        ih2 = ih / 2;
    }

    @Override
    public void reset(int w, int h) {
        this.pNum = 0;
        this.direction = 0;
        CubicCurve2D.Float cc = new CubicCurve2D.Float((float)w * 0.2f, (float)h * 0.5f, (float)w * 0.4f, 0.0f, (float)w * 0.6f, h, (float)w * 0.8f, (float)h * 0.5f);
        PathIterator pi = cc.getPathIterator(null, 0.1);
        Point2D[] tmp = new Point2D[200];
        int i = 0;
        while (!pi.isDone()) {
            float[] coords = new float[6];
            switch (pi.currentSegment(coords)) {
                case 0: 
                case 1: {
                    tmp[i] = new Point2D.Float(coords[0], coords[1]);
                }
            }
            ++i;
            pi.next();
        }
        this.pts = new Point2D[i];
        System.arraycopy(tmp, 0, this.pts, 0, i);
    }

    @Override
    public void step(int w, int h) {
        if (this.pts == null) {
            return;
        }
        this.x = (int)this.pts[this.pNum].getX();
        this.y = (int)this.pts[this.pNum].getY();
        if (this.direction == 0 && ++this.pNum == this.pts.length) {
            this.direction = 1;
        }
        if (this.direction == 1 && --this.pNum == 0) {
            this.direction = 0;
        }
    }

    @Override
    public void render(int w, int h, Graphics2D g2) {
        g2.drawImage(img, 0, 0, this.x, this.y, 0, 0, iw2, ih2, this);
        g2.drawImage(img, this.x, 0, w, this.y, iw2, 0, iw, ih2, this);
        g2.drawImage(img, 0, this.y, this.x, h, 0, ih2, iw2, ih, this);
        g2.drawImage(img, this.x, this.y, w, h, iw2, ih2, iw, ih, this);
    }

    public static void main(String[] argv) {
        WarpImage.createDemoFrame(new WarpImage());
    }
}

