require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_ARM_ARM32_PARAM_H_)) {
    eval 'sub _ARM_ARM32_PARAM_H_ () {1;}' unless defined(&_ARM_ARM32_PARAM_H_);
    if(defined(&_KERNEL_OPT)) {
	require './arm/arm32/opt_arm32_pmap.ph';
    }
    unless(defined(&PGSHIFT)) {
	if(defined(&_ARM_ARCH_6)) {
	    eval 'sub PGSHIFT () {13;}' unless defined(&PGSHIFT);
	} else {
	    eval 'sub PGSHIFT () {12;}' unless defined(&PGSHIFT);
	}
    }
    eval 'sub NBPG () {(1<<  &PGSHIFT);}' unless defined(&NBPG);
    eval 'sub PGOFSET () {( &NBPG - 1);}' unless defined(&PGOFSET);
    eval 'sub NPTEPG () {( &NBPG / $sizeof{ &pt_entry_t});}' unless defined(&NPTEPG);
    eval 'sub SSIZE () {1;}' unless defined(&SSIZE);
    eval 'sub SINCR () {1;}' unless defined(&SINCR);
    eval 'sub USPACE () {8192;}' unless defined(&USPACE);
    eval 'sub UPAGES () {( &USPACE /  &NBPG);}' unless defined(&UPAGES);
    unless(defined(&MSGBUFSIZE)) {
	eval 'sub MSGBUFSIZE () {16384;}' unless defined(&MSGBUFSIZE);
    }
    eval 'sub NKMEMPAGES_MIN_DEFAULT () {((8* 1024* 1024) >>  &PAGE_SHIFT);}' unless defined(&NKMEMPAGES_MIN_DEFAULT);
    if(defined(&_ARM_ARCH_6)) {
	eval 'sub NKMEMPAGES_MAX_DEFAULT () {((768* 1024* 1024) >>  &PAGE_SHIFT);}' unless defined(&NKMEMPAGES_MAX_DEFAULT);
    } else {
	eval 'sub NKMEMPAGES_MAX_DEFAULT () {((256* 1024* 1024) >>  &PAGE_SHIFT);}' unless defined(&NKMEMPAGES_MAX_DEFAULT);
    }
    eval 'sub USPACE_SVC_STACK_TOP () {( &USPACE);}' unless defined(&USPACE_SVC_STACK_TOP);
    eval 'sub USPACE_SVC_STACK_BOTTOM () {($sizeof{\'struct pcb\'});}' unless defined(&USPACE_SVC_STACK_BOTTOM);
    eval 'sub arm_btop {
        my($x) = @_;
	    eval q((($x) >>  &PGSHIFT));
    }' unless defined(&arm_btop);
    eval 'sub arm_ptob {
        my($x) = @_;
	    eval q((($x) <<  &PGSHIFT));
    }' unless defined(&arm_ptob);
    eval 'sub arm_trunc_page {
        my($x) = @_;
	    eval q((($x) & ~ &PGOFSET));
    }' unless defined(&arm_trunc_page);
    if(defined(&_KERNEL)) {
	unless(defined(&_LOCORE)) {
	    unless(defined(&__HIDE_DELAY)) {
		eval 'sub DELAY {
		    my($x) = @_;
    		    eval q( &delay($x));
		}' unless defined(&DELAY);
	    }
	}
    }
    require 'arm/param.ph';
}
1;
