require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&luaconf_h)) {
    eval 'sub luaconf_h () {1;}' unless defined(&luaconf_h);
    unless(defined(&_KERNEL)) {
	require 'limits.ph';
	require 'stddef.ph';
    } else {
	require 'machine/limits.ph';
	require 'sys/systm.ph';
    }
    if(!defined(&LUA_USE_C89)  && defined(&_WIN32)  && !defined(&_WIN32_WCE)) {
	eval 'sub LUA_USE_WINDOWS () {1;}' unless defined(&LUA_USE_WINDOWS);
    }
    if(defined(&LUA_USE_WINDOWS)) {
	eval 'sub LUA_DL_DLL () {1;}' unless defined(&LUA_DL_DLL);
	eval 'sub LUA_USE_C89 () {1;}' unless defined(&LUA_USE_C89);
    }
    if(defined(&LUA_USE_LINUX)) {
	eval 'sub LUA_USE_POSIX () {1;}' unless defined(&LUA_USE_POSIX);
	eval 'sub LUA_USE_DLOPEN () {1;}' unless defined(&LUA_USE_DLOPEN);
	eval 'sub LUA_USE_READLINE () {1;}' unless defined(&LUA_USE_READLINE);
    }
    if(defined(&LUA_USE_MACOSX)) {
	eval 'sub LUA_USE_POSIX () {1;}' unless defined(&LUA_USE_POSIX);
	eval 'sub LUA_USE_DLOPEN () {1;}' unless defined(&LUA_USE_DLOPEN);
	eval 'sub LUA_USE_READLINE () {1;}' unless defined(&LUA_USE_READLINE);
    }
    if(defined(&LUA_USE_C89)  && !defined(&LUA_USE_WINDOWS)) {
	eval 'sub LUA_C89_NUMBERS () {1;}' unless defined(&LUA_C89_NUMBERS);
    }
    if((((defined(&INT_MAX) ? &INT_MAX : undef) >> 15) >> 15) >= 1) {
	eval 'sub LUAI_BITSINT () {32;}' unless defined(&LUAI_BITSINT);
    } else {
	eval 'sub LUAI_BITSINT () {16;}' unless defined(&LUAI_BITSINT);
    }
    eval 'sub LUA_INT_INT () {1;}' unless defined(&LUA_INT_INT);
    eval 'sub LUA_INT_LONG () {2;}' unless defined(&LUA_INT_LONG);
    eval 'sub LUA_INT_LONGLONG () {3;}' unless defined(&LUA_INT_LONGLONG);
    eval 'sub LUA_FLOAT_FLOAT () {1;}' unless defined(&LUA_FLOAT_FLOAT);
    eval 'sub LUA_FLOAT_DOUBLE () {2;}' unless defined(&LUA_FLOAT_DOUBLE);
    eval 'sub LUA_FLOAT_LONGDOUBLE () {3;}' unless defined(&LUA_FLOAT_LONGDOUBLE);
    if(defined(&LUA_32BITS) ) {
	if((defined(&LUAI_BITSINT) ? &LUAI_BITSINT : undef) >= 32) {
	    eval 'sub LUA_INT_TYPE () { &LUA_INT_INT;}' unless defined(&LUA_INT_TYPE);
	} else {
	    eval 'sub LUA_INT_TYPE () { &LUA_INT_LONG;}' unless defined(&LUA_INT_TYPE);
	}
	eval 'sub LUA_FLOAT_TYPE () { &LUA_FLOAT_FLOAT;}' unless defined(&LUA_FLOAT_TYPE);
    }
 elsif(defined(&LUA_C89_NUMBERS) ) {
	eval 'sub LUA_INT_TYPE () { &LUA_INT_LONG;}' unless defined(&LUA_INT_TYPE);
	eval 'sub LUA_FLOAT_TYPE () { &LUA_FLOAT_DOUBLE;}' unless defined(&LUA_FLOAT_TYPE);
    }
    if(!defined(&LUA_INT_TYPE)) {
	eval 'sub LUA_INT_TYPE () { &LUA_INT_LONGLONG;}' unless defined(&LUA_INT_TYPE);
    }
    if(!defined(&LUA_FLOAT_TYPE)) {
	eval 'sub LUA_FLOAT_TYPE () { &LUA_FLOAT_DOUBLE;}' unless defined(&LUA_FLOAT_TYPE);
    }
    eval 'sub LUA_PATH_SEP () {";";}' unless defined(&LUA_PATH_SEP);
    eval 'sub LUA_PATH_MARK () {"?";}' unless defined(&LUA_PATH_MARK);
    eval 'sub LUA_EXEC_DIR () {"!";}' unless defined(&LUA_EXEC_DIR);
    eval 'sub LUA_VDIR () { &LUA_VERSION_MAJOR "."  &LUA_VERSION_MINOR;}' unless defined(&LUA_VDIR);
    if(defined(&_WIN32) ) {
	eval 'sub LUA_LDIR () {"!\\\\lua\\\\";}' unless defined(&LUA_LDIR);
	eval 'sub LUA_CDIR () {"!\\\\";}' unless defined(&LUA_CDIR);
	eval 'sub LUA_SHRDIR () {"!\\\\..\\\\share\\\\lua\\\\" LUA_VDIR "\\\\";}' unless defined(&LUA_SHRDIR);
	eval 'sub LUA_PATH_DEFAULT () { &LUA_LDIR"?.lua;"  &LUA_LDIR"?\\\\init.lua;"  &LUA_CDIR"?.lua;"  &LUA_CDIR"?\\\\init.lua;"  &LUA_SHRDIR"?.lua;"  &LUA_SHRDIR"?\\\\init.lua;" ".\\\\?.lua;" ".\\\\?\\\\init.lua";}' unless defined(&LUA_PATH_DEFAULT);
	eval 'sub LUA_CPATH_DEFAULT () { &LUA_CDIR"?.dll;"  &LUA_CDIR"..\\\\lib\\\\lua\\\\" LUA_VDIR "\\\\?. &dll;" 		LUA_CDIR" ($loadall->{dll});" ".\\\\?. &dll";}' unless defined(&LUA_CPATH_DEFAULT);
    } else {
	eval 'sub LUA_ROOT () {"/usr/local/";}' unless defined(&LUA_ROOT);
	eval 'sub LUA_LDIR () { &LUA_ROOT "share/lua/"  &LUA_VDIR "/";}' unless defined(&LUA_LDIR);
	eval 'sub LUA_CDIR () { &LUA_ROOT "lib/lua/"  &LUA_VDIR "/";}' unless defined(&LUA_CDIR);
	eval 'sub LUA_PATH_DEFAULT () { &LUA_LDIR"?.lua;"  &LUA_LDIR"?/init.lua;"  &LUA_CDIR"?.lua;"  &LUA_CDIR"?/init.lua;" "./?.lua;" "./?/init.lua";}' unless defined(&LUA_PATH_DEFAULT);
	eval 'sub LUA_CPATH_DEFAULT () { &LUA_CDIR"?.so;"  &LUA_CDIR"loadall.so;" "./?.so";}' unless defined(&LUA_CPATH_DEFAULT);
    }
    if(defined(&_WIN32)) {
	eval 'sub LUA_DIRSEP () {"\\\\";}' unless defined(&LUA_DIRSEP);
    } else {
	eval 'sub LUA_DIRSEP () {"/";}' unless defined(&LUA_DIRSEP);
    }
    if(defined(&LUA_BUILD_AS_DLL) ) {
	if(defined(&LUA_CORE) || defined(&LUA_LIB) ) {
	    eval 'sub LUA_API () { &__declspec( &dllexport);}' unless defined(&LUA_API);
	} else {
	    eval 'sub LUA_API () { &__declspec( &dllimport);}' unless defined(&LUA_API);
	}
    } else {
	eval 'sub LUA_API () { &extern;}' unless defined(&LUA_API);
    }
    eval 'sub LUALIB_API () { &LUA_API;}' unless defined(&LUALIB_API);
    eval 'sub LUAMOD_API () { &LUALIB_API;}' unless defined(&LUAMOD_API);
    if(defined(&__GNUC__)  && (((defined(&__GNUC__) ? &__GNUC__ : undef)*100+ (defined(&__GNUC_MINOR__) ? &__GNUC_MINOR__ : undef)) >= 302)  && defined(&__ELF__) ) {
	eval 'sub LUAI_FUNC () { &__attribute__(( &visibility("hidden")))  &extern;}' unless defined(&LUAI_FUNC);
    } else {
	eval 'sub LUAI_FUNC () { &extern;}' unless defined(&LUAI_FUNC);
    }
    eval 'sub LUAI_DDEC () { &LUAI_FUNC;}' unless defined(&LUAI_DDEC);
    eval 'sub LUAI_DDEF () {1;}' unless defined(&LUAI_DDEF);
    if(defined(&LUA_COMPAT_5_2) ) {
	eval 'sub LUA_COMPAT_MATHLIB () {1;}' unless defined(&LUA_COMPAT_MATHLIB);
	eval 'sub LUA_COMPAT_BITLIB () {1;}' unless defined(&LUA_COMPAT_BITLIB);
	eval 'sub LUA_COMPAT_IPAIRS () {1;}' unless defined(&LUA_COMPAT_IPAIRS);
	eval 'sub LUA_COMPAT_APIINTCASTS () {1;}' unless defined(&LUA_COMPAT_APIINTCASTS);
    }
    if(defined(&LUA_COMPAT_5_1) ) {
	eval 'sub LUA_COMPAT_MATHLIB () {1;}' unless defined(&LUA_COMPAT_MATHLIB);
	eval 'sub LUA_COMPAT_APIINTCASTS () {1;}' unless defined(&LUA_COMPAT_APIINTCASTS);
	eval 'sub LUA_COMPAT_UNPACK () {1;}' unless defined(&LUA_COMPAT_UNPACK);
	eval 'sub LUA_COMPAT_LOADERS () {1;}' unless defined(&LUA_COMPAT_LOADERS);
	eval 'sub lua_cpcall {
	    my($L,$f,$u) = @_;
    	    eval q(( &lua_pushcfunction($L, ($f)),  &lua_pushlightuserdata($L,($u)),  &lua_pcall($L,1,0,0)));
	}' unless defined(&lua_cpcall);
	eval 'sub LUA_COMPAT_LOG10 () {1;}' unless defined(&LUA_COMPAT_LOG10);
	eval 'sub LUA_COMPAT_LOADSTRING () {1;}' unless defined(&LUA_COMPAT_LOADSTRING);
	eval 'sub LUA_COMPAT_MAXN () {1;}' unless defined(&LUA_COMPAT_MAXN);
	eval 'sub lua_strlen {
	    my($L,$i) = @_;
    	    eval q( &lua_rawlen($L, ($i)));
	}' unless defined(&lua_strlen);
	eval 'sub lua_objlen {
	    my($L,$i) = @_;
    	    eval q( &lua_rawlen($L, ($i)));
	}' unless defined(&lua_objlen);
	eval 'sub lua_equal {
	    my($L,$idx1,$idx2) = @_;
    	    eval q( &lua_compare($L,($idx1),($idx2), &LUA_OPEQ));
	}' unless defined(&lua_equal);
	eval 'sub lua_lessthan {
	    my($L,$idx1,$idx2) = @_;
    	    eval q( &lua_compare($L,($idx1),($idx2), &LUA_OPLT));
	}' unless defined(&lua_lessthan);
	eval 'sub LUA_COMPAT_MODULE () {1;}' unless defined(&LUA_COMPAT_MODULE);
    }
    unless(defined(&_KERNEL)) {
	eval 'sub l_floor {
	    my($x) = @_;
    	    eval q(( &l_mathop( &floor)($x)));
	}' unless defined(&l_floor);
	eval 'sub lua_number2str {
	    my($s,$sz,$n) = @_;
    	    eval q( &l_sprintf(($s), $sz,  &LUA_NUMBER_FMT, ( &LUAI_UACNUMBER)($n)));
	}' unless defined(&lua_number2str);
	eval 'sub lua_numbertointeger {
	    my($n,$p) = @_;
    	    eval q((($n) >= ( &LUA_NUMBER)( &LUA_MININTEGER)  && ($n) < -( &LUA_NUMBER)( &LUA_MININTEGER)  && (*($p) = ( &LUA_INTEGER)($n), 1)));
	}' unless defined(&lua_numbertointeger);
	if((defined(&LUA_FLOAT_TYPE) ? &LUA_FLOAT_TYPE : undef) == (defined(&LUA_FLOAT_FLOAT) ? &LUA_FLOAT_FLOAT : undef) ) {
	    eval 'sub LUA_NUMBER () {\'float\';}' unless defined(&LUA_NUMBER);
	    eval 'sub l_mathlim {
	        my($n) = @_;
    		eval q(( &FLT_$n));
	    }' unless defined(&l_mathlim);
	    eval 'sub LUAI_UACNUMBER () {\'double\';}' unless defined(&LUAI_UACNUMBER);
	    eval 'sub LUA_NUMBER_FRMLEN () {"";}' unless defined(&LUA_NUMBER_FRMLEN);
	    eval 'sub LUA_NUMBER_FMT () {"%.7g";}' unless defined(&LUA_NUMBER_FMT);
	    eval 'sub l_mathop {
	        my($op) = @_;
    		eval q($op &f);
	    }' unless defined(&l_mathop);
	    eval 'sub lua_str2number {
	        my($s,$p) = @_;
    		eval q( &strtof(($s), ($p)));
	    }' unless defined(&lua_str2number);
	}
 elsif((defined(&LUA_FLOAT_TYPE) ? &LUA_FLOAT_TYPE : undef) == (defined(&LUA_FLOAT_LONGDOUBLE) ? &LUA_FLOAT_LONGDOUBLE : undef) ) {
	    eval 'sub LUA_NUMBER () {\'long double\';}' unless defined(&LUA_NUMBER);
	    eval 'sub l_mathlim {
	        my($n) = @_;
    		eval q(( &LDBL_$n));
	    }' unless defined(&l_mathlim);
	    eval 'sub LUAI_UACNUMBER () {\'long double\';}' unless defined(&LUAI_UACNUMBER);
	    eval 'sub LUA_NUMBER_FRMLEN () {"L";}' unless defined(&LUA_NUMBER_FRMLEN);
	    eval 'sub LUA_NUMBER_FMT () {"%.19Lg";}' unless defined(&LUA_NUMBER_FMT);
	    eval 'sub l_mathop {
	        my($op) = @_;
    		eval q($op &l);
	    }' unless defined(&l_mathop);
	    eval 'sub lua_str2number {
	        my($s,$p) = @_;
    		eval q( &strtold(($s), ($p)));
	    }' unless defined(&lua_str2number);
	}
 elsif((defined(&LUA_FLOAT_TYPE) ? &LUA_FLOAT_TYPE : undef) == (defined(&LUA_FLOAT_DOUBLE) ? &LUA_FLOAT_DOUBLE : undef) ) {
	    eval 'sub LUA_NUMBER () {\'double\';}' unless defined(&LUA_NUMBER);
	    eval 'sub l_mathlim {
	        my($n) = @_;
    		eval q(( &DBL_$n));
	    }' unless defined(&l_mathlim);
	    eval 'sub LUAI_UACNUMBER () {\'double\';}' unless defined(&LUAI_UACNUMBER);
	    eval 'sub LUA_NUMBER_FRMLEN () {"";}' unless defined(&LUA_NUMBER_FRMLEN);
	    eval 'sub LUA_NUMBER_FMT () {"%.14g";}' unless defined(&LUA_NUMBER_FMT);
	    eval 'sub l_mathop {
	        my($op) = @_;
    		eval q($op);
	    }' unless defined(&l_mathop);
	    eval 'sub lua_str2number {
	        my($s,$p) = @_;
    		eval q( &strtod(($s), ($p)));
	    }' unless defined(&lua_str2number);
	} else {
	    die("numeric float type not defined");
	}
    }
    eval 'sub LUA_INTEGER_FMT () {"%"  &LUA_INTEGER_FRMLEN "d";}' unless defined(&LUA_INTEGER_FMT);
    eval 'sub LUAI_UACINT () { &LUA_INTEGER;}' unless defined(&LUAI_UACINT);
    eval 'sub lua_integer2str {
        my($s,$sz,$n) = @_;
	    eval q( &l_sprintf(($s), $sz,  &LUA_INTEGER_FMT, ( &LUAI_UACINT)($n)));
    }' unless defined(&lua_integer2str);
    eval 'sub LUA_UNSIGNED () {\'unsigned LUAI_UACINT\';}' unless defined(&LUA_UNSIGNED);
    if((defined(&LUA_INT_TYPE) ? &LUA_INT_TYPE : undef) == (defined(&LUA_INT_INT) ? &LUA_INT_INT : undef) ) {
	eval 'sub LUA_INTEGER () {\'int\';}' unless defined(&LUA_INTEGER);
	eval 'sub LUA_INTEGER_FRMLEN () {"";}' unless defined(&LUA_INTEGER_FRMLEN);
	eval 'sub LUA_MAXINTEGER () { &INT_MAX;}' unless defined(&LUA_MAXINTEGER);
	eval 'sub LUA_MININTEGER () { &INT_MIN;}' unless defined(&LUA_MININTEGER);
    }
 elsif((defined(&LUA_INT_TYPE) ? &LUA_INT_TYPE : undef) == (defined(&LUA_INT_LONG) ? &LUA_INT_LONG : undef) ) {
	eval 'sub LUA_INTEGER () {\'long\';}' unless defined(&LUA_INTEGER);
	eval 'sub LUA_INTEGER_FRMLEN () {"l";}' unless defined(&LUA_INTEGER_FRMLEN);
	eval 'sub LUA_MAXINTEGER () { &LONG_MAX;}' unless defined(&LUA_MAXINTEGER);
	eval 'sub LUA_MININTEGER () { &LONG_MIN;}' unless defined(&LUA_MININTEGER);
    }
 elsif((defined(&LUA_INT_TYPE) ? &LUA_INT_TYPE : undef) == (defined(&LUA_INT_LONGLONG) ? &LUA_INT_LONGLONG : undef) ) {
	if(defined(&LLONG_MAX) ) {
	    eval 'sub LUA_INTEGER () {\'long long\';}' unless defined(&LUA_INTEGER);
	    eval 'sub LUA_INTEGER_FRMLEN () {"ll";}' unless defined(&LUA_INTEGER_FRMLEN);
	    eval 'sub LUA_MAXINTEGER () { &LLONG_MAX;}' unless defined(&LUA_MAXINTEGER);
	    eval 'sub LUA_MININTEGER () { &LLONG_MIN;}' unless defined(&LUA_MININTEGER);
	}
 elsif(defined(&LUA_USE_WINDOWS) ) {
	    eval 'sub LUA_INTEGER () { &__int64;}' unless defined(&LUA_INTEGER);
	    eval 'sub LUA_INTEGER_FRMLEN () {"I64";}' unless defined(&LUA_INTEGER_FRMLEN);
	    eval 'sub LUA_MAXINTEGER () { &_I64_MAX;}' unless defined(&LUA_MAXINTEGER);
	    eval 'sub LUA_MININTEGER () { &_I64_MIN;}' unless defined(&LUA_MININTEGER);
	} else {
	    die("Compiler does not support 'long long'. Use option '-DLUA_32BITS'   or '-DLUA_C89_NUMBERS' (see file 'luaconf.h' for details)");
	}
    } else {
	die("numeric integer type not defined");
    }
    if(!defined(&LUA_USE_C89)) {
	eval 'sub l_sprintf {
	    my($s,$sz,$f,$i) = @_;
    	    eval q( &snprintf($s,$sz,$f,$i));
	}' unless defined(&l_sprintf);
    } else {
	eval 'sub l_sprintf {
	    my($s,$sz,$f,$i) = @_;
    	    eval q((( &void)($sz),  &sprintf($s,$f,$i)));
	}' unless defined(&l_sprintf);
    }
    if(!defined(&LUA_USE_C89)) {
	eval 'sub lua_strx2number {
	    my($s,$p) = @_;
    	    eval q( &lua_str2number($s,$p));
	}' unless defined(&lua_strx2number);
    }
    eval 'sub lua_pointer2str {
        my($buff,$sz,$p) = @_;
	    eval q( &l_sprintf($buff,$sz,\\"%p\\",$p));
    }' unless defined(&lua_pointer2str);
    if(!defined(&LUA_USE_C89)) {
	eval 'sub lua_number2strx {
	    my($L,$b,$sz,$f,$n) = @_;
    	    eval q((( &void)$L,  &l_sprintf($b,$sz,$f,( &LUAI_UACNUMBER)($n))));
	}' unless defined(&lua_number2strx);
    }
    if(defined(&LUA_USE_C89) || (defined(&HUGE_VAL)  && !defined(&HUGE_VALF))) {
	undef(&l_mathop) if defined(&l_mathop);
	undef(&lua_str2number) if defined(&lua_str2number);
	eval 'sub l_mathop {
	    my($op) = @_;
    	    eval q(( &lua_Number)$op);
	}' unless defined(&l_mathop);
	eval 'sub lua_str2number {
	    my($s,$p) = @_;
    	    eval q((( &lua_Number) &strtod(($s), ($p))));
	}' unless defined(&lua_str2number);
    }
    eval 'sub LUA_KCONTEXT () { &ptrdiff_t;}' unless defined(&LUA_KCONTEXT);
    if(!defined(&LUA_USE_C89)  && defined(&__STDC_VERSION__)  && (defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : undef) >= 199901) {
	require 'stdint.ph';
	if(defined(&INTPTR_MAX) ) {
	    undef(&LUA_KCONTEXT) if defined(&LUA_KCONTEXT);
	    eval 'sub LUA_KCONTEXT () { &intptr_t;}' unless defined(&LUA_KCONTEXT);
	}
    }
    if(!defined(&lua_getlocaledecpoint)) {
	eval 'sub lua_getlocaledecpoint () {
	    eval q(( &localeconv()-> $decimal_point[0]));
	}' unless defined(&lua_getlocaledecpoint);
    }
    if(defined(&LUA_USE_APICHECK)) {
	require 'assert.ph';
	eval 'sub luai_apicheck {
	    my($l,$e) = @_;
    	    eval q( &assert($e));
	}' unless defined(&luai_apicheck);
    }
    if((defined(&LUAI_BITSINT) ? &LUAI_BITSINT : undef) >= 32) {
	eval 'sub LUAI_MAXSTACK () {1000000;}' unless defined(&LUAI_MAXSTACK);
    } else {
	eval 'sub LUAI_MAXSTACK () {15000;}' unless defined(&LUAI_MAXSTACK);
    }
    eval 'sub LUA_EXTRASPACE () {($sizeof{ &void });}' unless defined(&LUA_EXTRASPACE);
    eval 'sub LUA_IDSIZE () {60;}' unless defined(&LUA_IDSIZE);
    if(defined(&_KERNEL)) {
	eval 'sub LUAL_BUFFERSIZE () {128;}' unless defined(&LUAL_BUFFERSIZE);
    }
 elsif((defined(&LUA_FLOAT_TYPE) ? &LUA_FLOAT_TYPE : undef) == (defined(&LUA_FLOAT_LONGDOUBLE) ? &LUA_FLOAT_LONGDOUBLE : undef)) {
	eval 'sub LUAL_BUFFERSIZE () {8192;}' unless defined(&LUAL_BUFFERSIZE);
    } else {
	eval 'sub LUAL_BUFFERSIZE () {((0x80 * $sizeof{ &void} * $sizeof{ &lua_Integer}));}' unless defined(&LUAL_BUFFERSIZE);
    }
    eval 'sub LUA_QL {
        my($x) = @_;
	    eval q(\\"\'\\" $x \\"\'\\");
    }' unless defined(&LUA_QL);
    eval 'sub LUA_QS () { &LUA_QL("%s");}' unless defined(&LUA_QS);
    if(defined(&__NetBSD__)) {
	eval 'sub LUA_STRFTIMEOPTIONS () {"aAbBcCdDeFgGhHIjklmMnprRsStTuUvVwWxXyYzZ%";}' unless defined(&LUA_STRFTIMEOPTIONS);
	undef(&LUA_INTEGER) if defined(&LUA_INTEGER);
	undef(&LUA_INTEGER_FRMLEN) if defined(&LUA_INTEGER_FRMLEN);
	undef(&LUA_UNSIGNED) if defined(&LUA_UNSIGNED);
	undef(&LUA_MAXUNSIGNED) if defined(&LUA_MAXUNSIGNED);
	undef(&LUA_MAXINTEGER) if defined(&LUA_MAXINTEGER);
	undef(&LUA_MININTEGER) if defined(&LUA_MININTEGER);
	eval 'sub LUA_INTEGER () { &intmax_t;}' unless defined(&LUA_INTEGER);
	eval 'sub LUA_INTEGER_FRMLEN () {"j";}' unless defined(&LUA_INTEGER_FRMLEN);
	eval 'sub LUA_UNSIGNED () { &uintmax_t;}' unless defined(&LUA_UNSIGNED);
	eval 'sub LUA_MAXUNSIGNED () { &UINTMAX_MAX;}' unless defined(&LUA_MAXUNSIGNED);
	eval 'sub LUA_MAXINTEGER () { &INTMAX_MAX;}' unless defined(&LUA_MAXINTEGER);
	eval 'sub LUA_MININTEGER () { &INTMAX_MIN;}' unless defined(&LUA_MININTEGER);
	undef(&LUA_ROOT) if defined(&LUA_ROOT);
	undef(&LUA_PATH_DEFAULT) if defined(&LUA_PATH_DEFAULT);
	undef(&LUA_CPATH_DEFAULT) if defined(&LUA_CPATH_DEFAULT);
	eval 'sub LUA_ROOT () {"/usr/";}' unless defined(&LUA_ROOT);
	eval 'sub LUA_PATH_DEFAULT () { &LUA_LDIR"?.lua;"  &LUA_LDIR"?/init.lua;"  &LUA_CDIR"?.lua;"  &LUA_CDIR"?/init.lua";}' unless defined(&LUA_PATH_DEFAULT);
	eval 'sub LUA_CPATH_DEFAULT () { &LUA_CDIR"?.so;"  &LUA_CDIR"loadall.so";}' unless defined(&LUA_CPATH_DEFAULT);
	unless(defined(&_KERNEL)) {
	    require 'stdint.ph';
	} else {
	    eval 'sub LUA_NUMBER () { &LUA_INTEGER;}' unless defined(&LUA_NUMBER);
	    eval 'sub LUA_NUMBER_FMT () { &LUA_INTEGER_FMT;}' unless defined(&LUA_NUMBER_FMT);
	    eval 'sub l_mathlim {
	        my($n) = @_;
    		eval q((0));
	    }' unless defined(&l_mathlim);
	    eval 'sub l_randomizePivot () {
	        eval q((~0));
	    }' unless defined(&l_randomizePivot);
	    eval 'sub LUAI_THROW {
	        my($L,$c) = @_;
    		eval q( &longjmp((($c)-> &b)));
	    }' unless defined(&LUAI_THROW);
	    eval 'sub LUAI_TRY {
	        my($L,$c,$a) = @_;
    		eval q( &if ( &setjmp((($c)-> &b)) == 0) { $a });
	    }' unless defined(&LUAI_TRY);
	    eval 'sub luai_jmpbuf () { &label_t;}' unless defined(&luai_jmpbuf);
	    require 'sys/time.ph';
	    eval 'sub time {
	        my($p) = @_;
    		eval q(( &time_uptime));
	    }' unless defined(&time);
	    eval 'sub lua_writestring {
	        my($s,$l) = @_;
    		eval q( &printf(\\"%s\\", ($s)));
	    }' unless defined(&lua_writestring);
	    eval 'sub lua_writeline () {
	        eval q( &printf(\\"\\\\n\\"));
	    }' unless defined(&lua_writeline);
	    eval 'sub strcoll () { &strcmp;}' unless defined(&strcoll);
	    eval 'sub abort () {
	        eval q( &panic(\\"Lua has aborted!\\"));
	    }' unless defined(&abort);
	}
    }
}
1;
