require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&HEADER_RSA_H)) {
    eval 'sub HEADER_RSA_H () {1;}' unless defined(&HEADER_RSA_H);
    require 'openssl/opensslconf.ph';
    unless(defined(&OPENSSL_NO_RSA)) {
	require 'openssl/asn1.ph';
	require 'openssl/bio.ph';
	require 'openssl/crypto.ph';
	require 'openssl/ossl_typ.ph';
	if((defined(&OPENSSL_API_COMPAT) ? &OPENSSL_API_COMPAT : undef) < 0x10100000) {
	    require 'openssl/bn.ph';
	}
	require 'openssl/rsaerr.ph';
	if(defined(&__cplusplus)) {
	}
	unless(defined(&OPENSSL_RSA_MAX_MODULUS_BITS)) {
	    eval 'sub OPENSSL_RSA_MAX_MODULUS_BITS () {16384;}' unless defined(&OPENSSL_RSA_MAX_MODULUS_BITS);
	}
	eval 'sub OPENSSL_RSA_FIPS_MIN_MODULUS_BITS () {1024;}' unless defined(&OPENSSL_RSA_FIPS_MIN_MODULUS_BITS);
	unless(defined(&OPENSSL_RSA_SMALL_MODULUS_BITS)) {
	    eval 'sub OPENSSL_RSA_SMALL_MODULUS_BITS () {3072;}' unless defined(&OPENSSL_RSA_SMALL_MODULUS_BITS);
	}
	unless(defined(&OPENSSL_RSA_MAX_PUBEXP_BITS)) {
	    eval 'sub OPENSSL_RSA_MAX_PUBEXP_BITS () {64;}' unless defined(&OPENSSL_RSA_MAX_PUBEXP_BITS);
	}
	eval 'sub RSA_3 () {0x3;}' unless defined(&RSA_3);
	eval 'sub RSA_F4 () {0x10001;}' unless defined(&RSA_F4);
	eval 'sub RSA_ASN1_VERSION_DEFAULT () {0;}' unless defined(&RSA_ASN1_VERSION_DEFAULT);
	eval 'sub RSA_ASN1_VERSION_MULTI () {1;}' unless defined(&RSA_ASN1_VERSION_MULTI);
	eval 'sub RSA_DEFAULT_PRIME_NUM () {2;}' unless defined(&RSA_DEFAULT_PRIME_NUM);
	eval 'sub RSA_METHOD_FLAG_NO_CHECK () {0x1;}' unless defined(&RSA_METHOD_FLAG_NO_CHECK);
	eval 'sub RSA_FLAG_CACHE_PUBLIC () {0x2;}' unless defined(&RSA_FLAG_CACHE_PUBLIC);
	eval 'sub RSA_FLAG_CACHE_PRIVATE () {0x4;}' unless defined(&RSA_FLAG_CACHE_PRIVATE);
	eval 'sub RSA_FLAG_BLINDING () {0x8;}' unless defined(&RSA_FLAG_BLINDING);
	eval 'sub RSA_FLAG_THREAD_SAFE () {0x10;}' unless defined(&RSA_FLAG_THREAD_SAFE);
	eval 'sub RSA_FLAG_EXT_PKEY () {0x20;}' unless defined(&RSA_FLAG_EXT_PKEY);
	eval 'sub RSA_FLAG_NO_BLINDING () {0x80;}' unless defined(&RSA_FLAG_NO_BLINDING);
	if((defined(&OPENSSL_API_COMPAT) ? &OPENSSL_API_COMPAT : undef) < 0x10100000) {
	    eval 'sub RSA_FLAG_NO_CONSTTIME () {0x;}' unless defined(&RSA_FLAG_NO_CONSTTIME);
	}
	if((defined(&OPENSSL_API_COMPAT) ? &OPENSSL_API_COMPAT : undef) < 0x908000) {
	    eval 'sub RSA_FLAG_NO_EXP_CONSTTIME () { &RSA_FLAG_NO_CONSTTIME;}' unless defined(&RSA_FLAG_NO_EXP_CONSTTIME);
	}
	eval 'sub EVP_PKEY_CTX_set_rsa_padding {
	    my($ctx, $pad) = @_;
    	    eval q( &RSA_pkey_ctx_ctrl($ctx, -1,  &EVP_PKEY_CTRL_RSA_PADDING, $pad,  &NULL));
	}' unless defined(&EVP_PKEY_CTX_set_rsa_padding);
	eval 'sub EVP_PKEY_CTX_get_rsa_padding {
	    my($ctx, $ppad) = @_;
    	    eval q( &RSA_pkey_ctx_ctrl($ctx, -1,  &EVP_PKEY_CTRL_GET_RSA_PADDING, 0, $ppad));
	}' unless defined(&EVP_PKEY_CTX_get_rsa_padding);
	eval 'sub EVP_PKEY_CTX_set_rsa_pss_saltlen {
	    my($ctx, $len) = @_;
    	    eval q( &RSA_pkey_ctx_ctrl($ctx, ( &EVP_PKEY_OP_SIGN| &EVP_PKEY_OP_VERIFY),  &EVP_PKEY_CTRL_RSA_PSS_SALTLEN, $len,  &NULL));
	}' unless defined(&EVP_PKEY_CTX_set_rsa_pss_saltlen);
	eval 'sub RSA_PSS_SALTLEN_DIGEST () {-1;}' unless defined(&RSA_PSS_SALTLEN_DIGEST);
	eval 'sub RSA_PSS_SALTLEN_AUTO () {-2;}' unless defined(&RSA_PSS_SALTLEN_AUTO);
	eval 'sub RSA_PSS_SALTLEN_MAX () {-3;}' unless defined(&RSA_PSS_SALTLEN_MAX);
	eval 'sub RSA_PSS_SALTLEN_MAX_SIGN () {-2;}' unless defined(&RSA_PSS_SALTLEN_MAX_SIGN);
	eval 'sub EVP_PKEY_CTX_set_rsa_pss_keygen_saltlen {
	    my($ctx, $len) = @_;
    	    eval q( &EVP_PKEY_CTX_ctrl($ctx,  &EVP_PKEY_RSA_PSS,  &EVP_PKEY_OP_KEYGEN,  &EVP_PKEY_CTRL_RSA_PSS_SALTLEN, $len,  &NULL));
	}' unless defined(&EVP_PKEY_CTX_set_rsa_pss_keygen_saltlen);
	eval 'sub EVP_PKEY_CTX_get_rsa_pss_saltlen {
	    my($ctx, $plen) = @_;
    	    eval q( &RSA_pkey_ctx_ctrl($ctx, ( &EVP_PKEY_OP_SIGN| &EVP_PKEY_OP_VERIFY),  &EVP_PKEY_CTRL_GET_RSA_PSS_SALTLEN, 0, $plen));
	}' unless defined(&EVP_PKEY_CTX_get_rsa_pss_saltlen);
	eval 'sub EVP_PKEY_CTX_set_rsa_keygen_bits {
	    my($ctx, $bits) = @_;
    	    eval q( &RSA_pkey_ctx_ctrl($ctx,  &EVP_PKEY_OP_KEYGEN,  &EVP_PKEY_CTRL_RSA_KEYGEN_BITS, $bits,  &NULL));
	}' unless defined(&EVP_PKEY_CTX_set_rsa_keygen_bits);
	eval 'sub EVP_PKEY_CTX_set_rsa_keygen_pubexp {
	    my($ctx, $pubexp) = @_;
    	    eval q( &RSA_pkey_ctx_ctrl($ctx,  &EVP_PKEY_OP_KEYGEN,  &EVP_PKEY_CTRL_RSA_KEYGEN_PUBEXP, 0, $pubexp));
	}' unless defined(&EVP_PKEY_CTX_set_rsa_keygen_pubexp);
	eval 'sub EVP_PKEY_CTX_set_rsa_keygen_primes {
	    my($ctx, $primes) = @_;
    	    eval q( &RSA_pkey_ctx_ctrl($ctx,  &EVP_PKEY_OP_KEYGEN,  &EVP_PKEY_CTRL_RSA_KEYGEN_PRIMES, $primes,  &NULL));
	}' unless defined(&EVP_PKEY_CTX_set_rsa_keygen_primes);
	eval 'sub EVP_PKEY_CTX_set_rsa_mgf1_md {
	    my($ctx, $md) = @_;
    	    eval q( &RSA_pkey_ctx_ctrl($ctx,  &EVP_PKEY_OP_TYPE_SIG |  &EVP_PKEY_OP_TYPE_CRYPT,  &EVP_PKEY_CTRL_RSA_MGF1_MD, 0, ( &void *)($md)));
	}' unless defined(&EVP_PKEY_CTX_set_rsa_mgf1_md);
	eval 'sub EVP_PKEY_CTX_set_rsa_pss_keygen_mgf1_md {
	    my($ctx, $md) = @_;
    	    eval q( &EVP_PKEY_CTX_ctrl($ctx,  &EVP_PKEY_RSA_PSS,  &EVP_PKEY_OP_KEYGEN,  &EVP_PKEY_CTRL_RSA_MGF1_MD, 0, ( &void *)($md)));
	}' unless defined(&EVP_PKEY_CTX_set_rsa_pss_keygen_mgf1_md);
	eval 'sub EVP_PKEY_CTX_set_rsa_oaep_md {
	    my($ctx, $md) = @_;
    	    eval q( &EVP_PKEY_CTX_ctrl($ctx,  &EVP_PKEY_RSA,  &EVP_PKEY_OP_TYPE_CRYPT,  &EVP_PKEY_CTRL_RSA_OAEP_MD, 0, ( &void *)($md)));
	}' unless defined(&EVP_PKEY_CTX_set_rsa_oaep_md);
	eval 'sub EVP_PKEY_CTX_get_rsa_mgf1_md {
	    my($ctx, $pmd) = @_;
    	    eval q( &RSA_pkey_ctx_ctrl($ctx,  &EVP_PKEY_OP_TYPE_SIG |  &EVP_PKEY_OP_TYPE_CRYPT,  &EVP_PKEY_CTRL_GET_RSA_MGF1_MD, 0, ( &void *)($pmd)));
	}' unless defined(&EVP_PKEY_CTX_get_rsa_mgf1_md);
	eval 'sub EVP_PKEY_CTX_get_rsa_oaep_md {
	    my($ctx, $pmd) = @_;
    	    eval q( &EVP_PKEY_CTX_ctrl($ctx,  &EVP_PKEY_RSA,  &EVP_PKEY_OP_TYPE_CRYPT,  &EVP_PKEY_CTRL_GET_RSA_OAEP_MD, 0, ( &void *)($pmd)));
	}' unless defined(&EVP_PKEY_CTX_get_rsa_oaep_md);
	eval 'sub EVP_PKEY_CTX_set0_rsa_oaep_label {
	    my($ctx, $l, $llen) = @_;
    	    eval q( &EVP_PKEY_CTX_ctrl($ctx,  &EVP_PKEY_RSA,  &EVP_PKEY_OP_TYPE_CRYPT,  &EVP_PKEY_CTRL_RSA_OAEP_LABEL, $llen, ( &void *)($l)));
	}' unless defined(&EVP_PKEY_CTX_set0_rsa_oaep_label);
	eval 'sub EVP_PKEY_CTX_get0_rsa_oaep_label {
	    my($ctx, $l) = @_;
    	    eval q( &EVP_PKEY_CTX_ctrl($ctx,  &EVP_PKEY_RSA,  &EVP_PKEY_OP_TYPE_CRYPT,  &EVP_PKEY_CTRL_GET_RSA_OAEP_LABEL, 0, ( &void *)($l)));
	}' unless defined(&EVP_PKEY_CTX_get0_rsa_oaep_label);
	eval 'sub EVP_PKEY_CTX_set_rsa_pss_keygen_md {
	    my($ctx, $md) = @_;
    	    eval q( &EVP_PKEY_CTX_ctrl($ctx,  &EVP_PKEY_RSA_PSS,  &EVP_PKEY_OP_KEYGEN,  &EVP_PKEY_CTRL_MD, 0, ( &void *)($md)));
	}' unless defined(&EVP_PKEY_CTX_set_rsa_pss_keygen_md);
	eval 'sub EVP_PKEY_CTRL_RSA_PADDING () {( &EVP_PKEY_ALG_CTRL + 1);}' unless defined(&EVP_PKEY_CTRL_RSA_PADDING);
	eval 'sub EVP_PKEY_CTRL_RSA_PSS_SALTLEN () {( &EVP_PKEY_ALG_CTRL + 2);}' unless defined(&EVP_PKEY_CTRL_RSA_PSS_SALTLEN);
	eval 'sub EVP_PKEY_CTRL_RSA_KEYGEN_BITS () {( &EVP_PKEY_ALG_CTRL + 3);}' unless defined(&EVP_PKEY_CTRL_RSA_KEYGEN_BITS);
	eval 'sub EVP_PKEY_CTRL_RSA_KEYGEN_PUBEXP () {( &EVP_PKEY_ALG_CTRL + 4);}' unless defined(&EVP_PKEY_CTRL_RSA_KEYGEN_PUBEXP);
	eval 'sub EVP_PKEY_CTRL_RSA_MGF1_MD () {( &EVP_PKEY_ALG_CTRL + 5);}' unless defined(&EVP_PKEY_CTRL_RSA_MGF1_MD);
	eval 'sub EVP_PKEY_CTRL_GET_RSA_PADDING () {( &EVP_PKEY_ALG_CTRL + 6);}' unless defined(&EVP_PKEY_CTRL_GET_RSA_PADDING);
	eval 'sub EVP_PKEY_CTRL_GET_RSA_PSS_SALTLEN () {( &EVP_PKEY_ALG_CTRL + 7);}' unless defined(&EVP_PKEY_CTRL_GET_RSA_PSS_SALTLEN);
	eval 'sub EVP_PKEY_CTRL_GET_RSA_MGF1_MD () {( &EVP_PKEY_ALG_CTRL + 8);}' unless defined(&EVP_PKEY_CTRL_GET_RSA_MGF1_MD);
	eval 'sub EVP_PKEY_CTRL_RSA_OAEP_MD () {( &EVP_PKEY_ALG_CTRL + 9);}' unless defined(&EVP_PKEY_CTRL_RSA_OAEP_MD);
	eval 'sub EVP_PKEY_CTRL_RSA_OAEP_LABEL () {( &EVP_PKEY_ALG_CTRL + 10);}' unless defined(&EVP_PKEY_CTRL_RSA_OAEP_LABEL);
	eval 'sub EVP_PKEY_CTRL_GET_RSA_OAEP_MD () {( &EVP_PKEY_ALG_CTRL + 11);}' unless defined(&EVP_PKEY_CTRL_GET_RSA_OAEP_MD);
	eval 'sub EVP_PKEY_CTRL_GET_RSA_OAEP_LABEL () {( &EVP_PKEY_ALG_CTRL + 12);}' unless defined(&EVP_PKEY_CTRL_GET_RSA_OAEP_LABEL);
	eval 'sub EVP_PKEY_CTRL_RSA_KEYGEN_PRIMES () {( &EVP_PKEY_ALG_CTRL + 13);}' unless defined(&EVP_PKEY_CTRL_RSA_KEYGEN_PRIMES);
	eval 'sub RSA_PKCS1_PADDING () {1;}' unless defined(&RSA_PKCS1_PADDING);
	eval 'sub RSA_SSLV23_PADDING () {2;}' unless defined(&RSA_SSLV23_PADDING);
	eval 'sub RSA_NO_PADDING () {3;}' unless defined(&RSA_NO_PADDING);
	eval 'sub RSA_PKCS1_OAEP_PADDING () {4;}' unless defined(&RSA_PKCS1_OAEP_PADDING);
	eval 'sub RSA_X931_PADDING () {5;}' unless defined(&RSA_X931_PADDING);
	eval 'sub RSA_PKCS1_PSS_PADDING () {6;}' unless defined(&RSA_PKCS1_PSS_PADDING);
	eval 'sub RSA_PKCS1_PADDING_SIZE () {11;}' unless defined(&RSA_PKCS1_PADDING_SIZE);
	eval 'sub RSA_set_app_data {
	    my($s,$arg) = @_;
    	    eval q( &RSA_set_ex_data($s,0,$arg));
	}' unless defined(&RSA_set_app_data);
	eval 'sub RSA_get_app_data {
	    my($s) = @_;
    	    eval q( &RSA_get_ex_data($s,0));
	}' unless defined(&RSA_get_app_data);
	unless(defined(&OPENSSL_NO_STDIO)) {
	}
	eval 'sub RSA_get_ex_new_index {
	    my($l, $p, $newf, $dupf, $freef) = @_;
    	    eval q( &CRYPTO_get_ex_new_index( &CRYPTO_EX_INDEX_RSA, $l, $p, $newf, $dupf, $freef));
	}' unless defined(&RSA_get_ex_new_index);
	eval 'sub RSA_FLAG_FIPS_METHOD () {0x400;}' unless defined(&RSA_FLAG_FIPS_METHOD);
	eval 'sub RSA_FLAG_NON_FIPS_ALLOW () {0x400;}' unless defined(&RSA_FLAG_NON_FIPS_ALLOW);
	eval 'sub RSA_FLAG_CHECKED () {0x800;}' unless defined(&RSA_FLAG_CHECKED);
	if(defined(&__cplusplus)) {
	}
    }
}
1;
