require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SYS_STATVFS_H_)) {
    eval 'sub _SYS_STATVFS_H_ () {1;}' unless defined(&_SYS_STATVFS_H_);
    require 'sys/cdefs.ph';
    require 'sys/featuretest.ph';
    require 'sys/stdint.ph';
    require 'machine/ansi.ph';
    require 'sys/ansi.ph';
    require 'sys/fstypes.ph';
    eval 'sub _VFS_NAMELEN () {32;}' unless defined(&_VFS_NAMELEN);
    eval 'sub _VFS_MNAMELEN () {1024;}' unless defined(&_VFS_MNAMELEN);
    unless(defined(&fsblkcnt_t)) {
	eval 'sub fsblkcnt_t () { &__fsblkcnt_t;}' unless defined(&fsblkcnt_t);
    }
    unless(defined(&fsfilcnt_t)) {
	eval 'sub fsfilcnt_t () { &__fsfilcnt_t;}' unless defined(&fsfilcnt_t);
    }
    unless(defined(&uid_t)) {
	eval 'sub uid_t () { &__uid_t;}' unless defined(&uid_t);
    }
    if(defined(&_BSD_SIZE_T_)) {
	eval 'sub _SIZE_T () {1;}' unless defined(&_SIZE_T);
	undef(&_BSD_SIZE_T_) if defined(&_BSD_SIZE_T_);
    }
    if(defined(&_NETBSD_SOURCE)  && !defined(&_POSIX_SOURCE)  && !defined(&_XOPEN_SOURCE)) {
	eval 'sub VFS_NAMELEN () { &_VFS_NAMELEN;}' unless defined(&VFS_NAMELEN);
	eval 'sub VFS_MNAMELEN () { &_VFS_MNAMELEN;}' unless defined(&VFS_MNAMELEN);
    }
    eval 'sub ST_RDONLY () { &MNT_RDONLY;}' unless defined(&ST_RDONLY);
    eval 'sub ST_SYNCHRONOUS () { &MNT_SYNCHRONOUS;}' unless defined(&ST_SYNCHRONOUS);
    eval 'sub ST_NOEXEC () { &MNT_NOEXEC;}' unless defined(&ST_NOEXEC);
    eval 'sub ST_NOSUID () { &MNT_NOSUID;}' unless defined(&ST_NOSUID);
    eval 'sub ST_NODEV () { &MNT_NODEV;}' unless defined(&ST_NODEV);
    eval 'sub ST_UNION () { &MNT_UNION;}' unless defined(&ST_UNION);
    eval 'sub ST_ASYNC () { &MNT_ASYNC;}' unless defined(&ST_ASYNC);
    eval 'sub ST_NOCOREDUMP () { &MNT_NOCOREDUMP;}' unless defined(&ST_NOCOREDUMP);
    eval 'sub ST_RELATIME () { &MNT_RELATIME;}' unless defined(&ST_RELATIME);
    eval 'sub ST_IGNORE () { &MNT_IGNORE;}' unless defined(&ST_IGNORE);
    eval 'sub ST_NOATIME () { &MNT_NOATIME;}' unless defined(&ST_NOATIME);
    eval 'sub ST_SYMPERM () { &MNT_SYMPERM;}' unless defined(&ST_SYMPERM);
    eval 'sub ST_NODEVMTIME () { &MNT_NODEVMTIME;}' unless defined(&ST_NODEVMTIME);
    eval 'sub ST_SOFTDEP () { &MNT_SOFTDEP;}' unless defined(&ST_SOFTDEP);
    eval 'sub ST_LOG () { &MNT_LOG;}' unless defined(&ST_LOG);
    eval 'sub ST_EXTATTR () { &MNT_EXTATTR;}' unless defined(&ST_EXTATTR);
    eval 'sub ST_EXRDONLY () { &MNT_EXRDONLY;}' unless defined(&ST_EXRDONLY);
    eval 'sub ST_EXPORTED () { &MNT_EXPORTED;}' unless defined(&ST_EXPORTED);
    eval 'sub ST_DEFEXPORTED () { &MNT_DEFEXPORTED;}' unless defined(&ST_DEFEXPORTED);
    eval 'sub ST_EXPORTANON () { &MNT_EXPORTANON;}' unless defined(&ST_EXPORTANON);
    eval 'sub ST_EXKERB () { &MNT_EXKERB;}' unless defined(&ST_EXKERB);
    eval 'sub ST_EXNORESPORT () { &MNT_EXNORESPORT;}' unless defined(&ST_EXNORESPORT);
    eval 'sub ST_EXPUBLIC () { &MNT_EXPUBLIC;}' unless defined(&ST_EXPUBLIC);
    eval 'sub ST_LOCAL () { &MNT_LOCAL;}' unless defined(&ST_LOCAL);
    eval 'sub ST_QUOTA () { &MNT_QUOTA;}' unless defined(&ST_QUOTA);
    eval 'sub ST_ROOTFS () { &MNT_ROOTFS;}' unless defined(&ST_ROOTFS);
    eval 'sub ST_WAIT () { &MNT_WAIT;}' unless defined(&ST_WAIT);
    eval 'sub ST_NOWAIT () { &MNT_NOWAIT;}' unless defined(&ST_NOWAIT);
    if(defined(&_KERNEL) || defined(&_STANDALONE)) {
    } else {
	unless(defined(&__LIBC12_SOURCE__)) {
	}
	if(defined(&_NETBSD_SOURCE)) {
	    unless(defined(&__LIBC12_SOURCE__)) {
	    }
	    unless(defined(&__LIBC12_SOURCE__)) {
	    }
	}
    }
    if(defined(&_KERNEL)) {
	require 'sys/kmem.ph';
	eval 'sub STATVFSBUF_GET () {
	    eval q( &kmem_alloc($sizeof{\'struct statvfs\'},  &KM_SLEEP));
	}' unless defined(&STATVFSBUF_GET);
	eval 'sub STATVFSBUF_PUT {
	    my($sb) = @_;
    	    eval q( &kmem_free($sb, $sizeof{\'struct statvfs\'}));
	}' unless defined(&STATVFSBUF_PUT);
    }
}
1;
