/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.RemoteStatement;
import com.intellij.database.remote.jdbc.helpers.AseJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.CHouseJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.CassandraJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.Db2JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.DerbyJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.ExaJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.GenericJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.H2JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.HsqlJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.MsBaseJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.MysqlBaseJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.OraJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.PgBaseJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.SqliteJdbcHelper;
import com.intellij.database.remote.jdbc.impl.ReflectionHelper;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.ThrowableRunnable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdbcNativeUtil {
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    protected static final Pattern DEFAULT_VERSION_PATTERN = Pattern.compile("(\\d+(?:\\.\\d+)+)");

    public static void logInfo(@NotNull String s) {
        if (s == null) {
            JdbcNativeUtil.$$$reportNull$$$0(0);
        }
        System.out.println(s);
    }

    public static void logWarn(@Nullable String s, @Nullable Throwable t) {
        if (s != null) {
            System.err.println(s);
        }
        if (t != null) {
            t.printStackTrace();
        }
    }

    public static void closeRemoteStatementSafe(final @Nullable RemoteStatement statement) {
        if (statement == null) {
            return;
        }
        JdbcNativeUtil.performSafe((ThrowableRunnable<? extends Exception>)new ThrowableRunnable<Exception>(){

            public void run() throws Exception {
                statement.close();
            }
        });
    }

    public static void performSafe(@NotNull ThrowableRunnable<? extends Exception> runnable) {
        if (runnable == null) {
            JdbcNativeUtil.$$$reportNull$$$0(1);
        }
        try {
            runnable.run();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Nullable
    public static <T> T computeSafe(@NotNull ThrowableComputable<T, ? extends Exception> computable) {
        if (computable == null) {
            JdbcNativeUtil.$$$reportNull$$$0(2);
        }
        try {
            return (T)computable.compute();
        }
        catch (Exception ignore) {
            return null;
        }
    }

    @Nullable
    public static Object tryGetString(@NotNull Object o) {
        if (o == null) {
            JdbcNativeUtil.$$$reportNull$$$0(3);
        }
        return ReflectionHelper.tryInvokeMethod(o, "getString", null, null);
    }

    @Nullable
    public static Object tryGetBytes(@NotNull Object o) {
        if (o == null) {
            JdbcNativeUtil.$$$reportNull$$$0(4);
        }
        return ReflectionHelper.tryInvokeMethod(o, "getBytes", null, null);
    }

    @NotNull
    public static JdbcHelperImpl detect(@NotNull Connection delegate) {
        if (delegate == null) {
            JdbcNativeUtil.$$$reportNull$$$0(5);
        }
        JdbcHelperImpl res = null;
        try {
            res = JdbcNativeUtil.detectImpl(delegate);
            JdbcNativeUtil.logInfo("Detected: " + res.getDbmsName() + " " + res.getVersion());
        }
        catch (Exception e) {
            JdbcNativeUtil.logWarn("DBMS detection failed", e);
        }
        JdbcHelperImpl jdbcHelperImpl = res == null ? new GenericJdbcHelper() : res;
        if (jdbcHelperImpl == null) {
            JdbcNativeUtil.$$$reportNull$$$0(6);
        }
        return jdbcHelperImpl;
    }

    @NotNull
    static JdbcHelperImpl detectImpl(@NotNull Connection delegate) throws Exception {
        if (delegate == null) {
            JdbcNativeUtil.$$$reportNull$$$0(7);
        }
        DatabaseMetaData metaData = delegate.getMetaData();
        try {
            JdbcNativeUtil.logInfo("Driver: " + metaData.getDriverName() + " " + metaData.getDriverVersion());
        }
        catch (Exception e) {
            JdbcNativeUtil.logWarn("Driver version detection failed", e);
        }
        String name = metaData.getDatabaseProductName();
        JdbcHelperImpl res = AseJdbcHelper.detect(delegate, name);
        if (res == null) {
            res = Db2JdbcHelper.detect(delegate, name);
        }
        if (res == null) {
            res = CHouseJdbcHelper.detect(delegate, name);
        }
        if (res == null) {
            res = CassandraJdbcHelper.detect(delegate, name);
        }
        if (res == null) {
            res = H2JdbcHelper.detect(delegate, name);
        }
        if (res == null) {
            res = HsqlJdbcHelper.detect(delegate, name);
        }
        if (res == null) {
            res = ExaJdbcHelper.detect(delegate, name);
        }
        if (res == null) {
            res = MsBaseJdbcHelper.detect(delegate, name);
        }
        if (res == null) {
            res = MysqlBaseJdbcHelper.detect(delegate, name);
        }
        if (res == null) {
            res = OraJdbcHelper.detect(delegate, name);
        }
        if (res == null) {
            res = PgBaseJdbcHelper.detect(delegate, name);
        }
        if (res == null) {
            res = SqliteJdbcHelper.detect(delegate, name);
        }
        if (res == null) {
            res = DerbyJdbcHelper.detect(delegate, name);
        }
        if (res == null) {
            res = GenericJdbcHelper.create(delegate);
        }
        JdbcHelperImpl jdbcHelperImpl = res;
        if (jdbcHelperImpl == null) {
            JdbcNativeUtil.$$$reportNull$$$0(8);
        }
        return jdbcHelperImpl;
    }

    static boolean detectString(@Nullable String product, @NotNull String part) {
        if (part == null) {
            JdbcNativeUtil.$$$reportNull$$$0(9);
        }
        return product != null && Pattern.compile("\\b" + part, 2).matcher(product).find();
    }

    @Nullable
    static String getString(@NotNull Connection delegate, @Language(value="SQL") @NotNull String sql) throws Exception {
        if (delegate == null) {
            JdbcNativeUtil.$$$reportNull$$$0(10);
        }
        if (sql == null) {
            JdbcNativeUtil.$$$reportNull$$$0(11);
        }
        final Ref res = Ref.create();
        JdbcNativeUtil.consume(delegate, sql, (ThrowableConsumer<? super ResultSet, ? extends Exception>)new ThrowableConsumer<ResultSet, Exception>(){

            public void consume(ResultSet rs) throws Exception {
                res.set(rs.next() ? rs.getString(1) : null);
            }
        });
        return (String)res.get();
    }

    @NotNull
    static String[] getStrings(@NotNull Connection delegate, @Language(value="SQL") @NotNull String sql) throws Exception {
        if (delegate == null) {
            JdbcNativeUtil.$$$reportNull$$$0(12);
        }
        if (sql == null) {
            JdbcNativeUtil.$$$reportNull$$$0(13);
        }
        final Ref res = Ref.create();
        JdbcNativeUtil.consume(delegate, sql, (ThrowableConsumer<? super ResultSet, ? extends Exception>)new ThrowableConsumer<ResultSet, Exception>(){

            public void consume(ResultSet rs) throws Exception {
                if (!rs.next()) {
                    return;
                }
                String[] cols = new String[rs.getMetaData().getColumnCount()];
                for (int i = 0; i < cols.length; ++i) {
                    cols[i] = rs.getString(i + 1);
                }
                res.set((Object)cols);
            }
        });
        String[] stringArray = res.isNull() ? ArrayUtilRt.EMPTY_STRING_ARRAY : (String[])res.get();
        if (stringArray == null) {
            JdbcNativeUtil.$$$reportNull$$$0(14);
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void consume(@NotNull Connection delegate, @Language(value="SQL") @NotNull String sql, @NotNull ThrowableConsumer<? super ResultSet, ? extends Exception> computable) throws Exception {
        if (delegate == null) {
            JdbcNativeUtil.$$$reportNull$$$0(15);
        }
        if (sql == null) {
            JdbcNativeUtil.$$$reportNull$$$0(16);
        }
        if (computable == null) {
            JdbcNativeUtil.$$$reportNull$$$0(17);
        }
        PreparedStatement stmt = delegate.prepareStatement(sql);
        try {
            stmt.execute();
            ResultSet rs = stmt.getResultSet();
            try {
                computable.consume((Object)rs);
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
    }

    @Nullable
    static String findVersion(@Nullable String versionStr, @NotNull Pattern pattern) {
        if (pattern == null) {
            JdbcNativeUtil.$$$reportNull$$$0(18);
        }
        if (versionStr == null) {
            return null;
        }
        Matcher matcher = pattern.matcher(versionStr);
        return matcher.find() ? matcher.group(1) : null;
    }

    @NotNull
    public static Calendar getUtcCalendar() {
        Calendar calendar = Calendar.getInstance(UTC);
        if (calendar == null) {
            JdbcNativeUtil.$$$reportNull$$$0(19);
        }
        return calendar;
    }

    @NotNull
    public static Date createSqlDate(@NotNull java.util.Date value) {
        if (value == null) {
            JdbcNativeUtil.$$$reportNull$$$0(20);
        }
        Date date = value instanceof Date ? (Date)value : new Date(value.getTime());
        if (date == null) {
            JdbcNativeUtil.$$$reportNull$$$0(21);
        }
        return date;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 14: 
            case 19: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 14: 
            case 19: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 2: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 6: 
            case 8: 
            case 14: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdbc/helpers/JdbcNativeUtil";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "part";
                break;
            }
            case 11: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sql";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/JdbcNativeUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "detect";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "detectImpl";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getStrings";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getUtcCalendar";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createSqlDate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "logInfo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "performSafe";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "computeSafe";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "tryGetString";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "tryGetBytes";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
            case 6: 
            case 8: 
            case 14: 
            case 19: 
            case 21: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "detectImpl";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "detectString";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getString";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getStrings";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "consume";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findVersion";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createSqlDate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 14: 
            case 19: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

