/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.remote.dbimport.BatchRecords;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.ObjectUtils;
import java.util.concurrent.atomic.DoubleAdder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ImportIndicatorUpdater {
    private static final double UNSET = -1.0;
    protected final ProgressIndicator myIndicator;
    protected final ImportInfo myInfo;
    protected final DoubleAdder mySize;
    protected double myCurrentSize;
    protected long myLines;
    protected long myStartTime;

    public ImportIndicatorUpdater(@NotNull ProgressIndicator indicator, @NotNull DoubleAdder size, @NotNull ImportInfo info) {
        if (indicator == null) {
            ImportIndicatorUpdater.$$$reportNull$$$0(0);
        }
        if (size == null) {
            ImportIndicatorUpdater.$$$reportNull$$$0(1);
        }
        if (info == null) {
            ImportIndicatorUpdater.$$$reportNull$$$0(2);
        }
        this.myIndicator = indicator;
        this.mySize = size;
        this.myInfo = info;
    }

    public void start() {
        this.myIndicator.setFraction(0.0);
        this.myIndicator.setText(this.getIndicatorTitle());
        this.myStartTime = System.currentTimeMillis();
        this.myIndicator.setText(this.getIndicatorTitle());
    }

    public void update(@NotNull BatchRecords records, long lines) {
        if (records == null) {
            ImportIndicatorUpdater.$$$reportNull$$$0(3);
        }
        this.myIndicator.checkCanceled();
        double value = this.mySize.doubleValue();
        this.myCurrentSize += records.getBatchSize();
        this.myLines += lines;
        this.myIndicator.setText2(this.getStatistics());
        if (Double.compare(value, -1.0) == 0) {
            return;
        }
        this.myIndicator.setFraction(this.myCurrentSize / value);
    }

    @NotNull
    private String getIndicatorTitle() {
        DbDataSource source = (DbDataSource)ObjectUtils.notNull((Object)this.myInfo.getContext().getDataSource());
        String string = String.format("Importing %s to %s (%s)", this.myInfo.getProducerName(), this.myInfo.getTableName(), source.getName());
        if (string == null) {
            ImportIndicatorUpdater.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    private String getStatistics() {
        long timeSpent = (System.currentTimeMillis() - this.myStartTime) / 1000L;
        if (this.myLines == 0L || timeSpent == 0L) {
            if ("" == null) {
                ImportIndicatorUpdater.$$$reportNull$$$0(5);
            }
            return "";
        }
        String speed = this.calculateSpeed(timeSpent);
        String string = String.format("%s %s", this.myLines, ImportUtil.pluralizeRows(this.myLines)) + (speed == null ? "" : String.format(" (%s)", speed));
        if (string == null) {
            ImportIndicatorUpdater.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public abstract String calculateSpeed(long var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "size";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "records";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/ImportIndicatorUpdater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/ImportIndicatorUpdater";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndicatorTitle";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatistics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

