/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.config;

import com.intellij.openapi.util.Ref;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.idea.svn.SvnBundle;

public class AmbiguousPatternsFinder {
    private final Map<String, Set<String>> urls2groups = new HashMap<String, Set<String>>();
    private static final int ourMessageLen = 30;

    public void acceptUrls(String groupName, List<String> urls) {
        for (String url : urls) {
            Set<Object> set;
            if (this.urls2groups.containsKey(url)) {
                set = this.urls2groups.get(url);
            } else {
                set = new HashSet();
                this.urls2groups.put(url, set);
            }
            set.add(groupName);
        }
    }

    public boolean isValid(Ref<String> errorMessageRef) {
        StringBuilder sb = null;
        for (Map.Entry<String, Set<String>> entry : this.urls2groups.entrySet()) {
            if (entry.getValue().size() <= 1) continue;
            if (sb == null) {
                sb = new StringBuilder();
            } else {
                if (sb.length() > 30) {
                    sb.append("...");
                    break;
                }
                sb.append("; ");
            }
            StringBuilder innerBuilder = null;
            for (String groupName : entry.getValue()) {
                if (innerBuilder == null) {
                    innerBuilder = new StringBuilder();
                } else {
                    innerBuilder.append(", ");
                }
                innerBuilder.append(groupName);
            }
            sb.append(SvnBundle.message("dialog.edit.http.proxies.settings.error.ambiguous.group.patterns.to.text", entry.getKey(), innerBuilder.toString()));
        }
        if (sb != null) {
            errorMessageRef.set((Object)SvnBundle.message("dialog.edit.http.proxies.settings.error.ambiguous.group.patterns.text", sb.toString()));
        }
        return sb == null;
    }
}

