/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.apacheConfig.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.lang.apacheConfig.parser.ApacheConfigElementTypes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class ApacheConfigParser
implements PsiParser {
    private final Project project;

    public ApacheConfigParser(Project project) {
        this.project = project;
    }

    @NotNull
    public ASTNode parse(IElementType root, PsiBuilder builder) {
        PsiBuilder.Marker rootMarker = builder.mark();
        while (!builder.eof()) {
            if (builder.getTokenType() == ApacheConfigElementTypes.IDENTIFIER) {
                this.parseDirective(builder);
                continue;
            }
            if (builder.getTokenType() == ApacheConfigElementTypes.BEGIN_SECTION_START) {
                this.parseSection(builder);
                continue;
            }
            if (builder.getTokenType() == ApacheConfigElementTypes.WHITE_SPACE) {
                builder.advanceLexer();
                continue;
            }
            builder.error("Directive or section begin expected");
            builder.advanceLexer();
        }
        rootMarker.done(root);
        ASTNode aSTNode = builder.getTreeBuilt();
        if (aSTNode == null) {
            ApacheConfigParser.$$$reportNull$$$0(0);
        }
        return aSTNode;
    }

    private void parseSection(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        String sectionNameInHeader = this.parseSectionHeader(builder);
        while (builder.getTokenType() != ApacheConfigElementTypes.END_SECTION_START && !builder.eof()) {
            this.eatWhiteSpaces(builder);
            if (builder.getTokenType() == ApacheConfigElementTypes.IDENTIFIER) {
                this.parseDirective(builder);
                continue;
            }
            if (builder.getTokenType() == ApacheConfigElementTypes.BEGIN_SECTION_START) {
                this.parseSection(builder);
                continue;
            }
            builder.advanceLexer();
        }
        String sectionNameInFooter = this.parseSectionFooter(builder);
        if (sectionNameInHeader == null || !sectionNameInHeader.equals(sectionNameInFooter)) {
            builder.error("Section end expected");
        }
        marker.done((IElementType)ApacheConfigElementTypes.SECTION);
    }

    private String parseSectionFooter(PsiBuilder builder) {
        String result = null;
        PsiBuilder.Marker marker = builder.mark();
        builder.advanceLexer();
        this.eatWhiteSpaces(builder);
        if (builder.getTokenType() != ApacheConfigElementTypes.IDENTIFIER) {
            builder.error("Section name expected");
        } else {
            result = builder.getTokenText();
        }
        this.eatWhiteSpaces(builder);
        builder.advanceLexer();
        if (builder.getTokenType() != ApacheConfigElementTypes.SECTION_STOP) {
            builder.error("> expected");
        }
        builder.advanceLexer();
        this.eatWhiteSpaces(builder);
        marker.done((IElementType)ApacheConfigElementTypes.SECTION_FOOTER);
        return result;
    }

    private void eatWhiteSpaces(PsiBuilder builder) {
        while (builder.getTokenType() == ApacheConfigElementTypes.WHITE_SPACE) {
            builder.advanceLexer();
        }
    }

    private String parseSectionHeader(PsiBuilder builder) {
        String result = null;
        PsiBuilder.Marker marker = builder.mark();
        builder.advanceLexer();
        this.eatWhiteSpaces(builder);
        if (builder.getTokenType() != ApacheConfigElementTypes.IDENTIFIER) {
            builder.error("Section name expected");
        } else {
            result = builder.getTokenText();
        }
        builder.advanceLexer();
        while (builder.getTokenType() != ApacheConfigElementTypes.SECTION_STOP && !builder.eof() && builder.getTokenText() != null && builder.getTokenText().indexOf(10) == -1) {
            this.parseArgument(builder, true);
            if (builder.getTokenType() == ApacheConfigElementTypes.ARG_LEXEM || builder.getTokenType() == ApacheConfigElementTypes.WHITE_SPACE || builder.getTokenType() == ApacheConfigElementTypes.SECTION_STOP || builder.getTokenType() == ApacheConfigElementTypes.ARG_SEPARATOR || builder.getTokenText() == null || builder.getTokenText().indexOf(10) == -1) continue;
            builder.error("Argument or > expected");
            break;
        }
        if (!builder.eof()) {
            builder.advanceLexer();
        }
        this.eatWhiteSpaces(builder);
        marker.done((IElementType)ApacheConfigElementTypes.SECTION_HEADER);
        return result;
    }

    private void parseArgument(PsiBuilder builder, boolean isHeader) {
        if (this.isArgLexem(builder, isHeader)) {
            PsiBuilder.Marker argument = builder.mark();
            while (this.isArgLexem(builder, isHeader) || builder.getTokenType() == ApacheConfigElementTypes.IDENTIFIER) {
                boolean isWhitespace = builder.rawLookup(1) == ApacheConfigElementTypes.WHITE_SPACE;
                builder.advanceLexer();
                if (!isWhitespace) continue;
                break;
            }
            argument.done(ApacheConfigElementTypes.ARGUMENT);
        } else if (builder.getTokenType() == ApacheConfigElementTypes.QUOTE) {
            PsiBuilder.Marker argument = builder.mark();
            builder.advanceLexer();
            if (builder.getTokenType() != ApacheConfigElementTypes.ARG_LEXEM && builder.getTokenType() != ApacheConfigElementTypes.QUOTE && builder.getTokenType() != ApacheConfigElementTypes.ARG_SEPARATOR) {
                builder.error("Argument parse error");
                argument.done(ApacheConfigElementTypes.ARGUMENT);
            } else if (builder.getTokenType() == ApacheConfigElementTypes.QUOTE) {
                builder.advanceLexer();
                argument.done(ApacheConfigElementTypes.ARGUMENT);
            } else {
                while (builder.getTokenType() == ApacheConfigElementTypes.ARG_LEXEM || builder.getTokenType() == ApacheConfigElementTypes.ARG_SEPARATOR) {
                    builder.advanceLexer();
                }
                if (builder.getTokenType() != ApacheConfigElementTypes.QUOTE) {
                    builder.error("\" expected");
                    argument.done(ApacheConfigElementTypes.ARGUMENT);
                } else {
                    builder.advanceLexer();
                    argument.done(ApacheConfigElementTypes.ARGUMENT);
                }
            }
        } else {
            builder.advanceLexer();
        }
    }

    private boolean isArgLexem(PsiBuilder builder, boolean isHeader) {
        IElementType type = builder.getTokenType();
        return type == ApacheConfigElementTypes.ARG_LEXEM || !isHeader && type == ApacheConfigElementTypes.SECTION_STOP;
    }

    private void parseDirective(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        do {
            this.parseArgument(builder, false);
        } while (this.isArgLexem(builder, false) || builder.getTokenType() == ApacheConfigElementTypes.QUOTE || builder.getTokenType() == ApacheConfigElementTypes.ARG_SEPARATOR || builder.getTokenType() == ApacheConfigElementTypes.WHITE_SPACE && builder.getTokenText() != null && builder.getTokenText().indexOf(10) == -1 && !builder.eof());
        this.eatWhiteSpaces(builder);
        marker.done((IElementType)ApacheConfigElementTypes.DIRECTIVE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/apacheConfig/parser/ApacheConfigParser", "parse"));
    }
}

