/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson;

import com.google.common.collect.ConcurrentHashMultiset;
import com.intellij.javascript.nodejs.packageJson.PackageJsonDependenciesExternalUpdateListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageJsonDependenciesExternalUpdateManager {
    private final Project myProject;
    private final AtomicInteger myRunningExternalUpdateCount;
    private final ConcurrentHashMultiset<String> myRunningNamedExternalUpdates;
    private final List<PackageJsonDependenciesExternalUpdateListener> myListeners;

    public PackageJsonDependenciesExternalUpdateManager(@NotNull Project project) {
        if (project == null) {
            PackageJsonDependenciesExternalUpdateManager.$$$reportNull$$$0(0);
        }
        this.myRunningExternalUpdateCount = new AtomicInteger(0);
        this.myRunningNamedExternalUpdates = ConcurrentHashMultiset.create();
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProject = project;
    }

    public void addListener(@NotNull PackageJsonDependenciesExternalUpdateListener listener2) {
        if (listener2 == null) {
            PackageJsonDependenciesExternalUpdateManager.$$$reportNull$$$0(1);
        }
        this.myListeners.add(listener2);
    }

    public void removeListener(@NotNull PackageJsonDependenciesExternalUpdateListener listener2) {
        if (listener2 == null) {
            PackageJsonDependenciesExternalUpdateManager.$$$reportNull$$$0(2);
        }
        this.myListeners.remove(listener2);
    }

    @NotNull
    public static PackageJsonDependenciesExternalUpdateManager getInstance(@NotNull Project project) {
        if (project == null) {
            PackageJsonDependenciesExternalUpdateManager.$$$reportNull$$$0(3);
        }
        PackageJsonDependenciesExternalUpdateManager packageJsonDependenciesExternalUpdateManager = (PackageJsonDependenciesExternalUpdateManager)ServiceManager.getService((Project)project, PackageJsonDependenciesExternalUpdateManager.class);
        if (packageJsonDependenciesExternalUpdateManager == null) {
            PackageJsonDependenciesExternalUpdateManager.$$$reportNull$$$0(4);
        }
        return packageJsonDependenciesExternalUpdateManager;
    }

    @NotNull
    public Runnable externalUpdateStarted(@Nullable VirtualFile packageJson, @Nullable String taskName) {
        this.myRunningExternalUpdateCount.incrementAndGet();
        if (taskName != null) {
            this.myRunningNamedExternalUpdates.add((Object)taskName);
        }
        this.fireOnExternalUpdateStarted(packageJson);
        Alarm alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this.myProject);
        Runnable done = ConcurrencyUtil.once(() -> {
            this.myRunningExternalUpdateCount.decrementAndGet();
            if (taskName != null) {
                this.myRunningNamedExternalUpdates.remove((Object)taskName);
            }
            Disposer.dispose((Disposable)alarm);
            this.fireOnExternalUpdateFinished(packageJson);
        });
        alarm.addRequest(done, TimeUnit.MINUTES.toMillis(5L));
        Runnable runnable = done;
        if (runnable == null) {
            PackageJsonDependenciesExternalUpdateManager.$$$reportNull$$$0(5);
        }
        return runnable;
    }

    private void fireOnExternalUpdateStarted(@Nullable VirtualFile packageJson) {
        for (PackageJsonDependenciesExternalUpdateListener listener2 : this.myListeners) {
            listener2.externalUpdateStarted(packageJson);
        }
    }

    private void fireOnExternalUpdateFinished(@Nullable VirtualFile packageJson) {
        for (PackageJsonDependenciesExternalUpdateListener listener2 : this.myListeners) {
            listener2.externalUpdateFinished(packageJson);
        }
    }

    public boolean isExternalUpdateRunning() {
        return this.myRunningExternalUpdateCount.get() > 0;
    }

    public boolean isExternalUpdateRunning(@NotNull String taskName) {
        if (taskName == null) {
            PackageJsonDependenciesExternalUpdateManager.$$$reportNull$$$0(6);
        }
        return this.myRunningNamedExternalUpdates.contains((Object)taskName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/PackageJsonDependenciesExternalUpdateManager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/PackageJsonDependenciesExternalUpdateManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "externalUpdateStarted";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isExternalUpdateRunning";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

