/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.protractor;

import com.google.common.collect.ImmutableList;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.javascript.protractor.ProtractorConfigurationType;
import com.intellij.javascript.protractor.ProtractorRunConfiguration;
import com.intellij.javascript.protractor.ProtractorRunSettings;
import com.intellij.javascript.protractor.ProtractorUtil;
import com.intellij.javascript.protractor.scope.ProtractorScopeKind;
import com.intellij.javascript.testFramework.JsTestElementPath;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructure;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructureBuilder;
import com.intellij.javascript.testing.JsTestRunConfigurationProducer;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProtractorRunConfigurationProducer
extends JsTestRunConfigurationProducer<ProtractorRunConfiguration> {
    protected ProtractorRunConfigurationProducer() {
        super((ConfigurationType)ProtractorConfigurationType.getInstance(), (List<String>)ImmutableList.of((Object)"protractor"));
    }

    private boolean isTestRunnerPackageAvailableFor(@NotNull PsiElement element, @NotNull ConfigurationContext context) {
        if (element == null) {
            ProtractorRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ProtractorRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (context.getOriginalConfiguration((ConfigurationType)ProtractorConfigurationType.getInstance()) instanceof ProtractorRunConfiguration) {
            return true;
        }
        return super.isTestRunnerPackageAvailableFor(element);
    }

    protected boolean setupConfigurationFromCompatibleContext(@NotNull ProtractorRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        PsiElement element;
        if (configuration == null) {
            ProtractorRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (context == null) {
            ProtractorRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        if (sourceElement == null) {
            ProtractorRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        if ((element = context.getPsiLocation()) == null || !this.isTestRunnerPackageAvailableFor(element, context)) {
            return false;
        }
        TestElementInfo elementRunInfo = ProtractorRunConfigurationProducer.createTestElementRunInfo(element, configuration.getRunSettings());
        if (elementRunInfo == null) {
            return false;
        }
        ProtractorRunSettings runSettings = elementRunInfo.getRunSettings();
        configuration.setRunSettings(runSettings);
        sourceElement.set((Object)elementRunInfo.getEnclosingTestElement());
        configuration.setGeneratedName();
        return true;
    }

    public boolean isConfigurationFromCompatibleContext(@NotNull ProtractorRunConfiguration configuration, @NotNull ConfigurationContext context) {
        PsiElement location;
        if (configuration == null) {
            ProtractorRunConfigurationProducer.$$$reportNull$$$0(5);
        }
        if (context == null) {
            ProtractorRunConfigurationProducer.$$$reportNull$$$0(6);
        }
        if ((location = context.getPsiLocation()) == null) {
            return false;
        }
        ProtractorRunSettings confSettings = configuration.getRunSettings();
        TestElementInfo info = ProtractorRunConfigurationProducer.createTestElementRunInfo(location, confSettings);
        return info != null && confSettings.equals(info.myRunSettings);
    }

    public boolean isPreferredConfiguration(ConfigurationFromContext self, ConfigurationFromContext other) {
        ProtractorRunConfiguration selfRc = (ProtractorRunConfiguration)ObjectUtils.tryCast((Object)self.getConfiguration(), ProtractorRunConfiguration.class);
        PsiFile psiFile = self.getSourceElement().getContainingFile();
        return psiFile != null && selfRc != null && other != null && selfRc.isPreferredOver(other.getConfiguration(), (PsiElement)psiFile);
    }

    @Nullable
    private static TestElementInfo createTestElementRunInfo(@NotNull PsiElement element, @NotNull ProtractorRunSettings templateRunSettings) {
        TestElementInfo info;
        VirtualFile virtualFile;
        if (element == null) {
            ProtractorRunConfigurationProducer.$$$reportNull$$$0(7);
        }
        if (templateRunSettings == null) {
            ProtractorRunConfigurationProducer.$$$reportNull$$$0(8);
        }
        if ((virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element)) == null) {
            return null;
        }
        JSFile file2 = (JSFile)ObjectUtils.tryCast((Object)element.getContainingFile(), JSFile.class);
        TestElementInfo testElementInfo = info = file2 != null ? ProtractorRunConfigurationProducer.setupAsSuiteOrTest(file2, virtualFile, element, templateRunSettings) : null;
        if (info != null) {
            return info;
        }
        if (file2 != null && ProtractorUtil.isProtractorConfigFile(virtualFile.getNameSequence())) {
            ProtractorRunSettings.Builder builder = templateRunSettings.toBuilder().setScopeKind(ProtractorScopeKind.ALL).setConfigFilePath(virtualFile.getPath());
            String suiteName = ProtractorRunConfigurationProducer.getSuiteName(element);
            if (suiteName != null) {
                String options = templateRunSettings.getProtractorOptions();
                builder.setProtractorOptions(options + (options.isEmpty() ? "" : " ") + "--suite=" + suiteName);
            }
            return new TestElementInfo(builder.build(), (PsiElement)file2);
        }
        if (file2 != null && file2.getTestFileType() != null) {
            ProtractorRunSettings settings = ProtractorRunConfigurationProducer.guessConfigFileIfNeeded(templateRunSettings, virtualFile, element.getProject());
            return new TestElementInfo(settings.toBuilder().setScopeKind(ProtractorScopeKind.TEST_FILE).setTestFilePath(virtualFile.getPath()).build(), (PsiElement)file2);
        }
        return null;
    }

    static String getSuiteName(@NotNull PsiElement element) {
        JSProperty suiteProperty;
        JSObjectLiteralExpression objectLiteralExpression;
        JSProperty property;
        if (element == null) {
            ProtractorRunConfigurationProducer.$$$reportNull$$$0(9);
        }
        if (element instanceof LeafPsiElement && (property = (JSProperty)ObjectUtils.tryCast((Object)element.getParent(), JSProperty.class)) != null && property.getNameIdentifier() == element && (objectLiteralExpression = (JSObjectLiteralExpression)ObjectUtils.tryCast((Object)property.getParent(), JSObjectLiteralExpression.class)) != null && (suiteProperty = (JSProperty)ObjectUtils.tryCast((Object)objectLiteralExpression.getParent(), JSProperty.class)) != null && "suites".equals(suiteProperty.getName())) {
            return property.getName();
        }
        return null;
    }

    @Nullable
    private static TestElementInfo setupAsSuiteOrTest(@NotNull JSFile file2, @NotNull VirtualFile virtualFile, @NotNull PsiElement element, @NotNull ProtractorRunSettings templateSettings) {
        if (file2 == null) {
            ProtractorRunConfigurationProducer.$$$reportNull$$$0(10);
        }
        if (virtualFile == null) {
            ProtractorRunConfigurationProducer.$$$reportNull$$$0(11);
        }
        if (element == null) {
            ProtractorRunConfigurationProducer.$$$reportNull$$$0(12);
        }
        if (templateSettings == null) {
            ProtractorRunConfigurationProducer.$$$reportNull$$$0(13);
        }
        if (element instanceof PsiFileSystemItem) {
            return null;
        }
        TextRange textRange = element.getTextRange();
        if (textRange == null || !file2.isTestFile()) {
            return null;
        }
        JasmineFileStructure jasmineStructure = (JasmineFileStructure)JasmineFileStructureBuilder.getInstance().fetchCachedTestFileStructure(file2);
        JsTestElementPath path = jasmineStructure.findTestElementPath(textRange);
        if (path != null) {
            templateSettings = ProtractorRunConfigurationProducer.guessConfigFileIfNeeded(templateSettings, virtualFile, element.getProject());
            ProtractorRunSettings.Builder builder = templateSettings.toBuilder();
            builder.setTestFilePath(virtualFile.getPath());
            String testName = path.getTestName();
            if (testName == null) {
                builder.setScopeKind(ProtractorScopeKind.SUITE);
                builder.setTestNames(path.getSuiteNames());
            } else {
                builder.setScopeKind(ProtractorScopeKind.TEST);
                builder.setTestNames(path.getAllNames());
            }
            return new TestElementInfo(builder.build(), path.getTestElement());
        }
        return null;
    }

    @NotNull
    private static ProtractorRunSettings guessConfigFileIfNeeded(@NotNull ProtractorRunSettings settings, @NotNull VirtualFile contextFile, @NotNull Project project) {
        VirtualFile dir;
        if (settings == null) {
            ProtractorRunConfigurationProducer.$$$reportNull$$$0(14);
        }
        if (contextFile == null) {
            ProtractorRunConfigurationProducer.$$$reportNull$$$0(15);
        }
        if (project == null) {
            ProtractorRunConfigurationProducer.$$$reportNull$$$0(16);
        }
        if (!settings.getConfigFileSystemDependentPath().isEmpty()) {
            ProtractorRunSettings protractorRunSettings = settings;
            if (protractorRunSettings == null) {
                ProtractorRunConfigurationProducer.$$$reportNull$$$0(17);
            }
            return protractorRunSettings;
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)project);
        VirtualFile virtualFile = dir = contextFile.isDirectory() ? contextFile : contextFile.getParent();
        if (dir == null) {
            ProtractorRunSettings protractorRunSettings = settings;
            if (protractorRunSettings == null) {
                ProtractorRunConfigurationProducer.$$$reportNull$$$0(18);
            }
            return protractorRunSettings;
        }
        VirtualFile contentRoot = fileIndex.getContentRootForFile(dir, false);
        while (dir != null && contentRoot != null) {
            VirtualFile[] children;
            for (VirtualFile child : children = dir.getChildren()) {
                if (!ProtractorUtil.isProtractorConfigFile(child.getNameSequence())) continue;
                ProtractorRunSettings protractorRunSettings = settings.toBuilder().setConfigFilePath(child.getPath()).build();
                if (protractorRunSettings == null) {
                    ProtractorRunConfigurationProducer.$$$reportNull$$$0(19);
                }
                return protractorRunSettings;
            }
            if (dir.equals(contentRoot)) {
                dir = dir.getParent();
                contentRoot = fileIndex.getContentRootForFile(dir, false);
                continue;
            }
            dir = dir.getParent();
        }
        ProtractorRunSettings protractorRunSettings = settings;
        if (protractorRunSettings == null) {
            ProtractorRunConfigurationProducer.$$$reportNull$$$0(20);
        }
        return protractorRunSettings;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateRunSettings";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateSettings";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/protractor/ProtractorRunConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/protractor/ProtractorRunConfigurationProducer";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "guessConfigFileIfNeeded";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isTestRunnerPackageAvailableFor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromCompatibleContext";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromCompatibleContext";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createTestElementRunInfo";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSuiteName";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setupAsSuiteOrTest";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "guessConfigFileIfNeeded";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TestElementInfo {
        private final ProtractorRunSettings myRunSettings;
        private final PsiElement myEnclosingTestElement;

        TestElementInfo(@NotNull ProtractorRunSettings runSettings, @NotNull PsiElement enclosingTestElement) {
            if (runSettings == null) {
                TestElementInfo.$$$reportNull$$$0(0);
            }
            if (enclosingTestElement == null) {
                TestElementInfo.$$$reportNull$$$0(1);
            }
            this.myRunSettings = runSettings;
            this.myEnclosingTestElement = enclosingTestElement;
        }

        @NotNull
        public ProtractorRunSettings getRunSettings() {
            ProtractorRunSettings protractorRunSettings = this.myRunSettings;
            if (protractorRunSettings == null) {
                TestElementInfo.$$$reportNull$$$0(2);
            }
            return protractorRunSettings;
        }

        @NotNull
        public PsiElement getEnclosingTestElement() {
            PsiElement psiElement = this.myEnclosingTestElement;
            if (psiElement == null) {
                TestElementInfo.$$$reportNull$$$0(3);
            }
            return psiElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runSettings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "enclosingTestElement";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/protractor/ProtractorRunConfigurationProducer$TestElementInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/protractor/ProtractorRunConfigurationProducer$TestElementInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRunSettings";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEnclosingTestElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

