/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base;

import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.ui.UISettings;
import com.intellij.lang.javascript.buildTools.base.JsbtService;
import com.intellij.lang.javascript.buildTools.base.JsbtSortingMode;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskTreeView;
import com.intellij.lang.javascript.buildTools.base.JsbtToolWindowPanel;
import com.intellij.lang.javascript.buildTools.base.actions.JsbtAddBuildfileAction;
import com.intellij.lang.javascript.buildTools.base.actions.JsbtReloadTasksAction;
import com.intellij.lang.javascript.buildTools.base.actions.JsbtRemoveBuildfileAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ui.tree.TreeUtil;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

public class JsbtToolWindowManager {
    private final Project myProject;
    private final String myToolWindowId;
    private final Icon myToolWindowIcon;
    private final String myHelpId;
    private final JsbtService myService;
    private ToolWindow myToolWindow;

    public JsbtToolWindowManager(@NotNull Project project, @NotNull String toolWindowId, @NotNull Icon toolWindowIcon, @NotNull String helpId, @NotNull JsbtService service) {
        if (project == null) {
            JsbtToolWindowManager.$$$reportNull$$$0(0);
        }
        if (toolWindowId == null) {
            JsbtToolWindowManager.$$$reportNull$$$0(1);
        }
        if (toolWindowIcon == null) {
            JsbtToolWindowManager.$$$reportNull$$$0(2);
        }
        if (helpId == null) {
            JsbtToolWindowManager.$$$reportNull$$$0(3);
        }
        if (service == null) {
            JsbtToolWindowManager.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.myToolWindowId = toolWindowId;
        this.myToolWindowIcon = toolWindowIcon;
        this.myHelpId = helpId;
        this.myService = service;
    }

    public void setAvailable() {
        AnAction[] titleActions;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myToolWindow != null) {
            return;
        }
        this.myToolWindow = JsbtToolWindowManager.createToolWindow(this.myProject, this.myToolWindowId, this.myToolWindowIcon);
        ContentManager contentManager = this.myToolWindow.getContentManager();
        JsbtTaskTreeView taskTreeView = this.myService.createTaskTreeView(this.myProject, null);
        taskTreeView.init();
        JsbtToolWindowPanel panel = new JsbtToolWindowPanel(this.myProject, taskTreeView, this.myHelpId);
        for (AnAction action : titleActions = new AnAction[]{new JsbtAddBuildfileAction(this.myService, false), new JsbtRemoveBuildfileAction(this.myService, taskTreeView), new JsbtReloadTasksAction(taskTreeView), JsbtToolWindowManager.createCollapseAllAction(taskTreeView)}) {
            ShortcutSet shortcutSet = action.getShortcutSet();
            if (shortcutSet == null) continue;
            action.registerCustomShortcutSet(shortcutSet, (JComponent)taskTreeView.getComponent());
        }
        ToolWindowEx toolWindowEx = (ToolWindowEx)this.myToolWindow;
        toolWindowEx.setTitleActions(titleActions);
        DefaultActionGroup actionGroup = new DefaultActionGroup(new AnAction[]{new ShowSettingsAction()});
        DefaultActionGroup sortActionGroup = new DefaultActionGroup("Sort by", true);
        sortActionGroup.add((AnAction)new ToggleSortingModeAction(JsbtSortingMode.DEFINITION_ORDER, taskTreeView));
        sortActionGroup.add((AnAction)new ToggleSortingModeAction(JsbtSortingMode.NAME, taskTreeView));
        actionGroup.add((AnAction)sortActionGroup);
        actionGroup.add((AnAction)new WideScreenToolWindowLayout());
        toolWindowEx.setAdditionalGearActions((ActionGroup)actionGroup);
        Content content = contentManager.getFactory().createContent((JComponent)((Object)panel), "", true);
        content.setCloseable(false);
        content.setPreferredFocusableComponent(panel.getPreferredFocusedComponent());
        contentManager.addContent(content);
        contentManager.setSelectedContent(content);
        this.myToolWindow.setAvailable(true, null);
    }

    @NotNull
    private static AnAction createCollapseAllAction(final @NotNull JsbtTaskTreeView taskTreeView) {
        if (taskTreeView == null) {
            JsbtToolWindowManager.$$$reportNull$$$0(5);
        }
        AnAction collapseAllAction = CommonActionsManager.getInstance().createCollapseAllAction(new TreeExpander(){

            public boolean canExpand() {
                return false;
            }

            public void collapseAll() {
                TreeUtil.collapseAll((JTree)taskTreeView.getComponent(), (int)0);
            }

            public boolean canCollapse() {
                return true;
            }
        }, (JComponent)taskTreeView.getComponent());
        collapseAllAction.getTemplatePresentation().setIcon(AllIcons.General.CollapseAll);
        collapseAllAction.getTemplatePresentation().setHoveredIcon(AllIcons.General.CollapseAllHover);
        AnAction anAction = collapseAllAction;
        if (anAction == null) {
            JsbtToolWindowManager.$$$reportNull$$$0(6);
        }
        return anAction;
    }

    @NotNull
    private static ToolWindow createToolWindow(@NotNull Project project, @NotNull String id, @NotNull Icon icon) {
        if (project == null) {
            JsbtToolWindowManager.$$$reportNull$$$0(7);
        }
        if (id == null) {
            JsbtToolWindowManager.$$$reportNull$$$0(8);
        }
        if (icon == null) {
            JsbtToolWindowManager.$$$reportNull$$$0(9);
        }
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).registerToolWindow(id, true, ToolWindowAnchor.LEFT, (Disposable)project, true, true);
        toolWindow.setToHideOnEmptyContent(true);
        toolWindow.setIcon(icon);
        ToolWindow toolWindow2 = toolWindow;
        if (toolWindow2 == null) {
            JsbtToolWindowManager.$$$reportNull$$$0(10);
        }
        return toolWindow2;
    }

    public void show(boolean alsoActivate) {
        this.setAvailable();
        this.myToolWindow.show(null);
        if (alsoActivate && !this.myToolWindow.isActive()) {
            this.myToolWindow.activate(null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowIcon";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskTreeView";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/base/JsbtToolWindowManager";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/JsbtToolWindowManager";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createCollapseAllAction";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolWindow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createCollapseAllAction";
                break;
            }
            case 6: 
            case 10: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createToolWindow";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class WideScreenToolWindowLayout
    extends ToggleAction
    implements DumbAware {
        WideScreenToolWindowLayout() {
            super(IdeBundle.message((String)"checkbox.widescreen.tool.window.layout", (Object[])new Object[0]));
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                WideScreenToolWindowLayout.$$$reportNull$$$0(0);
            }
            return UISettings.getInstance().getWideScreenSupport();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            UISettings uiSettings;
            boolean prev;
            if (e == null) {
                WideScreenToolWindowLayout.$$$reportNull$$$0(1);
            }
            if ((prev = (uiSettings = UISettings.getInstance()).getWideScreenSupport()) != state) {
                uiSettings.setWideScreenSupport(state);
                uiSettings.fireUISettingsChanged();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/JsbtToolWindowManager$WideScreenToolWindowLayout";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ToggleSortingModeAction
    extends ToggleAction
    implements DumbAware {
        private final JsbtSortingMode mySortingMode;
        private final JsbtTaskTreeView myTaskTreeView;

        ToggleSortingModeAction(@NotNull JsbtSortingMode sortingMode, @NotNull JsbtTaskTreeView taskTreeView) {
            if (sortingMode == null) {
                ToggleSortingModeAction.$$$reportNull$$$0(0);
            }
            if (taskTreeView == null) {
                ToggleSortingModeAction.$$$reportNull$$$0(1);
            }
            super(sortingMode.getDisplayName());
            this.mySortingMode = sortingMode;
            this.myTaskTreeView = taskTreeView;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleSortingModeAction.$$$reportNull$$$0(2);
            }
            return this.myTaskTreeView.getSortingMode() == this.mySortingMode;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ToggleSortingModeAction.$$$reportNull$$$0(3);
            }
            this.myTaskTreeView.setSortingMode(this.mySortingMode);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sortingMode";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "taskTreeView";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/JsbtToolWindowManager$ToggleSortingModeAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ShowSettingsAction
    extends DumbAwareAction {
        ShowSettingsAction() {
            super(JsbtToolWindowManager.this.myService.getToolWindowSettingsActionName(), null, JsbtToolWindowManager.this.myService.getIcon());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowSettingsAction.$$$reportNull$$$0(0);
            }
            JsbtToolWindowManager.this.myService.showTaskListingSettingsDialog(JsbtToolWindowManager.this.myProject, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/buildTools/base/JsbtToolWindowManager$ShowSettingsAction", "actionPerformed"));
        }
    }
}

