/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.lang.ecmascript6.psi.impl.ES6FieldStatementImpl;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptField;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptFieldToParameterPropertyIntention
extends JavaScriptIntention
implements LowPriorityAction {
    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            TypeScriptFieldToParameterPropertyIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            TypeScriptFieldToParameterPropertyIntention.$$$reportNull$$$0(1);
        }
        TypeScriptField field = TypeScriptFieldToParameterPropertyIntention.getField(element);
        assert (field != null);
        Pair<JSParameter, JSStatement> parameterForField = TypeScriptFieldToParameterPropertyIntention.getParameterForField(field, false);
        assert (parameterForField != null);
        JSParameter parameter = (JSParameter)parameterForField.first;
        JSStatement statement = (JSStatement)parameterForField.second;
        JSParameter param = (JSParameter)JSChangeUtil.createParameter(field.getText(), (PsiElement)field);
        new JSAttributeListWrapper((JSAttributeListOwner)field).applyTo((JSAttributeListOwner)param);
        parameter.replace((PsiElement)param);
        statement.delete();
        ((ES6FieldStatementImpl)PsiTreeUtil.getParentOfType((PsiElement)field, ES6FieldStatementImpl.class)).delete();
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            TypeScriptFieldToParameterPropertyIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            TypeScriptFieldToParameterPropertyIntention.$$$reportNull$$$0(3);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        TypeScriptField field = TypeScriptFieldToParameterPropertyIntention.getField(element);
        if (field == null || !DialectDetector.isTypeScript((PsiElement)field) || field.getInitializer() != null) {
            return false;
        }
        return TypeScriptFieldToParameterPropertyIntention.getParameterForField(field, true) != null;
    }

    @Nullable
    private static TypeScriptField getField(@NotNull PsiElement element) {
        if (element == null) {
            TypeScriptFieldToParameterPropertyIntention.$$$reportNull$$$0(4);
        }
        return JavaScriptIntention.findParentVariable(element, TypeScriptField.class);
    }

    @Contract(value="null, _, _ -> false")
    private static boolean isFieldToParameterValueAssignment(@Nullable JSStatement statement, @NotNull String parameterName, @NotNull String fieldName) {
        if (parameterName == null) {
            TypeScriptFieldToParameterPropertyIntention.$$$reportNull$$$0(5);
        }
        if (fieldName == null) {
            TypeScriptFieldToParameterPropertyIntention.$$$reportNull$$$0(6);
        }
        if (!(statement instanceof JSExpressionStatement)) {
            return false;
        }
        JSExpression expression = ((JSExpressionStatement)statement).getExpression();
        if (!(expression instanceof JSAssignmentExpression)) {
            return false;
        }
        JSExpression left = ((JSAssignmentExpression)expression).getLOperand();
        if (left instanceof JSDefinitionExpression) {
            left = ((JSDefinitionExpression)left).getExpression();
        }
        JSExpression right = ((JSAssignmentExpression)expression).getROperand();
        if (!(left instanceof JSReferenceExpression) || !(right instanceof JSReferenceExpression) || ((JSReferenceExpression)right).getQualifier() != null) {
            return false;
        }
        JSExpression qualifier = ((JSReferenceExpression)left).getQualifier();
        if (!(qualifier instanceof JSThisExpression)) {
            return false;
        }
        String leftName = ((JSReferenceExpression)left).getReferenceName();
        String rightName = ((JSReferenceExpression)right).getReferenceName();
        return Objects.equals(leftName, fieldName) && Objects.equals(rightName, parameterName);
    }

    @Nullable
    private static Pair<JSParameter, JSStatement> getParameterForField(TypeScriptField field, boolean completeCheck) {
        JSClass jsClass = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)field, JSClass.class);
        if (jsClass == null) {
            return null;
        }
        JSFunction constructor = jsClass.getConstructor();
        if (constructor == null) {
            return null;
        }
        final String fieldName = field.getName();
        if (fieldName == null) {
            return null;
        }
        JSSourceElement[] body = constructor.getBody();
        if (body.length != 1 || !(body[0] instanceof JSBlockStatement)) {
            return null;
        }
        JSStatement[] statements = ((JSBlockStatement)body[0]).getStatements();
        JSParameter candidate = null;
        JSStatement candidateAssignment = null;
        for (JSParameterListElement parameter : constructor.getParameters()) {
            JSAttributeList list;
            if (!(parameter instanceof JSParameter) || (list = ((JSParameter)parameter).getAttributeList()) != null && (list.hasModifier(JSAttributeList.ModifierType.READONLY) || list.getExplicitAccessType() != null) || !Objects.equals(fieldName, parameter.getName())) continue;
            candidate = (JSParameter)parameter;
            break;
        }
        if (candidate == null) {
            return null;
        }
        int matchIndex = -1;
        final Ref lastUsage = Ref.create();
        for (int i = 0; i < statements.length; ++i) {
            JSStatement statement = statements[i];
            if (completeCheck) {
                final int finalI = i;
                statement.accept((PsiElementVisitor)new JSRecursiveWalkingElementVisitor(){

                    public void visitJSReferenceExpression(JSReferenceExpression node) {
                        if (node.getQualifier() instanceof JSThisExpression && Objects.equals(fieldName, node.getReferenceName())) {
                            lastUsage.set((Object)finalI);
                        }
                        super.visitJSReferenceExpression(node);
                    }
                });
            }
            if (!TypeScriptFieldToParameterPropertyIntention.isFieldToParameterValueAssignment(statement, fieldName, fieldName)) continue;
            candidateAssignment = statement;
            matchIndex = i;
            break;
        }
        if (matchIndex == -1 || !lastUsage.isNull() && matchIndex > (Integer)lastUsage.get()) {
            return null;
        }
        return Pair.create((Object)candidate, candidateAssignment);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"ts.convert.field.to.parameter.property", (Object[])new Object[0]);
        if (string == null) {
            TypeScriptFieldToParameterPropertyIntention.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = JSBundle.message((String)"ts.convert.field.to.parameter.property", (Object[])new Object[0]);
        if (string == null) {
            TypeScriptFieldToParameterPropertyIntention.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/TypeScriptFieldToParameterPropertyIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/TypeScriptFieldToParameterPropertyIntention";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getField";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isFieldToParameterValueAssignment";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

