/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationProcessor;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.safeDelete.NonCodeUsageSearchInfo;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessorDelegate;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteReferenceSimpleDeleteUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaScriptSafeDeleteProcessor
implements SafeDeleteProcessorDelegate {
    private static final TokenSet parameterDelimiterSet = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.COMMA});

    public boolean handlesElement(PsiElement element) {
        return element instanceof JSParameter;
    }

    public NonCodeUsageSearchInfo findUsages(final @NotNull PsiElement element, @NotNull PsiElement[] allElementsToDelete, final @NotNull List<UsageInfo> usages) {
        if (element == null) {
            JavaScriptSafeDeleteProcessor.$$$reportNull$$$0(0);
        }
        if (allElementsToDelete == null) {
            JavaScriptSafeDeleteProcessor.$$$reportNull$$$0(1);
        }
        if (usages == null) {
            JavaScriptSafeDeleteProcessor.$$$reportNull$$$0(2);
        }
        if (!(element instanceof JSParameter)) {
            return null;
        }
        JSFunction fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)element, JSFunction.class);
        if (fun == null) {
            return null;
        }
        JSParameterListElement parameterElement = JavaScriptSafeDeleteProcessor.destructuringParameterIfPossibleToDelete((JSParameter)element);
        final int parameterIndex = ArrayUtil.find((Object[])fun.getParameters(), (Object)parameterElement);
        if (parameterIndex == -1) {
            return null;
        }
        String paramName = ((JSParameter)element).getName();
        PsiComment comment = JSDocumentationUtils.findFunctionComment(fun);
        if (comment instanceof JSDocComment) {
            JSDocTag[] tags;
            for (JSDocTag tag : tags = ((JSDocComment)comment).getTags()) {
                JSDocumentationUtils.DocTag docTag = JSDocumentationUtils.getDocTag(tag.getText());
                if (docTag == null || docTag.type != JSDocumentationProcessor.MetaDocType.PARAMETER || docTag.matchName == null || !docTag.matchName.equals(paramName) && !docTag.matchName.startsWith(paramName + ".")) continue;
                usages.add((UsageInfo)new SafeDeleteReferenceSimpleDeleteUsageInfo((PsiElement)tag, element, true));
            }
        }
        ReferencesSearch.search((PsiElement)fun).forEach((Processor)new Processor<PsiReference>(){

            public boolean process(PsiReference psiReference) {
                PsiElement parent;
                if (psiReference instanceof JSReferenceExpression && (parent = ((JSReferenceExpression)psiReference).getParent()) instanceof JSCallExpression) {
                    JSExpression[] args;
                    final JSArgumentList argumentList = ((JSCallExpression)parent).getArgumentList();
                    JSExpression[] jSExpressionArray = args = argumentList != null ? argumentList.getArguments() : JSExpression.EMPTY_ARRAY;
                    if (args.length > parameterIndex) {
                        usages.add(new SafeDeleteReferenceSimpleDeleteUsageInfo((PsiElement)args[parameterIndex], element, true){

                            public void deleteElement() throws IncorrectOperationException {
                                PsiElement comma = null;
                                if (this.isSafeDelete()) {
                                    ASTNode commaNode = null;
                                    ASTNode argumentListNode = argumentList.getNode();
                                    if (parameterIndex < args.length - 1) {
                                        commaNode = argumentListNode.findChildByType(parameterDelimiterSet, args[parameterIndex].getNode());
                                    } else {
                                        ASTNode[] astNodes = argumentListNode.getChildren(parameterDelimiterSet);
                                        if (astNodes.length > 0) {
                                            commaNode = astNodes[astNodes.length - 1];
                                        }
                                    }
                                    if (commaNode != null) {
                                        comma = commaNode.getPsi();
                                    }
                                }
                                super.deleteElement();
                                if (comma != null && comma.isValid()) {
                                    comma.delete();
                                }
                            }
                        });
                    }
                }
                return true;
            }
        });
        return new NonCodeUsageSearchInfo(Conditions.alwaysFalse(), element);
    }

    @NotNull
    private static JSParameterListElement destructuringParameterIfPossibleToDelete(@NotNull JSParameter parameter) {
        if (parameter == null) {
            JavaScriptSafeDeleteProcessor.$$$reportNull$$$0(3);
        }
        JSParameter current = parameter;
        while (JSDestructuringUtil.isDestructuring(current.getParent())) {
            if (current instanceof JSDestructuringArray && !JSDestructuringUtil.hasSingleElement((JSDestructuringArray)current)) {
                JSParameter jSParameter = parameter;
                if (jSParameter == null) {
                    JavaScriptSafeDeleteProcessor.$$$reportNull$$$0(4);
                }
                return jSParameter;
            }
            if (current instanceof JSDestructuringObject && !JSDestructuringUtil.hasSingleProperty((JSDestructuringObject)current)) {
                JSParameter jSParameter = parameter;
                if (jSParameter == null) {
                    JavaScriptSafeDeleteProcessor.$$$reportNull$$$0(5);
                }
                return jSParameter;
            }
            current = current.getParent();
        }
        Object object = current instanceof JSDestructuringParameter ? (JSDestructuringParameter)current : parameter;
        if (object == null) {
            JavaScriptSafeDeleteProcessor.$$$reportNull$$$0(6);
        }
        return object;
    }

    public Collection<? extends PsiElement> getElementsToSearch(@NotNull PsiElement element, @NotNull Collection<PsiElement> allElementsToDelete) {
        if (element == null) {
            JavaScriptSafeDeleteProcessor.$$$reportNull$$$0(7);
        }
        if (allElementsToDelete == null) {
            JavaScriptSafeDeleteProcessor.$$$reportNull$$$0(8);
        }
        return Collections.singletonList(element);
    }

    public Collection<PsiElement> getAdditionalElementsToDelete(@NotNull PsiElement element, @NotNull Collection<PsiElement> allElementsToDelete, boolean askUser) {
        if (element == null) {
            JavaScriptSafeDeleteProcessor.$$$reportNull$$$0(9);
        }
        if (allElementsToDelete == null) {
            JavaScriptSafeDeleteProcessor.$$$reportNull$$$0(10);
        }
        return null;
    }

    public Collection<String> findConflicts(@NotNull PsiElement element, @NotNull PsiElement[] allElementsToDelete) {
        if (element == null) {
            JavaScriptSafeDeleteProcessor.$$$reportNull$$$0(11);
        }
        if (allElementsToDelete == null) {
            JavaScriptSafeDeleteProcessor.$$$reportNull$$$0(12);
        }
        return null;
    }

    public UsageInfo[] preprocessUsages(Project project, UsageInfo[] usages) {
        return usages;
    }

    public void prepareForDeletion(PsiElement element) throws IncorrectOperationException {
    }

    public boolean isToSearchInComments(PsiElement element) {
        return RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_COMMENTS;
    }

    public boolean isToSearchForTextOccurrences(PsiElement element) {
        return RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_NON_JAVA;
    }

    public void setToSearchInComments(PsiElement element, boolean enabled) {
        RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_COMMENTS = enabled;
    }

    public void setToSearchForTextOccurrences(PsiElement element, boolean enabled) {
        RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_NON_JAVA = enabled;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allElementsToDelete";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/JavaScriptSafeDeleteProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/JavaScriptSafeDeleteProcessor";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "destructuringParameterIfPossibleToDelete";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "destructuringParameterIfPossibleToDelete";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getElementsToSearch";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalElementsToDelete";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findConflicts";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

