/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.deployment.ui;

import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.cli.DockerRunCliBuilder;
import com.intellij.docker.deployment.ui.DockerBuildSettingsUI;
import com.intellij.docker.deployment.ui.DockerContainerSettingsUI;
import com.intellij.docker.deployment.ui.DockerDeploymentEditorBase;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class DockerDeploymentEditor
extends DockerDeploymentEditorBase {
    private final boolean myImageNotFileSource;
    private JPanel myMainPanel;
    private JTextField myImageIdTextField;
    private JBLabel myImageIdLabel;
    private JPanel myBuildImageOptionsPanel;
    private JPanel myContainerOptionsPanel;
    private JTextField myContainerNameTextField;
    private JBCheckBox myShouldRunContainerCheckbox;
    private ExpandableTextField myCommandPreviewField;
    private DockerContainerSettingsUI myContainerSettingsUI;
    private DockerBuildSettingsUI myBuildSettingsUI;

    public DockerDeploymentEditor(@NotNull Project project, boolean imageNotFileSource) {
        if (project == null) {
            DockerDeploymentEditor.$$$reportNull$$$0(0);
        }
        super(project);
        this.myImageNotFileSource = imageNotFileSource;
        this.$$$setupUI$$$();
        if (this.myImageNotFileSource) {
            this.myBuildImageOptionsPanel.setVisible(false);
            this.myShouldRunContainerCheckbox.setVisible(false);
            this.myImageIdTextField.setVisible(true);
            this.myImageIdLabel.setVisible(true);
        } else {
            this.myBuildImageOptionsPanel.setVisible(true);
            this.myBuildSettingsUI.setContextFolderListener(this.myContainerSettingsUI::setContextFolder);
            this.myShouldRunContainerCheckbox.setVisible(true);
            this.myImageIdTextField.setVisible(false);
            this.myImageIdLabel.setVisible(false);
        }
        this.myCommandPreviewField.setForeground(UIUtil.getInactiveTextColor());
    }

    @Override
    protected void resetEditorFrom(@NotNull DockerDeploymentConfiguration configuration) {
        if (configuration == null) {
            DockerDeploymentEditor.$$$reportNull$$$0(1);
        }
        super.resetEditorFrom(configuration);
        if (this.myImageNotFileSource) {
            this.myImageIdTextField.setText(configuration.getImageTag());
        } else {
            this.myBuildSettingsUI.resetEditorFrom(configuration);
            this.myShouldRunContainerCheckbox.setSelected(!configuration.isBuildOnly());
        }
        this.myContainerNameTextField.setText(configuration.getContainerName());
        this.myContainerSettingsUI.resetEditorFrom(configuration);
    }

    @Override
    protected void applyEditorTo(@NotNull DockerDeploymentConfiguration configuration) throws ConfigurationException {
        if (configuration == null) {
            DockerDeploymentEditor.$$$reportNull$$$0(2);
        }
        this.updatePreview();
        configuration.setContainerName(this.myContainerNameTextField.getText());
        if (this.myImageNotFileSource) {
            configuration.setImageTag(this.myImageIdTextField.getText());
            configuration.setBuildArgs(null);
        } else {
            this.myBuildSettingsUI.applyEditorTo(configuration);
            configuration.setBuildOnly(!this.myShouldRunContainerCheckbox.isSelected());
        }
        this.myContainerSettingsUI.applyEditorTo(configuration);
        super.applyEditorTo(configuration);
    }

    @NotNull
    private String getNotEmptyImageTag() {
        String imageTag = this.myImageNotFileSource ? this.myImageIdTextField.getText() : this.myBuildSettingsUI.getNotEmptyImageTag();
        String string = StringUtil.isEmptyOrSpaces((String)imageTag) ? "<image_tag>" : imageTag;
        if (string == null) {
            DockerDeploymentEditor.$$$reportNull$$$0(3);
        }
        return string;
    }

    private void updatePreview() {
        LinkedList<String> allLines = new LinkedList<String>();
        String imageTag = this.getNotEmptyImageTag();
        if (!this.myImageNotFileSource) {
            List<String> buildLines = this.myBuildSettingsUI.prepareBuildCliBuilder().buildPreviewLines();
            allLines.addAll(buildLines);
        }
        if (this.myImageNotFileSource || this.myShouldRunContainerCheckbox.isSelected()) {
            DockerRunCliBuilder runBuilder = this.myContainerSettingsUI.prepareRunCliBuilder(imageTag);
            runBuilder.setContainerTag(this.myContainerNameTextField.getText());
            allLines.addAll(runBuilder.buildPreviewLines(!allLines.isEmpty()));
        }
        this.getCommandPreviewField().setSplittedText(allLines);
    }

    private void createUIComponents() {
        this.myContainerSettingsUI = new DockerContainerSettingsUI(this.getProject());
        this.myContainerOptionsPanel = this.myContainerSettingsUI.getMainPanel();
        this.myBuildSettingsUI = new DockerBuildSettingsUI(this.getProject());
        this.myBuildImageOptionsPanel = this.myBuildSettingsUI.getMainPanel();
        this.myCommandPreviewField = new DockerDeploymentEditorBase.CommandPreviewField();
    }

    private DockerDeploymentEditorBase.CommandPreviewField getCommandPreviewField() {
        return (DockerDeploymentEditorBase.CommandPreviewField)this.myCommandPreviewField;
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            DockerDeploymentEditor.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/deployment/ui/DockerDeploymentEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/deployment/ui/DockerDeploymentEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotEmptyImageTag";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JTextField jTextField;
        JTextField jTextField2;
        JBLabel jBLabel;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myImageIdLabel = jBLabel = new JBLabel();
        jBLabel.setText("Image ID:");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myImageIdTextField = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myContainerNameTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Container name:");
        jPanel.add((Component)jBLabel2, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myShouldRunContainerCheckbox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Run built image");
        jPanel.add((Component)jBCheckBox, new GridConstraints(2, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = this.myContainerOptionsPanel;
        jPanel.add((Component)jPanel2, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setEnabled(false);
        jBLabel3.setText("Command preview:");
        jPanel.add((Component)jBLabel3, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ExpandableTextField expandableTextField = this.myCommandPreviewField;
        expandableTextField.setEditable(false);
        expandableTextField.setEnabled(true);
        jPanel.add((Component)expandableTextField, new GridConstraints(5, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        JPanel jPanel3 = this.myBuildImageOptionsPanel;
        jPanel.add((Component)jPanel3, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        jBLabel.setLabelFor(jTextField2);
        jBLabel2.setLabelFor(jTextField);
        jBLabel3.setLabelFor((Component)expandableTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

