/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.TextMateSyntaxTable;
import org.jetbrains.plugins.textmate.plist.Plist;
import org.jetbrains.plugins.textmate.regex.RegexFacade;

class SyntaxProxyDescriptor
implements SyntaxNodeDescriptor {
    private final String proxyName;
    private final SyntaxNodeDescriptor myParentNode;
    private final SyntaxNodeDescriptor myRootNode;
    private final TextMateSyntaxTable mySyntaxTable;

    SyntaxProxyDescriptor(@NotNull Plist plist, @NotNull SyntaxNodeDescriptor parentNode, @NotNull SyntaxNodeDescriptor rootNode, @NotNull TextMateSyntaxTable syntaxTable) {
        if (plist == null) {
            SyntaxProxyDescriptor.$$$reportNull$$$0(0);
        }
        if (parentNode == null) {
            SyntaxProxyDescriptor.$$$reportNull$$$0(1);
        }
        if (rootNode == null) {
            SyntaxProxyDescriptor.$$$reportNull$$$0(2);
        }
        if (syntaxTable == null) {
            SyntaxProxyDescriptor.$$$reportNull$$$0(3);
        }
        this.myRootNode = rootNode;
        this.mySyntaxTable = syntaxTable;
        this.proxyName = plist.getPlistValue("include", "").getString();
        this.myParentNode = parentNode;
    }

    @Override
    @Nullable
    public String getStringAttribute(String key) {
        return this.getTargetNode().getStringAttribute(key);
    }

    @Override
    @Nullable
    public Plist getPlistAttribute(String key) {
        return this.getTargetNode().getPlistAttribute(key);
    }

    @Override
    @Nullable
    public RegexFacade getRegexAttribute(String key) {
        return this.getTargetNode().getRegexAttribute(key);
    }

    @Override
    @NotNull
    public List<SyntaxNodeDescriptor> getChildren() {
        List<SyntaxNodeDescriptor> list = this.getTargetNode().getChildren();
        if (list == null) {
            SyntaxProxyDescriptor.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    @NotNull
    public SyntaxNodeDescriptor findInRepository(String key) {
        SyntaxNodeDescriptor syntaxNodeDescriptor = this.getTargetNode().findInRepository(key);
        if (syntaxNodeDescriptor == null) {
            SyntaxProxyDescriptor.$$$reportNull$$$0(5);
        }
        return syntaxNodeDescriptor;
    }

    @Override
    @NotNull
    public String getScopeName() {
        String string = this.getTargetNode().getScopeName();
        if (string == null) {
            SyntaxProxyDescriptor.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @Nullable
    public SyntaxNodeDescriptor getParentNode() {
        return this.myParentNode;
    }

    @NotNull
    private SyntaxNodeDescriptor getTargetNode() {
        if (this.proxyName.startsWith("#")) {
            SyntaxNodeDescriptor syntaxNodeDescriptor = this.myParentNode.findInRepository(this.proxyName.substring(1));
            if (syntaxNodeDescriptor == null) {
                SyntaxProxyDescriptor.$$$reportNull$$$0(7);
            }
            return syntaxNodeDescriptor;
        }
        if ("$self".equalsIgnoreCase(this.proxyName)) {
            SyntaxNodeDescriptor syntaxNodeDescriptor = this.myRootNode;
            if (syntaxNodeDescriptor == null) {
                SyntaxProxyDescriptor.$$$reportNull$$$0(8);
            }
            return syntaxNodeDescriptor;
        }
        if ("$base".equalsIgnoreCase(this.proxyName)) {
            SyntaxNodeDescriptor syntaxNodeDescriptor = this.myRootNode;
            if (syntaxNodeDescriptor == null) {
                SyntaxProxyDescriptor.$$$reportNull$$$0(9);
            }
            return syntaxNodeDescriptor;
        }
        SyntaxNodeDescriptor syntaxNodeDescriptor = this.mySyntaxTable.getSyntax(this.proxyName);
        if (syntaxNodeDescriptor == null) {
            SyntaxProxyDescriptor.$$$reportNull$$$0(10);
        }
        return syntaxNodeDescriptor;
    }

    public String toString() {
        return "Proxy rule for '" + this.proxyName + "'";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plist";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootNode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syntaxTable";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/language/syntax/SyntaxProxyDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/language/syntax/SyntaxProxyDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findInRepository";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeName";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

