/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.login;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.perforce.ExecResult;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.PerforceTimeoutException;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.P4ParametersConnection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManagerI;
import org.jetbrains.idea.perforce.perforce.login.LoginPerformer;
import org.jetbrains.idea.perforce.perforce.login.LoginState;

public class LoginPerformerImpl
implements LoginPerformer {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.perforce.perforce.login.LoginPerformerImpl");
    @NonNls
    private static final String LOGGED_IN_MESSAGE = "logged in";
    @NonNls
    private static final String CONNECT_FAILED = "Connect to server failed; check $P4PORT.";
    @NonNls
    private static final String CONNECTION_REFUSED = "Connection refused";
    private final P4Connection myConnection;
    private final PerforceSettings mySettings;
    private static final Pattern ourTicketExpiresPattern = Pattern.compile("User * ticket expires in (d*) hours (d+) minutes.");
    private final PerforceConnectionManagerI myConnectionManager;
    private String myRecentCredentials;

    public LoginPerformerImpl(Project project, P4Connection connection, PerforceConnectionManagerI connectionManagerI) {
        this.mySettings = PerforceSettings.getSettings(project);
        this.myConnectionManager = connectionManagerI;
        this.myConnection = connection;
    }

    @Override
    public LoginState getLoginState() {
        try {
            ExecResult result = this.myConnection.runP4CommandLine(this.mySettings, new String[]{"login", "-s"}, null);
            if (result.getExitCode() != 0) {
                Throwable exception;
                String stdErr = result.getStderr();
                if (stdErr.contains(CONNECT_FAILED) || stdErr.contains(CONNECTION_REFUSED) || stdErr.contains("No route to host")) {
                    return new LoginState(false, -1L, stdErr);
                }
                if (StringUtil.isEmpty((String)stdErr) && (exception = result.getException()) != null) {
                    return new LoginState(false, -1L, exception.getMessage());
                }
                return new LoginState(false, -1L, null);
            }
            String stdOut = result.getStdout();
            return LoginPerformerImpl.tryParseTicketExpiresTime(stdOut);
        }
        catch (VcsException e) {
            if (e.getCause() instanceof PerforceTimeoutException) {
                return new LoginState(false, -1L, e.getMessage());
            }
            return new LoginState(false, -1L, null);
        }
    }

    private static LoginState tryParseTicketExpiresTime(String stdOut) {
        Matcher matcher = ourTicketExpiresPattern.matcher(stdOut);
        if (matcher.matches()) {
            String hours = matcher.group(2);
            String minutes = matcher.group(3);
            if (hours != null && minutes != null) {
                try {
                    long hoursInt = Integer.parseInt(hours);
                    int minutesInt = Integer.parseInt(minutes);
                    return new LoginState(true, (hoursInt * 60L + (long)minutesInt) * 60L * 1000L, null);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return new LoginState(true, -1L, null);
    }

    @Override
    public boolean isCredentialsChanged() {
        if (!this.mySettings.useP4CONFIG) {
            return true;
        }
        if (!Comparing.equal((String)this.mySettings.getPasswd(), (String)this.myRecentCredentials)) {
            this.myRecentCredentials = this.mySettings.getPasswd();
            return true;
        }
        return false;
    }

    @Override
    public LoginState login(@NotNull String password) {
        if (password == null) {
            LoginPerformerImpl.$$$reportNull$$$0(0);
        }
        try {
            StringBuffer data = new StringBuffer();
            data.append(password);
            ExecResult loginResult = this.myConnection.runP4CommandLine(this.mySettings, new String[]{"login"}, data);
            String stdOut = loginResult.getStdout();
            String stdErr = loginResult.getStderr();
            if (stdErr.length() > 0 || !stdOut.contains(LOGGED_IN_MESSAGE)) {
                String message;
                String string = message = !stdOut.isEmpty() && !stdErr.isEmpty() ? stdOut + "\n" + stdErr : stdOut + stdErr;
                if (StringUtil.isEmptyOrSpaces((String)message) && loginResult.getException() != null) {
                    message = loginResult.getException().getMessage();
                }
                LOG.debug("Login failed, message: " + message);
                return new LoginState(false, -1L, message);
            }
            this.myConnectionManager.updateConnections();
            return new LoginState(true, -1L, null);
        }
        catch (VcsException e) {
            if (e.getCause() instanceof PerforceTimeoutException) {
                return new LoginState(false, -1L, e.getMessage());
            }
            return new LoginState(false, -1L, null);
        }
    }

    @Override
    public LoginState loginWithStoredPassword() {
        String password;
        String string = password = this.myConnection instanceof P4ParametersConnection ? ((P4ParametersConnection)this.myConnection).getParameters().getPassword() : this.mySettings.getPasswd();
        if (StringUtil.isNotEmpty((String)password)) {
            return this.login(password);
        }
        return new LoginState(false, -1L, null);
    }

    @Override
    public P4Connection getMyConnection() {
        return this.myConnection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "password", "org/jetbrains/idea/perforce/perforce/login/LoginPerformerImpl", "login"));
    }
}

