/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public abstract class SplitAction
extends AnAction
implements DumbAware {
    private final int myOrientation;
    private final boolean myCloseSource;

    protected SplitAction(int orientation) {
        this(orientation, false);
    }

    protected SplitAction(int orientation, boolean closeSource) {
        this.myOrientation = orientation;
        this.myCloseSource = closeSource;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            SplitAction.$$$reportNull$$$0(0);
        }
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        FileEditorManagerEx fileEditorManager = FileEditorManagerEx.getInstanceEx(project);
        EditorWindow window = (EditorWindow)event.getData(EditorWindow.DATA_KEY);
        VirtualFile file2 = (VirtualFile)event.getData(CommonDataKeys.VIRTUAL_FILE);
        fileEditorManager.createSplitter(this.myOrientation, window);
        if (this.myCloseSource && window != null && file2 != null) {
            window.closeFile(file2, false, false);
        }
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            SplitAction.$$$reportNull$$$0(1);
        }
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        EditorWindow window = (EditorWindow)event.getData(EditorWindow.DATA_KEY);
        int minimum = this.myCloseSource ? 2 : 1;
        boolean enabled = project != null && window != null && window.getTabCount() >= minimum && !window.getOwner().isPreview();
        event.getPresentation().setEnabledAndVisible(enabled);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "event";
        objectArray2[1] = "com/intellij/ide/actions/SplitAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

