/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.ex;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.SystemInfo;
import java.awt.datatransfer.DataFlavor;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClipboardUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.Clipboard");
    private static final String USE_LEGACY_MERGE_SORT_PROPERTY_NAME = "java.util.Arrays.useLegacyMergeSort";

    public static <E> E handleClipboardSafely(@NotNull Supplier<? extends E> supplier, @NotNull Supplier<? extends E> onFail) {
        if (supplier == null) {
            ClipboardUtil.$$$reportNull$$$0(0);
        }
        if (onFail == null) {
            ClipboardUtil.$$$reportNull$$$0(1);
        }
        try {
            return ClipboardUtil.useLegacyMergeSort(supplier);
        }
        catch (IllegalStateException e) {
            if (SystemInfo.isWindows) {
                LOG.debug("Clipboard is busy");
            } else {
                LOG.warn((Throwable)e);
            }
        }
        catch (NullPointerException e) {
            LOG.warn("Java bug #6322854", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Java bug #7173464", (Throwable)e);
        }
        return onFail.get();
    }

    private static <T> T useLegacyMergeSort(Supplier<T> supplier) {
        String originalValue = System.getProperty(USE_LEGACY_MERGE_SORT_PROPERTY_NAME);
        System.setProperty(USE_LEGACY_MERGE_SORT_PROPERTY_NAME, "true");
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            if (originalValue != null) {
                System.setProperty(USE_LEGACY_MERGE_SORT_PROPERTY_NAME, originalValue);
            }
        }
    }

    @Nullable
    public static String getTextInClipboard() {
        return (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "supplier";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "onFail";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/application/ex/ClipboardUtil";
        objectArray[2] = "handleClipboardSafely";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

