/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.openapi.updateSettings.UpdateStrategyCustomization;
import com.intellij.openapi.updateSettings.impl.BuildInfo;
import com.intellij.openapi.updateSettings.impl.ChannelStatus;
import com.intellij.openapi.updateSettings.impl.CheckForUpdateResult;
import com.intellij.openapi.updateSettings.impl.PatchInfo;
import com.intellij.openapi.updateSettings.impl.Product;
import com.intellij.openapi.updateSettings.impl.UpdateChain;
import com.intellij.openapi.updateSettings.impl.UpdateChannel;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.updateSettings.impl.UpdateStrategy;
import com.intellij.openapi.updateSettings.impl.UpdateStrategyKt;
import com.intellij.openapi.updateSettings.impl.UpdatesInfo;
import com.intellij.openapi.updateSettings.impl.UserUpdateSettings;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.BuildRange;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.graph.GraphAlgorithms;
import com.intellij.util.graph.InboundSemiGraph;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001$B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B'\b\u0017\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB/\b\u0017\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0011J\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J\"\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/openapi/updateSettings/impl/UpdateStrategy;", "", "currentBuild", "Lcom/intellij/openapi/util/BuildNumber;", "updates", "Lcom/intellij/openapi/updateSettings/impl/UpdatesInfo;", "(Lcom/intellij/openapi/util/BuildNumber;Lcom/intellij/openapi/updateSettings/impl/UpdatesInfo;)V", "majorVersion", "", "updatesInfo", "updateSettings", "Lcom/intellij/openapi/updateSettings/impl/UserUpdateSettings;", "(ILcom/intellij/openapi/util/BuildNumber;Lcom/intellij/openapi/updateSettings/impl/UpdatesInfo;Lcom/intellij/openapi/updateSettings/impl/UserUpdateSettings;)V", "customization", "Lcom/intellij/openapi/updateSettings/UpdateStrategyCustomization;", "(ILcom/intellij/openapi/util/BuildNumber;Lcom/intellij/openapi/updateSettings/impl/UpdatesInfo;Lcom/intellij/openapi/updateSettings/impl/UserUpdateSettings;Lcom/intellij/openapi/updateSettings/UpdateStrategyCustomization;)V", "settings", "(Lcom/intellij/openapi/util/BuildNumber;Lcom/intellij/openapi/updateSettings/impl/UpdatesInfo;Lcom/intellij/openapi/updateSettings/impl/UserUpdateSettings;)V", "checkForUpdates", "Lcom/intellij/openapi/updateSettings/impl/CheckForUpdateResult;", "compareBuilds", "n1", "n2", "isApplicable", "", "candidate", "Lcom/intellij/openapi/updateSettings/impl/BuildInfo;", "ignoredBuilds", "", "", "patches", "Lcom/intellij/openapi/updateSettings/impl/UpdateChain;", "newBuild", "product", "Lcom/intellij/openapi/updateSettings/impl/Product;", "from", "State", "intellij.platform.ide.impl"})
public final class UpdateStrategy {
    private final BuildNumber currentBuild;
    private final UpdatesInfo updates;
    private final UserUpdateSettings settings;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CheckForUpdateResult checkForUpdates() {
        Pair result2;
        void $receiver$iv;
        String string = this.currentBuild.getProductCode();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"currentBuild.productCode");
        Product product = this.updates.get(string);
        if (product == null || product.getChannels().isEmpty()) {
            return new CheckForUpdateResult(State.NOTHING_LOADED, null);
        }
        ChannelStatus channelStatus = this.settings.getSelectedChannelStatus();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)channelStatus), (String)"settings.selectedChannelStatus");
        ChannelStatus selectedChannel = channelStatus;
        List<String> list2 = this.settings.getIgnoredBuildNumbers();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"settings.ignoredBuildNumbers");
        Set ignoredBuilds = CollectionsKt.toSet((Iterable)list2);
        Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)product.getChannels()), (Function1)((Function1)new Function1<UpdateChannel, Boolean>(selectedChannel){
            final /* synthetic */ ChannelStatus $selectedChannel;

            public final boolean invoke(@NotNull UpdateChannel ch) {
                Intrinsics.checkParameterIsNotNull((Object)ch, (String)"ch");
                return ch.getStatus().compareTo((Enum)this.$selectedChannel) >= 0;
            }
            {
                this.$selectedChannel = channelStatus;
                super(1);
            }
        }));
        void var6_5 = $receiver$iv;
        Comparator comparator2 = new Comparator<T>(){

            public final int compare(T a, T b) {
                UpdateChannel ch = (UpdateChannel)a;
                Comparable comparable = (Comparable)((Object)ch.getStatus());
                ch = (UpdateChannel)b;
                Comparable comparable2 = comparable;
                ChannelStatus channelStatus = ch.getStatus();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)channelStatus)));
            }
        };
        Pair pair = result2 = (Pair)SequencesKt.maxWith((Sequence)SequencesKt.filter((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.sortedWith((Sequence)var6_5, (Comparator)comparator2), (Function1)checkForUpdates.result.3.INSTANCE), (Function1)((Function1)new Function1<Pair<? extends BuildInfo, ? extends UpdateChannel>, Boolean>(this, ignoredBuilds){
            final /* synthetic */ UpdateStrategy this$0;
            final /* synthetic */ Set $ignoredBuilds;

            public final boolean invoke(@NotNull Pair<BuildInfo, UpdateChannel> p) {
                Intrinsics.checkParameterIsNotNull(p, (String)"p");
                return UpdateStrategy.access$isApplicable(this.this$0, (BuildInfo)p.getFirst(), this.$ignoredBuilds);
            }
            {
                this.this$0 = updateStrategy;
                this.$ignoredBuilds = set;
                super(1);
            }
        })), (Comparator)new Comparator<Pair<? extends BuildInfo, ? extends UpdateChannel>>(this){
            final /* synthetic */ UpdateStrategy this$0;

            public final int compare(Pair<BuildInfo, UpdateChannel> p1, Pair<BuildInfo, UpdateChannel> p2) {
                return UpdateStrategy.access$compareBuilds(this.this$0, ((BuildInfo)p1.getFirst()).getNumber(), ((BuildInfo)p2.getFirst()).getNumber());
            }
            {
                this.this$0 = updateStrategy;
            }
        });
        BuildInfo newBuild = pair != null ? (BuildInfo)pair.getFirst() : null;
        Pair pair2 = result2;
        UpdateChannel updatedChannel = pair2 != null ? (UpdateChannel)pair2.getSecond() : null;
        UpdateChain patches2 = newBuild != null ? this.patches(newBuild, product, this.currentBuild) : null;
        return new CheckForUpdateResult(newBuild, updatedChannel, patches2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isApplicable(BuildInfo candidate, Set<String> ignoredBuilds) {
        if (candidate.getNumber().compareTo(this.currentBuild) <= 0) return false;
        if (ignoredBuilds.contains(candidate.getNumber().asStringWithoutProductCode())) return false;
        BuildRange buildRange = candidate.getTarget();
        if (buildRange == null) return true;
        boolean bl = buildRange.inRange(this.currentBuild);
        if (!bl) return false;
        return true;
    }

    private final int compareBuilds(BuildNumber n1, BuildNumber n2) {
        UpdateStrategyCustomization customization = UpdateStrategyCustomization.getInstance();
        int preferSameMajorVersion = Intrinsics.compare((int)(customization.haveSameMajorVersion(this.currentBuild, n1) ? 1 : 0), (int)(customization.haveSameMajorVersion(this.currentBuild, n2) ? 1 : 0));
        return preferSameMajorVersion != 0 ? preferSameMajorVersion : n1.compareTo(n2);
    }

    /*
     * WARNING - void declaration
     */
    private final UpdateChain patches(BuildInfo newBuild, Product product, BuildNumber from) {
        Object v0;
        block8: {
            Iterable iterable;
            Iterable iterable2 = iterable = (Iterable)newBuild.getPatches();
            for (Object object : iterable2) {
                PatchInfo it = (PatchInfo)object;
                if (!(it.isAvailable() && it.getFromBuild().compareTo(from) == 0)) continue;
                v0 = object;
                break block8;
            }
            v0 = null;
        }
        PatchInfo single = v0;
        if (single != null) {
            return new UpdateChain(CollectionsKt.listOf((Object[])new BuildNumber[]{from, newBuild.getNumber()}), single.getSize());
        }
        MultiMap upgrades = new MultiMap();
        Map sizes = new LinkedHashMap();
        Iterable $receiver$iv = product.getChannels();
        for (Object element$iv : $receiver$iv) {
            UpdateChannel channel = (UpdateChannel)element$iv;
            Iterable $receiver$iv2 = channel.getBuilds();
            for (Object element$iv2 : $receiver$iv2) {
                BuildInfo build2 = (BuildInfo)element$iv2;
                Intrinsics.checkExpressionValueIsNotNull((Object)build2.getNumber().withoutProductCode(), (String)"build.number.withoutProductCode()");
                Iterable $receiver$iv3 = build2.getPatches();
                for (Object element$iv3 : $receiver$iv3) {
                    Integer maxSize2;
                    BuildNumber fromBuild;
                    BuildNumber toBuild;
                    PatchInfo patch = (PatchInfo)element$iv3;
                    if (!patch.isAvailable()) continue;
                    Intrinsics.checkExpressionValueIsNotNull((Object)patch.getFromBuild().withoutProductCode(), (String)"patch.fromBuild.withoutProductCode()");
                    upgrades.putValue((Object)toBuild, (Object)fromBuild);
                    if (patch.getSize() == null || (maxSize2 = (Integer)SequencesKt.max((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)UpdateStrategyKt.access$getNUMBER$p(), (CharSequence)patch.getSize(), (int)0, (int)2, null), (Function1)patches.1.1.1.maxSize.1.INSTANCE)))) == null) continue;
                    Map map = sizes;
                    Pair pair = TuplesKt.to((Object)TuplesKt.to((Object)fromBuild, (Object)toBuild), (Object)maxSize2);
                    map.put(pair.getFirst(), pair.getSecond());
                }
            }
        }
        InboundSemiGraph<BuildNumber> graph2 = new InboundSemiGraph<BuildNumber>(upgrades){
            final /* synthetic */ MultiMap $upgrades;

            @NotNull
            public Set<BuildNumber> getNodes() {
                Set set = this.$upgrades.keySet();
                Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"upgrades.keySet()");
                Collection collection = this.$upgrades.values();
                Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"upgrades.values()");
                return SetsKt.plus((Set)set, (Iterable)collection);
            }

            @NotNull
            public Iterator<BuildNumber> getIn(@NotNull BuildNumber n) {
                Intrinsics.checkParameterIsNotNull((Object)n, (String)"n");
                return this.$upgrades.get((Object)n).iterator();
            }
            {
                this.$upgrades = $captured_local_variable$0;
            }
        };
        List path = GraphAlgorithms.getInstance().findShortestPath((InboundSemiGraph)graph2, (Object)from.withoutProductCode(), (Object)newBuild.getNumber().withoutProductCode());
        if (path == null || path.size() <= 2) {
            return null;
        }
        int total = 0;
        int channel = 1;
        int n = path.size();
        while (channel < n) {
            void i;
            Integer size = (Integer)sizes.get(TuplesKt.to(path.get((int)(i - true)), path.get((int)i)));
            if (size == null) {
                total = -1;
                break;
            }
            total += size.intValue();
            ++i;
        }
        return new UpdateChain(path, total > 0 ? String.valueOf(total) : null);
    }

    public UpdateStrategy(@NotNull BuildNumber currentBuild, @NotNull UpdatesInfo updates, @NotNull UserUpdateSettings settings) {
        Intrinsics.checkParameterIsNotNull((Object)currentBuild, (String)"currentBuild");
        Intrinsics.checkParameterIsNotNull((Object)updates, (String)"updates");
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        this.currentBuild = currentBuild;
        this.updates = updates;
        this.settings = settings;
    }

    public UpdateStrategy(@NotNull BuildNumber currentBuild, @NotNull UpdatesInfo updates) {
        Intrinsics.checkParameterIsNotNull((Object)currentBuild, (String)"currentBuild");
        Intrinsics.checkParameterIsNotNull((Object)updates, (String)"updates");
        UpdateSettings updateSettings = UpdateSettings.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)updateSettings, (String)"UpdateSettings.getInstance()");
        this(currentBuild, updates, updateSettings);
    }

    @Deprecated(message="use {@link #UpdateStrategy(BuildNumber, UpdatesInfo, UserUpdateSettings)}")
    public UpdateStrategy(int majorVersion, @NotNull BuildNumber currentBuild, @NotNull UpdatesInfo updatesInfo, @NotNull UserUpdateSettings updateSettings) {
        Intrinsics.checkParameterIsNotNull((Object)currentBuild, (String)"currentBuild");
        Intrinsics.checkParameterIsNotNull((Object)updatesInfo, (String)"updatesInfo");
        Intrinsics.checkParameterIsNotNull((Object)updateSettings, (String)"updateSettings");
        this(currentBuild, updatesInfo, updateSettings);
    }

    @Deprecated(message="use {@link #UpdateStrategy(BuildNumber, UpdatesInfo, UserUpdateSettings)}")
    public UpdateStrategy(int majorVersion, @NotNull BuildNumber currentBuild, @NotNull UpdatesInfo updatesInfo, @NotNull UserUpdateSettings updateSettings, @NotNull UpdateStrategyCustomization customization) {
        Intrinsics.checkParameterIsNotNull((Object)currentBuild, (String)"currentBuild");
        Intrinsics.checkParameterIsNotNull((Object)updatesInfo, (String)"updatesInfo");
        Intrinsics.checkParameterIsNotNull((Object)updateSettings, (String)"updateSettings");
        Intrinsics.checkParameterIsNotNull((Object)customization, (String)"customization");
        this(currentBuild, updatesInfo, updateSettings);
    }

    public static final /* synthetic */ boolean access$isApplicable(UpdateStrategy $this, @NotNull BuildInfo candidate, @NotNull Set ignoredBuilds) {
        return $this.isApplicable(candidate, ignoredBuilds);
    }

    public static final /* synthetic */ int access$compareBuilds(UpdateStrategy $this, @NotNull BuildNumber n1, @NotNull BuildNumber n2) {
        return $this.compareBuilds(n1, n2);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/updateSettings/impl/UpdateStrategy$State;", "", "(Ljava/lang/String;I)V", "LOADED", "CONNECTION_ERROR", "NOTHING_LOADED", "intellij.platform.ide.impl"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State LOADED;
        public static final /* enum */ State CONNECTION_ERROR;
        public static final /* enum */ State NOTHING_LOADED;
        private static final /* synthetic */ State[] $VALUES;

        static {
            State[] stateArray = new State[3];
            State[] stateArray2 = stateArray;
            stateArray[0] = LOADED = new State();
            stateArray[1] = CONNECTION_ERROR = new State();
            stateArray[2] = NOTHING_LOADED = new State();
            $VALUES = stateArray;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }
    }
}

