/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer.ssi;

import io.netty.buffer.ByteBufUtf8Writer;
import java.text.DecimalFormat;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.builtInWebServer.ssi.SsiCommand;
import org.jetbrains.builtInWebServer.ssi.SsiProcessingState;
import org.jetbrains.builtInWebServer.ssi.SsiProcessorKt;

final class SsiFsize
implements SsiCommand {
    private static final int ONE_KILOBYTE = 1024;
    private static final int ONE_MEGABYTE = 0x100000;

    SsiFsize() {
    }

    @Override
    public long process(@NotNull SsiProcessingState state, @NotNull String commandName, @NotNull List<String> paramNames, @NotNull String[] paramValues, @NotNull ByteBufUtf8Writer writer) {
        if (state == null) {
            SsiFsize.$$$reportNull$$$0(0);
        }
        if (commandName == null) {
            SsiFsize.$$$reportNull$$$0(1);
        }
        if (paramNames == null) {
            SsiFsize.$$$reportNull$$$0(2);
        }
        if (paramValues == null) {
            SsiFsize.$$$reportNull$$$0(3);
        }
        if (writer == null) {
            SsiFsize.$$$reportNull$$$0(4);
        }
        long lastModified = 0L;
        String configErrMsg = state.configErrorMessage;
        for (int i = 0; i < paramNames.size(); ++i) {
            String paramName = paramNames.get(i);
            String paramValue = paramValues[i];
            String substitutedValue = state.substituteVariables(paramValue);
            if (paramName.equalsIgnoreCase("file") || paramName.equalsIgnoreCase("virtual")) {
                boolean virtual = paramName.equalsIgnoreCase("virtual");
                lastModified = state.ssiExternalResolver.getFileLastModified(substitutedValue, virtual);
                writer.write(SsiFsize.formatSize(state.ssiExternalResolver.getFileSize(substitutedValue, virtual), state.configSizeFmt));
                continue;
            }
            SsiProcessorKt.getLOG().info("#fsize--Invalid attribute: " + paramName);
            writer.write(configErrMsg);
        }
        return lastModified;
    }

    /*
     * WARNING - void declaration
     */
    private static String formatSize(long size, @NotNull String string) {
        void format;
        if (string == null) {
            SsiFsize.$$$reportNull$$$0(5);
        }
        if (format.equalsIgnoreCase("bytes")) {
            return new DecimalFormat("#,##0").format(size);
        }
        String result2 = size == 0L ? "0k" : (size < 1024L ? "1k" : (size < 0x100000L ? (size + 512L) / 1024L + "k" : (size < 0x6300000L ? new DecimalFormat("0.0M").format((double)size / 1048576.0) : (size + 541696L) / 0x100000L + "M")));
        int charsToAdd = 5 - result2.length();
        if (charsToAdd < 0) {
            throw new IllegalArgumentException("Num chars can't be negative");
        }
        if (charsToAdd == 0) {
            return result2;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < charsToAdd; ++i) {
            buf.append(' ');
        }
        return buf.append(result2).toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramNames";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramValues";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/builtInWebServer/ssi/SsiFsize";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "formatSize";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

