/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.psi.impl;

import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.intellij.lang.xpath.xslt.impl.XsltIncludeIndex;
import org.jetbrains.annotations.Nullable;

public class ResolveUtil {
    private final Set<PsiElement> myHistory = ContainerUtil.newIdentityTroveSet();

    private ResolveUtil() {
    }

    @Nullable
    public static Collection<XmlFile> getDependencies(XmlFile element) {
        CommonProcessors.CollectUniquesProcessor<XmlFile> processor = new CommonProcessors.CollectUniquesProcessor<XmlFile>(){

            public boolean process(XmlFile file) {
                if (!this.getResults().contains(file)) {
                    XsltIncludeIndex.processForwardDependencies(file, (Processor<? super XmlFile>)this);
                }
                return super.process((Object)file);
            }
        };
        XsltIncludeIndex.processForwardDependencies(element, (Processor<? super XmlFile>)processor);
        return processor.getResults();
    }

    @Nullable
    public static PsiFile resolveFile(String name, PsiFile baseFile) {
        PsiFile file;
        if (baseFile == null) {
            return null;
        }
        VirtualFile virtualFile = VfsUtil.findRelativeFile((String)name, (VirtualFile)baseFile.getVirtualFile());
        if (virtualFile != null && (file = baseFile.getManager().findFile(virtualFile)) != baseFile && file instanceof XmlFile) {
            return file;
        }
        return null;
    }

    @Nullable
    public static PsiFile resolveFile(XmlAttribute location, PsiFile baseFile) {
        PsiReference[] references;
        if (location == null) {
            return null;
        }
        XmlAttributeValue valueElement = location.getValueElement();
        if (valueElement == null) {
            return null;
        }
        String value = valueElement.getValue();
        PsiFile file = ResolveUtil.resolveFile(value, baseFile);
        if (file != baseFile && file instanceof XmlFile) {
            return file;
        }
        for (PsiReference reference : references = valueElement.getReferences()) {
            PsiElement target = reference.resolve();
            if (target == null && reference instanceof PsiPolyVariantReference) {
                ResolveResult[] results;
                for (ResolveResult result : results = ((PsiPolyVariantReference)reference).multiResolve(false)) {
                    PsiElement element;
                    if (!result.isValidResult() || (element = result.getElement()) == baseFile || !(element instanceof XmlFile)) continue;
                    return (PsiFile)target;
                }
                continue;
            }
            if (target == baseFile || !(target instanceof XmlFile)) continue;
            return (PsiFile)target;
        }
        return null;
    }

    @Nullable
    public static PsiElement resolve(Matcher matcher) {
        if (matcher == null) {
            return null;
        }
        List<PsiElement> found = ResolveUtil.process(matcher, true);
        return found.size() > 0 ? found.get(0) : null;
    }

    public static PsiElement[] collect(Matcher matcher) {
        if (matcher == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        List<PsiElement> found = ResolveUtil.process(matcher, false);
        return PsiUtilCore.toPsiElementArray(found);
    }

    private static List<PsiElement> process(Matcher matcher, boolean resolve) {
        return new ResolveUtil()._process(matcher, resolve);
    }

    private List<PsiElement> _process(final Matcher matcher, final boolean resolve) {
        XmlTag root = matcher.getRoot();
        if (root == null || this.myHistory.contains(root)) {
            return Collections.emptyList();
        }
        this.myHistory.add((PsiElement)root);
        final ArrayList<PsiElement> found = new ArrayList<PsiElement>();
        try {
            if (matcher.isRecursive()) {
                root.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                    public void visitXmlTag(XmlTag tag) {
                        Matcher.Result match = matcher.match(tag);
                        if (match != null) {
                            if (match.chain != null) {
                                found.addAll(ResolveUtil.this._process(match.chain, resolve));
                            } else {
                                assert (match.result != null);
                                found.add(match.result);
                                if (resolve) {
                                    throw Stop.DONE;
                                }
                            }
                        }
                        super.visitXmlTag(tag);
                    }
                });
            } else {
                root.acceptChildren((PsiElementVisitor)new XmlElementVisitor(){

                    public void visitXmlTag(XmlTag tag) {
                        Matcher.Result match = matcher.match(tag);
                        if (match != null) {
                            if (match.chain != null) {
                                found.addAll(ResolveUtil.this._process(match.chain, resolve));
                            } else {
                                assert (match.result != null);
                                found.add(match.result);
                                if (resolve) {
                                    throw Stop.DONE;
                                }
                            }
                        }
                    }
                });
            }
        }
        catch (Stop stop) {
            // empty catch block
        }
        return found;
    }

    @Nullable
    public static PsiElement treeWalkUp(XmlProcessor processor, PsiElement elt) {
        if (elt == null) {
            return null;
        }
        PsiElement cur = elt;
        do {
            XmlTag tag;
            if (!(cur instanceof XmlTag) || processor.process(tag = (XmlTag)cur)) continue;
            if (processor instanceof ResolveProcessor) {
                return ((ResolveProcessor)processor).getResult();
            }
            return null;
        } while (!(cur instanceof PsiFile) && (cur = PsiTreeUtil.getPrevSiblingOfType((PsiElement)cur, XmlTag.class)) != null);
        return ResolveUtil.treeWalkUp(processor, elt.getContext());
    }

    public static interface ResolveProcessor
    extends XmlProcessor {
        public PsiElement getResult();
    }

    public static interface XmlProcessor
    extends Processor<XmlTag> {
        public boolean process(XmlTag var1);
    }

    private static class Stop
    extends RuntimeException {
        public static final Stop DONE = new Stop();

        private Stop() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    public static interface Matcher {
        @Nullable
        public XmlTag getRoot();

        public boolean isRecursive();

        @Nullable
        public Result match(XmlTag var1);

        public Matcher variantMatcher();

        public static class Result {
            final PsiElement result;
            final Matcher chain;

            public Result(PsiElement element) {
                this.result = element;
                this.chain = null;
            }

            public Result(Matcher matcher) {
                this.chain = matcher;
                this.result = null;
            }

            public static Result create(PsiElement element) {
                return new Result(element);
            }

            public static Result create(Matcher matcher) {
                return new Result(matcher);
            }
        }
    }
}

