/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.refactoring.introduceParameter;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.usageView.UsageInfo;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.xslt.util.XsltCodeInsightUtil;
import org.jetbrains.annotations.Nullable;

class XPathUsageInfo
extends UsageInfo {
    private final XPathExpression myExpression;

    private XPathUsageInfo(XPathExpression expression, int startOffset, int endOffset) {
        super(expression.getContainingFile().getContext(), startOffset, endOffset, false);
        this.myExpression = expression;
    }

    @Nullable
    public XmlAttribute getAttribute() {
        return (XmlAttribute)PsiTreeUtil.getContextOfType((PsiElement)this.myExpression, XmlAttribute.class, (boolean)true);
    }

    public XPathExpression getExpression() {
        return this.myExpression;
    }

    public static XPathUsageInfo create(XPathExpression expression) {
        TextRange range = XsltCodeInsightUtil.getRangeInsideHost(expression);
        return new XPathUsageInfo(expression, range.getStartOffset(), range.getEndOffset());
    }
}

