/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ui.SelectFilesDialog;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.DialogManager;
import git4idea.GitLocalBranch;
import git4idea.GitUtil;
import git4idea.actions.BasicAction;
import git4idea.actions.GitInit;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.util.GitFileUtils;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.GithubShareAction;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutorManager;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GithubAuthenticatedUser;
import org.jetbrains.plugins.github.api.data.GithubRepo;
import org.jetbrains.plugins.github.api.util.GithubApiPagesLoader;
import org.jetbrains.plugins.github.authentication.GithubAuthenticationManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccountInformationProvider;
import org.jetbrains.plugins.github.ui.GithubShareDialog;
import org.jetbrains.plugins.github.util.GithubAccountsMigrationHelper;
import org.jetbrains.plugins.github.util.GithubGitHelper;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubUtil;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \b2\u00020\u0001:\u0003\b\t\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/GithubShareAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "Companion", "GithubExistingRemotesDialog", "GithubUntrackedFilesDialog", "intellij.vcs.github"})
public final class GithubShareAction
extends DumbAwareAction {
    private static final Logger LOG;
    public static final Companion Companion;

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        Presentation presentation = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
        presentation.setEnabledAndVisible(project != null && !project.isDefault());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project == null || project.isDisposed()) {
            return;
        }
        Companion.shareProjectOnGithub(project, file);
    }

    public GithubShareAction() {
        super("Share Project on GitHub", "Easily share project on GitHub", AllIcons.Vcs.Vendors.Github);
    }

    static {
        Companion = new Companion(null);
        LOG = GithubUtil.LOG;
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    @JvmStatic
    public static final void shareProjectOnGithub(@NotNull Project project, @Nullable VirtualFile file) {
        Companion.shareProjectOnGithub(project, file);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/github/GithubShareAction$GithubExistingRemotesDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "remotes", "", "", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "createCenterPanel", "Ljavax/swing/JComponent;", "intellij.vcs.github"})
    public static final class GithubExistingRemotesDialog
    extends DialogWrapper {
        private final List<String> remotes;

        @Nullable
        protected JComponent createCenterPanel() {
            Container $receiver;
            Container container;
            JBLabel mainText = new JBLabel(this.remotes.size() == 1 ? "Remote is already on GitHub:" : "Following remotes are already on GitHub:");
            JPanel jPanel = new JPanel();
            JPanel $receiver2 = jPanel;
            $receiver2.setLayout(new BoxLayout($receiver2, 1));
            JPanel remotesPanel = jPanel;
            for (String remote : this.remotes) {
                container = new JPanel(new FlowLayout(0, 0, 0));
                JPanel jPanel2 = remotesPanel;
                $receiver = container;
                $receiver.add((Component)LinkLabel.create((String)remote, (Runnable)new Runnable(remote){
                    final /* synthetic */ String $remote$inlined;
                    {
                        this.$remote$inlined = string;
                    }

                    public final void run() {
                        BrowserUtil.browse((String)this.$remote$inlined);
                    }
                }));
                $receiver.add((Component)new JBLabel(AllIcons.Ide.External_link_arrow));
                Container container2 = container;
                jPanel2.add(container2);
            }
            BorderLayoutPanel borderLayoutPanel = JBUI.Panels.simplePanel((int)10, (int)4).addToTop((Component)mainText).addToCenter((Component)remotesPanel);
            Intrinsics.checkExpressionValueIsNotNull((Object)borderLayoutPanel, (String)"JBUI.Panels.simplePanel(\u2026addToCenter(remotesPanel)");
            BorderLayoutPanel messagesPanel = borderLayoutPanel;
            $receiver = container = new Container();
            $receiver.setLayout(new BorderLayout());
            $receiver.add((Component)new JLabel(Messages.getQuestionIcon()), "North");
            Container iconContainer = container;
            $receiver = container = JBUI.Panels.simplePanel((int)10, (int)4).addToCenter((Component)messagesPanel).addToLeft((Component)iconContainer);
            $receiver.setBorder((Border)JBUI.Borders.emptyBottom((int)12));
            return (JComponent)container;
        }

        public GithubExistingRemotesDialog(@NotNull Project project, @NotNull List<String> remotes) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull(remotes, (String)"remotes");
            super(project);
            this.remotes = remotes;
            this.setTitle("Project Is Already on GitHub");
            this.setOKButtonText("Share Anyway");
            this.init();
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0014J\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\b\u0001\u0010\u0014\u001a\u00020\nH\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\nH\u0014R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/github/GithubShareAction$GithubUntrackedFilesDialog;", "Lcom/intellij/openapi/vcs/changes/ui/SelectFilesDialog;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "myProject", "Lcom/intellij/openapi/project/Project;", "untrackedFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "commitMessage", "", "getCommitMessage", "()Ljava/lang/String;", "myCommitMessagePanel", "Lcom/intellij/openapi/vcs/ui/CommitMessage;", "createCenterPanel", "Ljavax/swing/JComponent;", "createNorthPanel", "getData", "", "dataId", "getDimensionServiceKey", "intellij.vcs.github"})
    public static final class GithubUntrackedFilesDialog
    extends SelectFilesDialog
    implements DataProvider {
        private CommitMessage myCommitMessagePanel;
        private final Project myProject;

        @NotNull
        public final String getCommitMessage() {
            CommitMessage commitMessage = this.myCommitMessagePanel;
            if (commitMessage == null) {
                Intrinsics.throwNpe();
            }
            String string = commitMessage.getComment();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"myCommitMessagePanel!!.comment");
            return string;
        }

        @Nullable
        protected JComponent createNorthPanel() {
            return null;
        }

        @Nullable
        protected JComponent createCenterPanel() {
            JComponent tree = super.createCenterPanel();
            CommitMessage commitMessage = this.myCommitMessagePanel = new CommitMessage(this.myProject);
            if (commitMessage == null) {
                Intrinsics.throwNpe();
            }
            commitMessage.setCommitMessage("Initial commit");
            Splitter splitter = new Splitter(true);
            splitter.setHonorComponentsMinimumSize(true);
            splitter.setFirstComponent(tree);
            splitter.setSecondComponent((JComponent)this.myCommitMessagePanel);
            splitter.setProportion(0.7f);
            return (JComponent)splitter;
        }

        @Nullable
        public Object getData(@NonNls @NotNull String dataId) {
            Intrinsics.checkParameterIsNotNull((Object)dataId, (String)"dataId");
            return VcsDataKeys.COMMIT_MESSAGE_CONTROL.is(dataId) ? this.myCommitMessagePanel : null;
        }

        @Nullable
        protected String getDimensionServiceKey() {
            return "Github.UntrackedFilesDialog";
        }

        public GithubUntrackedFilesDialog(@NotNull Project myProject, @NotNull List<? extends VirtualFile> untrackedFiles) {
            Intrinsics.checkParameterIsNotNull((Object)myProject, (String)"myProject");
            Intrinsics.checkParameterIsNotNull(untrackedFiles, (String)"untrackedFiles");
            super(myProject, untrackedFiles, null, null, true, false);
            this.myProject = myProject;
            this.setTitle("Add Files For Initial Commit");
            this.setOKButtonText(CommonBundle.getAddButtonText());
            this.setCancelButtonText(CommonBundle.getCancelButtonText());
            this.init();
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/GithubShareAction$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "shareProjectOnGithub", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.vcs.github"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final void shareProjectOnGithub(@NotNull Project project, @Nullable VirtualFile file) {
            Object object;
            GithubAccount githubAccount;
            Set<GithubAccount> set;
            Project project2;
            GithubShareDialog githubShareDialog;
            GithubShareDialog githubShareDialog2;
            Function2<GithubAccount, Component, Pair<? extends Boolean, ? extends Set<? extends String>>> accountInformationLoader2;
            Git git;
            GithubGitHelper gitHelper;
            GithubAccountInformationProvider accountInformationProvider;
            GithubApiRequestExecutorManager requestExecutorManager;
            GitRepository gitRepository;
            block14: {
                block13: {
                    Collection<String> collection;
                    void $receiver$iv$iv;
                    void $receiver$iv;
                    GithubShareDialog githubShareDialog3;
                    Object object2;
                    Collection<String> collection2;
                    Object p1;
                    Object object3;
                    Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                    BasicAction.saveAll();
                    gitRepository = GithubGitHelper.Companion.findGitRepository(project, file);
                    Object object4 = ServiceManager.getService(GithubAccountsMigrationHelper.class);
                    Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"ServiceManager.getService(T::class.java)");
                    if (!GithubAccountsMigrationHelper.migrate$default((GithubAccountsMigrationHelper)object4, project, null, 2, null)) {
                        return;
                    }
                    Object object5 = ServiceManager.getService(GithubAuthenticationManager.class);
                    Intrinsics.checkExpressionValueIsNotNull((Object)object5, (String)"ServiceManager.getService(T::class.java)");
                    GithubAuthenticationManager authManager = (GithubAuthenticationManager)object5;
                    if (!GithubAuthenticationManager.ensureHasAccounts$default(authManager, project, null, 2, null)) {
                        return;
                    }
                    Set<GithubAccount> accounts = authManager.getAccounts();
                    Object object6 = ServiceManager.getService(ProgressManager.class);
                    Intrinsics.checkExpressionValueIsNotNull((Object)object6, (String)"ServiceManager.getService(T::class.java)");
                    ProgressManager progressManager = (ProgressManager)object6;
                    Object object7 = ServiceManager.getService(GithubApiRequestExecutorManager.class);
                    Intrinsics.checkExpressionValueIsNotNull((Object)object7, (String)"ServiceManager.getService(T::class.java)");
                    requestExecutorManager = (GithubApiRequestExecutorManager)object7;
                    Object object8 = ServiceManager.getService(GithubAccountInformationProvider.class);
                    Intrinsics.checkExpressionValueIsNotNull((Object)object8, (String)"ServiceManager.getService(T::class.java)");
                    accountInformationProvider = (GithubAccountInformationProvider)object8;
                    Object object9 = ServiceManager.getService(GithubGitHelper.class);
                    Intrinsics.checkExpressionValueIsNotNull((Object)object9, (String)"ServiceManager.getService(T::class.java)");
                    gitHelper = (GithubGitHelper)object9;
                    Object object10 = ServiceManager.getService(Git.class);
                    Intrinsics.checkExpressionValueIsNotNull((Object)object10, (String)"ServiceManager.getService(T::class.java)");
                    git = (Git)object10;
                    GitRepository gitRepository2 = gitRepository;
                    if (gitRepository2 != null) {
                        object3 = gitRepository2;
                        GithubGitHelper githubGitHelper = gitHelper;
                        p1 = object3;
                        collection2 = githubGitHelper.getAccessibleRemoteUrls((GitRepository)p1);
                    } else {
                        collection2 = object3 = null;
                    }
                    if ((object2 = object3) == null) {
                        object2 = CollectionsKt.emptyList();
                    }
                    GitRepository possibleRemotes = object2;
                    object3 = (Collection)possibleRemotes;
                    if (!object3.isEmpty()) {
                        GithubExistingRemotesDialog existingRemotesDialog = new GithubExistingRemotesDialog(project, (List<String>)possibleRemotes);
                        DialogManager.show((DialogWrapper)existingRemotesDialog);
                        if (!existingRemotesDialog.isOK()) {
                            return;
                        }
                    }
                    accountInformationLoader2 = new Function2<GithubAccount, Component, Pair<? extends Boolean, ? extends Set<? extends String>>>(requestExecutorManager, progressManager, project){
                        private final Map<GithubAccount, Pair<Boolean, Set<String>>> loadedInfo;
                        final /* synthetic */ GithubApiRequestExecutorManager $requestExecutorManager;
                        final /* synthetic */ ProgressManager $progressManager;
                        final /* synthetic */ Project $project;

                        @NotNull
                        public Pair<Boolean, Set<String>> invoke(@NotNull GithubAccount account, @NotNull Component parentComponent) throws IOException {
                            Pair pair;
                            Intrinsics.checkParameterIsNotNull((Object)account, (String)"account");
                            Intrinsics.checkParameterIsNotNull((Object)parentComponent, (String)"parentComponent");
                            Map<GithubAccount, Pair<Boolean, Set<String>>> $receiver$iv = this.loadedInfo;
                            Pair value$iv = $receiver$iv.get(account);
                            if (value$iv == null) {
                                GithubApiRequestExecutor.WithTokenAuth withTokenAuth = this.$requestExecutorManager.getExecutor(account, parentComponent);
                                if (withTokenAuth == null) {
                                    throw (Throwable)new ProcessCanceledException();
                                }
                                GithubApiRequestExecutor.WithTokenAuth requestExecutor = withTokenAuth;
                                Object object = this.$progressManager.runProcessWithProgressSynchronously((ThrowableComputable)new ThrowableComputable<Pair<? extends Boolean, ? extends Set<? extends String>>, IOException>(requestExecutor, this, account, parentComponent){
                                    final /* synthetic */ GithubApiRequestExecutor.WithTokenAuth $requestExecutor;
                                    final /* synthetic */ shareProjectOnGithub.accountInformationLoader.1 this$0;
                                    final /* synthetic */ GithubAccount $account$inlined;
                                    final /* synthetic */ Component $parentComponent$inlined;
                                    {
                                        this.$requestExecutor = withTokenAuth;
                                        this.this$0 = var2_2;
                                        this.$account$inlined = githubAccount;
                                        this.$parentComponent$inlined = component;
                                    }

                                    /*
                                     * WARNING - void declaration
                                     */
                                    @NotNull
                                    public final Pair<Boolean, Set<String>> compute() {
                                        Set set;
                                        ProgressIndicator progressIndicator = this.this$0.$progressManager.getProgressIndicator();
                                        Intrinsics.checkExpressionValueIsNotNull((Object)progressIndicator, (String)"progressManager.progressIndicator");
                                        GithubServerPath githubServerPath = this.$account$inlined.getServer();
                                        Intrinsics.checkExpressionValueIsNotNull((Object)githubServerPath, (String)"account.server");
                                        GithubAuthenticatedUser user = this.$requestExecutor.execute(progressIndicator, GithubApiRequests.CurrentUser.get(githubServerPath));
                                        GithubApiRequestExecutor githubApiRequestExecutor = this.$requestExecutor;
                                        ProgressIndicator progressIndicator2 = this.this$0.$progressManager.getProgressIndicator();
                                        Intrinsics.checkExpressionValueIsNotNull((Object)progressIndicator2, (String)"progressManager.progressIndicator");
                                        GithubServerPath githubServerPath2 = this.$account$inlined.getServer();
                                        Intrinsics.checkExpressionValueIsNotNull((Object)githubServerPath2, (String)"account.server");
                                        Collection $receiver$iv = GithubApiPagesLoader.loadAll(githubApiRequestExecutor, progressIndicator2, GithubApiRequests.CurrentUser.Repos.pages(githubServerPath2, false));
                                        int size$iv = $receiver$iv.size();
                                        switch (size$iv) {
                                            case 1: {
                                                void it;
                                                SmartHashSet result$iv = new SmartHashSet();
                                                GithubRepo githubRepo = (GithubRepo)CollectionsKt.first((Iterable)$receiver$iv);
                                                SmartHashSet smartHashSet = result$iv;
                                                String string = it.getName();
                                                smartHashSet.add((Object)string);
                                                set = (Set)result$iv;
                                                break;
                                            }
                                            case 0: {
                                                set = SetsKt.emptySet();
                                                break;
                                            }
                                            default: {
                                                void $receiver$iv$iv;
                                                Iterable result$iv = $receiver$iv;
                                                Collection destination$iv$iv = (Collection)new THashSet(size$iv);
                                                for (T item$iv$iv : $receiver$iv$iv) {
                                                    GithubRepo it = (GithubRepo)item$iv$iv;
                                                    Collection collection = destination$iv$iv;
                                                    String string = it.getName();
                                                    collection.add(string);
                                                }
                                                set = (Set)destination$iv$iv;
                                            }
                                        }
                                        Set names = set;
                                        return TuplesKt.to((Object)user.canCreatePrivateRepo(), (Object)names);
                                    }
                                }, "Loading Account Information For " + account, true, this.$project);
                                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"progressManager.runProce\u2026$account\", true, project)");
                                Pair answer$iv = (Pair)object;
                                $receiver$iv.put(account, (Pair<Boolean, Set<String>>)answer$iv);
                                pair = answer$iv;
                            } else {
                                pair = value$iv;
                            }
                            return pair;
                        }
                        {
                            Map map2;
                            this.$requestExecutorManager = $captured_local_variable$0;
                            this.$progressManager = $captured_local_variable$1;
                            this.$project = $captured_local_variable$2;
                            shareProjectOnGithub.accountInformationLoader.1 var4_4 = this;
                            var4_4.loadedInfo = map2 = (Map)new LinkedHashMap<K, V>();
                        }
                    };
                    githubShareDialog2 = githubShareDialog3;
                    githubShareDialog = githubShareDialog3;
                    project2 = project;
                    set = accounts;
                    githubAccount = authManager.getDefaultAccount(project);
                    object = gitRepository;
                    if (object == null || (object = object.getRemotes()) == null) break block13;
                    p1 = (Iterable)object;
                    GithubAccount githubAccount2 = githubAccount;
                    Set<GithubAccount> set2 = set;
                    Project project3 = project2;
                    GithubShareDialog githubShareDialog4 = githubShareDialog2;
                    GithubShareDialog githubShareDialog5 = githubShareDialog;
                    void $i$a$1$unknown = $receiver$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    for (Object item$iv$iv : $receiver$iv$iv) {
                        void it;
                        GitRemote gitRemote = (GitRemote)item$iv$iv;
                        collection = destination$iv$iv;
                        void v17 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v17, (String)"it");
                        String string = v17.getName();
                        collection.add(string);
                    }
                    collection = (List)destination$iv$iv;
                    githubShareDialog = githubShareDialog5;
                    githubShareDialog2 = githubShareDialog4;
                    project2 = project3;
                    set = set2;
                    githubAccount = githubAccount2;
                    object = CollectionsKt.toSet((Iterable)collection);
                    if (object != null) break block14;
                }
                object = SetsKt.emptySet();
            }
            githubShareDialog2(project2, set, githubAccount, (Set<String>)object, (Function2<? super GithubAccount, ? super Component, ? extends Pair<Boolean, ? extends Set<String>>>)((Function2)accountInformationLoader2));
            GithubShareDialog shareDialog = githubShareDialog;
            DialogManager.show((DialogWrapper)shareDialog);
            if (!shareDialog.isOK()) {
                return;
            }
            String name = shareDialog.getRepositoryName();
            boolean isPrivate = shareDialog.isPrivate();
            String remoteName = shareDialog.getRemoteName();
            String description = shareDialog.getDescription();
            GithubAccount account = shareDialog.getAccount();
            GithubApiRequestExecutor.WithTokenAuth withTokenAuth = requestExecutorManager.getExecutor(account, project);
            if (withTokenAuth == null) {
                return;
            }
            GithubApiRequestExecutor.WithTokenAuth requestExecutor = withTokenAuth;
            new Task.Backgroundable(requestExecutor, account, name, description, isPrivate, gitRepository, project, accountInformationProvider, gitHelper, git, remoteName, project, "Sharing Project on GitHub..."){
                private String url;
                final /* synthetic */ GithubApiRequestExecutor.WithTokenAuth $requestExecutor;
                final /* synthetic */ GithubAccount $account;
                final /* synthetic */ String $name;
                final /* synthetic */ String $description;
                final /* synthetic */ boolean $isPrivate;
                final /* synthetic */ GitRepository $gitRepository;
                final /* synthetic */ Project $project;
                final /* synthetic */ GithubAccountInformationProvider $accountInformationProvider;
                final /* synthetic */ GithubGitHelper $gitHelper;
                final /* synthetic */ Git $git;
                final /* synthetic */ String $remoteName;

                public void run(@NotNull ProgressIndicator indicator) {
                    Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                    GithubShareAction.access$getLOG$cp().info("Creating GitHub repository");
                    indicator.setText("Creating GitHub repository...");
                    GithubServerPath githubServerPath = this.$account.getServer();
                    Intrinsics.checkExpressionValueIsNotNull((Object)githubServerPath, (String)"account.server");
                    String string = this.$requestExecutor.execute(indicator, GithubApiRequests.CurrentUser.Repos.create(githubServerPath, this.$name, this.$description, this.$isPrivate)).getHtmlUrl();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"requestExecutor\n        \u2026tion, isPrivate)).htmlUrl");
                    this.url = string;
                    GithubShareAction.access$getLOG$cp().info("Successfully created GitHub repository");
                    GitRepository gitRepository = this.$gitRepository;
                    if (gitRepository == null || (gitRepository = gitRepository.getRoot()) == null) {
                        gitRepository = this.$project.getBaseDir();
                    }
                    GitRepository root = gitRepository;
                    GithubShareAction.access$getLOG$cp().info("Binding local project with GitHub");
                    if (this.$gitRepository == null) {
                        GithubShareAction.access$getLOG$cp().info("No git detected, creating empty git repo");
                        indicator.setText("Creating empty git repo...");
                        GitRepository gitRepository2 = root;
                        Intrinsics.checkExpressionValueIsNotNull((Object)gitRepository2, (String)"root");
                        if (!this.createEmptyGitRepository(this.$project, (VirtualFile)gitRepository2)) {
                            return;
                        }
                    }
                    GitRepositoryManager gitRepositoryManager = GitUtil.getRepositoryManager((Project)this.$project);
                    Intrinsics.checkExpressionValueIsNotNull((Object)gitRepositoryManager, (String)"GitUtil.getRepositoryManager(project)");
                    GitRepositoryManager repositoryManager = gitRepositoryManager;
                    GitRepository repository = (GitRepository)repositoryManager.getRepositoryForRoot((VirtualFile)root);
                    if (repository == null) {
                        GithubNotifications.showError(this.$project, "Failed to create GitHub Repository", "Can't find Git repository");
                        return;
                    }
                    indicator.setText("Retrieving username...");
                    String string2 = this.$accountInformationProvider.getInformation(this.$requestExecutor, indicator, this.$account).getLogin();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"accountInformationProvid\u2026indicator, account).login");
                    String username = string2;
                    GithubServerPath githubServerPath2 = this.$account.getServer();
                    Intrinsics.checkExpressionValueIsNotNull((Object)githubServerPath2, (String)"account.server");
                    String remoteUrl = this.$gitHelper.getRemoteUrl(githubServerPath2, username, this.$name);
                    GithubShareAction.access$getLOG$cp().info("Adding GitHub as a remote host");
                    indicator.setText("Adding GitHub as a remote host...");
                    this.$git.addRemote(repository, this.$remoteName, remoteUrl).throwOnError(new int[0]);
                    repository.update();
                    GitRepository gitRepository3 = root;
                    Intrinsics.checkExpressionValueIsNotNull((Object)gitRepository3, (String)"root");
                    String string3 = this.url;
                    if (string3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"url");
                    }
                    if (!this.performFirstCommitIfRequired(this.$project, (VirtualFile)gitRepository3, repository, indicator, this.$name, string3)) {
                        return;
                    }
                    GithubShareAction.access$getLOG$cp().info("Pushing to github master");
                    indicator.setText("Pushing to github master...");
                    String string4 = this.url;
                    if (string4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"url");
                    }
                    if (!this.pushCurrentBranch(this.$project, repository, this.$remoteName, remoteUrl, this.$name, string4)) {
                        return;
                    }
                    String string5 = this.url;
                    if (string5 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"url");
                    }
                    GithubNotifications.showInfoURL(this.$project, "Successfully shared project on GitHub", this.$name, string5);
                }

                private final boolean createEmptyGitRepository(Project project, VirtualFile root) {
                    GitCommandResult gitCommandResult = Git.getInstance().init(project, root, new GitLineHandlerListener[0]);
                    Intrinsics.checkExpressionValueIsNotNull((Object)gitCommandResult, (String)"Git.getInstance().init(project, root)");
                    GitCommandResult result = gitCommandResult;
                    if (!result.success()) {
                        VcsNotifier.getInstance((Project)project).notifyError(GitBundle.getString((String)"initializing.title"), result.getErrorOutputAsHtmlString());
                        GithubShareAction.access$getLOG$cp().info("Failed to create empty git repo: " + result.getErrorOutputAsJoinedString());
                        return false;
                    }
                    GitInit.refreshAndConfigureVcsMappings((Project)project, (VirtualFile)root, (String)root.getPath());
                    return true;
                }

                private final boolean performFirstCommitIfRequired(Project project, VirtualFile root, GitRepository repository, ProgressIndicator indicator, String name, String url) {
                    if (!repository.isFresh()) {
                        return true;
                    }
                    GithubShareAction.access$getLOG$cp().info("Trying to commit");
                    try {
                        GithubShareAction.access$getLOG$cp().info("Adding files for commit");
                        indicator.setText("Adding files to git...");
                        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
                        Intrinsics.checkExpressionValueIsNotNull((Object)changeListManager, (String)"ChangeListManager.getInstance(project)");
                        List list2 = changeListManager.getAffectedFiles();
                        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"ChangeListManager.getIns\u2026ce(project).affectedFiles");
                        List trackedFiles = list2;
                        Collection collection = repository.getUntrackedFilesHolder().retrieveUntrackedFiles();
                        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"repository.untrackedFile\u2026.retrieveUntrackedFiles()");
                        Collection<VirtualFile> untrackedFiles = this.filterOutIgnored(project, collection);
                        trackedFiles.removeAll(untrackedFiles);
                        ArrayList<VirtualFile> allFiles = new ArrayList<VirtualFile>();
                        allFiles.addAll(trackedFiles);
                        allFiles.addAll(untrackedFiles);
                        GithubUntrackedFilesDialog dialog2 = (GithubUntrackedFilesDialog)((Object)ActionsKt.invokeAndWaitIfNeed((ModalityState)indicator.getModalityState(), (Function0)((Function0)new Function0<GithubUntrackedFilesDialog>(project, allFiles, trackedFiles){
                            final /* synthetic */ Project $project;
                            final /* synthetic */ ArrayList $allFiles;
                            final /* synthetic */ List $trackedFiles;

                            @NotNull
                            public final GithubUntrackedFilesDialog invoke() {
                                GithubUntrackedFilesDialog githubUntrackedFilesDialog;
                                GithubUntrackedFilesDialog $receiver = githubUntrackedFilesDialog = new GithubUntrackedFilesDialog(this.$project, this.$allFiles);
                                if (!this.$trackedFiles.isEmpty()) {
                                    $receiver.setSelectedFiles(this.$trackedFiles);
                                }
                                DialogManager.show((DialogWrapper)((DialogWrapper)$receiver));
                                return githubUntrackedFilesDialog;
                            }
                            {
                                this.$project = project;
                                this.$allFiles = arrayList;
                                this.$trackedFiles = list2;
                                super(0);
                            }
                        })));
                        Collection files2commit = dialog2.getSelectedFiles();
                        if (!dialog2.isOK() || files2commit.isEmpty()) {
                            GithubNotifications.showInfoURL(project, "Successfully created empty repository on GitHub", name, url);
                            return false;
                        }
                        Collection collection2 = ContainerUtil.intersection(untrackedFiles, (Collection)files2commit);
                        Intrinsics.checkExpressionValueIsNotNull((Object)collection2, (String)"ContainerUtil.intersecti\u2026ackedFiles, files2commit)");
                        Collection files2add = collection2;
                        Collection collection3 = ContainerUtil.subtract((Collection)trackedFiles, (Collection)files2commit);
                        Intrinsics.checkExpressionValueIsNotNull((Object)collection3, (String)"ContainerUtil.subtract(trackedFiles, files2commit)");
                        Collection files2rm = collection3;
                        HashSet<E> modified = new HashSet<E>(trackedFiles);
                        modified.addAll(files2commit);
                        GitFileUtils.addFiles((Project)project, (VirtualFile)root, (Collection)files2add);
                        GitFileUtils.deleteFilesFromCache((Project)project, (VirtualFile)root, (Collection)files2rm);
                        GithubShareAction.access$getLOG$cp().info("Performing commit");
                        indicator.setText("Performing commit...");
                        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.COMMIT);
                        handler.setStdoutSuppressed(false);
                        handler.addParameters(new String[]{"-m", dialog2.getCommitMessage()});
                        handler.endOptions();
                        Git.getInstance().runCommand(handler).throwOnError(new int[0]);
                        VcsFileUtil.markFilesDirty((Project)project, (Collection)modified);
                    }
                    catch (VcsException e) {
                        GithubShareAction.access$getLOG$cp().warn((Throwable)e);
                        GithubNotifications.showErrorURL(project, "Can't finish GitHub sharing process", "Successfully created project ", '\'' + name + '\'', " on GitHub, but initial commit failed:<br/>" + GithubUtil.getErrorTextFromException(e), url);
                        return false;
                    }
                    GithubShareAction.access$getLOG$cp().info("Successfully created initial commit");
                    return true;
                }

                private final Collection<VirtualFile> filterOutIgnored(Project project, Collection<? extends VirtualFile> files) {
                    ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
                    Intrinsics.checkExpressionValueIsNotNull((Object)changeListManager, (String)"ChangeListManager.getInstance(project)");
                    ChangeListManager changeListManager2 = changeListManager;
                    ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
                    List list2 = ContainerUtil.filter(files, (Condition)((Condition)new Condition<T>(changeListManager2, vcsManager){
                        final /* synthetic */ ChangeListManager $changeListManager;
                        final /* synthetic */ ProjectLevelVcsManager $vcsManager;

                        public final boolean value(VirtualFile file) {
                            return !this.$changeListManager.isIgnoredFile(file) && !this.$vcsManager.isIgnored(file);
                        }
                        {
                            this.$changeListManager = changeListManager;
                            this.$vcsManager = projectLevelVcsManager;
                        }
                    }));
                    Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"ContainerUtil.filter(fil\u2026Manager.isIgnored(file) }");
                    return list2;
                }

                private final boolean pushCurrentBranch(Project project, GitRepository repository, String remoteName, String remoteUrl, String name, String url) {
                    GitLocalBranch currentBranch = repository.getCurrentBranch();
                    if (currentBranch == null) {
                        GithubNotifications.showErrorURL(project, "Can't finish GitHub sharing process", "Successfully created project ", '\'' + name + '\'', " on GitHub, but initial push failed: no current branch", url);
                        return false;
                    }
                    GitCommandResult gitCommandResult = this.$git.push(repository, remoteName, remoteUrl, currentBranch.getName(), true, new GitLineHandlerListener[0]);
                    Intrinsics.checkExpressionValueIsNotNull((Object)gitCommandResult, (String)"git.push(repository, rem\u2026currentBranch.name, true)");
                    GitCommandResult result = gitCommandResult;
                    if (!result.success()) {
                        GithubNotifications.showErrorURL(project, "Can't finish GitHub sharing process", "Successfully created project ", '\'' + name + '\'', " on GitHub, but initial push failed:<br/>" + result.getErrorOutputAsHtmlString(), url);
                        return false;
                    }
                    return true;
                }

                public void onThrowable(@NotNull Throwable error) {
                    Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                    GithubNotifications.showError(this.$project, "Failed to create GitHub Repository", error);
                }
                {
                    this.$requestExecutor = $captured_local_variable$0;
                    this.$account = $captured_local_variable$1;
                    this.$name = $captured_local_variable$2;
                    this.$description = $captured_local_variable$3;
                    this.$isPrivate = $captured_local_variable$4;
                    this.$gitRepository = $captured_local_variable$5;
                    this.$project = $captured_local_variable$6;
                    this.$accountInformationProvider = $captured_local_variable$7;
                    this.$gitHelper = $captured_local_variable$8;
                    this.$git = $captured_local_variable$9;
                    this.$remoteName = $captured_local_variable$10;
                    super($super_call_param$11, $super_call_param$12);
                }
            }.queue();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

