/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.impord;

import java.io.IOException;
import org.netbeans.lib.cvsclient.IClientEnvironment;
import org.netbeans.lib.cvsclient.IRequestProcessor;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.IOCommandException;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.ICvsListenerRegistry;
import org.netbeans.lib.cvsclient.event.IEventSender;
import org.netbeans.lib.cvsclient.file.DirectoryObject;
import org.netbeans.lib.cvsclient.file.FileUtils;
import org.netbeans.lib.cvsclient.progress.IProgressViewer;
import org.netbeans.lib.cvsclient.progress.sending.DummyRequestsProgressHandler;
import org.netbeans.lib.cvsclient.progress.sending.IRequestsProgressHandler;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.DirectoryRequest;
import org.netbeans.lib.cvsclient.request.IRequest;
import org.netbeans.lib.cvsclient.request.Requests;
import org.netbeans.lib.cvsclient.request.ResponseExpectingRequest;
import org.netbeans.lib.cvsclient.util.BugLog;

public final class CreateModuleCommand
extends Command {
    private String module;

    public boolean execute(IRequestProcessor requestProcessor, IEventSender eventManager, ICvsListenerRegistry listenerRegistry, IClientEnvironment clientEnvironment, IProgressViewer progressViewer) throws CommandException, AuthenticationException {
        BugLog.getInstance().assertNotNull((Object)this.module);
        String repositoryRoot = FileUtils.removeTrailingSlash((String)clientEnvironment.getCvsRoot().getRepositoryPath()) + '/' + this.module;
        Requests requests = new Requests((ResponseExpectingRequest)CommandRequest.IMPORT, clientEnvironment);
        requests.addArgumentRequest("-b");
        requests.addArgumentRequest("1.1.1");
        requests.addMessageRequests("Create module");
        requests.addArgumentRequest(this.module);
        requests.addArgumentRequest("vendor-tag");
        requests.addArgumentRequest("release-tag");
        requests.addRequest((IRequest)new DirectoryRequest(".", repositoryRoot));
        if (!requestProcessor.processRequests(requests, (IRequestsProgressHandler)new DummyRequestsProgressHandler())) {
            return false;
        }
        try {
            this.createCvsDirectory(clientEnvironment, repositoryRoot);
        }
        catch (IOException ex) {
            throw new IOCommandException(ex);
        }
        return true;
    }

    public void resetCvsCommand() {
        super.resetCvsCommand();
        this.setModule(null);
    }

    public String getCvsCommandLine() {
        return "import " + this.module;
    }

    public void setModule(String module) {
        this.module = CreateModuleCommand.getTrimmedString((String)module);
    }

    private void createCvsDirectory(IClientEnvironment clientEnvironment, String repositoryRoot) throws IOException {
        clientEnvironment.getAdminWriter().ensureCvsDirectory(DirectoryObject.getRoot(), repositoryRoot, clientEnvironment.getCvsRoot(), clientEnvironment.getCvsFileSystem());
    }
}

