/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.codeStyle;

import com.intellij.application.options.CodeStyleAbstractConfigurable;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleGroup;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.css.codeStyle.CssCodeStyleMainPanel;
import com.intellij.psi.css.codeStyle.CssCodeStyleSettings;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CssLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    public static final CodeStyleGroup STYLESHEET_GROUP = new CodeStyleGroup("stylesheet.code.style.group", "Style Sheets");

    @NotNull
    public Language getLanguage() {
        CSSLanguage cSSLanguage = CSSLanguage.INSTANCE;
        if (cSSLanguage == null) {
            CssLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(0);
        }
        return cSSLanguage;
    }

    public CodeStyleGroup getGroup() {
        return STYLESHEET_GROUP;
    }

    protected void customizeDefaults(@NotNull CommonCodeStyleSettings commonSettings, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (commonSettings == null) {
            CssLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(1);
        }
        if (indentOptions == null) {
            CssLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(2);
        }
        commonSettings.LINE_COMMENT_AT_FIRST_COLUMN = false;
        commonSettings.BLOCK_COMMENT_AT_FIRST_COLUMN = false;
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            CssLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(3);
        }
        return "body {\n    background: black;\n    color: #80c0c0\n}\np:first-line {\n    margin-left: 25px\n}\n\n\n\n\n/* after several blank lines */\n";
    }

    public IndentOptionsEditor getIndentOptionsEditor() {
        return new SmartIndentOptionsEditor();
    }

    @NotNull
    public CustomCodeStyleSettings createCustomSettings(CodeStyleSettings settings) {
        CssCodeStyleSettings cssCodeStyleSettings = new CssCodeStyleSettings(settings);
        if (cssCodeStyleSettings == null) {
            CssLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(4);
        }
        return cssCodeStyleSettings;
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (consumer == null) {
            CssLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(5);
        }
        if (settingsType == null) {
            CssLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(6);
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.BLANK_LINES_SETTINGS) {
            CssLanguageCodeStyleSettingsProvider.customizeStyleSheetBlankLinesSettings(consumer, CssCodeStyleSettings.class);
        }
    }

    public static void customizeStyleSheetBlankLinesSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull Class<? extends CssCodeStyleSettings> settingsClass) {
        if (consumer == null) {
            CssLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(7);
        }
        if (settingsClass == null) {
            CssLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(8);
        }
        consumer.showStandardOptions(new String[]{"KEEP_BLANK_LINES_IN_CODE"});
        consumer.showCustomOption(settingsClass, "BLANK_LINES_BETWEEN_BLOCKS", "Around top-level block:", CodeStyleSettingsCustomizable.BLANK_LINES, new Object[0]);
        consumer.showCustomOption(settingsClass, "BLANK_LINES_AROUND_NESTED_SELECTOR", "Around nested selector:", CodeStyleSettingsCustomizable.BLANK_LINES, new Object[0]);
    }

    @NotNull
    public CodeStyleConfigurable createConfigurable(@NotNull CodeStyleSettings baseSettings, @NotNull CodeStyleSettings modelSettings) {
        if (baseSettings == null) {
            CssLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(9);
        }
        if (modelSettings == null) {
            CssLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(10);
        }
        CodeStyleAbstractConfigurable codeStyleAbstractConfigurable = new CodeStyleAbstractConfigurable(baseSettings, modelSettings, this.getConfigurableDisplayName()){

            protected CodeStyleAbstractPanel createPanel(CodeStyleSettings settings) {
                return new CssCodeStyleMainPanel(this.getCurrentSettings(), settings);
            }

            @NotNull
            @NonNls
            public String getHelpTopic() {
                if ("reference.settingsdialog.IDE.csscodestyle" == null) {
                    1.$$$reportNull$$$0(0);
                }
                return "reference.settingsdialog.IDE.csscodestyle";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/codeStyle/CssLanguageCodeStyleSettingsProvider$1", "getHelpTopic"));
            }
        };
        if (codeStyleAbstractConfigurable == null) {
            CssLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(11);
        }
        return codeStyleAbstractConfigurable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/codeStyle/CssLanguageCodeStyleSettingsProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentOptions";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsType";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseSettings";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/codeStyle/CssLanguageCodeStyleSettingsProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomSettings";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "customizeDefaults";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCodeSample";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "customizeSettings";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "customizeStyleSheetBlankLinesSettings";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

