/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.twig;

import com.intellij.codeInsight.editorActions.SimpleTokenSetQuoteHandler;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.twig.TwigTokenTypes;

public class TwigQuoteHandler
extends SimpleTokenSetQuoteHandler {
    public TwigQuoteHandler() {
        super(new IElementType[]{TwigTokenTypes.SINGLE_QUOTE, TwigTokenTypes.DOUBLE_QUOTE});
    }

    public boolean isClosingQuote(HighlighterIterator iterator, int offset) {
        if (!this.myLiteralTokenSet.contains(iterator.getTokenType()) || iterator.getEnd() - iterator.getStart() != 1) {
            return false;
        }
        return !this.isOpeningQuoteInternal(iterator);
    }

    public boolean isOpeningQuote(HighlighterIterator iterator, int offset) {
        if (!this.myLiteralTokenSet.contains(iterator.getTokenType()) || offset != iterator.getStart()) {
            return false;
        }
        return this.isOpeningQuoteInternal(iterator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isOpeningQuoteInternal(HighlighterIterator iterator) {
        iterator.retreat();
        try {
            if (iterator.atEnd()) {
                boolean bl = true;
                return bl;
            }
            IElementType type = iterator.getTokenType();
            boolean bl = !this.myLiteralTokenSet.contains(type) && !TwigTokenTypes.STRING_TEXT.equals(type);
            return bl;
        }
        finally {
            iterator.advance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNonClosedLiteral(Editor editor, HighlighterIterator iterator, int offset) {
        int start = iterator.getStart();
        try {
            Document doc = editor.getDocument();
            CharSequence chars = doc.getCharsSequence();
            int lineEnd = doc.getLineEndOffset(doc.getLineNumber(offset));
            while (!iterator.atEnd() && iterator.getStart() < lineEnd) {
                IElementType tokenType = iterator.getTokenType();
                if (this.myLiteralTokenSet.contains(tokenType) && (iterator.getStart() >= iterator.getEnd() - 1 || chars.charAt(iterator.getEnd() - 1) != '\"' && chars.charAt(iterator.getEnd() - 1) != '\'')) {
                    boolean bl = true;
                    return bl;
                }
                iterator.advance();
            }
        }
        finally {
            while (iterator.atEnd() || iterator.getStart() != start) {
                iterator.retreat();
            }
        }
        return false;
    }
}

