/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.structuralsearch.PredefinedConfigurationUtil;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.jetbrains.php.lang.PhpFileType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.BiConsumer;

public class PhpPredefinedConfigurations {
    private static final String GENERAL_CATEGORY = "PHP/General";
    private static final String EXPRESSIONS_CATEGORY = "PHP/Expressions";
    private static final String SUSPICIOUS_CATEGORY = "PHP/Suspicious";

    private PhpPredefinedConfigurations() {
    }

    public static Configuration[] createPredefinedTemplates() {
        ArrayList<Configuration> configurations = new ArrayList<Configuration>();
        configurations.addAll(PhpPredefinedConfigurations.createGeneralConfigurations());
        configurations.addAll(PhpPredefinedConfigurations.createExpressionsConfigurations());
        configurations.addAll(PhpPredefinedConfigurations.createMiscConfigurations());
        return configurations.toArray(Configuration.EMPTY_ARRAY);
    }

    private static Collection<Configuration> createGeneralConfigurations() {
        ArrayList<Configuration> configurations = new ArrayList<Configuration>();
        BiConsumer<String, String> addGeneralTemplate = (name, template) -> configurations.add(PredefinedConfigurationUtil.createSearchTemplateInfo((String)name, (String)template, (String)GENERAL_CATEGORY, (FileType)PhpFileType.INSTANCE));
        addGeneralTemplate.accept("Class", "class 'a {}");
        addGeneralTemplate.accept("All public fields of the class", "class '_a {public 'b+}");
        addGeneralTemplate.accept("All public methods of the class", "class '_a {public function 'b+()}");
        addGeneralTemplate.accept("All constants of the class", "class '_a {const 'b+}");
        addGeneralTemplate.accept("Interface", "interface 'a {}");
        addGeneralTemplate.accept("Trait", "trait 'a {}");
        addGeneralTemplate.accept("Class that extends another", "class 'a extends '_b {}");
        addGeneralTemplate.accept("Class that implements two interfaces", "class 'a implements '_b{2,2} {}");
        return configurations;
    }

    private static Collection<Configuration> createExpressionsConfigurations() {
        ArrayList<Configuration> configurations = new ArrayList<Configuration>();
        BiConsumer<String, String> addExpressionTemplate = (name, template) -> configurations.add(PredefinedConfigurationUtil.createSearchTemplateInfo((String)name, (String)template, (String)EXPRESSIONS_CATEGORY, (FileType)PhpFileType.INSTANCE));
        addExpressionTemplate.accept("Assignment", "'_a = '_b");
        addExpressionTemplate.accept("Function call with 2 parameters", "'a('_p{2,2})");
        addExpressionTemplate.accept("Instance method call", "'_a->'_b()");
        addExpressionTemplate.accept("Static method call", "'_a::'_b()");
        addExpressionTemplate.accept("Field access", "'_a->'_b");
        addExpressionTemplate.accept("Constructor call", "new '_b()");
        addExpressionTemplate.accept("Instanceof", "'_a instanceof '_b");
        return configurations;
    }

    private static Collection<Configuration> createMiscConfigurations() {
        ArrayList<Configuration> configurations = new ArrayList<Configuration>();
        BiConsumer<String, String> addMiscTemplate = (name, template) -> configurations.add(PredefinedConfigurationUtil.createSearchTemplateInfo((String)name, (String)template, (String)SUSPICIOUS_CATEGORY, (FileType)PhpFileType.INSTANCE));
        addMiscTemplate.accept("Old style constructor", "class '_a{1,1} {function '_a()}");
        addMiscTemplate.accept("Empty 'if' statement", "if () {'_s{0,0}}");
        addMiscTemplate.accept("Explicit magic method call", "'_a->'_b:[regex( ^__.+$ )]()");
        addMiscTemplate.accept("Final method inside final class", "final class '_a {public final function 'b+()}");
        addMiscTemplate.accept("Assigning the return value of new by reference", "'_a = &new '_b");
        addMiscTemplate.accept("'parse_str(...)' call without second parameter", "parse_str('_a{0,1})");
        addMiscTemplate.accept("'fopen(...)' call without binary safe modifier", "fopen('_a, \"'_b:[!regex( ^.*b$ )]\", '_c{0,1}, '_d{0,1})");
        addMiscTemplate.accept("'error_reporting(...)' without predefined constant as argument", "error_reporting('_a:[!ref( \"define(\\''_b:[regex( E_STRICT|E_DEPRECATED|E_USER_DEPRECATED|E_RECOVERABLE_ERROR|E_STRICT|E_ALL )]\\', '_c) \" )])");
        return configurations;
    }
}

