/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.interpreters;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializer;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.commandLine.PhpCommandSettingsBuilder;
import com.jetbrains.php.config.interpreters.PhpConfigurationOptionData;
import com.jetbrains.php.config.interpreters.PhpInterpreterDecorator;
import com.jetbrains.php.config.interpreters.PhpLocalInterpreterDecorator;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpSdkAdditionalData
implements SdkAdditionalData {
    private static final String DEFAULT_NAME = "PHP";
    public static final String DEBUGGER_ID = "debugger_id";
    public static final String DEBUGGER_EXTENSION = "debugger_extension";
    public static final String CONFIGURATION_OPTIONS = "configuration_options";
    @Nullable
    private String myDebuggerId = "php.debugger.XDebug";
    @Nullable
    private String myDebuggerExtension = null;
    private String myInterpreterId;
    @NotNull
    protected List<PhpConfigurationOptionData> myConfigurationOptions = new ArrayList<PhpConfigurationOptionData>();

    @Nullable
    public String getDebuggerId() {
        return this.myDebuggerId;
    }

    public void setDebuggerId(@Nullable String debuggerId) {
        this.myDebuggerId = debuggerId;
    }

    @Nullable
    public String getDebuggerExtension() {
        return this.myDebuggerExtension;
    }

    public void setDebuggerExtension(@Nullable String debuggerExtension) {
        this.myDebuggerExtension = debuggerExtension;
    }

    @NotNull
    public String getInterpreterId() {
        String string = this.myInterpreterId;
        if (string == null) {
            PhpSdkAdditionalData.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void setInterpreterId(@Nullable String interpreterId) {
        this.myInterpreterId = interpreterId;
    }

    @NotNull
    public List<PhpConfigurationOptionData> getConfigurationOptions() {
        List<PhpConfigurationOptionData> list = PhpSdkAdditionalData.cloneConfigurationOptions(this.myConfigurationOptions);
        if (list == null) {
            PhpSdkAdditionalData.$$$reportNull$$$0(1);
        }
        return list;
    }

    public void setConfigurationOptions(@NotNull List<PhpConfigurationOptionData> configurationOptions) {
        if (configurationOptions == null) {
            PhpSdkAdditionalData.$$$reportNull$$$0(2);
        }
        this.myConfigurationOptions = PhpSdkAdditionalData.cloneConfigurationOptions(configurationOptions);
    }

    @NotNull
    public static List<PhpConfigurationOptionData> cloneConfigurationOptions(@NotNull List<? extends PhpConfigurationOptionData> configurationOptions) {
        List options;
        if (configurationOptions == null) {
            PhpSdkAdditionalData.$$$reportNull$$$0(3);
        }
        List list = (options = ContainerUtil.map(configurationOptions, PhpConfigurationOptionData.CLONE_FUNCTION)).isEmpty() ? ContainerUtil.newArrayList() : options;
        if (list == null) {
            PhpSdkAdditionalData.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    public String validate(@Nullable Project project, @Nullable JComponent parent) {
        return null;
    }

    @NotNull
    public PhpInterpreterDecorator getDecorator() {
        PhpLocalInterpreterDecorator phpLocalInterpreterDecorator = PhpLocalInterpreterDecorator.INSTANCE;
        if (phpLocalInterpreterDecorator == null) {
            PhpSdkAdditionalData.$$$reportNull$$$0(5);
        }
        return phpLocalInterpreterDecorator;
    }

    @Nullable
    public String getPathToExecutable(@Nullable String homePath) {
        try {
            return PhpCommandSettingsBuilder.findPhpBinary(homePath).getPresentableUrl();
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    @NotNull
    public String suggestName(@Nullable PhpInfo phpInfo) {
        PhpLanguageLevel level;
        if (phpInfo != null && (level = PhpLanguageLevel.parse(phpInfo)) != null) {
            String string = "PHP " + level.getPresentableName();
            if (string == null) {
                PhpSdkAdditionalData.$$$reportNull$$$0(6);
            }
            return string;
        }
        if (DEFAULT_NAME == null) {
            PhpSdkAdditionalData.$$$reportNull$$$0(7);
        }
        return DEFAULT_NAME;
    }

    public void save(@NotNull Element rootElement) {
        if (rootElement == null) {
            PhpSdkAdditionalData.$$$reportNull$$$0(8);
        }
        rootElement.setAttribute(DEBUGGER_ID, StringUtil.notNullize((String)this.getDebuggerId()));
        if (StringUtil.isNotEmpty((String)this.getDebuggerExtension())) {
            rootElement.setAttribute(DEBUGGER_EXTENSION, this.getDebuggerExtension());
        }
        if (!this.myConfigurationOptions.isEmpty()) {
            Element options = new Element(CONFIGURATION_OPTIONS);
            for (PhpConfigurationOptionData option : this.myConfigurationOptions) {
                Element element = XmlSerializer.serialize((Object)option);
                options.addContent(element);
            }
            rootElement.addContent(options);
        }
    }

    @NotNull
    public static PhpSdkAdditionalData load(@Nullable Element element) {
        PhpSdkAdditionalData data = new PhpSdkAdditionalData();
        PhpSdkAdditionalData.load(data, element);
        PhpSdkAdditionalData phpSdkAdditionalData = data;
        if (phpSdkAdditionalData == null) {
            PhpSdkAdditionalData.$$$reportNull$$$0(9);
        }
        return phpSdkAdditionalData;
    }

    protected static void load(@NotNull PhpSdkAdditionalData data, @Nullable Element element) {
        if (data == null) {
            PhpSdkAdditionalData.$$$reportNull$$$0(10);
        }
        if (element != null) {
            Element options;
            Attribute debugger;
            Attribute debuggerId = element.getAttribute(DEBUGGER_ID);
            if (debuggerId != null && StringUtil.isNotEmpty((String)debuggerId.getValue())) {
                data.setDebuggerId(debuggerId.getValue());
            }
            if ((debugger = element.getAttribute(DEBUGGER_EXTENSION)) != null && StringUtil.isNotEmpty((String)debugger.getValue())) {
                data.setDebuggerExtension(debugger.getValue());
            }
            if ((options = element.getChild(CONFIGURATION_OPTIONS)) != null) {
                ArrayList<PhpConfigurationOptionData> configurationOptions = new ArrayList<PhpConfigurationOptionData>();
                List children = options.getChildren();
                for (Element child : children) {
                    PhpConfigurationOptionData option = (PhpConfigurationOptionData)XmlSerializer.deserialize((Element)child, PhpConfigurationOptionData.class);
                    configurationOptions.add(option);
                }
                data.setConfigurationOptions(configurationOptions);
            }
        }
    }

    @NotNull
    public PhpSdkAdditionalData copy() {
        PhpSdkAdditionalData copy = new PhpSdkAdditionalData();
        this.copyTo(copy);
        PhpSdkAdditionalData phpSdkAdditionalData = copy;
        if (phpSdkAdditionalData == null) {
            PhpSdkAdditionalData.$$$reportNull$$$0(11);
        }
        return phpSdkAdditionalData;
    }

    protected void copyTo(@NotNull PhpSdkAdditionalData copy) {
        if (copy == null) {
            PhpSdkAdditionalData.$$$reportNull$$$0(12);
        }
        copy.setDebuggerId(this.getDebuggerId());
        copy.setDebuggerExtension(this.getDebuggerExtension());
        copy.setConfigurationOptions(this.getConfigurationOptions());
    }

    public String toPresentablePath() {
        return "local";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhpSdkAdditionalData data = (PhpSdkAdditionalData)o;
        if (!StringUtil.equals((CharSequence)this.myDebuggerId, (CharSequence)data.myDebuggerId)) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)this.myDebuggerExtension, (CharSequence)data.myDebuggerExtension)) {
            return false;
        }
        return this.myConfigurationOptions.equals(data.myConfigurationOptions);
    }

    public int hashCode() {
        int result = StringUtil.notNullize((String)this.myDebuggerId).hashCode();
        result += 31 * StringUtil.notNullize((String)this.myDebuggerExtension).hashCode();
        for (PhpConfigurationOptionData option : this.myConfigurationOptions) {
            result += 31 * result + option.hashCode();
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/interpreters/PhpSdkAdditionalData";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationOptions";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationOptions";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/interpreters/PhpSdkAdditionalData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneConfigurationOptions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDecorator";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setConfigurationOptions";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "cloneConfigurationOptions";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "copyTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

