/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang;

import com.intellij.ide.actions.OpenFileAction;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.actions.generation.PhpDocCreationOption;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocProperty;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.formatter.PhpFormatterUtil;
import com.jetbrains.php.lang.inspections.phpdoc.PhpDocCommentGenerator;
import com.jetbrains.php.lang.intentions.generators.PhpConstructorGenerator;
import com.jetbrains.php.lang.intentions.generators.PhpInvalidTemplateException;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpCodeUtil {
    public static final String PHP_OVERRIDDEN_METHOD_BODY = "PHP Overridden Method Body";
    public static final String PHP_IMPLEMENTED_METHOD_BODY = "PHP Implemented Method Body";
    public static final String FUNCTION_KEYWORD = "function";
    public static final String DEFAULT_GETTER_PREFIX = "get";
    public static final String DEFAULT_SETTER_PREFIX = "set";
    public static final String CALL_METHOD_NAME = "__call";
    public static final String NULL_CONST_NAME = "null";
    public static final String TRUE_CONST_NAME = "true";
    public static final String FALSE_CONST_NAME = "false";
    private static final Logger LOG = Logger.getInstance(PhpCodeUtil.class);
    public static final String MIXED_TYPE_HINT = "mixed";
    public static final String BOOL_TYPE_HINT = "bool";

    private PhpCodeUtil() {
    }

    public static String createOverridingMethodText(PhpClass targetClass, Method method, PhpDocCreationOption docCreationOption) {
        return PhpCodeUtil.createOverridingMethodText(targetClass, method, null, docCreationOption);
    }

    @NotNull
    public static String createOverridingMethodText(PhpClass targetClass, Method method, @Nullable String defaultBody, PhpDocCreationOption docCreationOption) {
        String string = PhpCodeUtil.createOverridingMethodText(targetClass, method, defaultBody, docCreationOption, null);
        if (string == null) {
            PhpCodeUtil.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public static String createOverridingMethodText(PhpClass targetClass, Method method, @Nullable String defaultBody, PhpDocCreationOption docCreationOption, @Nullable PhpDocComment docComment) {
        String constructorText;
        if (method.getMethodType(false) == Method.MethodType.CONSTRUCTOR && (constructorText = PhpCodeUtil.createOverridingConstructorText(targetClass, method, docCreationOption)) != null) {
            String string = constructorText;
            if (string == null) {
                PhpCodeUtil.$$$reportNull$$$0(1);
            }
            return string;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtil.notNullize((String)PhpCodeUtil.getCommentText(method, docCreationOption)));
        PhpCodeUtil.appendMethodSignature(method, targetClass, docComment, sb);
        PhpCodeUtil.appendMethodBody(method, defaultBody, sb);
        String string = sb.toString();
        if (string == null) {
            PhpCodeUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static void appendMethodSignature(Method method, PhpClass targetClass, @Nullable PhpDocComment docComment, StringBuilder sb) {
        PhpCodeUtil.appendModifiersExceptAbstract(method, sb);
        sb.append("function ");
        sb.append(method.getName());
        ParameterList parameterList = (ParameterList)PhpPsiUtil.getChildByCondition((PsiElement)method, (Condition<? super PsiElement>)ParameterList.INSTANCEOF);
        sb.append("(").append(PhpCodeUtil.getParametersText(parameterList, docComment)).append(")");
        PhpReturnType returnType = method.getReturnType();
        if (returnType != null) {
            sb.append(" : ");
            sb.append(PhpCodeUtil.getOverriddenReturnTypeText(returnType.getText(), method.getContainingClass(), targetClass));
        }
    }

    private static String getParametersText(@Nullable ParameterList parameterList, @Nullable PhpDocComment docComment) {
        if (parameterList == null) {
            return "";
        }
        if (docComment != null) {
            return parameterList.getText();
        }
        return StreamEx.of((Object[])parameterList.getParameters()).map(PhpCodeUtil::paramToString).joining((CharSequence)",");
    }

    private static String paramToString(@NotNull PsiElement parameter) {
        PhpType declaredType;
        if (parameter == null) {
            PhpCodeUtil.$$$reportNull$$$0(3);
        }
        if (parameter instanceof Parameter && !(declaredType = ((Parameter)parameter).getDeclaredType().globalLocationAware(parameter)).isEmpty()) {
            String relativizeType;
            boolean variadic = ((Parameter)parameter).isVariadic();
            boolean nullable = declaredType.unpluralize().getTypes().stream().anyMatch(PhpType::isNull);
            PhpType filteredType = declaredType.filterNull().filterMixed().filterUnknown();
            String type = PhpCodeUtil.convertPluralTypeForParameterTypeHint(filteredType, variadic);
            PhpPsiElement scope = PhpCodeInsightUtil.findScopeForUseOperator(parameter);
            String string = relativizeType = scope != null && type != null && PhpLangUtil.isFqn(type) ? PhpCodeInsightUtil.createQualifiedName(scope, type) : type;
            if (relativizeType != null) {
                return PhpCodeUtil.createParameterText((Parameter)parameter, relativizeType, variadic, nullable);
            }
        }
        return parameter.getText();
    }

    @NotNull
    private static String createParameterText(@NotNull Parameter parameter, @NotNull String type, boolean variadic, boolean nullable) {
        if (parameter == null) {
            PhpCodeUtil.$$$reportNull$$$0(4);
        }
        if (type == null) {
            PhpCodeUtil.$$$reportNull$$$0(5);
        }
        StringBuilder result = new StringBuilder();
        if (nullable && PhpProjectConfigurationFacade.getInstance(parameter.getProject()).getLanguageLevel().hasFeature(PhpLanguageFeature.NULLABLES)) {
            result.append("?");
        }
        result.append(type);
        result.append(" ");
        if (parameter.isPassByRef()) {
            result.append("&");
        }
        if (variadic) {
            result.append("...");
        }
        result.append("$").append(parameter.getName());
        PsiElement defaultValue = parameter.getDefaultValue();
        if (defaultValue != null) {
            result.append(" = ");
            result.append(defaultValue.getText());
        }
        String string = result.toString();
        if (string == null) {
            PhpCodeUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    private static String convertPluralTypeForParameterTypeHint(@NotNull PhpType type, boolean variadic) {
        String typeString;
        if (type == null) {
            PhpCodeUtil.$$$reportNull$$$0(7);
        }
        if ((typeString = (String)ContainerUtil.getFirstItem((Collection)type.getTypes())) != null && PhpType.isPluralType((String)typeString)) {
            if (variadic) {
                return (String)ContainerUtil.getFirstItem((Collection)type.unpluralize().getTypes());
            }
            return PhpType.ARRAY.toString();
        }
        return typeString;
    }

    @NotNull
    private static String getOverriddenReturnTypeText(@NotNull String returnType, @Nullable PhpClass containingClass, @NotNull PhpClass targetClass) {
        PhpPsiElement scope;
        if (returnType == null) {
            PhpCodeUtil.$$$reportNull$$$0(8);
        }
        if (targetClass == null) {
            PhpCodeUtil.$$$reportNull$$$0(9);
        }
        if (containingClass != null && (scope = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)targetClass)) != null) {
            PhpClass superClass;
            if ("self".equals(returnType)) {
                String string = PhpCodeInsightUtil.createQualifiedName(scope, containingClass.getFQN());
                if (string == null) {
                    PhpCodeUtil.$$$reportNull$$$0(10);
                }
                return string;
            }
            if ("parent".equals(returnType) && (superClass = containingClass.getSuperClass()) != null) {
                String string = PhpCodeInsightUtil.createQualifiedName(scope, superClass.getFQN());
                if (string == null) {
                    PhpCodeUtil.$$$reportNull$$$0(11);
                }
                return string;
            }
        }
        String string = returnType;
        if (string == null) {
            PhpCodeUtil.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static void appendModifiersExceptAbstract(Method method, StringBuilder sb) {
        PsiElement modifier;
        Object modifierList = PhpPsiUtil.getChildByCondition((PsiElement)method, (Condition<? super PsiElement>)PhpModifierList.INSTANCEOF);
        PsiElement psiElement = modifier = modifierList != null ? modifierList.getFirstChild() : null;
        while (modifier != null) {
            IElementType elementType = modifier.getNode().getElementType();
            if (PhpFormatterUtil.isModifier(elementType) && elementType != PhpTokenTypes.kwABSTACT) {
                sb.append(modifier.getText());
                sb.append(" ");
            }
            modifier = PhpPsiUtil.getNextSiblingIgnoreWhitespace(modifier, true);
        }
    }

    private static void appendMethodBody(Method method, @Nullable String defaultBody, StringBuilder sb) {
        sb.append("{");
        PhpClass containingClass = method.getContainingClass();
        if (!(method instanceof PhpDocMethod) && PhpPsiUtil.getChildOfType((PsiElement)method, PhpElementTypes.ANY_GROUP_STATEMENT) == null) {
            sb.append("\n ").append(PhpCodeUtil.getOverridingMethodBody(method, true, defaultBody));
        } else if (containingClass == null || !containingClass.isTrait()) {
            if (!(method.isAbstract() || containingClass != null && "\\___PHPSTORM_HELPERS\\object".equals(containingClass.getFQN()))) {
                sb.append("\n ").append(PhpCodeUtil.getOverridingMethodBody(method, false, defaultBody));
            } else {
                sb.append("\n ").append(PhpCodeUtil.getOverridingMethodBody(method, true, defaultBody));
            }
        }
        sb.append("\n}");
    }

    @Nullable
    private static String createOverridingConstructorText(@NotNull PhpClass targetClass, Method method, PhpDocCreationOption docOption) {
        if (targetClass == null) {
            PhpCodeUtil.$$$reportNull$$$0(13);
        }
        try {
            Pair<PhpDocComment, Method> result = new PhpConstructorGenerator(targetClass).withParameters(Arrays.asList(method.getParameters())).createConstructor();
            if (result != null) {
                StringBuilder sb = new StringBuilder();
                if (PhpDocCreationOption.DEFAULT.equals((Object)docOption)) {
                    if (result.first != null) {
                        sb.append(((PhpDocComment)result.first).getText()).append('\n');
                    }
                } else {
                    String constructorComment = PhpCodeUtil.getCommentText(method, docOption);
                    if (constructorComment != null) {
                        sb.append(constructorComment).append('\n');
                    }
                }
                sb.append(((Method)result.second).getText());
                return sb.toString();
            }
        }
        catch (PhpInvalidTemplateException e) {
            LOG.error("Invalid constructor template");
        }
        return null;
    }

    @Nullable
    private static String getCommentText(@NotNull Method method, PhpDocCreationOption option) {
        if (method == null) {
            PhpCodeUtil.$$$reportNull$$$0(14);
        }
        PhpDocComment comment = method.getDocComment();
        switch (option) {
            case NONE: {
                return null;
            }
            case INHERIT: {
                if (comment == null) break;
                return "/**\n @inheritDoc\n*/";
            }
            case COPY_IF_ABSTRACT: {
                if (!method.isAbstract()) break;
            }
            case COPY_ALWAYS: {
                if (comment == null) break;
                return comment.getText().replaceAll("\\n.*@abstract.*\\n", "\n");
            }
            case DEFAULT: {
                if (!method.isValid() || (comment = PhpDocCommentGenerator.constructDocComment(method.getProject(), (PsiElement)method, false)) == null) break;
                return comment.getText();
            }
        }
        return null;
    }

    private static String getOverridingMethodBody(Method method, boolean isImplementing, @Nullable String defaultBody) {
        if (defaultBody != null) {
            return defaultBody;
        }
        return PhpCodeUtil.getCodeTemplate(isImplementing ? PHP_IMPLEMENTED_METHOD_BODY : PHP_OVERRIDDEN_METHOD_BODY, PhpCodeUtil.getOverridingMethodAttributes(method), method.getProject());
    }

    private static Properties getOverridingMethodAttributes(Method method) {
        Properties attributes = new Properties();
        StringBuilder paramList = new StringBuilder();
        Parameter[] params = method.getParameters();
        for (int i = 0; i < params.length; ++i) {
            paramList.append("$").append(params[i].getName());
            if (i >= params.length - 1) continue;
            paramList.append(',');
        }
        attributes.setProperty("NAME", method.getName());
        attributes.setProperty("PARAM_LIST", paramList.toString());
        attributes.setProperty("RETURN", PhpCodeUtil.containsElement((PsiElement)method, PhpElementTypes.RETURN) ? "return" : "");
        return attributes;
    }

    private static boolean containsElement(PsiElement parent, IElementType eType) {
        for (PsiElement currChild = parent.getFirstChild(); currChild != null; currChild = currChild.getNextSibling()) {
            if (!PhpPsiUtil.isOfType(currChild, eType) && !PhpCodeUtil.containsElement(currChild, eType)) continue;
            return true;
        }
        return false;
    }

    public static boolean belongsTo(PsiElement element, PsiElement parent) {
        PsiElement currParent = element;
        while ((currParent = currParent.getParent()) != null) {
            if (currParent != parent) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static Method createMethodFromTemplate(PhpClass phpClass, Project p, String template) {
        return PhpCodeUtil.createMethodFromTemplate(p, phpClass.isInterface(), template);
    }

    @Nullable
    public static Method createMethodFromTemplate(Project p, boolean isInterface, String template) {
        String classKeyword = isInterface ? "interface" : "class";
        String classTemplate = classKeyword + " c { " + template + "}";
        return PhpPsiElementFactory.createFromText(p, Method.class, classTemplate);
    }

    @Nullable
    public static PhpClass createClassFromMethodTemplate(PhpClass phpClass, Project p, String template) {
        String classKeyword = phpClass.isInterface() ? "interface" : "class";
        String classTemplate = classKeyword + " c { " + template + "}";
        return PhpPsiElementFactory.createFromText(p, PhpClass.class, classTemplate);
    }

    public static String camelCaps(String str) {
        StringBuilder strBuf = new StringBuilder();
        boolean capitalize = true;
        for (char c : str.toCharArray()) {
            if (c == '_') {
                capitalize = true;
                continue;
            }
            if (capitalize) {
                strBuf.append(String.valueOf(c).toUpperCase());
                capitalize = false;
                continue;
            }
            strBuf.append(c);
        }
        return strBuf.toString();
    }

    public static String getCodeTemplate(String templateName, @Nullable Properties attributes, Project project) {
        FileTemplate fileTemplate = FileTemplateManager.getInstance((Project)project).getCodeTemplate(templateName);
        if (attributes == null) {
            return fileTemplate.getText();
        }
        try {
            return fileTemplate.getText(attributes);
        }
        catch (IOException e) {
            return fileTemplate.getText();
        }
    }

    @NotNull
    public static String getTypeHint(@NotNull Field field, @Nullable PhpPsiElement scopeForUseOperator) {
        if (field == null) {
            PhpCodeUtil.$$$reportNull$$$0(15);
        }
        PhpDocComment docComment = field.getDocComment();
        String typeHint = null;
        if (docComment != null && !(field instanceof PhpDocProperty)) {
            PhpDocParamTag varTag = docComment.getVarTag();
            if (varTag != null) {
                typeHint = PhpDocUtil.getTypePresentation(varTag.getProject(), varTag.getType(), scopeForUseOperator);
            }
        } else {
            typeHint = PhpDocUtil.getTypePresentation(field.getProject(), field.getType(), scopeForUseOperator);
        }
        if (typeHint == null || typeHint.isEmpty()) {
            typeHint = MIXED_TYPE_HINT;
        }
        String string = typeHint;
        if (string == null) {
            PhpCodeUtil.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Nullable
    public static String getVarDocComment(PsiElement target, Project project, @NotNull String typeTag) {
        if (typeTag == null) {
            PhpCodeUtil.$$$reportNull$$$0(17);
        }
        if (target == null || target.getNode() == null) {
            return null;
        }
        StringBuilder commentBuf = new StringBuilder();
        commentBuf.append(typeTag);
        if (PhpPsiUtil.isOfType(target, PhpElementTypes.CLASS_FIELDS, PhpElementTypes.CLASS_CONSTANTS)) {
            Field field = (Field)PsiTreeUtil.getChildOfType((PsiElement)target, Field.class);
            if (field == null) {
                return null;
            }
            PhpType type = PhpDocCommentGenerator.globalPreserving$This(field.getType(), (PsiElement)field);
            String fieldType = PhpDocUtil.getTypePresentation(project, type, PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)field));
            if (!fieldType.isEmpty()) {
                commentBuf.append(' ').append(fieldType);
            }
        } else {
            Statement expr;
            if (target instanceof GroupStatement) {
                expr = (Statement)PsiTreeUtil.getChildOfType((PsiElement)target, Statement.class);
                if (expr == null) {
                    return null;
                }
            } else if (target instanceof Statement) {
                expr = (Statement)target;
            } else {
                return null;
            }
            if (expr instanceof ForeachStatement) {
                List<PsiElement> declarations = PhpPsiUtil.getChildren((PsiElement)expr, (Condition<? super PsiElement>)((Condition)element -> element instanceof Variable && ((Variable)element).isDeclaration()));
                if (!declarations.isEmpty()) {
                    if (declarations.size() == 1) {
                        PsiReference ref;
                        PsiElement variable = declarations.get(0);
                        if (variable == null || (ref = variable.getReference()) == null) {
                            return null;
                        }
                        commentBuf.append("  ").append(ref.getCanonicalText());
                    } else {
                        boolean isFirst = true;
                        commentBuf.insert(0, "\n* ");
                        for (PsiElement variable : declarations) {
                            PsiReference ref;
                            if (!isFirst) {
                                commentBuf.append("\n* ");
                                commentBuf.append(typeTag);
                            }
                            if (variable == null || (ref = variable.getReference()) == null) {
                                return null;
                            }
                            commentBuf.append("  ").append(ref.getCanonicalText());
                            isFirst = false;
                        }
                    }
                }
            } else {
                PsiReference ref;
                PhpPsiElement assignment = expr.getFirstPsiChild();
                if (assignment == null || !PhpPsiUtil.isOfType((PsiElement)assignment, PhpElementTypes.ASSIGNMENT_EXPRESSION)) {
                    return null;
                }
                PhpPsiElement variable = ((AssignmentExpression)assignment).getVariable();
                if (variable == null || (ref = variable.getReference()) == null) {
                    return null;
                }
                commentBuf.append("  ").append(ref.getCanonicalText());
            }
        }
        return commentBuf.toString();
    }

    public static void openRelatedFile(Project project, PsiElement element) {
        VirtualFile file = element.getContainingFile().getVirtualFile();
        assert (file != null);
        OpenFileAction.openFile((String)file.getPath(), (Project)project);
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (!ApplicationManager.getApplication().isUnitTestMode()) assert (editor != null);
        if (editor != null) {
            editor.getCaretModel().moveToOffset(element.getTextOffset());
            editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        }
    }

    public static boolean isImplemented(@Nullable PhpClass phpClass, @NotNull Method target) {
        if (target == null) {
            PhpCodeUtil.$$$reportNull$$$0(18);
        }
        if (phpClass == null || phpClass.isInterface() || PhpLangUtil.isObject(phpClass)) {
            return false;
        }
        Method method = phpClass.findMethodByName((CharSequence)target.getName());
        return method != null && !method.isAbstract();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/PhpCodeUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeTag";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createOverridingMethodText";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/PhpCodeUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameterText";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getOverriddenReturnTypeText";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeHint";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "paramToString";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createParameterText";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "convertPluralTypeForParameterTypeHint";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getOverriddenReturnTypeText";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createOverridingConstructorText";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getCommentText";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTypeHint";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getVarDocComment";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isImplemented";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

