/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureProcessor;
import com.jetbrains.php.refactoring.changeSignature.PhpMethodDescriptor;
import com.jetbrains.php.refactoring.changeSignature.PhpParameterInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpRemoveParametersQuickFix
implements LocalQuickFix {
    @Nls
    @NotNull
    public String getName() {
        if ("Remove unused parameter" == null) {
            PhpRemoveParametersQuickFix.$$$reportNull$$$0(0);
        }
        return "Remove unused parameter";
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            PhpRemoveParametersQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            PhpRemoveParametersQuickFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            PhpRemoveParametersQuickFix.$$$reportNull$$$0(3);
        }
        Parameter parameter = (Parameter)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), Parameter.class);
        Function function = (Function)PsiTreeUtil.getParentOfType((PsiElement)parameter, Function.class);
        if (parameter != null && function != null) {
            this.removeParameters(function, ContainerUtil.set((Object[])new Parameter[]{parameter}));
        }
    }

    protected void removeParameters(@NotNull Function function, @NotNull Set<Parameter> parametersToDelete) {
        if (function == null) {
            PhpRemoveParametersQuickFix.$$$reportNull$$$0(4);
        }
        if (parametersToDelete == null) {
            PhpRemoveParametersQuickFix.$$$reportNull$$$0(5);
        }
        Parameter[] oldParameters = function.getParameters();
        ArrayList<PhpParameterInfo> infos = new ArrayList<PhpParameterInfo>(oldParameters.length - 1);
        for (int i = 0; i < oldParameters.length; ++i) {
            if (parametersToDelete.contains(oldParameters[i])) continue;
            infos.add(new PhpParameterInfo(i, oldParameters[i]));
        }
        new PhpChangeSignatureProcessor(function.getProject(), new PhpMethodDescriptor(function), new PhpMethodDescriptor(function).getVisibility(), function.getName(), PhpRemoveParametersQuickFix.getReturnType(function), (PhpParameterInfo[])ContainerUtil.toArray(infos, PhpParameterInfo[]::new), Collections.emptySet(), false).run();
    }

    @Nullable
    private static String getReturnType(@NotNull Function function) {
        PhpReturnType returnType;
        if (function == null) {
            PhpRemoveParametersQuickFix.$$$reportNull$$$0(6);
        }
        return (returnType = function.getReturnType()) != null ? returnType.getText() : null;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/PhpRemoveParametersQuickFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersToDelete";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/PhpRemoveParametersQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeParameters";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

