/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.parser.parsing.statements;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpParserErrors;
import com.jetbrains.php.lang.parser.PhpPsiBuilder;
import com.jetbrains.php.lang.parser.parsing.Statement;
import com.jetbrains.php.lang.parser.parsing.StatementList;
import com.jetbrains.php.lang.parser.parsing.calls.Variable;
import com.jetbrains.php.lang.parser.parsing.expressions.AssignmentExpression;
import com.jetbrains.php.lang.parser.parsing.expressions.Expression;
import com.jetbrains.php.lang.parser.parsing.functions.IsReference;

public class ForeachStatement {
    public static final TokenSet ENDFOREACH = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.kwENDFOREACH});

    public static IElementType parse(PhpPsiBuilder builder) {
        if (!builder.compare(PhpTokenTypes.kwFOREACH)) {
            return PhpElementTypes.EMPTY_INPUT;
        }
        PsiBuilder.Marker foreach = builder.mark();
        builder.advanceLexer();
        builder.match(PhpTokenTypes.chLPAREN);
        Expression.parse(builder);
        builder.match(PhpTokenTypes.kwAS);
        if (builder.compareAndEat(PhpTokenTypes.kwLIST)) {
            builder.match(PhpTokenTypes.chLPAREN);
            AssignmentExpression.parseAssignmentList(builder);
            builder.match(PhpTokenTypes.chRPAREN);
        } else if (builder.compareAndEat(PhpTokenTypes.chLBRACKET)) {
            AssignmentExpression.parseAssignmentList(builder);
            builder.match(PhpTokenTypes.chRBRACKET);
        } else {
            ForeachStatement.parseForeachVariable(builder);
            if (builder.compareAndEat(PhpTokenTypes.opHASH_ARRAY)) {
                if (builder.compareAndEat(PhpTokenTypes.kwLIST)) {
                    builder.match(PhpTokenTypes.chLPAREN);
                    AssignmentExpression.parseAssignmentList(builder);
                    builder.match(PhpTokenTypes.chRPAREN);
                } else if (builder.compareAndEat(PhpTokenTypes.chLBRACKET)) {
                    AssignmentExpression.parseAssignmentList(builder);
                    builder.match(PhpTokenTypes.chRBRACKET);
                } else {
                    ForeachStatement.parseForeachVariable(builder);
                }
            }
        }
        builder.match(PhpTokenTypes.chRPAREN);
        ForeachStatement.parseForeachStatement(builder);
        foreach.done(PhpElementTypes.FOREACH);
        return PhpElementTypes.FOREACH;
    }

    private static void parseForeachStatement(PhpPsiBuilder builder) {
        if (builder.compareAndEat(PhpTokenTypes.opCOLON)) {
            StatementList.parseAccurate(builder, ENDFOREACH);
            builder.match(PhpTokenTypes.kwENDFOREACH);
            if (!builder.compare(PhpTokenTypes.PHP_CLOSING_TAG)) {
                builder.match(PhpTokenTypes.opSEMICOLON);
            }
        } else {
            Statement.parse(builder);
        }
    }

    private static void parseForeachVariable(PhpPsiBuilder builder) {
        IsReference.parse(builder);
        PsiBuilder.Marker variable = builder.mark();
        IElementType result = Variable.parse(builder);
        if (result == PhpElementTypes.EMPTY_INPUT) {
            builder.error(PhpParserErrors.expected("variable"));
        }
        variable.done(result);
    }
}

