/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpClassMemberIconProvider;
import com.jetbrains.php.PhpPresentationUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpNamedElementImpl;
import com.jetbrains.php.lang.psi.stubs.PhpFieldStub;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldImpl
extends PhpNamedElementImpl<PhpFieldStub>
implements Field,
StubBasedPsiElement<PhpFieldStub> {
    private static final TokenSet NN = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.VARIABLE, PhpTokenTypes.IDENTIFIER}), PhpTokenTypes.tsKEYWORDS});

    public FieldImpl(ASTNode node) {
        super(node);
    }

    public FieldImpl(PhpFieldStub stub, IStubElementType type) {
        super(stub, type);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            FieldImpl.$$$reportNull$$$0(0);
        }
        if (visitor instanceof PhpElementVisitor) {
            ((PhpElementVisitor)visitor).visitPhpField((Field)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return PhpClassMemberIconProvider.getFieldIcon(this);
    }

    @Override
    @Nullable
    public ItemPresentation getPresentation() {
        return PhpPresentationUtil.getFieldPresentation(this);
    }

    @Override
    @NotNull
    public String getName() {
        String name = super.getName();
        String string = name.charAt(0) == '$' ? name.substring(1) : name;
        if (string == null) {
            FieldImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public CharSequence getNameCS() {
        CharSequence name = super.getNameCS();
        CharSequence charSequence = name.length() > 0 ? (name.charAt(0) == '$' ? name.subSequence(1, name.length()) : name) : "";
        if (charSequence == null) {
            FieldImpl.$$$reportNull$$$0(2);
        }
        return charSequence;
    }

    @Override
    @Nullable
    public ASTNode getNameNode() {
        return this.getNode().findChildByType(NN);
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        ASTNode nameNode;
        if (name == null) {
            FieldImpl.$$$reportNull$$$0(3);
        }
        if ((nameNode = this.getNameNode()) != null && !name.equals(this.getName())) {
            ASTNode node;
            ASTNode aSTNode = node = this.isConstant() ? PhpPsiElementFactory.createClassConstantReferenceUsingSelf(this.getProject(), name).getNameNode() : PhpPsiElementFactory.createVariable(this.getProject(), name, true).getNameNode();
            if (node != null) {
                nameNode.getTreeParent().replaceChild(nameNode, node);
            }
        }
        return this;
    }

    @NotNull
    public PhpModifier getModifier() {
        PhpModifier.State state = PhpModifier.State.DYNAMIC;
        PhpModifier.Access access = PhpModifier.Access.PUBLIC;
        PhpFieldStub fieldStub = (PhpFieldStub)this.getGreenStub();
        if (fieldStub != null) {
            if (fieldStub.isPrivate()) {
                access = PhpModifier.Access.PRIVATE;
            }
            if (fieldStub.isProtected()) {
                access = PhpModifier.Access.PROTECTED;
            }
            if (fieldStub.isStatic()) {
                state = PhpModifier.State.STATIC;
            }
        } else {
            PhpPsiElement element = ((PhpPsiElement)this.getParent()).getFirstPsiChild();
            if (PhpPsiUtil.isOfType((PsiElement)element, PhpElementTypes.MODIFIER_LIST)) {
                ASTNode[] nodes;
                for (ASTNode node : nodes = element.getNode().getChildren(PhpTokenTypes.tsVARIABLE_MODIFIERS)) {
                    if (node.getElementType() == PhpTokenTypes.kwPRIVATE) {
                        access = PhpModifier.Access.PRIVATE;
                        continue;
                    }
                    if (node.getElementType() == PhpTokenTypes.kwPROTECTED) {
                        access = PhpModifier.Access.PROTECTED;
                        continue;
                    }
                    if (node.getElementType() == PhpTokenTypes.kwPUBLIC || node.getElementType() == PhpTokenTypes.kwVAR) {
                        access = PhpModifier.Access.PUBLIC;
                        continue;
                    }
                    if (node.getElementType() != PhpTokenTypes.kwSTATIC) continue;
                    state = PhpModifier.State.STATIC;
                }
            }
        }
        if (this.isConstant()) {
            state = PhpModifier.State.STATIC;
        }
        PhpModifier phpModifier = PhpModifier.instance((PhpModifier.Access)access, (PhpModifier.Abstractness)PhpModifier.Abstractness.IMPLEMENTED, (PhpModifier.State)state);
        if (phpModifier == null) {
            FieldImpl.$$$reportNull$$$0(4);
        }
        return phpModifier;
    }

    public boolean isConstant() {
        return false;
    }

    @Nullable
    public PsiElement getDefaultValue() {
        return this.getLastChild();
    }

    @Nullable
    public String getDefaultValuePresentation() {
        return null;
    }

    @Override
    @Nullable
    public PhpDocComment getDocComment() {
        return PhpPsiUtil.getDocCommentFor(this, (NullableFunction<? super PhpPsiElement, ? extends PhpPsiElement>)((NullableFunction)element -> (PhpPsiElement)ObjectUtils.tryCast((Object)element.getParent(), PhpPsiElement.class)));
    }

    @Nullable
    public PhpClass getContainingClass() {
        return (PhpClass)this.getStubOrPsiParentOfType(PhpClass.class);
    }

    public boolean isWriteAccess() {
        return true;
    }

    @Override
    @NotNull
    public String getFQN() {
        PhpClass containingClass = this.getContainingClass();
        String string = containingClass != null ? containingClass.getFQN() + "." + (this.isConstant() ? "" : "$") + this.getName() : "";
        if (string == null) {
            FieldImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static Set<? extends PhpNamedElement> collectFieldDeclarations(@NotNull PhpPsiElement point) {
        if (point == null) {
            FieldImpl.$$$reportNull$$$0(6);
        }
        return FieldImpl.getCollectDeclarations(point, false);
    }

    private static Set<? extends PhpNamedElement> getCollectDeclarations(PhpPsiElement point, final boolean constants) {
        PhpClass parent = PhpClassImpl.getContainingClass(point);
        if (parent == null) {
            return Collections.emptySet();
        }
        THashSet fieldSet = new THashSet();
        parent.acceptChildren((PsiElementVisitor)new PhpRecursiveElementVisitor((Set)fieldSet){
            final /* synthetic */ Set val$fieldSet;
            {
                this.val$fieldSet = set;
            }

            public void visitPhpField(Field field) {
                if (constants == field.isConstant()) {
                    this.val$fieldSet.add(field);
                }
            }

            public void visitPhpFunction(Function function) {
            }

            public void visitPhpMethod(Method method) {
            }
        });
        return fieldSet;
    }

    public static Set<? extends PhpNamedElement> collectClassConstDeclarations(@NotNull PhpPsiElement point) {
        if (point == null) {
            FieldImpl.$$$reportNull$$$0(7);
        }
        return FieldImpl.getCollectDeclarations(point, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/FieldImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/FieldImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameCS";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifier";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFQN";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectFieldDeclarations";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectClassConstDeclarations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

