/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.navigation;

import com.intellij.navigation.GotoClassContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.classAlias.PhpClassAliasIndex;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpCaseSensitiveConstantIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpClassAliasNameIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpClassConstantIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpClassIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpClassNameIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpConstantIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpConstantNameIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFieldIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFunctionIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFunctionNameIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpInterfaceIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpMethodIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpMethodNameIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpTraitIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpUseIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpVariableIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpVariableNameIndex;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpGoToSymbolContributor
implements GotoClassContributor {
    @NotNull
    public String[] getNames(Project project, boolean includeNonProjectItems) {
        ArrayList names = ContainerUtil.newArrayListWithCapacity((int)20000);
        FileBasedIndex index = FileBasedIndex.getInstance();
        names.addAll(index.getAllKeys(PhpClassNameIndex.KEY, project));
        names.addAll(index.getAllKeys(PhpMethodNameIndex.KEY, project));
        names.addAll(index.getAllKeys(PhpFunctionNameIndex.KEY, project));
        names.addAll(index.getAllKeys(PhpVariableNameIndex.KEY, project));
        names.addAll(index.getAllKeys(PhpConstantNameIndex.KEY, project));
        names.addAll(index.getAllKeys(PhpClassAliasNameIndex.KEY, project));
        StubIndex.getInstance().processAllKeys(PhpUseIndex.KEY, project, Processors.cancelableCollectProcessor((Collection)names));
        StubIndex.getInstance().processAllKeys(PhpFieldIndex.KEY, project, Processors.cancelableCollectProcessor((Collection)names));
        StubIndex.getInstance().processAllKeys(PhpClassConstantIndex.KEY, project, Processors.cancelableCollectProcessor((Collection)names));
        String[] stringArray = ArrayUtil.toStringArray((Collection)names);
        if (stringArray == null) {
            PhpGoToSymbolContributor.$$$reportNull$$$0(0);
        }
        return stringArray;
    }

    @NotNull
    public NavigationItem[] getItemsByName(@NonNls String name, String pattern, Project project, boolean includeNonProjectItems) {
        GlobalSearchScope scope = includeNonProjectItems ? PhpIndex.getInstance((Project)project).getSearchScope() : GlobalSearchScope.projectScope((Project)project);
        ArrayList items = new ArrayList();
        String lowercasedName = name.toLowerCase();
        items.addAll(StubIndex.getElements(PhpUseIndex.KEY, (Object)lowercasedName, (Project)project, (GlobalSearchScope)scope, PhpUse.class));
        items.addAll(StubIndex.getElements(PhpConstantIndex.KEY, (Object)lowercasedName, (Project)project, (GlobalSearchScope)scope, Constant.class));
        items.addAll(StubIndex.getElements(PhpCaseSensitiveConstantIndex.KEY, (Object)name, (Project)project, (GlobalSearchScope)scope, Constant.class));
        items.addAll(StubIndex.getElements(PhpFunctionIndex.KEY, (Object)lowercasedName, (Project)project, (GlobalSearchScope)scope, Function.class));
        items.addAll(StubIndex.getElements(PhpClassIndex.KEY, (Object)lowercasedName, (Project)project, (GlobalSearchScope)scope, PhpClass.class));
        items.addAll(StubIndex.getElements(PhpInterfaceIndex.KEY, (Object)lowercasedName, (Project)project, (GlobalSearchScope)scope, PhpClass.class));
        items.addAll(StubIndex.getElements(PhpTraitIndex.KEY, (Object)lowercasedName, (Project)project, (GlobalSearchScope)scope, PhpClass.class));
        items.addAll(StubIndex.getElements(PhpMethodIndex.KEY, (Object)lowercasedName, (Project)project, (GlobalSearchScope)scope, Method.class));
        items.addAll(StubIndex.getElements(PhpFieldIndex.KEY, (Object)name, (Project)project, (GlobalSearchScope)scope, Field.class));
        items.addAll(StubIndex.getElements(PhpClassConstantIndex.KEY, (Object)name, (Project)project, (GlobalSearchScope)scope, Field.class));
        items.addAll(StubIndex.getElements(PhpVariableIndex.KEY, (Object)name, (Project)project, (GlobalSearchScope)scope, Variable.class));
        items.addAll(PhpClassAliasIndex.getInstance((Project)project).getAliasesByName(name, null, scope));
        NavigationItem[] navigationItemArray = items.toArray(NavigationItem.EMPTY_NAVIGATION_ITEM_ARRAY);
        if (navigationItemArray == null) {
            PhpGoToSymbolContributor.$$$reportNull$$$0(1);
        }
        return navigationItemArray;
    }

    @Nullable
    public String getQualifiedName(NavigationItem item) {
        if (item instanceof PhpClass) {
            PhpClass phpClass = (PhpClass)item;
            return phpClass.getFQN();
        }
        if (item instanceof Function) {
            return ((Function)item).getFQN();
        }
        if (item instanceof Field) {
            return ((Field)item).getFQN();
        }
        return null;
    }

    @Nullable
    public String getQualifiedNameSeparator() {
        return "\\";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/php/navigation/PhpGoToSymbolContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNames";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemsByName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

