/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit.codeGeneration;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.actions.PhpBaseNewClassDialog;
import com.jetbrains.php.actions.PhpNewFileDialog;
import com.jetbrains.php.completion.PhpCompletionUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.phpunit.codeGeneration.PhpTestCreator;
import com.jetbrains.php.refactoring.PhpMemberInfo;
import com.jetbrains.php.refactoring.ui.PhpMemberSelectionPanel;
import com.jetbrains.php.roots.PhpNamespaceCompositeProvider;
import com.jetbrains.php.roots.PhpNamespaceProvider;
import com.jetbrains.php.roots.ui.PhpNamespaceComboBox;
import com.jetbrains.php.roots.ui.PhpPsrDirectoryComboBox;
import com.jetbrains.php.testFramework.PhpTestCreateInfo;
import com.jetbrains.php.testFramework.PhpTestFrameworkType;
import com.jetbrains.php.ui.PhpUiUtil;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Function;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpNewTestDialog
extends PhpBaseNewClassDialog {
    private static final String DEFAULT_LIBRARY_NAME_PROPERTY = PhpNewTestDialog.class.getName() + ".defaultLibrary";
    private JPanel myMainPanel;
    private EditorTextField myNameTextField;
    private PhpNamespaceComboBox myNamespaceCombobox;
    private EditorTextField myFileNameTextField;
    private EditorTextField myTestTargetTextField;
    private JBLabel myNamespaceCompletionHintLabel;
    private JBLabel myTestTargetCompletionHintLabel;
    private PhpPsrDirectoryComboBox myDirectoryCombobox;
    private JBLabel myEditDirectoryHintLabel;
    private JPanel myLibrariesComboWrapper;
    private JBLabel myLibrariesLabel;
    private JBLabel myLibrariesUpDownHint;
    private JPanel myMethodsTableWrapper;
    private ComboBox<String> myTestTargetFileCombo;
    private JPanel myTestTargetPanel;
    private JBCheckBox myShowInheritedMembersCheckBox;
    private JBLabel myMethodsPanelLabel;
    private final PhpMemberSelectionPanel myMethodsPanel;
    private final ComboBox<PhpTestCreateInfo> myLibrariesCombo;
    private boolean myTestTargetTextChanged;
    @Nullable
    private final String mySelectedElementName;
    private boolean myLibraryChanged;
    private boolean myTestMethodSelectedOnInit;

    public PhpNewTestDialog(final @NotNull Project project, @Nullable PsiDirectory directory, final @Nullable PsiFile file, @Nullable PhpTestCreateInfo defaultTestCreateInfo, final @Nullable PhpNamedElement selectedElement) {
        if (project == null) {
            PhpNewTestDialog.$$$reportNull$$$0(0);
        }
        super(project, directory);
        this.$$$setupUI$$$();
        this.myMethodsPanel = new PhpMemberSelectionPanel(null, Collections.emptyList(), null);
        this.myLibrariesCombo = new ComboBox(new DefaultComboBoxModel());
        this.init(this.myMainPanel, this.myNameTextField, this.myNamespaceCombobox, this.myNamespaceCompletionHintLabel, this.myFileNameTextField, this.myDirectoryCombobox, this.myEditDirectoryHintLabel);
        this.initTestLibraryCombo(project, defaultTestCreateInfo);
        this.myTestTargetTextField.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                PhpNewTestDialog.this.addUpdateRequest(() -> {
                    String text;
                    if (project == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (!StringUtil.isEmpty((String)(text = PhpNewTestDialog.this.myTestTargetTextField.getText())) && !StringUtil.endsWith((CharSequence)text, (CharSequence)"\\")) {
                        PhpIndex instance = PhpIndex.getInstance((Project)PhpNewTestDialog.this.getProject());
                        Collection classes = instance.getAnyByFQN(text);
                        if (!classes.isEmpty()) {
                            PhpNewTestDialog.this.updateTestNameAndNamespaces(project, text);
                        }
                        PhpNewTestDialog.this.myTestTargetFileCombo.removeAllItems();
                        for (PhpClass aClass : classes) {
                            PhpNewTestDialog.this.myTestTargetFileCombo.addItem((Object)PhpNewTestDialog.getFilePath(aClass));
                        }
                        if (!PhpNewTestDialog.this.myTestTargetTextChanged && file != null) {
                            PhpNewTestDialog.this.myTestTargetFileCombo.setSelectedItem((Object)file.getVirtualFile().getPath());
                        }
                        PhpNewTestDialog.this.myTestTargetFileCombo.setEnabled(classes.size() > 1);
                        PhpNewTestDialog.this.reloadMemberSelectionPanel(project, selectedElement);
                        PhpNewTestDialog.this.myTestTargetTextChanged = true;
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/phpunit/codeGeneration/PhpNewTestDialog$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "documentChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$documentChanged$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        PhpCompletionUtil.installClassCompletion(this.myTestTargetTextField, null, this.getDisposable(), (Condition<? super PhpClass>)((Condition)clazz -> this.getSelectedTestCreateInfo().canCreateTestFor((PhpClass)clazz)), new String[0]);
        this.myTestTargetCompletionHintLabel.setText(PhpBundle.message("0.completion.shortcut", "class reference", PhpUiUtil.getShortcutTextByActionName("CodeCompletion")));
        this.addUpdateRequest(() -> {
            PhpClass targetElement = PhpNewTestDialog.getTargetClass(file, (PsiElement)selectedElement);
            if (targetElement != null) {
                String fqn = targetElement.getFQN();
                this.myTestTargetTextField.setText(PhpLangUtil.toName(fqn));
                return;
            }
            this.myNameTextField.setText(this.getSelectedTestCreateInfo().getDefaultTestName(""));
            Editor editor = this.myNameTextField.getEditor();
            if (editor != null) {
                editor.getCaretModel().moveToOffset(0);
            }
        });
        this.myTestTargetPanel.setVisible(selectedElement == null);
        this.myTestTargetFileCombo.addItemListener(e -> {
            if (project == null) {
                PhpNewTestDialog.$$$reportNull$$$0(28);
            }
            this.reloadMemberSelectionPanel(project, selectedElement);
        });
        this.myMethodsTableWrapper.add(this.myMethodsPanel);
        this.myMethodsPanelLabel.setLabelFor((Component)this.myMethodsPanel);
        this.myShowInheritedMembersCheckBox.addActionListener(e -> {
            if (project == null) {
                PhpNewTestDialog.$$$reportNull$$$0(27);
            }
            this.reloadMemberSelectionPanel(project, selectedElement);
        });
        this.mySelectedElementName = PhpNewTestDialog.getElementName(selectedElement);
        this.init();
    }

    public boolean isLibraryChanged() {
        return this.myLibraryChanged;
    }

    @Nullable
    private static String getElementName(@Nullable PhpNamedElement selectedElement) {
        if (selectedElement == null) {
            return null;
        }
        if (selectedElement instanceof Method) {
            PhpClass containingClass = ((Method)selectedElement).getContainingClass();
            return containingClass != null ? containingClass.getName() : null;
        }
        return selectedElement.getName();
    }

    @Nullable
    private static PhpClass getTargetClass(@Nullable PsiFile file, @Nullable PsiElement selectedElement) {
        if (selectedElement instanceof PhpClass) {
            return (PhpClass)selectedElement;
        }
        if (selectedElement instanceof Method) {
            return ((Method)selectedElement).getContainingClass();
        }
        return PhpTestCreator.findClass(file);
    }

    private void reloadMemberSelectionPanel(@NotNull Project project, @Nullable PhpNamedElement selectedMethod) {
        if (project == null) {
            PhpNewTestDialog.$$$reportNull$$$0(1);
        }
        Set<PhpClassMember> selectedMembers = this.getSelectedClassMembers();
        List<PhpMemberInfo> classMembersInfos = this.getClassMembersInfo(project, this.isInheritedMembersOptionSelected());
        classMembersInfos.forEach(info -> info.setChecked(selectedMembers.contains(info.getMember())));
        this.checkMethodSelectedOnInit(selectedMethod, classMembersInfos);
        this.myMethodsPanel.getTable().setMemberInfos(classMembersInfos);
    }

    private void checkMethodSelectedOnInit(@Nullable PhpNamedElement methodSelectedOnInit, @NotNull List<PhpMemberInfo> classMembersInfos) {
        PhpMemberInfo memberInfoForInit;
        if (classMembersInfos == null) {
            PhpNewTestDialog.$$$reportNull$$$0(2);
        }
        if (!this.myTestMethodSelectedOnInit && methodSelectedOnInit instanceof Method && (memberInfoForInit = (PhpMemberInfo)ContainerUtil.find(classMembersInfos, info -> info.getMember() == methodSelectedOnInit)) != null) {
            memberInfoForInit.setChecked(true);
            this.myTestMethodSelectedOnInit = true;
        }
    }

    public boolean isInheritedMembersOptionSelected() {
        return this.myShowInheritedMembersCheckBox.isSelected();
    }

    @Nullable
    private String getDefaultLibraryName() {
        return PropertiesComponent.getInstance((Project)this.myProject).getValue(DEFAULT_LIBRARY_NAME_PROPERTY);
    }

    private void initTestLibraryCombo(@NotNull Project project, @Nullable PhpTestCreateInfo defaultTestCreateInfo) {
        if (project == null) {
            PhpNewTestDialog.$$$reportNull$$$0(3);
        }
        String defaultLibraryName = defaultTestCreateInfo != null ? defaultTestCreateInfo.getName() : this.getDefaultLibraryName();
        for (PhpTestFrameworkType type : PhpTestFrameworkType.getTestFrameworkTypes()) {
            for (PhpTestCreateInfo createInfo : type.getDescriptor().getTestCreateInfos()) {
                this.myLibrariesCombo.addItem((Object)createInfo);
                if (!StringUtil.equals((CharSequence)createInfo.getName(), (CharSequence)defaultLibraryName)) continue;
                this.myLibrariesCombo.setSelectedItem((Object)createInfo);
            }
        }
        this.myLibrariesCombo.setRenderer((ListCellRenderer)new ListCellRendererWrapper<PhpTestCreateInfo>(){

            public void customize(JList list, PhpTestCreateInfo value, int index, boolean selected, boolean hasFocus) {
                if (value != null) {
                    this.setText(value.getName());
                    this.setIcon(value.getIcon());
                }
            }
        });
        this.myLibrariesCombo.addItemListener(e -> {
            if (project == null) {
                PhpNewTestDialog.$$$reportNull$$$0(26);
            }
            this.updateTestNameAndNamespaces(project, this.myTestTargetTextField.getText());
            this.myLibraryChanged = !StringUtil.equals((CharSequence)this.getSelectedTestCreateInfo().getName(), (CharSequence)defaultLibraryName);
        });
        this.registerLibrariesUpDownShortcut();
        this.myLibrariesComboWrapper.add((Component)this.myLibrariesCombo);
        this.myLibrariesLabel.setLabelFor(this.myLibrariesCombo);
    }

    private void registerLibrariesUpDownShortcut() {
        this.myLibrariesUpDownHint.setIcon(PlatformIcons.UP_DOWN_ARROWS);
        this.myLibrariesUpDownHint.setToolTipText(PhpBundle.message("actions.new.test.class.dialog.arrows.libraries.hint", new Object[0]));
        KeyboardShortcut up = new KeyboardShortcut(KeyStroke.getKeyStroke(38, 0), null);
        KeyboardShortcut down = new KeyboardShortcut(KeyStroke.getKeyStroke(40, 0), null);
        PhpNewFileDialog.getCbArrowAction(this.myLibrariesCombo).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(new Shortcut[]{up, down}), (JComponent)this.myNameTextField);
    }

    private void updateTestNameAndNamespaces(@NotNull Project project, @NotNull String testName) {
        if (project == null) {
            PhpNewTestDialog.$$$reportNull$$$0(4);
        }
        if (testName == null) {
            PhpNewTestDialog.$$$reportNull$$$0(5);
        }
        this.updateNamespacesSuggestions(this.getTestNamespaces(project));
        this.myNameTextField.setText(this.getSelectedTestCreateInfo().getDefaultTestName(PhpLangUtil.toShortName(testName)));
    }

    @NotNull
    private List<String> getTestNamespaces(@NotNull Project project) {
        if (project == null) {
            PhpNewTestDialog.$$$reportNull$$$0(6);
        }
        PhpTestCreateInfo selectedTestCreateInfo = this.getSelectedTestCreateInfo();
        List<String> suggestedNamespaces = this.myDirectory != null ? PhpNamespaceCompositeProvider.INSTANCE.suggestNamespaces(this.myDirectory) : PhpNamespaceProvider.GLOBAL_NAMESPACE;
        List list = ((StreamEx)StreamEx.of(suggestedNamespaces).flatMap(namespace -> {
            if (project == null) {
                PhpNewTestDialog.$$$reportNull$$$0(25);
            }
            return selectedTestCreateInfo.getTestNamespaces(project, (String)namespace).stream();
        }).distinct()).toList();
        if (list == null) {
            PhpNewTestDialog.$$$reportNull$$$0(7);
        }
        return list;
    }

    protected void init() {
        super.init();
        this.setTitle(this.mySelectedElementName != null ? PhpBundle.message("actions.new.test.class.dialog.title.named", this.mySelectedElementName) : PhpBundle.message("actions.new.test.class.dialog.title", new Object[0]));
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return "com.jetbrains.php.test.PhpNewTestDialog";
    }

    @Override
    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.mySelectedElementName != null ? this.myNameTextField : this.myTestTargetTextField;
    }

    @NotNull
    public PhpTestCreateInfo getSelectedTestCreateInfo() {
        Object result = this.myLibrariesCombo.getSelectedItem();
        assert (result instanceof PhpTestCreateInfo);
        PhpTestCreateInfo phpTestCreateInfo = (PhpTestCreateInfo)result;
        if (phpTestCreateInfo == null) {
            PhpNewTestDialog.$$$reportNull$$$0(8);
        }
        return phpTestCreateInfo;
    }

    @Override
    @NotNull
    public String getTemplateName() {
        String string = this.getSelectedTestCreateInfo().getTemplateName();
        if (string == null) {
            PhpNewTestDialog.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    @NotNull
    public Properties getProperties(@NotNull PsiDirectory directory) {
        String namespace;
        if (directory == null) {
            PhpNewTestDialog.$$$reportNull$$$0(10);
        }
        Properties properties = super.getProperties(directory);
        String fqn = PhpLangUtil.toName(this.myTestTargetTextField.getText());
        String testedName = PhpLangUtil.toShortName(fqn);
        if (StringUtil.isNotEmpty((String)testedName)) {
            properties.setProperty("TESTED_NAME", testedName);
        }
        if (!PhpLangUtil.isGlobalNamespaceName(namespace = PhpLangUtil.getParentQualifiedName(fqn))) {
            properties.setProperty("TESTED_NAMESPACE", namespace);
        }
        Properties properties2 = properties;
        if (properties2 == null) {
            PhpNewTestDialog.$$$reportNull$$$0(11);
        }
        return properties2;
    }

    private void createUIComponents() {
        this.myNamespaceCombobox = new PhpNamespaceComboBox(this.getProject(), "", this.getDisposable());
        this.myTestTargetTextField = new EditorTextField("", this.getProject(), (FileType)FileTypes.PLAIN_TEXT);
        this.myDirectoryCombobox = new PhpPsrDirectoryComboBox(this.getProject()){

            @Override
            public void init(@NotNull VirtualFile baseDir, @NotNull String namespace) {
                if (baseDir == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (namespace == null) {
                    3.$$$reportNull$$$0(1);
                }
                super.init(baseDir, namespace);
                ProjectFileIndex index = ProjectRootManager.getInstance((Project)PhpNewTestDialog.this.myProject).getFileIndex();
                if (index.isInSourceContent(baseDir)) {
                    this.setDirectoriesFilter((Condition<VirtualFile>)((Condition)arg_0 -> ((ProjectFileIndex)index).isInTestSourceContent(arg_0)));
                }
                this.updateDirectories(PhpNewTestDialog.this.getNamespace());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "baseDir";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "namespace";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/phpunit/codeGeneration/PhpNewTestDialog$3";
                objectArray[2] = "init";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    protected String getHelpId() {
        return "reference.php.reference.testing.create.new.phpunit.test";
    }

    protected void doOKAction() {
        this.saveDefaultLibraryName();
        super.doOKAction();
    }

    private void saveDefaultLibraryName() {
        PropertiesComponent.getInstance((Project)this.myProject).setValue(DEFAULT_LIBRARY_NAME_PROPERTY, this.getSelectedTestCreateInfo().getName());
    }

    @Nullable
    public PhpClass getSelectedTargetClass(@NotNull Project project) {
        Collection classes;
        if (project == null) {
            PhpNewTestDialog.$$$reportNull$$$0(12);
        }
        if ((classes = PhpIndex.getInstance((Project)project).getAnyByFQN(PhpLangUtil.toFQN(this.myTestTargetTextField.getText()))).isEmpty()) {
            return null;
        }
        if (classes.size() == 1) {
            return (PhpClass)ContainerUtil.getFirstItem((Collection)classes);
        }
        return (PhpClass)ContainerUtil.find((Iterable)classes, clazz -> StringUtil.equals((CharSequence)PhpNewTestDialog.getFilePath(clazz), (CharSequence)((String)this.myTestTargetFileCombo.getSelectedItem())));
    }

    @NotNull
    public String getTargetClassFqn() {
        String string = PhpLangUtil.toFQN(this.myTestTargetTextField.getText());
        if (string == null) {
            PhpNewTestDialog.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    private static String getFilePath(@NotNull PhpClass clazz) {
        if (clazz == null) {
            PhpNewTestDialog.$$$reportNull$$$0(14);
        }
        String string = clazz.getContainingFile().getVirtualFile().getPath();
        if (string == null) {
            PhpNewTestDialog.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    private List<PhpMemberInfo> getClassMembersInfo(@NotNull Project project, boolean includeInherited) {
        PhpClass targetClass;
        if (project == null) {
            PhpNewTestDialog.$$$reportNull$$$0(16);
        }
        if ((targetClass = this.getSelectedTargetClass(project)) == null) {
            List<PhpMemberInfo> list = Collections.emptyList();
            if (list == null) {
                PhpNewTestDialog.$$$reportNull$$$0(17);
            }
            return list;
        }
        List list = ((StreamEx)PhpNewTestDialog.getPublicMethods(targetClass, includeInherited).map(PhpMemberInfo::new).sorted(PhpNewTestDialog.ownMethodsFirst(targetClass.getContainingFile()).thenComparing(Function.identity()))).toList();
        if (list == null) {
            PhpNewTestDialog.$$$reportNull$$$0(18);
        }
        return list;
    }

    @NotNull
    private static Comparator<PhpMemberInfo> ownMethodsFirst(@NotNull PsiFile targetContainingFile) {
        if (targetContainingFile == null) {
            PhpNewTestDialog.$$$reportNull$$$0(19);
        }
        Comparator comparator = (o1, o2) -> {
            PsiFile containingFile2;
            PsiFile containingFile1;
            if (targetContainingFile == null) {
                PhpNewTestDialog.$$$reportNull$$$0(24);
            }
            if ((containingFile1 = ((PhpClassMember)o1.getMember()).getContainingFile()) != (containingFile2 = ((PhpClassMember)o2.getMember()).getContainingFile())) {
                if (containingFile1 == targetContainingFile) {
                    return -1;
                }
                if (containingFile2 == targetContainingFile) {
                    return 1;
                }
            }
            return 0;
        };
        if (comparator == null) {
            PhpNewTestDialog.$$$reportNull$$$0(20);
        }
        return comparator;
    }

    @NotNull
    private static StreamEx<Method> getPublicMethods(@NotNull PhpClass targetClass, boolean includeInherited) {
        if (targetClass == null) {
            PhpNewTestDialog.$$$reportNull$$$0(21);
        }
        StreamEx streamEx = (StreamEx)(includeInherited ? StreamEx.of((Collection)targetClass.getMethods()) : StreamEx.of((Object[])targetClass.getOwnMethods())).filter(method -> method.getAccess().isPublic());
        if (streamEx == null) {
            PhpNewTestDialog.$$$reportNull$$$0(22);
        }
        return streamEx;
    }

    @NotNull
    public Set<PhpClassMember> getSelectedClassMembers() {
        Set set = StreamEx.of((Collection)this.myMethodsPanel.getTable().getSelectedMemberInfos()).map(MemberInfoBase::getMember).toSet();
        if (set == null) {
            PhpNewTestDialog.$$$reportNull$$$0(23);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classMembersInfos";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testName";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phpunit/codeGeneration/PhpNewTestDialog";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetContainingFile";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phpunit/codeGeneration/PhpNewTestDialog";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestNamespaces";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedTestCreateInfo";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetClassFqn";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassMembersInfo";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "ownMethodsFirst";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getPublicMethods";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedClassMembers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "reloadMemberSelectionPanel";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkMethodSelectedOnInit";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "initTestLibraryCombo";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateTestNameAndNamespaces";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTestNamespaces";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 23: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getProperties";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedTargetClass";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFilePath";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getClassMembersInfo";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "ownMethodsFirst";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getPublicMethods";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$ownMethodsFirst$9";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getTestNamespaces$7";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$initTestLibraryCombo$6";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$3";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JPanel jPanel;
        ComboBox comboBox;
        JBLabel jBLabel2;
        JPanel jPanel2;
        JPanel jPanel3;
        JBCheckBox jBCheckBox;
        JBLabel jBLabel3;
        JBLabel jBLabel4;
        JBLabel jBLabel5;
        JBLabel jBLabel6;
        EditorTextField editorTextField;
        EditorTextField editorTextField2;
        JPanel jPanel4;
        this.createUIComponents();
        this.myMainPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(3, 0, 1, 3, 0, 2, 1, 6, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(8, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel5, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, null, null, 0, true));
        jPanel5.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/PhpBundle").getString("actions.new.test.class.dialog.border.title.test.class"), (int)0, (int)0, null, null));
        JBLabel jBLabel7 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel7, ResourceBundle.getBundle("messages/PhpBundle").getString("actions.new.test.class.dialog.label.namespace"));
        jPanel5.add((Component)jBLabel7, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(69, 14), null));
        JBLabel jBLabel8 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel8, ResourceBundle.getBundle("messages/PhpBundle").getString("actions.new.test.class.dialog.label.file.name"));
        jPanel5.add((Component)jBLabel8, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(69, 14), null));
        this.myNameTextField = editorTextField2 = new EditorTextField();
        jPanel5.add((Component)editorTextField2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        PhpNamespaceComboBox phpNamespaceComboBox = this.myNamespaceCombobox;
        jPanel5.add((Component)((Object)phpNamespaceComboBox), new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myFileNameTextField = editorTextField = new EditorTextField();
        jPanel5.add((Component)editorTextField, new GridConstraints(3, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JBLabel jBLabel9 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel9, ResourceBundle.getBundle("messages/PhpBundle").getString("actions.new.test.class.dialog.label.name"));
        jPanel5.add((Component)jBLabel9, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNamespaceCompletionHintLabel = jBLabel6 = new JBLabel();
        jBLabel6.setComponentStyle(UIUtil.ComponentStyle.MINI);
        jPanel5.add((Component)jBLabel6, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel10 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel10, ResourceBundle.getBundle("messages/PhpBundle").getString("actions.new.test.class.dialog.label.directory"));
        jPanel5.add((Component)jBLabel10, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        PhpPsrDirectoryComboBox phpPsrDirectoryComboBox = this.myDirectoryCombobox;
        jPanel5.add((Component)((Object)phpPsrDirectoryComboBox), new GridConstraints(4, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myEditDirectoryHintLabel = jBLabel5 = new JBLabel();
        jBLabel5.setComponentStyle(UIUtil.ComponentStyle.MINI);
        jPanel5.add((Component)jBLabel5, new GridConstraints(5, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLibrariesUpDownHint = jBLabel4 = new JBLabel();
        jPanel5.add((Component)jBLabel4, new GridConstraints(0, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myMethodsPanelLabel = jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, ResourceBundle.getBundle("messages/PhpBundle").getString("actions.new.test.class.dialog.select.methods"));
        jPanel5.add((Component)jBLabel3, new GridConstraints(6, 0, 1, 1, 8, 0, 6, 0, null, null, null));
        this.myShowInheritedMembersCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("messages/PhpBundle").getString("actions.new.test.class.dialog.select.methods.show.inherited.methods"));
        jPanel5.add((Component)jBCheckBox, new GridConstraints(6, 1, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.myMethodsTableWrapper = jPanel3 = new JPanel();
        jPanel3.setLayout(new CardLayout(0, 0));
        jPanel5.add((Component)jPanel3, new GridConstraints(7, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myTestTargetPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel2, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null, 0, true));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/PhpBundle").getString("actions.new.test.class.dialog.border.title.class.to.test"), (int)0, (int)0, null, null));
        EditorTextField editorTextField3 = this.myTestTargetTextField;
        editorTextField3.setToolTipText("optional");
        jPanel2.add((Component)editorTextField3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JBLabel jBLabel11 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel11, ResourceBundle.getBundle("messages/PhpBundle").getString("actions.new.test.class.dialog.label.fqn"));
        jPanel2.add((Component)jBLabel11, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTestTargetCompletionHintLabel = jBLabel2 = new JBLabel();
        jBLabel2.setComponentStyle(UIUtil.ComponentStyle.MINI);
        jBLabel2.setFontColor(UIUtil.FontColor.NORMAL);
        jBLabel2.setText("");
        jPanel2.add((Component)jBLabel2, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel12 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel12, ResourceBundle.getBundle("messages/PhpBundle").getString("actions.new.test.class.dialog.border.title.target.class.file.path"));
        jPanel2.add((Component)jBLabel12, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTestTargetFileCombo = comboBox = new ComboBox();
        jPanel2.add((Component)comboBox, new GridConstraints(2, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.myLibrariesComboWrapper = jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 5, 5));
        jPanel4.add((Component)jPanel, new GridConstraints(0, 0, 1, 3, 0, 3, 3, 3, null, null, null, 0, true));
        this.myLibrariesLabel = jBLabel = new JBLabel();
        jBLabel.setText("Test file template:");
        jBLabel.setDisplayedMnemonic('T');
        jBLabel.setDisplayedMnemonicIndex(0);
        Component component = jPanel.add((Component)jBLabel);
        Spacer spacer2 = new Spacer();
        Component component2 = jPanel.add((Component)spacer2);
        Spacer spacer3 = new Spacer();
        Component component3 = jPanel.add((Component)spacer3);
        jBLabel7.setLabelFor((Component)((Object)phpNamespaceComboBox));
        jBLabel8.setLabelFor((Component)editorTextField);
        jBLabel9.setLabelFor((Component)editorTextField2);
        jBLabel11.setLabelFor((Component)editorTextField3);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

