/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.refactoring.validation.PhpFilePathValidationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpFileCreationInfo {
    private final PsiDirectory myBaseDirectory;
    @Nullable
    private final String myRelativeTargetDirectory;
    private final String myFileName;

    protected PhpFileCreationInfo(@NotNull PsiDirectory baseDirectory, @Nullable String directory, @NotNull String fileName) {
        if (baseDirectory == null) {
            PhpFileCreationInfo.$$$reportNull$$$0(0);
        }
        if (fileName == null) {
            PhpFileCreationInfo.$$$reportNull$$$0(1);
        }
        this.myBaseDirectory = baseDirectory;
        this.myRelativeTargetDirectory = directory;
        this.myFileName = fileName;
    }

    @NotNull
    public PsiDirectory getBaseDirectory() {
        PsiDirectory psiDirectory = this.myBaseDirectory;
        if (psiDirectory == null) {
            PhpFileCreationInfo.$$$reportNull$$$0(2);
        }
        return psiDirectory;
    }

    @NotNull
    public String getRelativePath() {
        String string = (StringUtil.isEmpty((String)this.myRelativeTargetDirectory) ? "" : this.myRelativeTargetDirectory + '/') + this.myFileName;
        if (string == null) {
            PhpFileCreationInfo.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getAbsolutePath() {
        String basePath = this.myBaseDirectory.getVirtualFile().getPath();
        String relativePath = StringUtil.isEmpty((String)this.myRelativeTargetDirectory) ? "" : '/' + this.myRelativeTargetDirectory;
        String string = basePath + relativePath + '/' + this.myFileName;
        if (string == null) {
            PhpFileCreationInfo.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static PhpFileCreationInfo generateConfiguration(@NotNull Project project, @NotNull String filePath, @NotNull String fileName) throws PhpFilePathValidationException {
        PsiDirectory existingDir;
        if (project == null) {
            PhpFileCreationInfo.$$$reportNull$$$0(5);
        }
        if (filePath == null) {
            PhpFileCreationInfo.$$$reportNull$$$0(6);
        }
        if (fileName == null) {
            PhpFileCreationInfo.$$$reportNull$$$0(7);
        }
        if ((existingDir = PhpFileCreationInfo.extractDeepestExistingDirectory(project, filePath)) == null) {
            throw new PhpFilePathValidationException(PhpBundle.message("refactoring.common.validation.target.directory.is.not.valid", filePath));
        }
        VirtualFile baseDir = existingDir.getVirtualFile();
        boolean isInProject = ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(baseDir);
        if (!isInProject) {
            throw new PhpFilePathValidationException(PhpBundle.message("refactoring.common.validation.target.directory.not.inside.project", baseDir.getPath()));
        }
        String relativeTargetDir = PhpFileCreationInfo.getRelativePath(baseDir, filePath);
        if (relativeTargetDir == null) {
            throw new PhpFilePathValidationException(PhpBundle.message("validation.file.not.valid.name", filePath));
        }
        String message = PhpFileCreationInfo.isValidFilePath(existingDir, relativeTargetDir, fileName);
        if (StringUtil.isNotEmpty((String)message)) {
            throw new PhpFilePathValidationException(message);
        }
        PhpFileCreationInfo phpFileCreationInfo = new PhpFileCreationInfo(existingDir, relativeTargetDir, fileName);
        if (phpFileCreationInfo == null) {
            PhpFileCreationInfo.$$$reportNull$$$0(8);
        }
        return phpFileCreationInfo;
    }

    @Nullable
    private static String getRelativePath(@NotNull VirtualFile baseDir, @NotNull String filePath) {
        String relativeDirPath;
        if (baseDir == null) {
            PhpFileCreationInfo.$$$reportNull$$$0(9);
        }
        if (filePath == null) {
            PhpFileCreationInfo.$$$reportNull$$$0(10);
        }
        return StringUtil.equals((CharSequence)(relativeDirPath = FileUtil.getRelativePath((String)baseDir.getPath(), (String)filePath, (char)'/')), (CharSequence)".") ? "" : relativeDirPath;
    }

    @Nullable
    public static String isValidFilePath(@NotNull PsiDirectory baseDirectory, @NotNull String relativeDirPath, @NotNull String fileName) {
        String filePath;
        String dirPath;
        if (baseDirectory == null) {
            PhpFileCreationInfo.$$$reportNull$$$0(11);
        }
        if (relativeDirPath == null) {
            PhpFileCreationInfo.$$$reportNull$$$0(12);
        }
        if (fileName == null) {
            PhpFileCreationInfo.$$$reportNull$$$0(13);
        }
        ArrayList split = StringUtil.isEmpty((String)(dirPath = FileUtil.toSystemIndependentName((String)relativeDirPath))) ? ContainerUtil.newArrayList() : StringUtil.split((String)dirPath, (String)"/");
        split.add(fileName);
        if (split.size() == 0) {
            return PhpBundle.message("validation.file.not.valid.name", relativeDirPath);
        }
        for (String path : split) {
            if (PathUtil.isValidFileName((String)path)) continue;
            return PhpBundle.message("validation.file.not.valid.name", relativeDirPath);
        }
        VirtualFile baseDirectoryFile = baseDirectory.getVirtualFile();
        VirtualFile fileByRelativePath = baseDirectoryFile.findFileByRelativePath(filePath = StringUtil.isEmpty((String)dirPath) ? fileName : dirPath + '/' + fileName);
        if (fileByRelativePath != null) {
            StringBuilder directoryPath = new StringBuilder(baseDirectoryFile.getPath());
            if (!StringUtil.isEmpty((String)dirPath)) {
                directoryPath.append("/");
                directoryPath.append(dirPath);
            }
            return PhpBundle.message("validation.file.already.exists.in.dir", filePath, FileUtil.toSystemDependentName((String)directoryPath.toString()));
        }
        return null;
    }

    @Nullable
    private static PsiDirectory extractDeepestExistingDirectory(@NotNull Project project, @NotNull String path) {
        if (project == null) {
            PhpFileCreationInfo.$$$reportNull$$$0(14);
        }
        if (path == null) {
            PhpFileCreationInfo.$$$reportNull$$$0(15);
        }
        PsiManager manager = PsiManager.getInstance((Project)project);
        String existingPath = path;
        PsiDirectory directory = null;
        while (StringUtil.isNotEmpty((String)existingPath) && directory == null && existingPath.length() > 0) {
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(existingPath);
            if (file != null) {
                directory = manager.findDirectory(file);
                continue;
            }
            existingPath = PathUtil.getParentPath((String)existingPath);
        }
        return directory;
    }

    public String toString() {
        return "PhpFileCreationInfo{myBaseDirectory=" + this.myBaseDirectory.getVirtualFile().getPath() + ", myRelativeTargetDirectory='" + this.myRelativeTargetDirectory + '\'' + ", myFileName='" + this.myFileName + '\'' + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDirectory";
                break;
            }
            case 1: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/PhpFileCreationInfo";
                break;
            }
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeDirPath";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/PhpFileCreationInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseDirectory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativePath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbsolutePath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "generateConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "generateConfiguration";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isValidFilePath";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "extractDeepestExistingDirectory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

