/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.pullPush.pushDown;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.refactoring.PhpMemberInfo;
import com.jetbrains.php.refactoring.PhpMemberInfoStorage;
import com.jetbrains.php.refactoring.pullPush.PhpPullPushBaseHandler;
import com.jetbrains.php.refactoring.pullPush.pushDown.PhpPushDownDialog;
import org.jetbrains.annotations.NotNull;

public class PhpPushDownHandler
extends PhpPullPushBaseHandler {
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"push.members.down.title");
    public static final String HELP_ID = "members.push.down";
    private static final Logger LOG = Logger.getInstance(PhpPushDownHandler.class);

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            PhpPushDownHandler.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            PhpPushDownHandler.$$$reportNull$$$0(1);
        }
        if (elements.length != 1) {
            return;
        }
        PsiElement element = elements[0];
        PhpClass aClass = this.extractClass(element);
        LOG.assertTrue(aClass != null);
        PhpMemberInfoStorage memberInfoStorage = new PhpMemberInfoStorage(aClass);
        if (memberInfoStorage.getClassMemberInfos((PsiElement)aClass).isEmpty()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)this.myEditor, (String)"No members to push down found", (String)REFACTORING_NAME, (String)this.getHelpId());
            return;
        }
        for (PhpMemberInfo member : memberInfoStorage.getClassMemberInfos((PsiElement)aClass)) {
            if (!aClass.getManager().areElementsEquivalent(member.getMember(), element)) continue;
            member.setChecked(true);
            break;
        }
        PhpPushDownDialog dialog = new PhpPushDownDialog(project, aClass, memberInfoStorage);
        dialog.show();
    }

    @Override
    protected String getHelpId() {
        return HELP_ID;
    }

    @Override
    protected String getRefactoringName() {
        return REFACTORING_NAME;
    }

    @Override
    protected String getErrorMessageForCaretPosition() {
        return RefactoringBundle.message((String)"the.caret.should.be.positioned.inside.a.class.to.push.members.from");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/refactoring/pullPush/pushDown/PhpPushDownHandler";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

