/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.rename.automaticRenamers;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.UnresolvableCollisionUsageInfo;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.PhpRefactoringSettings;
import com.jetbrains.php.refactoring.rename.automaticRenamers.FileContainingClassRenamerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ClassInheritorsRenamerFactory
implements AutomaticRenamerFactory {
    @NotNull
    public AutomaticRenamer createRenamer(PsiElement element, String newName, Collection<UsageInfo> usages) {
        ClassInheritorsAndFilesRenamer classInheritorsAndFilesRenamer = new ClassInheritorsAndFilesRenamer((PhpClass)element, newName);
        if (classInheritorsAndFilesRenamer == null) {
            ClassInheritorsRenamerFactory.$$$reportNull$$$0(0);
        }
        return classInheritorsAndFilesRenamer;
    }

    public boolean isApplicable(@NotNull PsiElement element) {
        if (element == null) {
            ClassInheritorsRenamerFactory.$$$reportNull$$$0(1);
        }
        return element instanceof PhpClass;
    }

    public String getOptionName() {
        return RefactoringBundle.message((String)"rename.inheritors");
    }

    public boolean isEnabled() {
        return PhpRefactoringSettings.getInstance().RENAME_CLASS_INHERITORS_AND_REATED_FILES;
    }

    public void setEnabled(boolean enabled) {
        PhpRefactoringSettings.getInstance().RENAME_CLASS_INHERITORS_AND_REATED_FILES = enabled;
    }

    public static boolean containsFileNames(List<String> fileNames, String text) {
        for (String fileName : fileNames) {
            if (!text.contains(fileName)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/rename/automaticRenamers/ClassInheritorsRenamerFactory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createRenamer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/rename/automaticRenamers/ClassInheritorsRenamerFactory";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ClassInheritorsAndFilesRenamer
    extends AutomaticRenamer {
        List<String> myFileNames;

        public ClassInheritorsAndFilesRenamer(PhpClass clazz, String newClassName) {
            PsiFile clazzContainingFile = clazz.getContainingFile();
            this.myFileNames = new ArrayList<String>();
            this.myElements.add(clazzContainingFile);
            this.myFileNames.add(clazzContainingFile.getName());
            Collection subclasses = PhpIndex.getInstance((Project)clazz.getProject()).getDirectSubclasses(clazz.getFQN());
            for (PhpClass subClass : subclasses) {
                PsiFile containingFile = subClass.getContainingFile();
                if (containingFile instanceof PhpFile && FileContainingClassRenamerFactory.isFilePSR((PhpFile)containingFile)) {
                    this.myElements.add(containingFile);
                    this.myFileNames.add(containingFile.getName());
                }
                if (subClass.isAnonymous()) continue;
                this.myElements.add(subClass);
            }
            String className = clazz.getName();
            this.suggestAllNames(className, newClassName);
        }

        public String getDialogTitle() {
            return RefactoringBundle.message((String)"rename.inheritors.title");
        }

        public String getDialogDescription() {
            return PhpBundle.message("refactoring.rename.inheritors.and.related.files.with.the.following.names.to", new Object[0]);
        }

        public String entityName() {
            return PhpBundle.message("refactoring.rename.entity.name.inheritor", new Object[0]);
        }

        public boolean isSelectedByDefault() {
            return true;
        }

        protected String nameToCanonicalName(@NonNls String name, PsiNamedElement element) {
            return PhpNameUtil.getNameWithoutExtension(name);
        }

        protected String canonicalNameToName(@NonNls String canonicalName, PsiNamedElement element) {
            String oldName = element.getName();
            assert (oldName != null);
            String extension = PhpNameUtil.getExtension(oldName);
            if (extension.length() > 0) {
                return PhpNameUtil.getFullFileName(canonicalName, extension);
            }
            return canonicalName;
        }

        public void findUsages(List<UsageInfo> result, boolean searchInStringsAndComments, boolean searchInNonJavaFiles, List<UnresolvableCollisionUsageInfo> unresolvedUsages, Map<PsiElement, String> allRenames) {
            super.findUsages(result, searchInStringsAndComments, searchInNonJavaFiles, unresolvedUsages, allRenames);
            result.removeIf(i -> {
                PsiElement element = i.getElement();
                return element != null && ClassInheritorsRenamerFactory.containsFileNames(this.myFileNames, element.getText()) && i instanceof NonCodeUsageInfo && ((NonCodeUsageInfo)i).getReferencedElement() instanceof PhpFile;
            });
        }
    }
}

