/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.schema;

import com.intellij.lang.documentation.DocumentationProviderEx;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaDocumentationProvider;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YamlJsonSchemaDocumentationProvider
extends DocumentationProviderEx {
    @Nullable
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        return YamlJsonSchemaDocumentationProvider.findSchemaAndGenerateDoc(element, true);
    }

    @Nullable
    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        return null;
    }

    @Nullable
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        return YamlJsonSchemaDocumentationProvider.findSchemaAndGenerateDoc(element, false);
    }

    @Nullable
    private static String findSchemaAndGenerateDoc(PsiElement element, boolean preferShort) {
        JsonSchemaService jsonSchemaService = JsonSchemaService.Impl.get((Project)element.getProject());
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        VirtualFile virtualFile = containingFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        JsonSchemaObject schemaObject = jsonSchemaService.getSchemaObject(virtualFile);
        if (schemaObject == null) {
            return null;
        }
        return JsonSchemaDocumentationProvider.generateDoc((PsiElement)element, (JsonSchemaObject)schemaObject, (boolean)preferShort, null);
    }

    @Nullable
    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        return null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        return null;
    }

    @Nullable
    public PsiElement getCustomDocumentationElement(@NotNull Editor editor, @NotNull PsiFile file, @Nullable PsiElement contextElement) {
        if (editor == null) {
            YamlJsonSchemaDocumentationProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            YamlJsonSchemaDocumentationProvider.$$$reportNull$$$0(1);
        }
        JsonSchemaService service = JsonSchemaService.Impl.get((Project)file.getProject());
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null || service == null || service.getSchemaObject(virtualFile) == null) {
            return null;
        }
        return contextElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/yaml/schema/YamlJsonSchemaDocumentationProvider";
        objectArray[2] = "getCustomDocumentationElement";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

