/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ScriptRunnerUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ArrayUtil;
import com.jetbrains.php.framework.data.FrameworkDataService;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FrameworkExecutionProcessCreator {
    private final String exePath;
    private final String workingFolder;
    private final String[] params;

    FrameworkExecutionProcessCreator(@NotNull String exePath, @NotNull List<String> params, @Nullable String workingFolder) {
        if (exePath == null) {
            FrameworkExecutionProcessCreator.$$$reportNull$$$0(0);
        }
        if (params == null) {
            FrameworkExecutionProcessCreator.$$$reportNull$$$0(1);
        }
        this.exePath = exePath;
        this.workingFolder = workingFolder;
        this.params = ArrayUtil.toStringArray(params);
    }

    private static String patchExePath(String exePath, String workingFolder) {
        if (SystemInfo.isWindows && !exePath.contains(File.separator)) {
            File inWorkingFolder = FrameworkExecutionProcessCreator.findInWorkingFolder(exePath, Collections.singletonList(""), workingFolder);
            if (inWorkingFolder != null) {
                return inWorkingFolder.getAbsolutePath();
            }
            List executableFileExtensions = PathEnvironmentVariableUtil.getWindowsExecutableFileExtensions();
            File inWorkingFolderWithExtension = FrameworkExecutionProcessCreator.findInWorkingFolder(exePath, executableFileExtensions, workingFolder);
            if (inWorkingFolderWithExtension != null) {
                return inWorkingFolderWithExtension.getAbsolutePath();
            }
        }
        return exePath;
    }

    @Nullable
    private static File findInWorkingFolder(String fileName, List<String> extensions, @Nullable String workingFolder) {
        if (workingFolder == null) {
            return null;
        }
        File dir = new File(workingFolder);
        if (dir.isAbsolute() && dir.isDirectory()) {
            for (String extension : extensions) {
                File file = new File(dir, fileName + extension);
                if (!file.isFile() || !file.canExecute()) continue;
                return file;
            }
        }
        return null;
    }

    OSProcessHandler createProcessHandler() throws ExecutionException {
        String patchedExePath = FrameworkExecutionProcessCreator.patchExePath(this.exePath, this.workingFolder);
        return ScriptRunnerUtil.execute((String)patchedExePath, (String)this.workingFolder, null, (String[])this.params, (Charset)FrameworkDataService.getConsoleCharset(), commandLine -> new ColoredProcessHandler(commandLine));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "exePath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "params";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/framework/FrameworkExecutionProcessCreator";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

