/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.EditorTextField;
import com.jetbrains.php.FrameworkBundle;
import com.jetbrains.php.framework.FrameworkCurrentInputData;
import com.jetbrains.php.framework.FrameworkParameterCompletionContributor;
import com.jetbrains.php.framework.FrameworkUtils;
import com.jetbrains.php.framework.FrameworkWorkingFolderService;
import com.jetbrains.php.framework.completion.FrameworkCommandLookupElement;
import com.jetbrains.php.framework.completion.FrameworkOptionLookupElement;
import com.jetbrains.php.framework.completion.FrameworkPathCompletionUtil;
import com.jetbrains.php.framework.data.FrameworkCommand;
import com.jetbrains.php.framework.data.FrameworkDataService;
import com.jetbrains.php.framework.data.FrameworkOption;
import com.jetbrains.php.framework.parsing.OptionPart;
import com.jetbrains.php.framework.parsing.ParamPart;
import com.jetbrains.php.framework.parsing.UserInputPart;
import com.jetbrains.php.framework.ui.FrameworkToolWindowComponent;
import com.jetbrains.php.framework.ui.FrameworkUiUtils;
import java.util.List;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameworkCompletionContributor
extends CompletionContributor {
    public static final Key<EditorTextField> EDITOR_TEXT_FIELD_KEY = Key.create((String)"EDITOR_TEXT_FIELD_KEY");

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        EditorTextField editorTextField;
        if (context == null) {
            FrameworkCompletionContributor.$$$reportNull$$$0(0);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && (editorTextField = FrameworkCompletionContributor.getEditorTextField(context.getEditor())) != null) {
            final Project project = context.getProject();
            FrameworkDataService frameworkDataService = FrameworkDataService.getInstance(project);
            frameworkDataService.saveEditedDescriptions();
            final List<Pair<String, VirtualFile>> errorMessages = frameworkDataService.getErrorMessages();
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(FrameworkUiUtils.TOOL_WINDOW_ID);
            if (toolWindow != null) {
                FrameworkToolWindowComponent toolWindowComponent = FrameworkToolWindowComponent.getToolWindowComponent(toolWindow.getContentManager());
                ConsoleView errorConsoleView = toolWindowComponent.getValidateConsoleView();
                FrameworkCompletionContributor.setTextToErrorConsoleIfExists(errorConsoleView, errorMessages);
            }
            if (errorMessages.isEmpty()) {
                return;
            }
            DumbAwareAction showDescriptionAction = new DumbAwareAction("Show description"){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ToolWindow toolWindow = FrameworkUiUtils.getOrRegisterToolWindow(project);
                    FrameworkToolWindowComponent toolWindowComponent = FrameworkToolWindowComponent.getToolWindowComponent(toolWindow.getContentManager());
                    ConsoleView newErrorConsoleView = toolWindowComponent.getOrCreateValidationConsole(project);
                    FrameworkCompletionContributor.setTextToErrorConsoleIfExists(newErrorConsoleView, errorMessages);
                    newErrorConsoleView.scrollTo(0);
                    toolWindow.activate(null);
                    toolWindowComponent.showValidationTab();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/framework/completion/FrameworkCompletionContributor$1", "actionPerformed"));
                }
            };
            Notification errorNotification = new Notification("Command Line Tool", FrameworkBundle.message("framework.tool.window.message.title.command.line.tool", new Object[0]), FrameworkBundle.message("framework.parse.error.message", new Object[0]), NotificationType.ERROR);
            errorNotification.addAction((AnAction)showDescriptionAction);
            Notifications.Bus.notify((Notification)errorNotification, (Project)project);
        }
    }

    @Nullable
    public static EditorTextField getEditorTextField(@NotNull Editor editor) {
        if (editor == null) {
            FrameworkCompletionContributor.$$$reportNull$$$0(1);
        }
        return (EditorTextField)editor.getDocument().getUserData(EDITOR_TEXT_FIELD_KEY);
    }

    private static void setTextToErrorConsoleIfExists(@Nullable ConsoleView errorConsoleView, List<Pair<String, VirtualFile>> errorMessages) {
        if (errorConsoleView == null) {
            return;
        }
        errorConsoleView.clear();
        for (final Pair<String, VirtualFile> errorMessageData : errorMessages) {
            errorConsoleView.printHyperlink(((VirtualFile)errorMessageData.getSecond()).getName(), new HyperlinkInfo(){

                public void navigate(Project project) {
                    FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
                    fileEditorManager.openFile((VirtualFile)errorMessageData.getSecond(), false);
                }
            });
            errorConsoleView.print(": " + (String)errorMessageData.getFirst() + "\n", ConsoleViewContentType.NORMAL_OUTPUT);
        }
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        Editor editor;
        EditorTextField textField;
        if (parameters == null) {
            FrameworkCompletionContributor.$$$reportNull$$$0(2);
        }
        if (result == null) {
            FrameworkCompletionContributor.$$$reportNull$$$0(3);
        }
        if ((textField = FrameworkCompletionContributor.getEditorTextField(editor = parameters.getEditor())) == null) {
            return;
        }
        Document document = editor.getDocument();
        PsiFile file = parameters.getOriginalFile();
        String userInput = document.getText().substring(0, parameters.getOffset());
        CompletionResultSet resultSet = result.withPrefixMatcher(userInput);
        FrameworkDataService frameworkDataService = FrameworkDataService.getInstance(file.getProject());
        PrefixMatcher prefixMatcher = resultSet.getPrefixMatcher();
        boolean matches = false;
        for (FrameworkCommand command : frameworkDataService.getCommands()) {
            if (!command.isEnabled()) continue;
            FrameworkCommandLookupElement element = new FrameworkCommandLookupElement(command, file);
            resultSet.addElement((LookupElement)element);
            matches = matches || prefixMatcher.prefixMatches((LookupElement)element);
        }
        Project project = parameters.getOriginalFile().getProject();
        FrameworkCurrentInputData currentInputData = FrameworkCurrentInputData.getOrUpdate(document, userInput, frameworkDataService.getCommands());
        FrameworkCommand command = currentInputData.findCommand(true, true);
        if (command != null && userInput.startsWith(command.getAliasedBasicText() + " ")) {
            int currentParameterNumber;
            List<UserInputPart> userInputParts = FrameworkUtils.parseCurrentInput(userInput, command);
            UserInputPart lastPart = userInputParts.get(userInputParts.size() - 1);
            if (lastPart instanceof OptionPart && !lastPart.getText().isEmpty()) {
                FrameworkCompletionContributor.addOptionsBeforeCompletion((OptionPart)lastPart, command, result, file);
            }
            int n = currentParameterNumber = lastPart instanceof ParamPart ? ((ParamPart)lastPart).getNumber() : 0;
            if (currentParameterNumber < command.getParameters().size()) {
                String workingFolder = FrameworkWorkingFolderService.getInstance(project).getWorkingFolder();
                FrameworkCommand.Parameter parameter = command.getParameters().get(currentParameterNumber);
                String prefix = StringUtil.notNullize((String)lastPart.getText());
                CompletionResultSet parameterResultSet = result.withPrefixMatcher(prefix);
                for (FrameworkParameterCompletionContributor provider : (FrameworkParameterCompletionContributor[])FrameworkParameterCompletionContributor.EXTENSION_POINT.getExtensions()) {
                    for (LookupElement element : provider.getVariants(command, parameter, workingFolder)) {
                        parameterResultSet.addElement(element);
                    }
                }
            }
        }
        if (!matches) {
            FrameworkPathCompletionUtil.addPathCompletionVariants(result, userInput, project);
        }
        result.stopHere();
    }

    private static void addOptionsBeforeCompletion(OptionPart last, FrameworkCommand command, CompletionResultSet result, PsiFile psiFile) {
        if (command.getOptionsBeforeParams().isEmpty()) {
            return;
        }
        if (last.hasValue() && last.getValueText() != null) {
            return;
        }
        String prefix = last.getText();
        CompletionResultSet set = result.withPrefixMatcher(prefix);
        for (FrameworkOption option : command.getOptionsBeforeParams()) {
            set.addAllElements(FrameworkOptionLookupElement.createElements(option, psiFile, command));
        }
    }

    @NotNull
    public static String getParamsDescription(FrameworkCommand command, boolean enableHtml, int currentParameter) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        if (enableHtml) {
            sb.append("<html><body>");
        }
        for (FrameworkCommand.Parameter parameter : command.getParameters()) {
            if (enableHtml && i == currentParameter) {
                sb.append("<b>");
            }
            sb.append(" ").append(parameter.getName());
            if (parameter.hasDefaultValue()) {
                sb.append("[=").append(parameter.getDefaultValue()).append("]");
            }
            if (enableHtml && i == currentParameter) {
                sb.append("</b>");
            }
            ++i;
        }
        if (command.hasInfiniteParameters()) {
            if (currentParameter > command.getParameters().size() - 1) {
                sb.append(" <b>...</b>");
            } else {
                sb.append(" ...");
            }
        }
        if (enableHtml) {
            sb.append("</body></html>");
        }
        String string = sb.toString();
        if (string == null) {
            FrameworkCompletionContributor.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static void destroyInfoPopup(Editor editor) {
        PopupInfo oldPopupTrinity = PopupInfo.getPopupInfo(editor.getDocument());
        if (oldPopupTrinity != null) {
            JBPopup oldPopup = oldPopupTrinity.popup;
            if (!oldPopup.isDisposed()) {
                oldPopup.cancel();
            }
            PopupInfo.putPopupInfo(editor.getDocument(), null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/framework/completion/FrameworkCompletionContributor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/framework/completion/FrameworkCompletionContributor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getParamsDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeCompletion";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getEditorTextField";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PopupInfo {
        private static final Key<PopupInfo> COMPLETION_INFO_POPUP_KEY = Key.create((String)"COMPLETION_INFO_POPUP");
        public final FrameworkCommand command;
        public final JLabel label;
        public final JBPopup popup;

        public PopupInfo(JBPopup popup, JLabel label, FrameworkCommand command) {
            this.command = command;
            this.label = label;
            this.popup = popup;
        }

        @Nullable
        public static PopupInfo getPopupInfo(@NotNull Document document) {
            if (document == null) {
                PopupInfo.$$$reportNull$$$0(0);
            }
            return (PopupInfo)document.getUserData(COMPLETION_INFO_POPUP_KEY);
        }

        public static void putPopupInfo(@NotNull Document document, @Nullable PopupInfo info) {
            if (document == null) {
                PopupInfo.$$$reportNull$$$0(1);
            }
            document.putUserData(COMPLETION_INFO_POPUP_KEY, (Object)info);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "document";
            objectArray2[1] = "com/jetbrains/php/framework/completion/FrameworkCompletionContributor$PopupInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getPopupInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putPopupInfo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

