/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework.data;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.ui.GuiUtils;
import com.intellij.util.CachedValueImpl;
import com.intellij.util.JdomKt;
import com.jetbrains.php.FrameworkBundle;
import com.jetbrains.php.framework.data.FrameworkCommand;
import com.jetbrains.php.framework.data.FrameworkConfigurationDescription;
import com.jetbrains.php.framework.data.FrameworkDataService;
import com.jetbrains.php.framework.data.FrameworkDescription;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.SAXException;

abstract class FrameworkDataServiceBase {
    @NonNls
    private static final Logger LOG = Logger.getInstance(FrameworkDataServiceBase.class);
    @NonNls
    protected static final String DIRECTORY = "commandlinetools";
    @NonNls
    protected static final String PROJECT_DIRECTORY = "commandlinetools";
    @NonNls
    protected static final String OLD_PROJECT_DIRECTORY = ".commandlinetools";
    @NonNls
    private static final String SCHEMA_RESOURCE_PATH = "/resources/frameworkDescriptionVersion1.1.4.xsd";
    private final List<CachedValue<Pair<FrameworkConfigurationDescription, String>>> myFrameworks = new ArrayList<CachedValue<Pair<FrameworkConfigurationDescription, String>>>();
    private final ModificationTracker myFrameworksModificationTracker = new ModificationTracker(){

        public long getModificationCount() {
            long result = 0L;
            for (CachedValue framework : FrameworkDataServiceBase.this.myFrameworks) {
                result += FrameworkDataServiceBase.getFile((CachedValue<Pair<FrameworkConfigurationDescription, String>>)framework).getModificationCount();
            }
            return result;
        }
    };
    private CachedValue<List<FrameworkCommand>> myCommands;

    FrameworkDataServiceBase() {
    }

    protected void initialize() {
        ApplicationManager.getApplication().runReadAction(this::readData);
    }

    private void saveAndReadData(final List<FrameworkDataService.FrameworkFileData> frameworksCache, final boolean deleteOtherFiles) {
        final HashMap<String, Pair> descriptions = new HashMap<String, Pair>();
        final ArrayList<String> fileNames = new ArrayList<String>(frameworksCache.size());
        for (FrameworkDataService.FrameworkFileData frameworkTrinity : frameworksCache) {
            FrameworkConfigurationDescription framework = frameworkTrinity.getFramework();
            if (framework != null) {
                descriptions.put(framework.getName(), Pair.create((Object)framework.getFramework().writeToDocument(framework.getCommands()), (Object)framework.getFramework()));
            }
            fileNames.add(frameworkTrinity.getFileName());
        }
        Runnable writeData = new Runnable(){

            @Override
            public void run() {
                FrameworkDataServiceBase.writeDescriptions(FrameworkDataServiceBase.this.getDescriptionsDir(!frameworksCache.isEmpty()), descriptions, fileNames, deleteOtherFiles, this);
                FrameworkDataServiceBase.this.readData();
            }
        };
        ApplicationManager.getApplication().runWriteAction(writeData);
    }

    private static void writeDescriptions(@Nullable VirtualFile descriptorsDir, HashMap<String, Pair<org.jdom.Document, FrameworkDescription>> descriptions, List<String> fileNames, boolean deleteOtherFiles, Object requestor) {
        VirtualFile schemaDirectory;
        if (descriptorsDir == null) {
            return;
        }
        fileNames.add("schemas");
        if (deleteOtherFiles) {
            for (VirtualFile oldChild : descriptorsDir.getChildren()) {
                try {
                    if (fileNames.contains(oldChild.getName())) continue;
                    oldChild.delete((Object)FrameworkDataServiceBase.class.getName());
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        if ((schemaDirectory = descriptorsDir.findChild("schemas")) == null || !schemaDirectory.isDirectory()) {
            try {
                if (schemaDirectory != null) {
                    schemaDirectory.delete(requestor);
                }
                schemaDirectory = descriptorsDir.createChildDirectory(requestor, "schemas");
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        if (schemaDirectory.findChild("frameworkDescriptionVersion1.1.4.xsd") == null) {
            URL resourceUrl = FrameworkDataServiceBase.class.getResource(SCHEMA_RESOURCE_PATH);
            try {
                VirtualFile ideaSchemaFile = VfsUtil.findFileByURL((URL)resourceUrl);
                VfsUtilCore.copyFile((Object)requestor, (VirtualFile)ideaSchemaFile, (VirtualFile)schemaDirectory);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        for (Map.Entry<String, Pair<org.jdom.Document, FrameworkDescription>> documentStringEntry : descriptions.entrySet()) {
            try {
                VirtualFile newFile = descriptorsDir.findOrCreateChildData(requestor, FrameworkDataService.getFileName(documentStringEntry.getKey()));
                String text = JDOMUtil.writeDocument((org.jdom.Document)((org.jdom.Document)documentStringEntry.getValue().getFirst()), (String)"\n");
                VfsUtil.saveText((VirtualFile)newFile, (String)text);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public List<FrameworkCommand> getCommands() {
        return (List)this.myCommands.getValue();
    }

    public void saveEditedDescriptions() {
        FileDocumentManager docManager = FileDocumentManager.getInstance();
        ArrayList<Document> docsToSave = new ArrayList<Document>();
        for (CachedValue<Pair<FrameworkConfigurationDescription, String>> framework : this.myFrameworks) {
            Document document;
            VirtualFile file = FrameworkDataServiceBase.getFile(framework);
            if (!docManager.isFileModified(file) || (document = docManager.getDocument(file)) == null) continue;
            docsToSave.add(document);
        }
        Runnable saver = () -> {
            for (Document document : docsToSave) {
                docManager.saveDocument(document);
            }
        };
        Runnable saverInWriteAction = () -> ApplicationManager.getApplication().runWriteAction(saver);
        GuiUtils.invokeLaterIfNeeded((Runnable)saverInWriteAction, (ModalityState)ModalityState.defaultModalityState());
    }

    @Nullable
    protected abstract VirtualFile getDescriptionsDir(boolean var1);

    private void readData() {
        VirtualFile descriptionsDir = this.getDescriptionsDir(false);
        List<CachedValue<Pair<FrameworkConfigurationDescription, String>>> frameworks = FrameworkDataServiceBase.readData(descriptionsDir);
        this.myFrameworks.clear();
        this.myFrameworks.addAll(frameworks);
        this.myCommands = FrameworkDataServiceBase.extractCommandsFromFrameworks(this.myFrameworks, this.myFrameworksModificationTracker);
    }

    private static VirtualFile getFile(CachedValue<Pair<FrameworkConfigurationDescription, String>> framework) {
        return ((FrameworkCachedProvider)framework.getValueProvider()).myFile;
    }

    @NotNull
    private static List<CachedValue<Pair<FrameworkConfigurationDescription, String>>> readData(@Nullable VirtualFile descriptorsDir) {
        VirtualFile[] descriptors;
        if (descriptorsDir == null) {
            List<CachedValue<Pair<FrameworkConfigurationDescription, String>>> list = Collections.emptyList();
            if (list == null) {
                FrameworkDataServiceBase.$$$reportNull$$$0(0);
            }
            return list;
        }
        ArrayList<CachedValue<Pair<FrameworkConfigurationDescription, String>>> frameworks = new ArrayList<CachedValue<Pair<FrameworkConfigurationDescription, String>>>();
        for (VirtualFile descriptor : descriptors = descriptorsDir.getChildren()) {
            if (descriptor.isDirectory()) continue;
            CachedValueImpl<Pair<FrameworkConfigurationDescription, String>> cachedFramework = FrameworkDataServiceBase.getCachedFrameworkDescription(descriptor);
            frameworks.add((CachedValue<Pair<FrameworkConfigurationDescription, String>>)cachedFramework);
        }
        ArrayList<CachedValue<Pair<FrameworkConfigurationDescription, String>>> arrayList = frameworks;
        if (arrayList == null) {
            FrameworkDataServiceBase.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static CachedValueImpl<Pair<FrameworkConfigurationDescription, String>> getCachedFrameworkDescription(VirtualFile descriptor) {
        return new CachedValueImpl<Pair<FrameworkConfigurationDescription, String>>((CachedValueProvider)new FrameworkCachedProvider(descriptor)){

            public boolean isFromMyProject(Project project) {
                return true;
            }
        };
    }

    private static CachedValueImpl<List<FrameworkCommand>> extractCommandsFromFrameworks(List<CachedValue<Pair<FrameworkConfigurationDescription, String>>> frameworks, ModificationTracker tracker) {
        return new CachedValueImpl<List<FrameworkCommand>>(() -> {
            ArrayList<FrameworkCommand> commands = new ArrayList<FrameworkCommand>();
            for (CachedValue framework : frameworks) {
                FrameworkConfigurationDescription description = (FrameworkConfigurationDescription)((Pair)framework.getValue()).getFirst();
                if (description == null || !description.isEnabled()) continue;
                commands.addAll(description.getCommands());
            }
            return new CachedValueProvider.Result(commands, new Object[]{tracker});
        }){

            public boolean isFromMyProject(Project project) {
                return true;
            }
        };
    }

    @Nullable
    protected static VirtualFile getOrCreateChildDir(@Nullable VirtualFile parent, @NotNull String name, boolean createIfNotFound) {
        VirtualFile result;
        if (name == null) {
            FrameworkDataServiceBase.$$$reportNull$$$0(2);
        }
        VirtualFile virtualFile = result = parent == null ? LocalFileSystem.getInstance().findFileByPath(name) : parent.findChild(name);
        if (result == null && createIfNotFound) {
            try {
                result = VfsUtil.createDirectoryIfMissing((VirtualFile)parent, (String)name);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
                return null;
            }
        }
        if (result == null || !result.isValid() || !result.isDirectory()) {
            return null;
        }
        return result;
    }

    @NotNull
    public static FrameworkConfigurationDescription readFromDocument(@NotNull Element element, String fileName) throws SAXException {
        if (element == null) {
            FrameworkDataServiceBase.$$$reportNull$$$0(3);
        }
        if ("framework".equals(element.getName())) {
            List<FrameworkCommand> frameworkCommands = FrameworkDescription.readCommandsFromElement(element, fileName);
            FrameworkDescription framework = frameworkCommands.isEmpty() ? FrameworkDescription.readFromElement(element, fileName) : frameworkCommands.get(0).getFrameworkDescription();
            FrameworkConfigurationDescription frameworkConfigurationDescription = new FrameworkConfigurationDescription(framework, frameworkCommands);
            if (frameworkConfigurationDescription == null) {
                FrameworkDataServiceBase.$$$reportNull$$$0(4);
            }
            return frameworkConfigurationDescription;
        }
        throw new SAXException(FrameworkBundle.message("framework.data.service.root.element.must.be.0", "framework"));
    }

    public List<FrameworkDataService.FrameworkFileData> cloneData() {
        this.saveEditedDescriptions();
        ArrayList<FrameworkDataService.FrameworkFileData> newFrameworks = new ArrayList<FrameworkDataService.FrameworkFileData>(this.myFrameworks.size());
        for (CachedValue<Pair<FrameworkConfigurationDescription, String>> frameworkCachedValue : this.myFrameworks) {
            Pair value = (Pair)frameworkCachedValue.getValue();
            FrameworkConfigurationDescription framework = (FrameworkConfigurationDescription)value.getFirst();
            if (framework == null) {
                newFrameworks.add(new FrameworkDataService.FrameworkFileData(null, (String)value.getSecond(), FrameworkDataServiceBase.getFile(frameworkCachedValue).getName(), this.isProjectLevel()));
                continue;
            }
            FrameworkDescription newFramework = framework.getFramework().cloneFramework();
            List<FrameworkCommand> oldCommands = framework.getCommands();
            ArrayList<FrameworkCommand> newCommands = new ArrayList<FrameworkCommand>(oldCommands.size());
            for (FrameworkCommand command : oldCommands) {
                FrameworkCommand newCommand = command.cloneCommand();
                newCommand.setFrameworkDescription(newFramework);
                newCommands.add(newCommand);
            }
            newFrameworks.add(new FrameworkDataService.FrameworkFileData(new FrameworkConfigurationDescription(newFramework, newCommands), null, FrameworkDataService.getFileName(newFramework.getName()), this.isProjectLevel()));
        }
        return newFrameworks;
    }

    protected abstract boolean isProjectLevel();

    public Map<String, String> getAliasesAndHelp() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (CachedValue<Pair<FrameworkConfigurationDescription, String>> cachedValue : this.myFrameworks) {
            FrameworkConfigurationDescription framework = (FrameworkConfigurationDescription)((Pair)cachedValue.getValue()).getFirst();
            if (framework == null || !framework.isEnabled()) continue;
            result.put(framework.getAlias(), framework.getHelp());
        }
        return result;
    }

    public Map<String, String> getAliasesAndInvokeTexts() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (CachedValue<Pair<FrameworkConfigurationDescription, String>> cachedValue : this.myFrameworks) {
            FrameworkConfigurationDescription framework = (FrameworkConfigurationDescription)((Pair)cachedValue.getValue()).getFirst();
            if (framework == null || !framework.isEnabled()) continue;
            result.put(framework.getAlias(), framework.getInvokeText());
        }
        return result;
    }

    public List<Pair<String, VirtualFile>> getErrorMessages() {
        ArrayList<Pair<String, VirtualFile>> errorMessages = new ArrayList<Pair<String, VirtualFile>>();
        for (CachedValue<Pair<FrameworkConfigurationDescription, String>> pairCachedValue : this.myFrameworks) {
            String message = (String)((Pair)pairCachedValue.getValue()).getSecond();
            if (message == null) continue;
            errorMessages.add((Pair<String, VirtualFile>)Pair.create((Object)message, (Object)FrameworkDataServiceBase.getFile(pairCachedValue)));
        }
        return errorMessages;
    }

    public void loadChanged(List<FrameworkDataService.FrameworkFileData> frameworksCache) {
        this.saveAndReadData(frameworksCache, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/framework/data/FrameworkDataServiceBase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "readData";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/framework/data/FrameworkDataServiceBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "readFromDocument";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateChildDir";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readFromDocument";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FrameworkCachedProvider
    implements CachedValueProvider<Pair<FrameworkConfigurationDescription, String>> {
        private final VirtualFile myFile;

        private FrameworkCachedProvider(VirtualFile file) {
            this.myFile = file;
        }

        public CachedValueProvider.Result<Pair<FrameworkConfigurationDescription, String>> compute() {
            FrameworkConfigurationDescription value = null;
            String errorMessage = null;
            try (InputStream stream = this.myFile.getInputStream();){
                value = FrameworkDataServiceBase.readFromDocument(JdomKt.loadElement((InputStream)stream), this.myFile.getName());
            }
            catch (IOException e) {
                LOG.warn("Failed to read command line tools config file " + FileUtil.toSystemDependentName((String)this.myFile.getPath()), (Throwable)e);
                errorMessage = FrameworkBundle.message("framework.data.service.failed.to.read.command.line.tools.config.file.0", e.getMessage());
            }
            catch (JDOMException e) {
                LOG.warn("Failed to read command line tools config file " + FileUtil.toSystemDependentName((String)this.myFile.getPath()), (Throwable)e);
                errorMessage = e.getMessage();
            }
            catch (SAXException e) {
                errorMessage = e.getMessage();
            }
            return new CachedValueProvider.Result((Object)Pair.create(value, (Object)errorMessage), new Object[]{this.myFile});
        }
    }
}

