/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework.ui;

import com.intellij.CommonBundle;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.OSProcessManager;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.ExporterToTextFile;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindowManager;
import com.jetbrains.php.FrameworkBundle;
import com.jetbrains.php.framework.ui.FrameworkToolWindowComponent;
import com.jetbrains.php.framework.ui.FrameworkUiUtils;
import java.io.File;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FrameworkConsoleViewImpl
extends ConsoleViewImpl {
    @NonNls
    private static final String CONSOLE_HELP_ID = "reference.tool.window.command.line.tools.console";
    @NonNls
    private static final String CONSOLE_EXPORT_PATH_ID = "command.line.tools.console.export.path";
    @NonNls
    private static final String INITIAL_DEFAULT_PATH = "consoleOutput.txt";
    private static final long KILLING_PROCESS_TIMEOUT_IN_MILLISECONDS = 3000L;
    private static final int COMMANDS_LAYER = 5880;
    private static final String COMMAND_LINE_BEGINNING = FrameworkBundle.message("framework.console.command.line.prefix", "");
    private static final HyperlinkInfo EMPTY_HYPERLINK_INFO = new HyperlinkInfo(){

        public void navigate(Project project) {
        }
    };
    private final FrameworkToolWindowComponent myToolWindowComponent;
    private final boolean myCreateExtraActions;
    private final ExporterToTextFile myToFileExporter;

    public FrameworkConsoleViewImpl(final Project project, boolean viewer, FrameworkToolWindowComponent parent) {
        super(project, viewer);
        this.myToolWindowComponent = parent;
        this.myCreateExtraActions = !viewer;
        this.setHelpId(CONSOLE_HELP_ID);
        this.myToFileExporter = new ExporterToTextFile(){

            @NotNull
            public String getReportText() {
                Editor editor = (Editor)CommonDataKeys.EDITOR.getData((DataProvider)FrameworkConsoleViewImpl.this);
                String string = editor == null ? "" : editor.getDocument().getText();
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getDefaultFilePath() {
                PropertiesComponent component = PropertiesComponent.getInstance((Project)project);
                String path = component.getValue(FrameworkConsoleViewImpl.CONSOLE_EXPORT_PATH_ID);
                if (path == null) {
                    path = project.getBasePath();
                    if (path == null) {
                        if ("" == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        return "";
                    }
                    String string = path + File.separator + FrameworkConsoleViewImpl.INITIAL_DEFAULT_PATH;
                    if (string == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    return string;
                }
                String string = path;
                if (string == null) {
                    2.$$$reportNull$$$0(3);
                }
                return string;
            }

            public void exportedTo(@NotNull String filePath) {
                if (filePath == null) {
                    2.$$$reportNull$$$0(4);
                }
                PropertiesComponent component = PropertiesComponent.getInstance((Project)project);
                component.setValue(FrameworkConsoleViewImpl.CONSOLE_EXPORT_PATH_ID, filePath);
            }

            public boolean canExport() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 4: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 4: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/framework/ui/FrameworkConsoleViewImpl$2";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "filePath";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReportText";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDefaultFilePath";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/framework/ui/FrameworkConsoleViewImpl$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "exportedTo";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 4: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    public void printCommandStartSign() {
        this.flushDeferredText();
        String text = "\n" + COMMAND_LINE_BEGINNING;
        this.print(text, ConsoleViewContentType.SYSTEM_OUTPUT);
        int newSize = this.getContentSize();
        this.flushDeferredText();
        TextAttributes textAttributes = ConsoleViewContentType.SYSTEM_OUTPUT.getAttributes();
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData((DataProvider)this);
        assert (editor != null);
        RangeHighlighter highlighter = editor.getMarkupModel().addRangeHighlighter(newSize - text.length() + 1, newSize, 5880, textAttributes, HighlighterTargetArea.EXACT_RANGE);
        EditorHyperlinkSupport.associateHyperlink((RangeHighlighter)highlighter, (HyperlinkInfo)EMPTY_HYPERLINK_INFO);
    }

    protected OccurenceNavigator.OccurenceInfo calcNextOccurrence(int delta) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData((DataProvider)this);
        assert (editor != null);
        return EditorHyperlinkSupport.getNextOccurrence((Editor)editor, (int)delta, range -> this.scrollTo(range.getStartOffset()));
    }

    @NotNull
    public String getNextOccurenceActionName() {
        String string = FrameworkBundle.message("framework.next.action.name.to.next.command", new Object[0]);
        if (string == null) {
            FrameworkConsoleViewImpl.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getPreviousOccurenceActionName() {
        String string = FrameworkBundle.message("framework.previous.action.name.to.previous.command", new Object[0]);
        if (string == null) {
            FrameworkConsoleViewImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public AnAction[] createConsoleActions() {
        AnAction[] oldActions = super.createConsoleActions();
        if (this.myCreateExtraActions) {
            AnAction[] newActions = new AnAction[oldActions.length + 4];
            newActions[0] = new StopExecutionAction();
            AnAction toTextFileAction = CommonActionsManager.getInstance().createExportToTextFileAction(this.myToFileExporter);
            toTextFileAction.getTemplatePresentation().setDescription(FrameworkBundle.message("framework.console.export.action.description", new Object[0]));
            newActions[oldActions.length + 1] = toTextFileAction;
            newActions[oldActions.length + 2] = new CloseToolWindowAction();
            AnAction helpAction = CommonActionsManager.getInstance().createHelpAction(CONSOLE_HELP_ID);
            helpAction.getTemplatePresentation().setDescription(FrameworkBundle.message("framework.console.help.action.description", new Object[0]));
            newActions[oldActions.length + 3] = helpAction;
            System.arraycopy(oldActions, 0, newActions, 1, oldActions.length);
            if (newActions == null) {
                FrameworkConsoleViewImpl.$$$reportNull$$$0(2);
            }
            return newActions;
        }
        if (oldActions == null) {
            FrameworkConsoleViewImpl.$$$reportNull$$$0(3);
        }
        return oldActions;
    }

    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            FrameworkConsoleViewImpl.$$$reportNull$$$0(4);
        }
        if (PlatformDataKeys.EXPORTER_TO_TEXT_FILE.is(dataId)) {
            return this.myToFileExporter;
        }
        return super.getData(dataId);
    }

    void installActions() {
        AnAction[] actions;
        DefaultActionGroup group = new DefaultActionGroup(){

            public boolean isDumbAware() {
                return true;
            }
        };
        for (AnAction action : actions = this.createConsoleActions()) {
            group.add(action);
        }
        ActionToolbar tb = ActionManager.getInstance().createActionToolbar("PhpFrameworkConsole", (ActionGroup)group, false);
        tb.setTargetComponent(this.getComponent());
        this.add(tb.getComponent(), "West");
    }

    public void println(@NotNull String text, @NotNull ConsoleViewContentType contentType) {
        if (text == null) {
            FrameworkConsoleViewImpl.$$$reportNull$$$0(5);
        }
        if (contentType == null) {
            FrameworkConsoleViewImpl.$$$reportNull$$$0(6);
        }
        super.print(text + "\n", contentType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/framework/ui/FrameworkConsoleViewImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextOccurenceActionName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviousOccurenceActionName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleActions";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/framework/ui/FrameworkConsoleViewImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "println";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CloseToolWindowAction
    extends AnAction
    implements DumbAware {
        private CloseToolWindowAction() {
            super(CommonBundle.message((String)"action.close", (Object[])new Object[0]), FrameworkBundle.message("framework.close.action.name.close.tool.window", new Object[0]), AllIcons.Actions.Cancel);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CloseToolWindowAction.$$$reportNull$$$0(0);
            }
            if (FrameworkConsoleViewImpl.this.myToolWindowComponent.tryToCloseProcesses()) {
                Project project = e.getProject();
                if (project == null) {
                    return;
                }
                ToolWindowManager.getInstance((Project)project).unregisterToolWindow(FrameworkUiUtils.TOOL_WINDOW_ID);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/framework/ui/FrameworkConsoleViewImpl$CloseToolWindowAction", "actionPerformed"));
        }
    }

    private class StopExecutionAction
    extends AnAction {
        private StopExecutionAction() {
            super(FrameworkBundle.message("framework.stop.action.name", new Object[0]), FrameworkBundle.message("framework.stop.execution.description", new Object[0]), AllIcons.Actions.Suspend);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                StopExecutionAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(FrameworkConsoleViewImpl.this.isRunning());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            OSProcessHandler handler;
            if (e == null) {
                StopExecutionAction.$$$reportNull$$$0(1);
            }
            if ((handler = FrameworkConsoleViewImpl.this.myToolWindowComponent.getProcessHandler(FrameworkConsoleViewImpl.this)) != null && !handler.isProcessTerminated()) {
                OSProcessManager.getInstance().killProcessTree(handler.getProcess());
                if (!handler.waitFor(3000L)) {
                    handler.destroyProcess();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/jetbrains/php/framework/ui/FrameworkConsoleViewImpl$StopExecutionAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

