/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote.interpreter.ui;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.RemoteSdkException;
import com.intellij.ui.IdeBorderFactory;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.interpreters.PhpConfigurationFileAction;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpreterComponent;
import com.jetbrains.php.config.interpreters.PhpInterpretersPhpInfoCacheImpl;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import com.jetbrains.php.config.phpInfo.PhpInfoUtil;
import com.jetbrains.php.config.phpInfo.PhpNonPersistedInfo;
import com.jetbrains.php.remote.PhpRemoteInterpreterManagerImpl;
import com.jetbrains.php.remote.PhpRemoteSdkBundle;
import com.jetbrains.php.remote.PhpRemoteTransfer;
import com.jetbrains.php.remote.interpreter.PhpRemoteSdkAdditionalData;
import com.jetbrains.php.remote.interpreter.ui.PhpDeploymentConfigurationValidator;
import com.jetbrains.php.remote.interpreter.ui.PhpInplaceEditRemoteSdkForm;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import com.jetbrains.php.ui.ResultMessage;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.remotesdk.ui.RemoteSdkEditorContainer;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpRemoteInterpreterComponent
extends PhpInterpreterComponent
implements RemoteSdkEditorContainer {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.php.remote.interpreter.ui.PhpRemoteInterpreterComponent");
    private final Project myProject;
    private final String myInterpreterId;
    private String myInterpreterName;
    private final PhpInplaceEditRemoteSdkForm myInterpreterForm;
    private final String myHelpersPath;
    private final PhpDeploymentConfigurationValidator myValidator;
    private final Disposable myDisposable;

    public PhpRemoteInterpreterComponent(@NotNull Project project, @NotNull PhpRemoteSdkAdditionalData data, @NotNull String interpreterName) {
        if (project == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(0);
        }
        if (data == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(1);
        }
        if (interpreterName == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(2);
        }
        super(project, (PhpSdkAdditionalData)data);
        this.myDisposable = new Disposable(){

            public void dispose() {
                if (PhpRemoteInterpreterComponent.this.myInterpreterForm != null) {
                    PhpRemoteInterpreterComponent.this.myInterpreterForm.disposeUI();
                }
            }
        };
        this.myProject = project;
        this.myHelpersPath = data.getHelpersPath();
        this.myInterpreterId = data.getInterpreterId();
        this.myValidator = new PhpDeploymentConfigurationValidator(this.myIsProjectLevel);
        this.myInterpreterForm = new PhpInplaceEditRemoteSdkForm(this.myProject, this);
        this.init(interpreterName);
    }

    protected void init(@NotNull String interpreterName) {
        if (interpreterName == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(3);
        }
        super.init(interpreterName);
        this.myInterpreterName = interpreterName;
        this.myLastLoadedInfo = PhpInterpretersPhpInfoCacheImpl.getInstance((Project)this.myProject).getPhpInfo(interpreterName);
        this.myLastLoadedNonPersistedInfo = null;
    }

    public JPanel getMainPanel() {
        JPanel remotePanel = new JPanel(new BorderLayout());
        remotePanel.add((Component)((Object)this.myInterpreterForm), "Center");
        remotePanel.setBorder(IdeBorderFactory.createTitledBorder((String)PhpRemoteSdkBundle.message("remote.interpreter.configure.remote.title", new Object[0])));
        JPanel panel = new JPanel(new BorderLayout());
        JPanel mainPanel = super.getMainPanel();
        panel.add((Component)remotePanel, "North");
        panel.add((Component)mainPanel, "Center");
        return panel;
    }

    @NotNull
    protected ResultMessage reloadPhpInfo() {
        ResultMessage resultMessage;
        block5: {
            PhpRemoteInterpreterManager manager = PhpRemoteInterpreterManager.getInstance();
            if (manager == null) {
                ResultMessage resultMessage2 = new ResultMessage("Remote interpreter can't be executed. Please enable the PHP Remote Interpreter plugin.", MessageType.ERROR);
                if (resultMessage2 == null) {
                    PhpRemoteInterpreterComponent.$$$reportNull$$$0(4);
                }
                return resultMessage2;
            }
            try {
                PhpRemoteSdkAdditionalData data = this.createSdkData();
                Pair info = PhpInfoUtil.getWholePhpInfo((Project)this.myProject, (String)data.getInterpreterPath(), (PhpSdkAdditionalData)data, (List)this.getConfigurationOption(), (JComponent)this.myMainPanel);
                this.myLastLoadedInfo = (PhpInfo)info.getFirst();
                this.myLastLoadedNonPersistedInfo = (PhpNonPersistedInfo)info.getSecond();
                this.resetPhpInfo();
                resultMessage = new ResultMessage(PhpBundle.message((String)"PhpInterpreterConfigurable.updated.phpinfo", (Object[])new Object[0]), MessageType.INFO);
                if (resultMessage != null) break block5;
            }
            catch (Exception e) {
                LOG.warn("Can not update phpinfo", (Throwable)e);
                this.myLastLoadedInfo = null;
                this.myLastLoadedNonPersistedInfo = null;
                this.resetPhpInfo();
                String message = StringUtil.notNullize((String)e.getMessage(), (String)PhpBundle.message((String)"PhpInterpreterConfigurable.can.not.updated.phpinfo", (Object[])new Object[0]));
                ResultMessage resultMessage3 = new ResultMessage(message, MessageType.ERROR);
                if (resultMessage3 == null) {
                    PhpRemoteInterpreterComponent.$$$reportNull$$$0(6);
                }
                return resultMessage3;
            }
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(5);
        }
        return resultMessage;
    }

    protected boolean canReloadPhpInfo() {
        return true;
    }

    @Nullable
    protected PhpConfigurationFileAction createOpenFileAction() {
        if (!PhpRemoteInterpreterManagerImpl.supportRemoteBrowseAction(this.createSdkData())) {
            return null;
        }
        return new PhpConfigurationFileAction("Open in Editor"){

            public void run(@Nullable String path) {
                if (StringUtil.isEmpty((String)path)) {
                    return;
                }
                try {
                    PhpRemoteSdkAdditionalData data = PhpRemoteInterpreterComponent.this.createSdkData();
                    RemoteSdkCredentials credentials = data.getRemoteSdkCredentials(PhpRemoteInterpreterComponent.this.myProject, false);
                    if (RemoteSdkUtil.testConnection((Component)PhpRemoteInterpreterComponent.this.myMainPanel, (RemoteSdkCredentials)credentials, (boolean)false)) {
                        new PhpRemoteTransfer(PhpRemoteInterpreterComponent.this.myProject, null, credentials).editRemoteFile(PhpRemoteInterpreterComponent.this.myInterpreterName, path);
                    }
                }
                catch (InterruptedException e) {
                    LOG.warn("Can not open remote file by path '" + path + "'", (Throwable)e);
                }
                catch (ExecutionException e) {
                    LOG.warn("Can not open remote file by path '" + path + "'", (Throwable)e);
                    this.showErrorDialog(e.getMessage());
                }
            }

            private void showErrorDialog(@Nullable String error) {
                String title = PhpRemoteSdkBundle.message("remote.interpreter.open.remote.file.title", new Object[0]);
                String message = PhpRemoteSdkBundle.message("remote.interpreter.can.not.open.remote.file", error);
                Messages.showErrorDialog((Component)((Object)PhpRemoteInterpreterComponent.this.myInterpreterForm), (String)message, (String)title);
            }
        };
    }

    @Nullable
    protected ProcessOutput executeCommand(@NotNull String title, @NotNull String command) throws ExecutionException {
        if (title == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(7);
        }
        if (command == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(8);
        }
        PhpRemoteInterpreterManager manager = PhpRemoteInterpreterManager.getInstance();
        assert (manager != null);
        try {
            PhpRemoteSdkAdditionalData remoteData = this.createSdkData();
            GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{remoteData.getInterpreterPath(), command});
            return manager.getProcessOutput(this.myProject, (PhpSdkAdditionalData)remoteData, commandLine, title, (JComponent)this.myMainPanel);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    @NotNull
    private PhpRemoteSdkAdditionalData createSdkData() {
        PhpRemoteSdkAdditionalData remoteData;
        try {
            remoteData = (PhpRemoteSdkAdditionalData)this.myInterpreterForm.createSdkData();
        }
        catch (RemoteSdkException e) {
            LOG.error((Throwable)e);
            throw new RuntimeException(e);
        }
        remoteData.setInterpreterId(this.myInterpreterId);
        PhpRemoteSdkAdditionalData phpRemoteSdkAdditionalData = remoteData;
        if (phpRemoteSdkAdditionalData == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(9);
        }
        return phpRemoteSdkAdditionalData;
    }

    protected String getInterpreterPath(@NotNull String name, @NotNull PhpSdkAdditionalData data, @NotNull PhpInterpreter interpreter) {
        if (name == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(10);
        }
        if (data == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(11);
        }
        if (interpreter == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(12);
        }
        return data instanceof PhpRemoteSdkAdditionalData ? ((PhpRemoteSdkAdditionalData)data).getInterpreterPath() : "";
    }

    protected String getNewFullInterpreterPath() throws RemoteSdkException {
        return ((PhpRemoteSdkAdditionalData)this.myInterpreterForm.createSdkData()).getFullInterpreterPath();
    }

    public void reset(@NotNull String name, @NotNull PhpSdkAdditionalData data, @NotNull PhpInterpreter interpreter) {
        if (name == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(13);
        }
        if (data == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(14);
        }
        if (interpreter == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(15);
        }
        if (data instanceof PhpRemoteSdkAdditionalData) {
            this.myInterpreterForm.init((PhpRemoteSdkAdditionalData)data);
        }
        super.reset(name, data, interpreter);
    }

    @NotNull
    protected String getPresentableInterpreterPath(@NotNull String name, @NotNull PhpSdkAdditionalData data, @NotNull PhpInterpreter interpreter) {
        if (name == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(16);
        }
        if (data == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(17);
        }
        if (interpreter == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(18);
        }
        String string = StringUtil.notNullize((String)this.getInterpreterPath(name, data, interpreter));
        if (string == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(19);
        }
        return string;
    }

    public void apply(@NotNull PhpInterpreter interpreter) throws RemoteSdkException, ConfigurationException {
        ValidationInfo info;
        if (interpreter == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(20);
        }
        if ((info = this.myInterpreterForm.validateRemoteInterpreter()) != null) {
            throw new ConfigurationException(info.message);
        }
        PhpRemoteSdkAdditionalData data = (PhpRemoteSdkAdditionalData)this.myInterpreterForm.createSdkData();
        data.copyToRemote((PhpRemoteSdkAdditionalData)this.mySdkAdditionalData);
        super.apply(interpreter);
    }

    protected String getInterpreterPath() {
        return this.myPathTextField.getText();
    }

    protected String getHelpersPath() {
        return this.myHelpersPath;
    }

    @Nullable
    public String validate(@NotNull WebServerConfig config) {
        if (config == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(21);
        }
        return this.myValidator.validate(config);
    }

    public void setIsProjectLevel() {
        this.myValidator.setIsProjectLevel();
    }

    public void addListener(@NotNull ChangeListener changeListener) {
        if (changeListener == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(22);
        }
        this.myValidator.addListener(changeListener);
    }

    public boolean isModified(@NotNull String name, @NotNull PhpSdkAdditionalData data, @NotNull PhpInterpreter interpreter) {
        if (name == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(23);
        }
        if (data == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(24);
        }
        if (interpreter == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(25);
        }
        if (!this.isSdkSupported(this.mySdkAdditionalData)) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)((PhpRemoteSdkAdditionalData)this.mySdkAdditionalData).getInterpreterPath(), (CharSequence)this.getInterpreterPath())) {
            return true;
        }
        try {
            if (!this.mySdkAdditionalData.equals((Object)this.myInterpreterForm.createSdkData())) {
                return true;
            }
        }
        catch (RemoteSdkException e) {
            LOG.debug((Throwable)e);
        }
        return super.isModified(name, data, interpreter);
    }

    protected boolean isSdkSupported(PhpSdkAdditionalData additionalData) {
        return this.myInterpreterForm.isConnectionTypeSupported(((PhpRemoteSdkAdditionalData)additionalData).getRemoteConnectionType());
    }

    protected void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.myInterpreterForm.setEnabled(enabled);
    }

    public void disposeUIResources() {
        if (this.myDisposable != null) {
            Disposer.dispose((Disposable)this.myDisposable);
        }
        super.disposeUIResources();
    }

    public void updateSize() {
    }

    @NotNull
    public Disposable getDisposable() {
        Disposable disposable = this.myDisposable;
        if (disposable == null) {
            PhpRemoteInterpreterComponent.$$$reportNull$$$0(26);
        }
        return disposable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 19: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 19: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 11: 
            case 14: 
            case 17: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 19: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/remote/interpreter/ui/PhpRemoteInterpreterComponent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 10: 
            case 13: 
            case 16: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: 
            case 15: 
            case 18: 
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/remote/interpreter/ui/PhpRemoteInterpreterComponent";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "reloadPhpInfo";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createSdkData";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableInterpreterPath";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 19: 
            case 26: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "executeCommand";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getInterpreterPath";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableInterpreterPath";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 19: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

