/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.model.hyperlinks;

import com.google.common.collect.Lists;
import com.jediterm.terminal.HyperlinkStyle;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.model.CharBuffer;
import com.jediterm.terminal.model.TerminalLine;
import com.jediterm.terminal.model.hyperlinks.HyperlinkFilter;
import com.jediterm.terminal.model.hyperlinks.LinkResult;
import com.jediterm.terminal.model.hyperlinks.LinkResultItem;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TextProcessing {
    private final List<HyperlinkFilter> myHyperlinkFilter;
    private TextStyle myHyperlinkColor;
    private HyperlinkStyle.HighlightMode myHighlightMode;

    public TextProcessing(TextStyle hyperlinkColor, HyperlinkStyle.HighlightMode highlightMode) {
        this.myHyperlinkColor = hyperlinkColor;
        this.myHighlightMode = highlightMode;
        this.myHyperlinkFilter = Lists.newArrayList();
    }

    public void processHyperlinks(TerminalLine line) {
        if (this.myHyperlinkFilter.isEmpty()) {
            return;
        }
        line.runWithLock(() -> {
            String lineStr = line.getText();
            for (HyperlinkFilter filter : this.myHyperlinkFilter) {
                LinkResult result = filter.apply(lineStr);
                if (result == null) continue;
                for (LinkResultItem item : result.getItems()) {
                    HyperlinkStyle style = new HyperlinkStyle(this.myHyperlinkColor.getForeground(), this.myHyperlinkColor.getBackground(), item.getLinkInfo()).withHighlightMode(this.myHighlightMode);
                    if (item.getStartOffset() < 0 || item.getEndOffset() > lineStr.length()) continue;
                    line.writeString(item.getStartOffset(), new CharBuffer(lineStr.substring(item.getStartOffset(), item.getEndOffset())), style);
                }
            }
        });
    }

    public void addHyperlinkFilter(@NotNull HyperlinkFilter filter) {
        this.myHyperlinkFilter.add(filter);
    }
}

