/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.boilerplate.express;

import com.intellij.execution.ExecutionException;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.platform.WebProjectGenerator;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.nodejs.boilerplate.express.ExpressProjectSettings;
import com.jetbrains.nodejs.boilerplate.express.ExpressStylesheetEngine;
import com.jetbrains.nodejs.boilerplate.express.ExpressTemplateEngine;
import com.jetbrains.nodejs.boilerplate.express.NodePackageVersion;
import com.jetbrains.nodejs.boilerplate.express.NodePackageVersionListener;
import com.jetbrains.nodejs.boilerplate.express.NodePackageVersionView;
import com.jetbrains.nodejs.util.ui.UIHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpressProjectPeer
implements WebProjectGenerator.GeneratorPeer<ExpressProjectSettings> {
    private final List<WebProjectGenerator.SettingsStateListener> myStateListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final NodeJsInterpreterField myInterpreterField;
    private final NodePackageField myNpmPackageField;
    private final NodePackageVersionView myExpressGeneratorVersionView;
    private final ComboBox<ExpressTemplateEngine> myTemplateEngine;
    private final ComboBox<ExpressStylesheetEngine> myStylesheetEngine;
    private final JPanel myContentPanel;
    private final JPanel myOptionsPanel;

    protected ExpressProjectPeer() {
        Project defaultProject = ProjectManager.getInstance().getDefaultProject();
        this.myInterpreterField = new NodeJsInterpreterField(defaultProject, false){

            public boolean isDefaultProjectInterpreterField() {
                return true;
            }
        };
        this.myInterpreterField.setInterpreterRef(NodeJsInterpreterManager.getInstance((Project)defaultProject).getInterpreterRef());
        this.myNpmPackageField = NpmUtil.createPackageManagerPackageField((NodeJsInterpreterField)this.myInterpreterField, (boolean)true);
        this.myNpmPackageField.setSelectedRef(NodePackageRef.create((String)"npm"));
        this.myTemplateEngine = UIHelper.createCombobox("Unavailable");
        this.myTemplateEngine.setPrototypeDisplayValue((Object)ExpressTemplateEngine.NO_VIEW);
        this.myStylesheetEngine = UIHelper.createCombobox("Unavailable");
        this.myExpressGeneratorVersionView = new NodePackageVersionView("express-generator", new MyNodePackageVersionListener());
        this.myExpressGeneratorVersionView.update();
        this.myOptionsPanel = ExpressProjectPeer.createOptionsPanel(this.myExpressGeneratorVersionView, this.myTemplateEngine, this.myStylesheetEngine);
        JPanel pathsPanel = this.createPathsPanel();
        this.myContentPanel = UIHelper.createGrowingDownPanelWithHorizontallyStretchedComponent(SwingHelper.newLeftAlignedVerticalPanel((Component[])new Component[]{pathsPanel, this.myOptionsPanel}));
        this.myNpmPackageField.addSelectionListener(aPackage -> this.fireStateChanged(false));
    }

    private void fireStateChanged(boolean validSettings) {
        for (WebProjectGenerator.SettingsStateListener listener : this.myStateListeners) {
            listener.stateChanged(validSettings);
        }
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myContentPanel;
        if (jPanel == null) {
            ExpressProjectPeer.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    public void buildUI(@NotNull SettingsStep settingsStep) {
        if (settingsStep == null) {
            ExpressProjectPeer.$$$reportNull$$$0(1);
        }
        settingsStep.addSettingsField(UIUtil.replaceMnemonicAmpersand((String)"&Node interpreter:"), (JComponent)this.myInterpreterField);
        settingsStep.addSettingsField(UIUtil.replaceMnemonicAmpersand((String)"Package &manager:"), (JComponent)this.myNpmPackageField);
        settingsStep.addSettingsComponent((JComponent)this.myOptionsPanel);
    }

    @NotNull
    public ExpressProjectSettings getSettings() {
        NodePackage npmPkg;
        NodeJsInterpreter interpreter;
        NodePackageVersion expressGeneratorVersion = this.myExpressGeneratorVersionView.getVersion();
        if (expressGeneratorVersion == null) {
            throw new RuntimeException("express-generator version isn't selected");
        }
        SemVer ver = SemVer.parseFromText((String)expressGeneratorVersion.getRawVersion());
        ExpressTemplateEngine defaultTemplateEngine = ExpressTemplateEngine.JADE;
        if (ver == null || ver.isGreaterOrEqualThan(4, 15, 0)) {
            defaultTemplateEngine = ExpressTemplateEngine.PUG;
        }
        ExpressTemplateEngine templateEngine = (ExpressTemplateEngine)ObjectUtils.notNull((Object)((ExpressTemplateEngine)this.myTemplateEngine.getSelectedItem()), (Object)defaultTemplateEngine);
        ExpressStylesheetEngine cssEngine = (ExpressStylesheetEngine)ObjectUtils.notNull((Object)((ExpressStylesheetEngine)this.myStylesheetEngine.getSelectedItem()), (Object)ExpressStylesheetEngine.PLAIN_CSS);
        NodeJsInterpreterRef interpreterRef2 = this.myInterpreterField.getInterpreterRef();
        try {
            interpreter = interpreterRef2.resolveNotNull(this.myInterpreterField.getProject());
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        NodePackageRef npmPkgRef = this.myNpmPackageField.getSelectedRef();
        try {
            npmPkg = NpmUtil.resolvePackageRefOrThrow((NodePackageRef)npmPkgRef, null, (NodeJsInterpreter)interpreter);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        ExpressProjectSettings expressProjectSettings = new ExpressProjectSettings(interpreterRef2, interpreter, npmPkgRef, npmPkg, expressGeneratorVersion, templateEngine, cssEngine);
        if (expressProjectSettings == null) {
            ExpressProjectPeer.$$$reportNull$$$0(2);
        }
        return expressProjectSettings;
    }

    public ValidationInfo validate() {
        NodeJsInterpreter interpreter = this.myInterpreterField.getInterpreter();
        String errorMessage = NodeInterpreterUtil.validateAndGetErrorMessage((NodeJsInterpreter)interpreter);
        if (errorMessage != null) {
            return new ValidationInfo(errorMessage, (JComponent)this.myInterpreterField);
        }
        try {
            NodePackage pkg = NpmUtil.resolvePackageRefOrThrow((NodePackageRef)this.myNpmPackageField.getSelectedRef(), null, (NodeJsInterpreter)interpreter);
            NpmUtil.getValidNpmCliJsFilePath((NodePackage)pkg);
        }
        catch (ExecutionException e) {
            return new ValidationInfo(e.getMessage(), (JComponent)this.myNpmPackageField);
        }
        NodePackageVersion version = this.myExpressGeneratorVersionView.getVersion();
        if (version == null) {
            if (this.myExpressGeneratorVersionView.isLoadingVersions()) {
                return new ValidationInfo("", null);
            }
            return new ValidationInfo("Unspecified express-generator package version", (JComponent)this.myExpressGeneratorVersionView.getComboBox());
        }
        ExpressTemplateEngine templateEngine = (ExpressTemplateEngine)ObjectUtils.tryCast((Object)this.myTemplateEngine.getSelectedItem(), ExpressTemplateEngine.class);
        if (templateEngine == null) {
            return new ValidationInfo("Template engine is unavailable", this.myTemplateEngine);
        }
        ExpressStylesheetEngine stylesheetEngine = (ExpressStylesheetEngine)ObjectUtils.tryCast((Object)this.myStylesheetEngine.getSelectedItem(), ExpressStylesheetEngine.class);
        if (stylesheetEngine == null) {
            return new ValidationInfo("Stylesheet engine is unavailable", this.myStylesheetEngine);
        }
        return null;
    }

    public boolean isBackgroundJobRunning() {
        return this.myExpressGeneratorVersionView.isLoadingVersions();
    }

    public void addSettingsStateListener(@NotNull WebProjectGenerator.SettingsStateListener listener) {
        if (listener == null) {
            ExpressProjectPeer.$$$reportNull$$$0(3);
        }
        this.myStateListeners.add(listener);
    }

    @NotNull
    private JPanel createPathsPanel() {
        JPanel jPanel = new FormBuilder().addLabeledComponent("&Node interpreter:", (JComponent)this.myInterpreterField).addLabeledComponent("Package &manager:", (JComponent)this.myNpmPackageField).getPanel();
        if (jPanel == null) {
            ExpressProjectPeer.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    @NotNull
    private static JPanel createOptionsPanel(@NotNull NodePackageVersionView expressGeneratorVersionView, @NotNull ComboBox templateEngine, @NotNull ComboBox cssEngine) {
        if (expressGeneratorVersionView == null) {
            ExpressProjectPeer.$$$reportNull$$$0(5);
        }
        if (templateEngine == null) {
            ExpressProjectPeer.$$$reportNull$$$0(6);
        }
        if (cssEngine == null) {
            ExpressProjectPeer.$$$reportNull$$$0(7);
        }
        LabeledComponent<JComponent> versionLabeledComponent = ExpressProjectPeer.createLabeledComponent("&Version:", expressGeneratorVersionView.getComponent());
        LabeledComponent<JComponent> templateLabeledComponent = ExpressProjectPeer.createLabeledComponent("&Template:", (JComponent)templateEngine);
        LabeledComponent<JComponent> cssLabeledComponent = ExpressProjectPeer.createLabeledComponent("&CSS:", (JComponent)cssEngine);
        UIUtil.mergeComponentsWithAnchor((PanelWithAnchor[])new PanelWithAnchor[]{versionLabeledComponent, templateLabeledComponent, cssLabeledComponent});
        ExpressProjectPeer.setMaxPreferredWidth(expressGeneratorVersionView.getComboBox(), templateEngine, cssEngine);
        JPanel expressGeneratorPanel = ExpressProjectPeer.createExpressGeneratorPanel(versionLabeledComponent);
        JPanel optionsPanel = SwingHelper.newLeftAlignedVerticalPanel((Component[])new Component[]{templateLabeledComponent, Box.createVerticalStrut(4), cssLabeledComponent});
        optionsPanel.setBorder(IdeBorderFactory.createTitledBorder((String)"Options"));
        JPanel jPanel = SwingHelper.newLeftAlignedVerticalPanel((Component[])new Component[]{Box.createVerticalStrut(10), expressGeneratorPanel, Box.createVerticalStrut(4), optionsPanel});
        if (jPanel == null) {
            ExpressProjectPeer.$$$reportNull$$$0(8);
        }
        return jPanel;
    }

    private static void setMaxPreferredWidth(ComboBox ... comboBoxes) {
        int maxWidth = 0;
        for (ComboBox box : comboBoxes) {
            maxWidth = Math.max(maxWidth, box.getPreferredSize().width);
        }
        for (ComboBox box : comboBoxes) {
            SwingHelper.setPreferredWidth((Component)box, (int)maxWidth);
        }
    }

    @NotNull
    private static LabeledComponent<JComponent> createLabeledComponent(@NotNull String text, @NotNull JComponent comp) {
        if (text == null) {
            ExpressProjectPeer.$$$reportNull$$$0(9);
        }
        if (comp == null) {
            ExpressProjectPeer.$$$reportNull$$$0(10);
        }
        JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
        panel.add(comp);
        LabeledComponent labeledComponent = LabeledComponent.create((JComponent)panel, (String)text);
        labeledComponent.setLabelLocation("West");
        LabeledComponent labeledComponent2 = labeledComponent;
        if (labeledComponent2 == null) {
            ExpressProjectPeer.$$$reportNull$$$0(11);
        }
        return labeledComponent2;
    }

    @NotNull
    private static JPanel createExpressGeneratorPanel(@NotNull LabeledComponent<JComponent> versionLabeledComponent) {
        if (versionLabeledComponent == null) {
            ExpressProjectPeer.$$$reportNull$$$0(12);
        }
        JEditorPane descriptionPane = SwingHelper.createHtmlViewer((boolean)true, (Font)UIUtil.getTitledBorderFont(), null, null);
        Color color = UIUtil.getLabelForeground();
        SwingHelper.setHtml((JEditorPane)descriptionPane, (String)ExpressProjectPeer.getExpressGeneratorDescriptionHtml(), (Color)color);
        descriptionPane.addHyperlinkListener((HyperlinkListener)new BrowserHyperlinkListener());
        versionLabeledComponent.setBorder(BorderFactory.createEmptyBorder(4, JBUI.scale((int)20), 0, 0));
        JPanel jPanel = SwingHelper.newLeftAlignedVerticalPanel((Component[])new Component[]{descriptionPane, versionLabeledComponent});
        if (jPanel == null) {
            ExpressProjectPeer.$$$reportNull$$$0(13);
        }
        return jPanel;
    }

    @NotNull
    private static String getExpressGeneratorDescriptionHtml() {
        if ("Application will be created by <a href='https://www.npmjs.com/package/express-generator'>express-generator</a>" == null) {
            ExpressProjectPeer.$$$reportNull$$$0(14);
        }
        return "Application will be created by <a href='https://www.npmjs.com/package/express-generator'>express-generator</a>";
    }

    @Nullable
    private static ExpressTemplateEngine getDefaultTemplateEngine(@NotNull List<ExpressTemplateEngine> templates) {
        if (templates == null) {
            ExpressProjectPeer.$$$reportNull$$$0(15);
        }
        if (templates.contains(ExpressTemplateEngine.PUG)) {
            return ExpressTemplateEngine.PUG;
        }
        if (templates.contains(ExpressTemplateEngine.JADE)) {
            return ExpressTemplateEngine.JADE;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 15: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 15: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/boilerplate/express/ExpressProjectPeer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsStep";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressGeneratorVersionView";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateEngine";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cssEngine";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionLabeledComponent";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/boilerplate/express/ExpressProjectPeer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createPathsPanel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptionsPanel";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createLabeledComponent";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpressGeneratorPanel";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressGeneratorDescriptionHtml";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildUI";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addSettingsStateListener";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createOptionsPanel";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createLabeledComponent";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createExpressGeneratorPanel";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTemplateEngine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 15: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyNodePackageVersionListener
    implements NodePackageVersionListener {
        private MyNodePackageVersionListener() {
        }

        @Override
        public void onVersionSelected(@Nullable NodePackageVersion selectedVersion) {
            ArrayList templates = Collections.emptyList();
            ArrayList stylesheets = Collections.emptyList();
            if (selectedVersion != null) {
                templates = ContainerUtil.newArrayList((Object[])new ExpressTemplateEngine[]{ExpressTemplateEngine.JADE, ExpressTemplateEngine.EJS});
                stylesheets = ContainerUtil.newArrayList((Object[])new ExpressStylesheetEngine[]{ExpressStylesheetEngine.PLAIN_CSS, ExpressStylesheetEngine.STYLUS});
                if (selectedVersion.compareTo(NodePackageVersion.createFromRawVersion("3.0.0")) <= 0) {
                    templates.add(ExpressTemplateEngine.HBS);
                    templates.add(ExpressTemplateEngine.HOGAN);
                    stylesheets.add(ExpressStylesheetEngine.LESS);
                    stylesheets.add(ExpressStylesheetEngine.COMPASS);
                }
                if (selectedVersion.compareTo(NodePackageVersion.createFromRawVersion("4.16.0")) <= 0) {
                    templates = ContainerUtil.newArrayList((Object[])ExpressTemplateEngine.values());
                    templates.remove(ExpressTemplateEngine.JADE);
                } else if (selectedVersion.compareTo(NodePackageVersion.createFromRawVersion("4.15.0")) <= 0) {
                    templates = ContainerUtil.newArrayList((Object[])ExpressTemplateEngine.values());
                    templates.remove(ExpressTemplateEngine.JADE);
                    templates.remove(ExpressTemplateEngine.NO_VIEW);
                }
                if (selectedVersion.compareTo(NodePackageVersion.createFromRawVersion("4.13.0")) <= 0) {
                    stylesheets.add(ExpressStylesheetEngine.SASS);
                }
            }
            ExpressTemplateEngine defaultTemplateEngine = ExpressProjectPeer.getDefaultTemplateEngine(templates);
            SwingHelper.updateItems((JComboBox)ExpressProjectPeer.this.myTemplateEngine, templates, (Object)defaultTemplateEngine);
            SwingHelper.updateItems((JComboBox)ExpressProjectPeer.this.myStylesheetEngine, stylesheets, (Object)ExpressStylesheetEngine.PLAIN_CSS);
            ExpressProjectPeer.this.fireStateChanged(selectedVersion != null);
        }
    }
}

